define("mod_minilesson/fluency",["jquery","core/log","mod_minilesson/definitions","mod_minilesson/pollyhelper","mod_minilesson/ttrecorder","mod_minilesson/animatecss","mod_minilesson/progresstimer","core/templates","core/chartjs"],(function($,log,def,polly,ttrecorder,anim,progresstimer,templates,chartjs){log.debug("MiniLesson Fluency: initialising");var thefluencyitem={phonemeWarningThreshold:90,phonemeErrorThreshold:70,speechConfig:null,referencetext:"I met my love by the gas works wall",game:{pointer:0},usevoice:"",items:null,clone:function(){return $.extend(!0,{},this)},init:function(index,itemdata,quizhelper){this.itemdata=itemdata,this.quizhelper=quizhelper,this.index=index,this.init_components(quizhelper,itemdata),this.phonemeWarningThreshold=itemdata.correctthreshold||this.phonemeWarningThreshold,this.phonemeErrorThreshold>=this.phonemeWarningThreshold&&(this.phonemeErrorThreshold=Math.max(this.phonemeWarningThreshold-25,1));var animopts={};animopts.useanimatecss=quizhelper.useanimatecss,anim.init(animopts),this.register_events(index,itemdata,quizhelper),this.setvoice(),this.getItems()},init_components:function(quizhelper,itemdata){var self=this;self.thebutton="thettrbutton",self.container=$("#"+self.itemdata.uniqueid+"_container"),self.wordcount=$("#"+self.itemdata.uniqueid+"_container span.ml_wordcount"),self.actionbox=$("#"+self.itemdata.uniqueid+"_container div.ml_fluency_actionbox"),self.pendingbox=$("#"+self.itemdata.uniqueid+"_container div.ml_fluency_pendingbox"),self.resultsbox=$("#"+self.itemdata.uniqueid+"_container div.fluency_resultscontainer"),self.timerdisplay=$("#"+self.itemdata.uniqueid+"_container div.ml_fluency_timerdisplay"),self.audioplayerbtn=$("#"+self.itemdata.uniqueid+"_container .fluency_listen_btn"),self.audioplayerbtn_audiomodel=$("#"+self.itemdata.uniqueid+"_container .fluency_listen_btn.audiomodel"),self.audioplayerbtn_audioself=$("#"+self.itemdata.uniqueid+"_container .fluency_listen_btn.audioself"),self.skipbtn=$("#"+self.itemdata.uniqueid+"_container .fluency_skip_btn"),self.startbtn=$("#"+self.itemdata.uniqueid+"_container .fluency_start_btn"),self.smallnextbtn=$("#"+self.itemdata.uniqueid+"_container .minilesson_nextbutton"),self.ctrlbtns=$("#"+self.itemdata.uniqueid+"_container .fluency_ctrl_btn"),self.speakbtncont=$("#"+self.itemdata.uniqueid+"_container .fluency_speakbtncontainer"),self.questioncont=$("#"+self.itemdata.uniqueid+"_container .question"),self.listencont=$("#"+self.itemdata.uniqueid+"_container .fluency_listen_cont"),self.mainmenu=$("#"+self.itemdata.uniqueid+"_container .fluency_mainmenu"),self.mainstage=$("#"+self.itemdata.uniqueid+"_container .fluency_mainstage"),self.controls=$("#"+self.itemdata.uniqueid+"_container .fluency_controls"),self.progresscont=$("#"+self.itemdata.uniqueid+"_container .progress-container");var opts={};opts.uniqueid=itemdata.uniqueid,opts.callback=function(message){switch(message.type){case"recording":break;case"pronunciation_results":var speechresults=message.results;log.debug(speechresults),self.do_evaluation_feedback(speechresults),self.do_evaluation_stars(speechresults),self.do_recolor_continue_button(speechresults)}},opts.stt_guided=!1,opts.referencetext=this.referencetext,self.ttrec=ttrecorder.clone(),self.ttrec.init(opts)},setvoice:function(){this.usevoice=this.itemdata.usevoice,this.voiceoption=this.itemdata.voiceoption},getItems:function(){var self=this,text_items=self.itemdata.sentences;self.items=text_items.map((function(target){return{target:target.sentence,prompt:target.prompt,parsedstring:target.parsedstring,displayprompt:target.displayprompt,definition:target.definition,phonetic:target.phonetic,words:target.words,typed:"",timer:[],answered:!1,correct:!1,audio:null,audiourl:target.audiourl?target.audiourl:"",imageurl:target.imageurl}})).filter((function(e){return""!==e.target})),$.each(self.items,(function(index,item){item.audio=new Audio,item.audio.src=item.audiourl,0===self.items.filter((function(e){return null===e.audio})).length&&self.appReady()}))},appReady:function(){$("#"+this.itemdata.uniqueid+"_container .fluency_not_loaded").hide(),$("#"+this.itemdata.uniqueid+"_container .fluency_loaded").show(),this.itemdata.hidestartpage?this.start():$("#"+this.itemdata.uniqueid+"_container .fluency_start_btn").prop("disabled",!1)},next_question:function(){var stepdata={};stepdata.index=this.index,stepdata.hasgrade=!0,stepdata.totalitems=this.items.length,stepdata.correctitems=this.items.filter((function(e){return e.correct})).length,stepdata.grade=Math.round(stepdata.correctitems/stepdata.totalitems*100),this.stop_audio();var results_data={};results_data.correctitems=this.items.filter((function(e){return e.correct})).length,results_data.totalitems=this.items.length;results_data.items=this.items_for_results_display(!1),stepdata.resultsdata=results_data,this.quizhelper.do_next(stepdata)},register_events:function(index,itemdata,quizhelper){var self=this;self.smallnextbtn.on("click",(function(e){self.next_question()})),self.startbtn.on("click",(function(){self.start()})),self.audioplayerbtn.on("click",(function(){const $button=$(this);if($button.hasClass("audioself"))var theaudio=self.items[self.game.pointer].audioself;else theaudio=self.items[self.game.pointer].audio;if(!theaudio.paused)return theaudio.pause(),theaudio.currentTime=0,$button.children(".fa").removeClass("fa-stop"),void $button.children(".fa").addClass("fa-play");theaudio.addEventListener("ended",(function(){$button.children(".fa").removeClass("fa-stop"),$button.children(".fa").addClass("fa-play")})),theaudio.addEventListener("play",(function(){$button.children(".fa").removeClass("fa-play"),$button.children(".fa").addClass("fa-stop")})),theaudio.load(),theaudio.play()})),self.skipbtn.on("click",(function(){self.stopTimer(self.items[self.game.pointer].timer),self.game.pointer<self.items.length-1?setTimeout((function(){self.container.find(".fluency_reply_"+self.game.pointer).hide(),self.game.pointer++,self.nextPrompt()}),2e3):self.end()}))},end:function(){var self=this;self.smallnextbtn.prop("disabled",!0),self.updateProgressDots(),setTimeout((function(){self.smallnextbtn.prop("disabled",!1),self.quizhelper.showitemreview?self.show_item_review():self.next_question()}),2e3)},start:function(){this.ctrlbtns.prop("disabled",!0),this.speakbtncont.show(),this.items.forEach((function(item){item.spoken="",item.answered=!1,item.correct=!1})),this.game.pointer=0,this.questioncont.show(),this.listencont.show(),this.startbtn.hide(),this.mainmenu.hide(),this.controls.show(),this.nextPrompt()},show_item_review:function(){var self=this,review_data={};review_data.correctitems=self.items.filter((function(e){return e.correct})).length,review_data.totalitems=self.items.length;review_data.items=self.items_for_results_display(!0),templates.render("mod_minilesson/listitemresults",review_data).then((function(html,js){self.resultsbox.html(html),self.resultsbox.show(),self.mainstage.hide(),templates.runTemplateJS(js)}))},updateProgressDots:function(){var color,self=this,progress=self.items.map((function(item,idx){return color="gray",self.items[idx].answered&&self.items[idx].correct?color="green":self.items[idx].answered&&!self.items[idx].correct&&(color="red"),"<i style='color:"+color+"' class='fa fa-circle'></i>"})).join(" ");$("#"+self.itemdata.uniqueid+"_container .fluency_title").html(progress)},nextPrompt:function(){this.ctrlbtns.prop("disabled",!1),this.updateProgressDots();var newprompt=this.container.find(".fluency_prompt_"+this.game.pointer);anim.do_animate(newprompt,"zoomIn animate__faster","in").then((function(){})),this.nextReply()},nextReply:function(){var self=this,code="<div class='fluency_reply fluency_reply_"+self.game.pointer+" text-center' style='display:none;'>";code+="<div class='form-container'>",code+="<div class='fluency_prompt fluency_prompt_"+self.game.pointer+"'>",code+=self.items[self.game.pointer].displayprompt||self.items[self.game.pointer].prompt,code+="</div>",code+=" <i data-idx='"+self.game.pointer+"' class='fluency_feedback'></i></div>",self.items[self.game.pointer].imageurl&&(code+="<div class='minilesson_sentence_image'><div class='minilesson_padded_image'><img src='"+self.items[self.game.pointer].imageurl+"' alt='Image for gap fill' /></div></div>"),code+="<div class='item-results-container'></div>",code+="<div class='item-feedback-container'></div>",$("#"+self.itemdata.uniqueid+"_container .question").append(code);var newreply=self.container.find(".fluency_reply_"+self.game.pointer);anim.do_animate(newreply,"zoomIn animate__faster","in").then((function(){})),self.ctrlbtns.prop("disabled",!1),self.skipbtn.removeClass("btn-success"),self.skipbtn.addClass("btn-danger"),self.startTimer(),self.audioplayerbtn_audioself.hide(),self.quizhelper.mobile_user()||(self.itemdata.hidestartpage&&0===self.game.pointer?self.container.on("showElement",(()=>{setTimeout((function(){self.audioplayerbtn_audiomodel.trigger("click")}),1e3)})):setTimeout((function(){self.audioplayerbtn_audiomodel.trigger("click")}),1e3));var target=self.items[self.game.pointer].target;self.quizhelper.use_ttrecorder()&&self.ttrec.update_currentprompt(target)},startTimer:function(){var self=this;if(self.itemdata.timelimit>0){var doStartTimer=function(){self.progresscont.show(),self.progresscont.find("i").show(),self.progresscont.find("#progresstimer").progressTimer({height:"5px",timeLimit:self.itemdata.timelimit,onFinish:function(){self.skip_btn.trigger("click")}}).each((function(){self.items[self.game.pointer].timer.push($(this).attr("timer"))}))};self.itemdata.hidestartpage&&0===self.game.pointer?self.container.on("showElement",(()=>{doStartTimer()})):doStartTimer()}},stopTimer:function(timers){timers.length&&timers.forEach((function(timer){clearInterval(timer)}))},stop_audio:function(){var theaudio=this.items[this.game.pointer].audio;theaudio&&!theaudio.paused&&theaudio.pause()},do_evaluation_feedback:function(pronunciation_result){var self=this,itemfeedbackcontainer=self.container.find(".item-feedback-container");itemfeedbackcontainer.html("");var twoletterlang=self.itemdata.language.substr(0,2);if(self.itemdata.rtl)var words=pronunciation_result.privPronJson.Words.reverse();else words=pronunciation_result.privPronJson.Words;var lineresulthtml="";words.forEach((function(wordobject){if(wordobject.Syllables&&wordobject.Syllables.length>0&&wordobject.Syllables[0].Grapheme){var adata=[];wordobject.Syllables.forEach((function(syllable){adata.push({letter:syllable.Grapheme,phoneme:syllable.Syllable,score:syllable.PronunciationAssessment.AccuracyScore})}))}else adata=self.markuphelper.alignPhonemesToLetters(wordobject.Word,wordobject.Phonemes,twoletterlang);lineresulthtml+=self.markuphelper.renderPronunciationFeedback(adata)})),itemfeedbackcontainer.html(lineresulthtml),self.items[self.game.pointer].pronunciation_result=pronunciation_result,self.items[self.game.pointer].answered=!0,self.items[self.game.pointer].correct=pronunciation_result.privPronJson.PronunciationAssessment.AccuracyScore>=self.phonemeWarningThreshold,self.items[self.game.pointer].audioself=new Audio,self.items[self.game.pointer].audioself.src=URL.createObjectURL(self.ttrec.audio.blob),self.items[self.game.pointer].lineresulthtml=lineresulthtml,self.audioplayerbtn_audioself.show(),self.updateProgressDots()},do_recolor_continue_button:function(pronunciation_result){pronunciation_result.accuracyScore>=this.phonemeWarningThreshold?(this.skipbtn.removeClass("btn-danger"),this.skipbtn.addClass("btn-success")):(this.skipbtn.removeClass("btn-success"),this.skipbtn.addClass("btn-danger"))},do_evaluation_stars:function(pronunciation_result){log.debug("Accuracy score: ",pronunciation_result.accuracyScore);var itemstarscontainer=$("#"+this.itemdata.uniqueid+"_container .item-results-container");itemstarscontainer.html("");for(var starRating=$("<div class='fluency_star_rating'>"),accuracyScore=pronunciation_result.accuracyScore,starBandWidth=(100-(100-this.phonemeWarningThreshold))/4,i=0;i<5;i++){var star=$("<i class='fa'>");i<=accuracyScore/starBandWidth?star.addClass("fa-star"):star.addClass("fa-star-o"),starRating.append(star)}itemstarscontainer.append(starRating)},do_evaluation_results:function(pronunciation_result){var self=this,itemresultscontainer=self.container.find(".item-results-container");itemresultscontainer.html("");var itemresults=[];itemresults.push("Accuracy score: "+pronunciation_result.accuracyScore),itemresults.push("Pronunciation score: "+pronunciation_result.pronunciationScore),itemresults.push("Completeness score: "+pronunciation_result.completenessScore),itemresults.push("Fluency score: "+pronunciation_result.fluencyScore),itemresults.push("Prosody score: "+pronunciation_result.prosodyScore),itemresultscontainer.append(itemresults.join("<br>"));var data=[pronunciation_result.accuracyScore,pronunciation_result.pronunciationScore,pronunciation_result.completenessScore,pronunciation_result.fluencyScore,pronunciation_result.prosodyScore];["Accuracy","Pronunciation","Completeness","Fluency","Prosody"].forEach((function(label,index){var chartContainerId=self.itemdata.uniqueid+"_chart_"+index;itemresultscontainer.append('<canvas id="'+chartContainerId+'"></canvas>'),self.createRadialChart(chartContainerId,[label],[data[index]])})),log.debug("Accuracy score: ",pronunciation_result.accuracyScore),log.debug("Pronunciation score: ",pronunciation_result.pronunciationScore),log.debug("Completeness score : ",pronunciation_result.completenessScore),log.debug("Fluency score: ",pronunciation_result.fluencyScore),log.debug("Prosody score: ",pronunciation_result.prosodyScore),log.debug("  Word-level details:"),pronunciation_result.detailResult.Words.forEach((function(word,idx){console.log("    ",idx+1,": word: ",word.Word,"\taccuracy score: ",word.PronunciationAssessment.AccuracyScore,"\terror type: ",word.PronunciationAssessment.ErrorType,";")}))},createRadialChart:function(containerId,labels,data){var ctx=document.getElementById(containerId).getContext("2d");new chartjs(ctx,{type:"doughnut",data:{labels:labels,datasets:[{label:"Scores",data:data,backgroundColor:"rgba(54, 162, 235, 0.2)",borderColor:"rgba(54, 162, 235, 1)",borderWidth:1}]},options:{scale:{ticks:{beginAtZero:!0,max:100}}}})},items_for_results_display:function(includeaudioself){return this.items.map((function(target){return{target:target.answered?target.lineresulthtml:target.target,pronunciation_result:target.pronunciation_result,answered:target.answered,correct:target.correct,audio:target.audio?{src:target.audio.src}:null,audioself:includeaudioself&&target.audioself?{src:target.audioself.src}:null}}))},markuphelper:{languageMappings:{en:{graphemeGroups:["sh","th","ch","ph","wh","ck","ng"],phonemeGroups:{"ʃ":["sh"],"tʃ":["ch"],"θ":["th"],"ŋ":["ng"]}},es:{graphemeGroups:["ll","ch","rr"],phonemeGroups:{"ʎ":["ll"],"tʃ":["ch"],r:["rr"]}},fr:{graphemeGroups:["ch","gn","ou","eau","oi"],phonemeGroups:{"ʃ":["ch"],"ɲ":["gn"],u:["ou"],o:["eau"],wa:["oi"]}},ar:{graphemeGroups:["ث","ذ","ش","خ","غ","ق","ع","ص","ض","ط","ظ","ء"],phonemeGroups:{"θ":["ث"],"ð":["ذ"],"ʃ":["ش"],x:["خ"],"ɣ":["غ"],"ħ":["ح"],"ʕ":["ع"],h:["ه"],"sˤ":["ص"],"dˤ":["ض"],"tˤ":["ط"],"ðˤ":["ظ"],q:["ق"],"ʔ":["ء"],"aː":["ا"],"uː":["و"],"iː":["ي"]}},ru:{graphemeGroups:["щ","ч","ш","ж","ю","я"],phonemeGroups:{"ɕː":["щ"],"tɕ":["ч"],"ʂ":["ш"],"ʒ":["ж"],ju:["ю"],ja:["я"]}},no:{graphemeGroups:["kj","sj","ng"],phonemeGroups:{"ç":["kj"],"ʃ":["sj"],"ŋ":["ng"]}},so:{graphemeGroups:["kh","dh","sh"],phonemeGroups:{x:["kh"],"ð":["dh"],"ʃ":["sh"]}},de:{graphemeGroups:["sch","ch","ng","sp","st","z"],phonemeGroups:{"ʃ":["sch"],"ç":["ch"],"ŋ":["ng"],"ʃp":["sp"],"ʃt":["st"],ts:["z"]}},it:{graphemeGroups:["gl","gn","sc","ch","ci","ce"],phonemeGroups:{"ʎ":["gl"],"ɲ":["gn"],"ʃ":["sc"],k:["ch"],"tʃ":["ci","ce"]}}},alignPhonemesToLetters:function(word,phonemesWithScores){let language=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"en";const{graphemeGroups:graphemeGroups=[],phonemeGroups:phonemeGroups={}}=this.languageMappings[language]||{};function normalizeWord(word,language){return"ar"===language?word.normalize("NFKD").replace(/[\u064B-\u065F\u0670]/g,""):word.normalize("NFKD").replace(/[\u0300-\u036f]/g,"").toLowerCase()}function tokenizeGraphemes(word,groups){const tokens=[];let i=0;for(;i<word.length;){let matched=!1;for(const g of groups.sort(((a,b)=>b.length-a.length)))if(word.slice(i,i+g.length)===g){tokens.push(g),i+=g.length,matched=!0;break}matched||(tokens.push(word[i]),i+=1)}return tokens}function normalizePhoneme(p){for(const group in phonemeGroups)if(phonemeGroups[group].includes(p))return group;return p}const normWord=normalizeWord(word,language),graphemes=tokenizeGraphemes(normWord,graphemeGroups),phonemes=phonemesWithScores.map((p=>normalizePhoneme(p.Phoneme))),m=graphemes.length,n=phonemes.length,dp=Array(m+1).fill().map((()=>Array(n+1).fill(0))),traceback=Array(m+1).fill().map((()=>Array(n+1).fill(null))),matchCost=0,mismatchCost=1,gap=1;for(let i=0;i<=m;i++)dp[i][0]=i*gap,traceback[i][0]="up";for(let j=0;j<=n;j++)dp[0][j]=j*gap,traceback[0][j]="left";for(let i=1;i<=m;i++)for(let j=1;j<=n;j++){const cost=graphemes[i-1]===phonemes[j-1]?matchCost:mismatchCost,diag=dp[i-1][j-1]+cost,up=dp[i-1][j]+gap,left=dp[i][j-1]+gap;dp[i][j]=Math.min(diag,up,left),traceback[i][j]=dp[i][j]===diag?"diag":dp[i][j]===up?"up":"left"}let i=m,j=n;const result=[];for(;i>0||j>0;){const move=traceback[i][j];"diag"===move?(result.unshift({letter:graphemes[i-1],phoneme:phonemesWithScores[j-1].Phoneme,score:phonemesWithScores[j-1].PronunciationAssessment.AccuracyScore}),i--,j--):"up"===move?(result.unshift({letter:graphemes[i-1],phoneme:null,score:null}),i--):j--}return result},scoreToColorClass:function(score){return null===score?"letter_missing":score>=thefluencyitem.phonemeWarningThreshold?"letter_good":score>=thefluencyitem.phonemeErrorThreshold?"letter_fair":"letter_wrong"},renderPronunciationFeedback:function(alignmentData){var mhelper=this;const $wrapper=$("<div class='fluencywordresult'>");return alignmentData.forEach((_ref=>{let{letter:letter,phoneme:phoneme,score:score}=_ref;var resultcolorclass=mhelper.scoreToColorClass(score);const $span=$("<span class='fluencyletterresult "+resultcolorclass+"'>").text(letter),tooltipText=null===score?"No phoneme matched":"Phoneme: ".concat(phoneme,", Score: ").concat(score);$span.attr("title",tooltipText),$wrapper.append($span)})),$wrapper.prop("outerHTML")}}};return thefluencyitem}));

//# sourceMappingURL=fluency.min.js.map