define(["jquery","core/log","mod_minilesson/definitions","mod_minilesson/ttrecorder","core/templates","core/str"],(function($,log,def,ttrecorder,templates,str){return log.debug("MiniLesson AudioChat: initialising"),{autocreateresponse:!1,gradingrequesttag:"gradingrequest",gradingData:!1,strings:{},controls:{},itemdata:{},index:0,quizhelper:{},pc:null,dc:null,cantChat:!1,audiochat_voice:"alloy",isSessionStarted:!1,isSessionStopped:!1,isSessionActive:!1,isLoading:!1,isMicActive:!1,isMicInitialized:!1,loadingMessages:new Set,audioContext:null,analyser:null,dataArray:null,sourceNode:null,mediaStream:null,animationFrameId:null,canvasCtx:null,eventlogs:[],items:{},responses:{},abortcontroller:new AbortController,datainputbuffer:!1,inputBufferInterval:null,semantic_vad:{type:"semantic_vad",eagerness:"low"},timebased_vad:{type:"server_vad",silence_duration_ms:3500,create_response:!0,interrupt_response:!0,threshold:.3},clone:function(){return $.extend(!0,{},this)},init:function(index,itemdata,quizhelper){this.itemdata=itemdata,this.autocreateresponse=itemdata.audiochat_autoresponse||!1,log.debug("itemdata",itemdata),this.quizhelper=quizhelper,this.index=index,this.cantChat=!itemdata.canchat,this.init_strings(),this.init_controls(quizhelper,itemdata),this.init_voice(itemdata.audiochat_voice),this.register_events(index,itemdata,quizhelper),this.renderUI()},init_strings:function(){var self=this;str.get_strings([{key:"gradebywordcount",component:"mod_minilesson"}]).done((function(s){var i=0;self.strings.gradebywordcount=s[i++]}))},next_question:function(){var stepdata={};stepdata.index=this.index,stepdata.hasgrade=!0,stepdata.totalitems=this.itemdata.totalmarks,stepdata.resultsdata={items:Object.values(this.items)},(stepdata=this.grade_activity(stepdata)).correctitems=Math.round(this.itemdata.totalmarks*stepdata.grade/100),this.quizhelper.do_next(stepdata)},count_words:function(){var userTranscript=[];return Object.values(this.items).forEach((item=>{item.content&&userTranscript.push(item.content)})),userTranscript.join(" ").split(/\s+/).length},toggle_autocreate_response:function(){this.autocreateresponse=!this.autocreateresponse,this.timebased_vad.create_response=this.autocreateresponse,log.debug("Autocreate response toggled:",this.autocreateresponse),this.dc.send(JSON.stringify({type:"session.update",session:{turn_detection:this.timebased_vad}}))},grade_activity:function(stepdata){var wordcount=this.count_words();return this.gradingData&&void 0!==this.gradingData.score?(log.debug("Using grading data from AI:",this.gradingData),stepdata.grade=this.gradingData.score,"number"==typeof stepdata.grade&&"number"==typeof wordcount&&this.itemdata.targetwordcount>0&&wordcount<this.itemdata.targetwordcount&&(stepdata.grade=Math.round(stepdata.grade*(wordcount/this.itemdata.targetwordcount))),stepdata.resultsdata.aifeedback=this.gradingData.feedback||"",stepdata.resultsdata.gradeexplanation=this.gradingData.gradeexplanation||""):(stepdata.resultsdata.gradeexplanation=this.strings.gradebywordcount,!1!==this.itemdata.countwords&&0!==this.itemdata.targetwordcount||(stepdata.grade=100),stepdata.grade=100*Math.min(wordcount/this.itemdata.targetwordcount,1)),stepdata},register_events:function(index,itemdata,quizhelper){var self=this;self.controls.startSessionBtn.addEventListener("click",self.startSession.bind(this)),self.controls.stopSessionBtn.addEventListener("click",self.stopSession.bind(this)),self.controls.retrySessionBtn.addEventListener("click",self.resetSession.bind(this)),self.controls.autocreateresponseCheckbox.addEventListener("change",self.toggle_autocreate_response.bind(self)),self.controls.cancelStartSessionBtn.addEventListener("click",(()=>{log.debug("Cancelling session start"),self.abortcontroller.abort(),self.abortcontroller=new AbortController})),$(self.controls.nextbutton).on("click",(function(){self.next_question()}));var container=$(self.controls.container);container.on("showElement",(()=>{itemdata.timelimit>0&&(container.find(".progress-container").show(),container.find(".progress-container i").show(),container.find(".progress-container #progresstimer").progressTimer({height:"5px",timeLimit:itemdata.timelimit,onFinish:function(){nextbutton.trigger("click")}}))})),self.controls.toggleMicBtn&&self.controls.toggleMicBtn.addEventListener("click",self.toggleMute.bind(self))},init_voice:function(voice){voice&&["alloy","ash","ballad","coral","echo","sage","shimmer","verse"].includes(voice)?this.audiochat_voice=voice:this.audiochat_voice="alloy",log.debug("AudioChat voice set to:",this.audiochat_voice)},init_controls:async function(){var container=document.getElementById(this.itemdata.uniqueid+"_container");this.controls={hiddenaudio:container.querySelector(".ml_ac_hiddenaudio"),nextbutton:container.querySelector(".minilesson_nextbutton"),cantChatWarning:container.querySelector(".ml_ac_cantchat"),startSessionBtn:container.querySelector(".ml_ac_start-session-btn"),stopSessionBtn:container.querySelector(".ml_ac_stop-session-btn"),loadingIndicator:container.querySelector(".ml_ac_loading-indicator"),aiAvatarSection:container.querySelector(".ml_ac_ai-avatar-section"),chatActiveMessage:container.querySelector(".ml_ac_chat-active-message"),conversationSection:container.querySelector(".ml_ac_conversation-section"),messagesContainer:container.querySelector(".ml_ac_messages-container"),micButtonContainer:container.querySelector(".mic-button-container"),toggleMicBtn:container.querySelector(".toggle-mic-btn"),micIcon:container.querySelector(".mic-icon"),micWaveformCanvas:container.querySelector(".mic-waveform-canvas"),micSelect:container.querySelector(".ml_ac_micselect"),finishMessage:container.querySelector(".ml_ac_finished-message"),retrySessionBtn:container.querySelector(".ml_ac_retrybtn"),cancelStartSessionBtn:container.querySelector(".ml_ac_cancel-start-session-btn"),autocreateresponseCheckbox:container.querySelector(".ml_ac_autoresponse-checkbox"),resultscontainer:container.querySelector(".ml_ac_results_container"),resultscontent:container.querySelector(".ml_ac_results_content"),autocreateresponseToggle:container.querySelector(".ml_ac_autoresponse-toggle"),clicktosendlabel:container.querySelector(".ml_ac_clicktosend"),mainWrapper:container.querySelector(".minilesson_audiochat_box .ml_unique_mainwrapper")},this.canvasCtx=this.controls.micWaveformCanvas?this.controls.micWaveformCanvas.getContext("2d"):null,await this.populateMicList()},scrollToBottom:function(){this.controls.conversationSection.firstElementChild.scrollIntoViewIfNeeded(),this.controls.conversationSection.firstElementChild.scrollTop=this.controls.conversationSection.firstElementChild.scrollHeight},scrollMicButtonIntoView:function(){this.controls.micButtonContainer&&this.controls.micButtonContainer.scrollIntoView({behavior:"smooth",block:"center"})},renderUI:function(){var self=this;self.controls.startSessionBtn.classList.toggle("hidden",self.isSessionActive||self.isLoading||self.isSessionStarted||self.cantChat),self.controls.cantChatWarning.classList.toggle("hidden",!self.cantChat),self.controls.loadingIndicator.classList.toggle("hidden",!self.isLoading),self.controls.stopSessionBtn.classList.toggle("hidden",!self.isSessionActive),self.controls.micButtonContainer.classList.toggle("hidden",!self.isSessionActive);var endScreen=self.isSessionStarted&&self.isSessionStopped;if(self.controls.resultscontainer.classList.toggle("hidden",!endScreen&&self.quizhelper.showitemreview),self.controls.finishMessage.classList.toggle("hidden",!endScreen),self.controls.retrySessionBtn.classList.toggle("hidden",!endScreen&&self.itemdata.allowretry),self.controls.autocreateresponseToggle.classList.toggle("hidden",!self.isSessionActive),self.controls.micSelect){var noshowmics=self.controls.micSelect.querySelectorAll("option").length<2;self.controls.micSelect.parentElement.classList.toggle("hidden",noshowmics||self.isSessionStarted||self.isLoading||self.controls.micSelect.disabled)}var currentItem,orderedItems=[],idMap=new Map,previousMap=new Map;for(Object.values(self.items).forEach((item=>{idMap.set(item.id,item),previousMap.set(item.previous_item_id,item),null===item.previous_item_id&&(currentItem=item)}));currentItem;)orderedItems.push(currentItem),currentItem=previousMap.get(currentItem.id);self.controls.aiAvatarSection.classList.toggle("hidden",self.isSessionStarted||self.isSessionActive||self.isSessionStopped),self.controls.chatActiveMessage.classList.toggle("hidden",!self.isSessionActive),self.controls.conversationSection.classList.toggle("hidden",!(self.isSessionActive||self.isSessionStopped)),self.controls.messagesContainer.innerHTML="",orderedItems.forEach((message=>{if(message.content){var messageDiv=document.createElement("div");messageDiv.className="flex ".concat("user"===message.usertype?"justify-end":"justify-start"," ml_unique_ordered_message_").concat("user"===message.usertype?"user":"assistant");var contentDiv=document.createElement("div");contentDiv.className="max-w-xs lg:max-w-md px-4 py-2 rounded-lg ".concat("user"===message.usertype?"bg-blue-500 text-white":"bg-gray-200 text-gray-800"," ml_unique_content_").concat("user"===message.usertype?"user":"assistant");var headerDiv=document.createElement("div");if(headerDiv.className="flex items-center text-xs font-medium mb-1 ml_unique_headerdiv","assistant"===message.usertype){var pictureDiv=document.createElement("div");pictureDiv.innerHTML='\n                        <img src="'.concat(M.cfg.wwwroot,'/mod/minilesson/pix/cutepoodll_small.png" \n                        alt="AI Assistant" class="mr-2 rounded-circle shadow-lg ml_unique_assistant_img">\n                        '),headerDiv.appendChild(pictureDiv)}headerDiv.innerHTML+="user"===message.usertype?"Student":"AI Assistant",contentDiv.appendChild(headerDiv);var textDiv=document.createElement("div");if(textDiv.className="text-sm ml_unique_textsmall",textDiv.textContent=message.content,contentDiv.appendChild(textDiv),self.loadingMessages.has(message.id)){var loaderDiv=document.createElement("div");loaderDiv.className="flex items-center space-x-1 py-1 message-loader ml_unique_loadingmessage",loaderDiv.innerHTML='\n                        <div class="flex space-x-1 ml_unique_loader">\n                            <div class="w-2 h-2 bg-current rounded-full ml_unique_loader_dot"></div>\n                            <div class="w-2 h-2 bg-current rounded-full ml_unique_loader_dot"></div>\n                            <div class="w-2 h-2 bg-current rounded-full ml_unique_loader_dot"></div>\n                        </div>\n                        <span class="text-xs opacity-70 ml_unique_loader_text">AI is thinking...</span>\n                    ',contentDiv.appendChild(loaderDiv)}messageDiv.appendChild(contentDiv),self.controls.messagesContainer.appendChild(messageDiv)}})),self.scrollToBottom(),self.controls.micButtonContainer&&(self.controls.micButtonContainer.classList.toggle("active",self.isMicActive),self.controls.micButtonContainer.classList.toggle("bg-blue-500",self.isMicActive),self.controls.micButtonContainer.classList.toggle("text-white",self.isMicActive),self.controls.micButtonContainer.classList.toggle("bg-gray-200",!self.isMicActive),self.controls.micButtonContainer.classList.toggle("text-gray-800",!self.isMicActive)),self.controls.micWaveformCanvas&&self.controls.micWaveformCanvas.classList.toggle("active",self.isMicActive),self.controls.micIcon&&(self.controls.micIcon.innerHTML=self.isMicActive?'<rect id="primary" x="2" y="2" width="20" height="20" rx="2" style="fill: rgb(0, 0, 0);"></rect>':'<path id="secondary" d="M12,15h0a4,4,0,0,1-4-4V7a4,4,0,0,1,4-4h0a4,4,0,0,1,4,4v4A4,4,0,0,1,12,15Z" style="fill: rgb(44, 169, 188); stroke-width: 2;"></path><path id="primary" d="M18.24,16A8,8,0,0,1,5.76,16" style="fill: none; stroke: rgb(0, 0, 0); stroke-linecap: round; stroke-linejoin: round; stroke-width: 2;"></path><path id="primary-2" data-name="primary" d="M12,19v2m4-10V7a4,4,0,0,0-4-4h0A4,4,0,0,0,8,7v4a4,4,0,0,0,4,4h0A4,4,0,0,0,16,11Z" style="fill: none; stroke: rgb(0, 0, 0); stroke-linecap: round; stroke-linejoin: round; stroke-width: 2;"></path>'),self.isMicActive&&!self.autocreateresponse?self.controls.clicktosendlabel.classList.remove("hidden"):self.controls.clicktosendlabel.classList.add("hidden")},setDataInputBuffer:function(value,source){this.datainputbuffer=value,log.debug("Data in input buffer set to:",value),log.debug("Data input buffer set source:",source)},resetSession:function(){log.debug("reset  session");this.isLoading=!1,this.isSessionActive=!1,this.isSessionStopped=!1,this.isSessionStarted=!1,this.renderUI()},startSession:async function(){var self=this,twoletterlang=self.itemdata.language.substr(0,2),hiddenaudio=self.controls.hiddenaudio;log.debug("Session starting"),self.isLoading=!0,self.items=[],self.renderUI(),log.debug("Opening peer connection..."),self.pc=new RTCPeerConnection({iceServers:[{urls:"stun:stun.l.google.com:19302"}]}),log.debug("creating data channel..."),self.dc=self.pc.createDataChannel("oai-events"),self.dc.onmessage=e=>{self.eventlogs.push(e.data);try{var lines=e.data.split("\n").filter(Boolean);for(var line of lines)self.handleRTCEvent.call(self,JSON.parse(line))}catch(err){log.debug("Failed to parse",err)}},self.dc.onopen=()=>{log.debug("DataChannel open");self.timebased_vad.create_response=self.autocreateresponse,self.sendEvent({type:"session.update",session:{instructions:self.itemdata.audiochatinstructions,input_audio_format:"pcm16",input_audio_transcription:{language:twoletterlang,model:"whisper-1"},turn_detection:self.timebased_vad,speed:.9,voice:self.audiochat_voice,modalities:["text","audio"]}});self.sendEvent({type:"response.create",response:{modalities:["audio","text"],instructions:self.itemdata.audiochatinstructions+" Please introduce yourself to the student and explain todays topic.",voice:self.audiochat_voice}})},self.pc.ontrack=event=>{hiddenaudio.srcObject=event.streams[0]},self.mediaStream=await navigator.mediaDevices.getUserMedia({audio:!0}),self.mediaStream.getTracks().forEach((track=>{track.enabled=!1,self.pc.addTrack(track,self.mediaStream)}));var offer=await self.pc.createOffer({offerToReceiveAudio:!0});await self.pc.setLocalDescription(offer),await self.waitForIceGathering(self.pc);try{var sdpResponse=await fetch(M.cfg.wwwroot+"/mod/minilesson/openairtc.php",{method:"POST",headers:{"Content-Type":"application/sdp"},body:self.pc.localDescription.sdp,signal:self.abortcontroller.signal});if(!sdpResponse.ok)return void log.debug("Failed /rtc:",await sdpResponse.text());log.debug("Received SDP answer from server");var answer=await sdpResponse.text();log.debug(answer),await self.pc.setRemoteDescription({type:"answer",sdp:answer}),log.debug("Session started")}catch(e){return"AbortError"===e.name?(log.debug("Session start aborted by user."),self.isLoading=!1,void self.renderUI()):(self.dc&&self.dc.close(),self.pc&&self.pc.close(),self.mediaStream&&self.mediaStream.getTracks().forEach((track=>track.stop())),self.isLoading=!1,void self.renderUI())}self.isLoading=!1,self.isSessionActive=!0,self.isSessionStarted=!0,self.isSessionStopped=!1,self.renderUI()},sendGradingRequest:function(){var responsedata={conversation:"none",modalities:["text"],instructions:"Please provide a percentage score for the session, an explanation of the score (for teachers), and feedback (for the student). "+this.itemdata.audiochatgradeinstructions+'Return the response as JSON in the format: {"score": "the score  ( 0-100 ) ", "gradeexplanation": "the explanation", "feedback": "the feedback"}.',metadata:{tag:this.gradingrequesttag},max_output_tokens:500,temperature:.6};this.sendEvent({type:"response.create",response:responsedata})},stopSession:function(){var self=this;log.debug("Session stopping..."),self.isSessionActive=!1,self.isSessionStopped=!0,self.loadingMessages.clear(),self.releaseMicResources(),self.renderUI(),self.itemdata.audiochatgradeinstructions&&""!==self.itemdata.audiochatgradeinstructions?(self.sendGradingRequest(),self.controls.resultscontent.innerHTML='<i class="fa fa-spinner fa-spin fa-2x"></i>',setTimeout((()=>{self.quizhelper.showitemreview&&self.showResults(),log.debug("Closing session resources..."),self.closeDataChannel()}),2e3)):(log.debug("Closing session resources..."),self.closeDataChannel()),log.debug("Session stopped")},closeDataChannel:function(){void 0!==this.dc&&this.dc&&(this.dc.close(),this.dc=null),void 0!==this.pc&&this.pc&&(this.pc.close(),this.pc=null)},showResults:function(){var self=this,tdata={};tdata.resultsdata={items:Object.values(self.items)};const stars=[];(void 0===(tdata=self.grade_activity(tdata)).grade||isNaN(tdata.grade)||null===tdata.grade||""===tdata.grade)&&(tdata.grade=0);const filledStars=Math.round(tdata.grade/100*5);for(let i=0;i<5;i++)stars.push({filled:i<filledStars});tdata.stars=stars,templates.render("mod_minilesson/audiochatimmediatefeedback",tdata).then((function(html,js){self.controls.resultscontent.innerHTML=html}))},waitForIceGathering:function(pc){let timeout=arguments.length>1&&void 0!==arguments[1]?arguments[1]:15e3;return new Promise((resolve=>{let timer;function checkState(){"complete"===pc.iceGatheringState&&(clearTimeout(timer),pc.removeEventListener("icegatheringstatechange",checkState),resolve())}pc.addEventListener("icegatheringstatechange",checkState),timer=setTimeout((()=>{pc.removeEventListener("icegatheringstatechange",checkState),resolve()}),timeout)}))},sendEvent:function(obj){this.dc&&"open"===this.dc.readyState&&this.dc.send(JSON.stringify(obj))},handleRTCEvent:function(msg){var _msg$response$metadat;if(log.debug("Received event:"),"response.done"!==msg.type||(null===(_msg$response$metadat=msg.response.metadata)||void 0===_msg$response$metadat?void 0:_msg$response$metadat.tag)!==this.gradingrequesttag){var msgresponse_id=msg.response?msg.response.id:msg.response_id,msgitem_id=msg.item?msg.item.id:msg.item_id;switch(msgresponse_id&&(this.responses[msgresponse_id]=this.responses[msgresponse_id]||{id:msgresponse_id,itemid:msgitem_id,stack:[]}),msgitem_id&&(void 0===this.items[msgitem_id]&&this.scrollToBottom(),this.items[msgitem_id]=this.items[msgitem_id]||{id:msgitem_id,events:[],responses:null,content:""},msgresponse_id&&(this.items[msgitem_id].responses=this.responses[msgresponse_id])),msg.time=Date.now().toString(),msg.type){case"response.created":case"response.done":this.responses[msg.response.id].stack.push(msg);break;case"response.output_item.added":case"output_audio_buffer.cleared":case"response.audio.done":case"response.content_part.done":this.responses[msg.response_id].stack.push(msg);break;case"conversation.item.created":this.items[msg.item.id].previous_item_id=msg.previous_item_id,this.items[msg.item.id].usertype=msg.item.role,this.items[msg.item.id].events.push(msg),"assistant"===msg.item.role&&this.loadingMessages.add(msgitem_id);break;case"response.content_part.added":this.enableMic(),this.responses[msg.response_id].stack.push(msg);break;case"response.audio_transcript.delta":this.responses[msg.response_id].stack.push(msg),this.items[msg.item_id].content+=msg.delta;break;case"response.audio_transcript.done":this.responses[msg.response_id].stack.push(msg),this.items[msg.item_id].content=msg.transcript;break;case"response.output_item.done":this.responses[msg.response_id].stack.push(msg),this.loadingMessages.delete(msg.item.id);break;case"output_audio_buffer.stopped":this.isMicActive||this.toggleMute(),this.responses[msg.response.id].stack.push(msg);break;case"conversation.item.truncated":this.items[msg.item_id].events.push(msg);break;case"input_audio_buffer.speech_started":log.debug("Input audio buffer speech started"),this.setDataInputBuffer(!0,"audiobufferstarted"),this.items[msg.item_id].events.push(msg);break;case"input_audio_buffer.speech_stopped":this.isMicActive&&this.autocreateresponse&&(this.toggleMute(),this.disableMic()),this.items[msg.item_id].events.push(msg);break;case"input_audio_buffer.committed":log.debug("Input audio buffer committed"),this.setDataInputBuffer(!1,"audiobuffercommitted"),this.items[msg.item_id].events.push(msg);break;case"conversation.item.created":this.items[msg.item.id].events.push(msg);break;case"conversation.item.input_audio_transcription.delta":this.items[msg.item_id].events.push(msg),this.items[msg.item_id].content+=msg.delta;break;case"conversation.item.input_audio_transcription.completed":this.items[msg.item_id].events.push(msg),this.items[msg.item_id].content=msg.transcript,this.loadingMessages.delete(msg.item_id)}this.renderUI()}else try{var jsonresponse=msg.response.output[0].content[0].text;if(!jsonresponse||""===jsonresponse)return log.debug("No valid grading data received"),void this.closeDataChannel();this.gradingData=JSON.parse(jsonresponse),log.debug("Grading and Feedback:",this.gradingData)}catch(err){this.gradingData=!1,log.debug("Failed to parse grading feedback:",err)}},enableMic:function(){this.controls.toggleMicBtn&&(log.debug("Enabling mic"),this.controls.toggleMicBtn.parentElement.classList.remove("disabled"))},disableMic:function(){this.controls.toggleMicBtn&&(log.debug("Disabling mic"),this.controls.toggleMicBtn.parentElement.classList.add("disabled"))},initializeMicStream:async function(){try{this.audioContext=new(window.AudioContext||window.webkitAudioContext),this.analyser=this.audioContext.createAnalyser(),this.analyser.fftSize=2048;const bufferLength=this.analyser.frequencyBinCount;return this.dataArray=new Uint8Array(bufferLength),this.sourceNode=this.audioContext.createMediaStreamSource(this.mediaStream),this.isMicInitialized=!0,!0}catch(err){return log.debug("Error accessing microphone:",err),this.isMicInitialized=!1,log.debug("Could not access microphone. Please ensure it's connected and permissions are granted."),!1}},toggleMute:async function(){var self=this;if(!self.isMicInitialized){if(!await self.initializeMicStream())return}if(self.isMicActive){if(self.sourceNode&&self.analyser&&self.sourceNode.disconnect(self.analyser),self.animationFrameId&&(cancelAnimationFrame(self.animationFrameId),self.animationFrameId=null),self.pc&&self.mediaStream.getTracks().forEach((track=>{track.enabled=!1})),self.canvasCtx&&self.canvasCtx.clearRect(0,0,self.controls.micWaveformCanvas.width,self.controls.micWaveformCanvas.height),self.isMicActive=!1,!self.autocreateresponse)if(self.datainputbuffer){log.debug("Waiting for input audio buffer to commit before sending response.create");let attempts=0;self.inputBufferInterval&&(clearInterval(self.inputBufferInterval),self.inputBufferInterval=null);const maxAttempts=3;self.inputBufferInterval=setInterval((()=>{log.debug("Checking input buffer status, attempt:",attempts),(!self.datainputbuffer||attempts>=maxAttempts)&&(clearInterval(self.inputBufferInterval),self.setDataInputBuffer(!1,"setInterval:"+attempts),log.debug(" sending response.create"),self.sendEvent({type:"response.create",response:{modalities:["audio","text"],instructions:self.itemdata.audiochatinstructions,voice:self.audiochat_voice}})),attempts++}),1500)}else log.debug(" sending response.create"),self.sendEvent({type:"response.create",response:{modalities:["audio","text"],instructions:self.itemdata.audiochatinstructions,voice:self.audiochat_voice}})}else self.sourceNode&&self.analyser&&self.sourceNode.connect(self.analyser),self.pc&&self.mediaStream.getTracks().forEach((track=>{track.enabled=!0})),self.isMicActive=!0,self.drawWave();self.renderUI()},releaseMicResources:function(){var self=this;self.animationFrameId&&(cancelAnimationFrame(self.animationFrameId),self.animationFrameId=null),self.mediaStream&&(self.mediaStream.getTracks().forEach((track=>{if(void 0!==self.pc&&self.pc){const sender=self.pc.getSenders().find((s=>s.track===track));sender&&self.pc.removeTrack(sender)}track.stop()})),self.mediaStream=null),self.sourceNode&&(self.sourceNode.disconnect(),self.sourceNode=null),self.audioContext&&(self.audioContext.close(),self.audioContext=null),self.isMicActive=!1,self.isMicInitialized=!1,self.canvasCtx&&self.canvasCtx.clearRect(0,0,self.controls.micWaveformCanvas.width,self.controls.micWaveformCanvas.height),self.renderUI()},drawWave:function(){if(!(this.canvasCtx&&this.analyser&&this.dataArray&&this.isMicActive))return void(this.animationFrameId=null);const WIDTH=this.controls.micWaveformCanvas.width,HEIGHT=this.controls.micWaveformCanvas.height;this.animationFrameId=requestAnimationFrame(this.drawWave.bind(this)),this.analyser.getByteTimeDomainData(this.dataArray),this.canvasCtx.clearRect(0,0,WIDTH,HEIGHT),this.canvasCtx.lineWidth=2,this.canvasCtx.strokeStyle="rgb(255, 255, 255)",this.canvasCtx.beginPath();const sliceWidth=1*WIDTH/this.dataArray.length;let x=0;for(let i=0;i<this.dataArray.length;i++){const y=this.dataArray[i]/128*HEIGHT/2;0===i?this.canvasCtx.moveTo(x,y):this.canvasCtx.lineTo(x,y),x+=sliceWidth}this.canvasCtx.lineTo(WIDTH,HEIGHT/2),this.canvasCtx.stroke()},populateMicList:async function(){var self=this;try{const mics=(await navigator.mediaDevices.enumerateDevices()).filter((device=>"audioinput"===device.kind)),select=self.controls.micSelect;select.innerHTML="";const uniqueMics=[],seenGroups=new Set;for(const mic of mics)seenGroups.has(mic.groupId)||(uniqueMics.push(mic),seenGroups.add(mic.groupId));if(uniqueMics.length<=1)return void(select.disabled=!0);uniqueMics.forEach(((mic,index)=>{const option=document.createElement("option");option.value=mic.deviceId,option.text=mic.label||"Microphone ".concat(index+1),select.appendChild(option)})),select.parentElement.classList.remove("hidden"),select.addEventListener("change",(async e=>{const deviceId=e.target.value;await self.switchMic(deviceId)}))}catch(err){log.debug("Failed to get microphone list:",err)}},switchMic:async function(deviceId){var self=this;self.mediaStream&&self.mediaStream.getTracks().forEach((track=>track.stop()));try{if(self.mediaStream=await navigator.mediaDevices.getUserMedia({audio:{deviceId:{exact:deviceId}}}),self.pc){const senders=self.pc.getSenders(),audioTrack=self.mediaStream.getAudioTracks()[0],audioSender=senders.find((sender=>"audio"===sender.track.kind));audioSender&&audioSender.replaceTrack(audioTrack)}await self.initializeMicStream(),self.isMicInitialized&&(self.sourceNode.connect(self.analyser),self.mediaStream.getTracks().forEach((track=>{track.enabled=self.isMicActive})),self.isMicActive&&self.drawWave()),log.debug("Switched microphone to:"+deviceId)}catch(err){log.debug("Failed to switch microphone:"),log.debug(err)}}}}));

//# sourceMappingURL=audiochat.min.js.map