define(["jquery","core/log","mod_minilesson/ttwavencoder","mod_minilesson/ttstreamer"],(function($,log,wavencoder,audiostreamer){return log.debug("TT Audio Helper initialising"),{encodingconfig:null,streamer:null,encoder:null,microphone:null,isRecording:!1,audioContext:null,processor:null,uniqueid:null,alreadyhadsound:!1,silencecount:0,silenceintervals:15,silencelevel:25,enablesilencedetection:!0,wavconfig:{bufferLen:4096,numChannels:2,desiredSampleRate:48e3,mimeType:"audio/wav"},streamingconfig:{bufferLen:4096,numChannels:1,desiredSampleRate:16e3,mimeType:"audio/wav"},clone:function(){return $.extend(!0,{},this)},init:function(waveHeight,uniqueid,therecorder){this.waveHeight=waveHeight,this.uniqueid=uniqueid,this.therecorder=therecorder,this.region=therecorder.region,this.therecorder.is_streaming?this.encodingconfig=this.streamingconfig:this.encodingconfig=this.wavconfig,this.prepare_html(),window.AudioContext=window.AudioContext||window.webkitAudioContext},onStop:function(){},onStream:function(){},onSocketReady:function(){},onError:function(){},onfinalspeechcapture:function(speechtext){},oninterimspeechcapture:function(speechtext){},prepare_html:function(){this.canvas=$("#"+this.uniqueid+"_waveform"),this.canvasCtx=this.canvas[0].getContext("2d")},start:function(){var that=this;this.audioContext=new AudioContext({sampleRate:this.encodingconfig.desiredSampleRate}),this.processor=this.audioContext.createScriptProcessor(this.encodingconfig.bufferLen,this.encodingconfig.numChannels,this.encodingconfig.numChannels),this.processor.connect(this.audioContext.destination);"audioSession"in navigator&&(navigator.audioSession.type="play-and-record",console.log("AudioSession API is supported")),navigator.mediaDevices.getUserMedia({audio:!0,video:!1}).then((function(stream){that.isRecording=!0,that.tracks=stream.getTracks();for(var i=0;i<that.tracks.length;i++){var track=that.tracks[i];if("audio"==track.kind){var settings=track.getSettings();settings.noiseSuppression?log.debug("Noise Suppression is on"):log.debug("Noise Suppression is off"),settings.echoCancellation?log.debug("Echo Cancellation is on"):log.debug("Echo Cancellation is off")}}that.microphone=that.audioContext.createMediaStreamSource(stream),that.microphone.connect(that.processor),that.therecorder.is_streaming&&(that.streamer=audiostreamer.clone(),that.streamer.init(that.therecorder.speechtoken,that),that.enablesilencedetection=!1),that.onStream(stream),that.encoder=wavencoder.clone(),that.encoder.init(that.audioContext.sampleRate,that.encodingconfig.numChannels),that.processor.onaudioprocess=function(event){var thebuffers=that.getBuffers(event);that.encoder.audioprocess(thebuffers),that.streamer&&that.streamer.audioprocess(thebuffers)},that.listener=that.audioContext.createAnalyser(),that.microphone.connect(that.listener),that.listener.fftSize=2048,that.bufferLength=that.listener.frequencyBinCount,that.analyserData=new Uint8Array(that.bufferLength),that.volumeData=new Uint8Array(that.bufferLength),that.canvasCtx.clearRect(0,0,2*that.canvas.width(),2*that.waveHeight),that.alreadyhadsound=!1,that.silencecount=0,that.interval=setInterval((function(){that.drawWave(),that.detectSilence()}),100)})).catch(this.onError)},stop:function(){var that=this;clearInterval(this.interval),this.canvasCtx.clearRect(0,0,2*this.canvas.width(),2*this.waveHeight),this.isRecording=!1,this.silencecount=0,this.alreadyhadsound=!1,this.therecorder.update_audio("isRecording",!1),setTimeout((function(){null!==that.audioContext&&"closed"!==that.audioContext.state&&that.audioContext.close(),that.processor.disconnect(),that.tracks.forEach((track=>track.stop())),that.onStop(that.encoder.finish()),that.streamer&&that.streamer.finish()}),1e3)},getBuffers:function(event){for(var buffers=[],ch=0;ch<this.encodingconfig.numChannels;++ch)buffers[ch]=event.inputBuffer.getChannelData(ch);return buffers},detectSilence:function(){if(!this.enablesilencedetection)return;this.listener.getByteFrequencyData(this.volumeData);let sum=0;for(var vindex=0;vindex<this.volumeData.length;vindex++)sum+=this.volumeData[vindex]*this.volumeData[vindex];var volume=Math.sqrt(sum/this.volumeData.length);volume<this.silencelevel&&this.alreadyhadsound?(this.silencecount++,this.silencecount>=this.silenceintervals&&this.therecorder.silence_detected()):volume>this.silencelevel&&(this.alreadyhadsound=!0,this.silencecount=0)},drawWave:function(){var width=2*this.canvas.width();this.listener.getByteTimeDomainData(this.analyserData),this.canvasCtx.fillStyle="white",this.canvasCtx.fillRect(0,0,width,2*this.waveHeight),this.canvasCtx.lineWidth=5,this.canvasCtx.strokeStyle="gray",this.canvasCtx.beginPath();for(var slicewaveWidth=width/this.bufferLength,x=0,i=0;i<this.bufferLength;i++){var y=this.analyserData[i]/128*this.waveHeight;0===i||this.canvasCtx.lineTo(x,y),x+=slicewaveWidth}this.canvasCtx.lineTo(width,this.waveHeight),this.canvasCtx.stroke()}}}));

//# sourceMappingURL=ttaudiohelper.min.js.map