/**
 * Scatter app javascript for Poodll minilesson
 *
 * @package    mod_minilesson
 * @copyright  2024 Justin Hunt (poodllsupport@gmail.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(["jquery","core/notification","mod_minilesson/definitions","core/log","core/templates","mod_minilesson/animatecss","core/ajax","core/str","mod_minilesson/spacegame"],(function($,notification,def,log,templates,anim,Ajax,str,spacegame){return log.debug("MiniLesson Scatter: initialising"),{pointer:1,jsondata:null,props:null,language:"en-US",startTime:null,scatteritems:[],controls:{},progressTimer:null,markedIndex:[],clone:function(){return $.extend(!0,{},this)},init:function(index,itemdata,quizhelper){log.debug(itemdata),this.scatteritems=itemdata.scatteritems,this.language=itemdata.language,this.itemdata=itemdata,this.index=index,this.quizhelper=quizhelper;var animopts={};animopts.useanimatecss=quizhelper.useanimatecss,anim.init(animopts),this.init_controls(),this.register_events(),this.start()},init_controls:function(){var self=this;self.controls={container:$("#"+self.itemdata.uniqueid+"_container")},self.controls.stage=self.controls.container.find(".ml_scatter_stage"),self.controls.next_button=self.controls.container.find(".minilesson_nextbutton"),self.controls.progress_container=self.controls.container.find(".progress-container"),self.controls.result_container=self.controls.container.find(".ml_scatter_resultscontainer"),self.controls.actionbutton=self.controls.container.find(".minilesson_actionbutton"),self.controls.retrybutton=self.controls.container.find(".minilesson-try-again");self.controls.stage.children(".ml_scatter_listitem").each(((i,listitem)=>{self.itemdata.shuffleditems[i].item=listitem}))},shuffleItems:function(){var self=this;let randomIndex,array=Array.from(self.itemdata.shuffleditems),currentIndex=array.length;for(;0!=currentIndex;)randomIndex=Math.floor(Math.random()*currentIndex),currentIndex--,[array[currentIndex],array[randomIndex]]=[array[randomIndex],array[currentIndex]];self.itemdata.shuffleditems=array,self.itemdata.shuffleditems.forEach((shuffleitem=>{shuffleitem.item.classList.remove("borderblue","border","border-success","border-warning","shake-constant","invisible"),self.controls.stage.append(shuffleitem.item)}))},check_crosscard:function(e){var self=this;const $target=$(e.target),$listItems=self.controls.stage.children(".ml_scatter_listitem");if(!$listItems.is($target))return;$listItems.filter(((_,i)=>!i.classList.contains("border-success"))).removeClass("borderblue border border-warning shake-constant");const currentIndex=$target.index();if(0==self.markedIndex.length)self.markedIndex.push(currentIndex);else if(self.markedIndex.includes(currentIndex)){const rIndex=self.markedIndex.findIndex((i=>i===currentIndex));rIndex>-1&&self.markedIndex.slice(rIndex,1)}else{const lastIndex=self.markedIndex[0],lastItem=self.itemdata.shuffleditems[lastIndex],currentItem=self.itemdata.shuffleditems[currentIndex];lastItem.key===currentItem.key?(self.itemdata.scatteritems[currentItem.key].correct=!0,$listItems.eq(lastIndex).addClass("border border-success ml_scatter_anim_correct"),$listItems.eq(currentIndex).addClass("border border-success ml_scatter_anim_correct"),setTimeout((function(){$listItems.eq(lastIndex).addClass("invisible"),$listItems.eq(currentIndex).addClass("invisible"),$listItems.filter(":not(.invisible)").length||self.end()}),500)):(self.itemdata.scatteritems[currentItem.key].correct=!1,$listItems.eq(lastIndex).addClass("border border-warning ml_scatter_anim_incorrect"),$listItems.eq(currentIndex).addClass("border border-warning ml_scatter_anim_incorrect"),setTimeout((function(){$listItems.eq(lastIndex).removeClass("border border-warning ml_scatter_anim_incorrect"),$listItems.eq(currentIndex).removeClass("border border-warning ml_scatter_anim_incorrect")}),500)),self.markedIndex=[]}self.markedIndex.forEach((i=>{$listItems.eq(i).addClass("borderblue")})),$listItems.filter(":not(.invisible)").length||self.end()},next_question:function(){var stepdata={};stepdata.index=this.index,stepdata.hasgrade=!0,stepdata.totalitems=this.itemdata.scatteritems.length,stepdata.correctitems=this.itemdata.scatteritems.filter((e=>e.correct)).length,stepdata.grade=Math.round(stepdata.correctitems/stepdata.totalitems*100),this.quizhelper.do_next(stepdata)},register_events:function(){var self=this;self.controls.stage.on("click",self.check_crosscard.bind(self)),self.controls.stage.on("keydown",(function(e){" "!==e.key&&"Spacebar"!==e.key||$(document.activeElement).hasClass("ml_scatter_listitem")&&(self.check_crosscard.call(self,{target:document.activeElement}),e.preventDefault())})),self.controls.container.on("showElement",(()=>{self.itemdata.timelimit>0&&(self.controls.progress_container.show(),self.controls.progress_container.find("i").show(),self.progressTimer&&(clearInterval(self.progressTimer),self.progressTimer=null),self.progressTimer=self.controls.progress_container.find("#progresstimer").progressTimer({height:"5px",timeLimit:self.itemdata.timelimit,onFinish:function(){self.end()}}).attr("timer")),self.startTime=Date.now()})),self.controls.container.on("click","#minilesson-try-again",(()=>{self.startTime=null,self.markedIndex=[],self.shuffleItems(),self.controls.container.trigger("showElement"),self.controls.result_container.hide(),self.controls.stage.show(),self.controls.progress_container.find("#progresstimer,i").show(),self.controls.actionbutton.show()})),self.controls.container.on("keydown","#minilesson-try-again",(function(e){" "!==e.key&&"Spacebar"!==e.key||($(this).trigger("click"),e.preventDefault())})),self.controls.next_button.on("click",(function(){self.next_question()})),self.controls.next_button.on("keydown",(function(e){" "!==e.key&&"Spacebar"!==e.key||($(this).trigger("click"),e.preventDefault())}))},start:function(){},end:function(){var self=this,tdata={prettytime:"00:00",results:[]},totaltime=Date.now()-self.startTime;totaltime>0&&(totaltime=Number.parseFloat(totaltime/1e3).toFixed(0)),totaltime>0&&(tdata.prettytime=spacegame.pretty_print_secs(totaltime)),tdata.showitemreview=self.quizhelper.showitemreview,tdata.allowretry=self.itemdata.allowretry,tdata.total=self.itemdata.scatteritems.length,tdata.totalcorrect=self.itemdata.scatteritems.filter((e=>e.correct)).length,self.itemdata.scatteritems.forEach((item=>{tdata.results.push({question:item.term,answer:item.definition,correct:item.correct})})),self.controls.result_container.show(),self.controls.stage.hide(),self.controls.progress_container.find("#progresstimer,i").hide(),self.controls.actionbutton.hide(),self.progressTimer&&(clearInterval(self.progressTimer),self.progressTimer=null),templates.render("mod_minilesson/scatter_feedback",tdata).then((function(html,js){self.controls.result_container.html(html),templates.runTemplateJS(js||"")}))}}}));

//# sourceMappingURL=scatter.min.js.map