define(["jquery","core/log"],(function($,log){return log.debug("Media Uploader: initialising"),{config:null,clone:function(){return $.extend(!0,{},this)},init:function(config){this.config=config,this.config.sourcemimetype="audio/wav",this.registerEvents(),this.fetchNewUploadDetails()},registerEvents:function(){},fetchNewUploadDetails:function(){var xhr=new XMLHttpRequest,that=this;xhr.onreadystatechange=function(e){if(4===this.readyState)if(200===xhr.status){var payload=xhr.responseText,payloadobject=JSON.parse(payload);if(payloadobject){if(payloadobject.returnCode>0){var messageObject={};return messageObject.id=that.config.id,messageObject.type="error",messageObject.code=payloadobject.returnCode,messageObject.message=payloadobject.returnMessage,void that.message(messageObject)}that.config.allowedURL=payloadobject.allowedURL,that.config.posturl=payloadobject.postURL,that.config.filename=payloadobject.filename,that.config.s3filename=payloadobject.s3filename,that.config.s3root=payloadobject.s3root,that.config.cloudfilename=payloadobject.shortfilename,that.config.cloudroot=payloadobject.shortroot}else log.debug("error:"+payloadobject.message)}else log.debug("Not 200 response:"+xhr.status)};var xhrparams="wstoken="+this.config.wstoken+"&wsfunction=local_cpapi_fetch_upload_details&moodlewsrestformat=json&mediatype="+this.config.mediatype+"&parent="+this.config.parent+"&appid="+this.config.appid+"&owner="+this.config.owner+"&region="+this.config.region+"&expiredays="+this.config.expiredays+"&transcode="+this.config.transcode+"&transcoder="+this.config.transcoder+"&transcribe="+this.config.transcribe+"&subtitle="+this.config.subtitle+"&transcribelanguage="+this.config.language+"&transcribevocab="+this.config.transcribevocab+"&notificationurl="+this.config.notificationurl+"&sourcemimetype="+this.config.sourcemimetype,serverurl=this.config.cloudpoodllurl+"/webservice/rest/server.php";xhr.open("POST",serverurl,!0),xhr.setRequestHeader("Cache-Control","no-cache"),xhr.setRequestHeader("Content-Type","application/x-www-form-urlencoded"),xhr.send(xhrparams)},uploadBlob:function(blob,sourcemimetype){this.uploadFile(blob,sourcemimetype)},extractFilename:function(returntext){var start=returntext.indexOf("success<filename>");if(start<1)return!1;var end=returntext.indexOf("</filename>");return returntext.substring(start+"success<filename>".length,end)},fetchFileExtension:function(filetype){var ext="";switch(filetype.indexOf(";")>0&&(filetype=filetype.split(";")[0]),filetype){case"image/jpeg":ext="jpg";break;case"image/png":ext="png";break;case"audio/wav":ext="wav";break;case"audio/ogg":case"video/ogg":ext="ogg";break;case"audio/mpeg3":case"audio/mp3":case"audio/x-mpeg-3":ext="mp3";break;case"audio/webm":case"video/x-matroska":case"video/webm":ext="webm";break;case"audio/wma":ext="wma";break;case"audio/mp4":case"audio/m4a":case"audio/x-m4a":ext="m4a";break;case"audio/3gpp":case"video/mpeg3":ext="3gpp";break;case"video/m4v":ext="m4v";break;case"video/mp4":ext="mp4";break;case"video/mov":case"video/quicktime":ext="mov";break;case"video/wmv":ext="wmv"}return""===ext&&(ext=filetype.indexOf("video")>-1?"mp4":"mp3"),ext},doUploadCompleteCallback:function(uploader,filename){filename=uploader.config.s3root+uploader.config.s3filename;var callbackObject=[];callbackObject[0]=uploader.config.widgetid,callbackObject[1]="filesubmitted",callbackObject[2]=filename,callbackObject[3]=uploader.config.updatecontrol,callbackObject[4]=uploader.config.s3filename,uploader.config.callbackjs&&""!==uploader.config.callbackjs&&"function"==typeof uploader.config.callbackjs&&uploader.config.callbackjs(callbackObject)},postProcessUpload:function(e,uploader){var xhr=e.currentTarget;if(4===xhr.readyState)if(200===xhr.status){var filename=uploader.config.filename;if(filename||(filename=uploader.extractFilename(xhr.responseText)),!filename)return log.debug("upload failed #1"),void log.debug(xhr);this.doUploadCompleteCallback(uploader,filename),this.fetchNewUploadDetails()}else log.debug("upload failed #3"),log.debug(xhr)},uploadFile:function(filedata,sourcemimetype){var xhr=new XMLHttpRequest,config=this.config,uploader=this,sourceext=this.fetchFileExtension(sourcemimetype),using_s3=config.using_s3;uploader.config.sourcemimetype=sourcemimetype,uploader.config.sourcefilename=uploader.config.s3filename,xhr.onreadystatechange=function(e){using_s3&&4===this.readyState&&uploader.update_filenames(uploader,sourceext),uploader.postProcessUpload(e,uploader)},xhr.open("put",config.posturl,!0),xhr.setRequestHeader("Content-Type","application/octet-stream"),xhr.send(filedata)},update_filenames:function(uploader,sourceext){var config=uploader.config;switch(config.mediatype){case"audio":uploader.config.sourcefilename=config.s3filename.replace(".mp3","."+sourceext),config.transcode||(uploader.config.s3filename=uploader.config.sourcefilename,uploader.config.cloudfilename=uploader.config.s3filename);break;case"video":uploader.config.sourcefilename=config.s3filename.replace(".mp4","."+sourceext),config.transcode||(uploader.config.s3filename=uploader.config.sourcefilename)}},dataURItoBlob:function(dataURI,mimetype){for(var byteString=atob(dataURI.split(",")[1]),ab=new ArrayBuffer(byteString.length),ia=new Uint8Array(ab),i=0;i<byteString.length;i++)ia[i]=byteString.charCodeAt(i);return new Blob([ab],{type:mimetype})},message:function(messageobject){log.debug("Media Uploader Message: "+messageobject.code+" : "+messageobject.message)}}}));

//# sourceMappingURL=mediauploader.min.js.map