define(["jquery","core/log"],(function($,log){return log.debug("TT iFlyTek Streamer initialising"),{speechtoken:null,socket:null,audiohelper:null,earlyaudio:[],partials:[],finals:[],ready:!1,finaltext:"",clone:function(){return $.extend(!0,{},this)},init:function(speechtoken,theaudiohelper){this.speechtoken=speechtoken,this.audiohelper=theaudiohelper,this.preparesocket()},preparesocket:async function(){var that=this,socketurl=this.speechtoken,streamconfig={common:{app_id:"ga63dbb0"},business:{language:"en_us",domain:"ist",accent:"english",vad_eos:2e3,dwa:"wpgs"},data:{status:0,format:"audio/L16;rate=16000",encoding:"raw"}};this.socket=await new WebSocket(socketurl),log.debug("TT iFlyTek Streamer socket prepared"),this.socket.onmessage=function(message){let msg="";const res=JSON.parse(message.data);if(0===res.code){switch(res.status){case 1:var thetext=res.ws.map((word=>word.w)).join(" ");that.partials[res.audio_start]=thetext,(keys=Object.keys(that.partials)).sort(((a,b)=>a-b));for(const key of keys)that.partials[key]&&(msg+=" ".concat(that.partials[key]));that.audiohelper.oninterimspeechcapture(that.finaltext+" "+msg);break;case 2:that.partials=[];var keys;thetext=res.ws.map((word=>word.w)).join(" ");that.finals[res.audio_start]=thetext,(keys=Object.keys(that.finals)).sort(((a,b)=>a-b));for(const key of keys)that.finals[key]&&(msg+=" ".concat(that.finals[key]));that.finaltext=msg,that.audiohelper.oninterimspeechcapture(msg),log.debug("interim (final) transcript: "+msg)}log.debug(msg)}else log.debug("iFlyTek error: "+res.message)},this.socket.onopen=event=>{log.debug("TT iFlyTek Streamer socket opened"),that.partials=[],that.finals=[],that.socket.send(JSON.stringify(streamconfig)),that.audiohelper.onSocketReady("fromsocketopen")},this.socket.onerror=event=>{log.debug(event),that.socket.close()},this.socket.onclose=event=>{log.debug(event),that.socket=null}},updatetoken:function(newtoken){this.socket&&this.socket.close(),this.speechtoken=newtoken,this.preparesocket()},audioprocess:function(stereodata){const base64data=this.binarytobase64(stereodata[0]);if(void 0!==this.ready&&this.ready)if(this.earlyaudio.length>0){for(var i=0;i<this.earlyaudio.length;i++)this.sendaudio(this.earlyaudio[i]);this.earlyaudio=[],this.sendaudio(base64data)}else log.debug("TT iFlyTek Streamer sending current audiodata"),this.sendaudio(base64data);else log.debug("TT iFlyTek Streamer storing base64 audio"),this.earlyaudio.push(base64data)},binarytobase64:function(monoaudiodata){var tempbuffer=[];for(let i=0;i<monoaudiodata.length;i++){const sample=Math.max(-1,Math.min(1,monoaudiodata[i])),intSample=sample<0?32768*sample:32767*sample;tempbuffer.push(255&intSample),tempbuffer.push(intSample>>8&255)}for(var sendbuffer=new Uint8Array(tempbuffer),binary="",i=0;i<sendbuffer.length;i++)binary+=String.fromCharCode(sendbuffer[i]);return btoa(binary)},sendaudio:function(base64){this.socket&&this.socket.send(JSON.stringify({data:{status:1,audio:base64,encoding:"raw"}}))},finish:function(mimeType){var that=this;void 0!==this.ready&&this.ready&&(log.debug("forcing end utterance"),that.socket&&that.socket.send(JSON.stringify({data:{status:2,audio:"",encoding:"raw"}})),log.debug("timing out"),setTimeout((function(){var msg="",sets=[that.finals,that.partials];for(const set of sets){var keys=Object.keys(set);keys.sort(((a,b)=>a-b));for(const key of keys)set[key]&&(msg+=" ".concat(set[key]))}log.debug("sending final speech capture event"),that.audiohelper.onfinalspeechcapture(msg),that.cleanup()}),1e3))},cancel:function(){this.ready=!1,this.earlyaudio=[],this.partials=[],this.finals=[],this.finaltext="",this.socket&&this.socket.close()},cleanup:function(){this.cancel()}}}));

//# sourceMappingURL=ttiflytek.min.js.map