<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace mod_minilesson;

// Why do we need to include this?.

defined('MOODLE_INTERNAL') || die();
require_once($CFG->libdir . '/formslib.php');

use mod_minilesson\constants;
use mod_minilesson\utils;

/**
 * class setupform
 *
 * @package    mod_minilesson
 * @copyright  2025 Justin Hunt (poodllsupport@gmail.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class setupform extends \moodleform {
    /**
     * This is used to identify this itemtype.
     * @var string
     */
    public $type;

    /**
     * The simple string that describes the item type e.g. audioitem, textitem
     * @var string
     */
    public $typestring;

    /**
     * An array of options used in the htmleditor
     * @var array
     */
    protected $editoroptions = [];

    /**
     *
     * An array of options used in the filemanager
     * @var array
     */
    protected $filemanageroptions = [];

    /**
     * An array of options used in the filemanager
     * @var array
     */
    protected $moduleinstance = null;


    /**
     * Add the required basic elements to the form.
     *
     * This method adds the basic elements to the form including title and contents
     * and then calls custom_definition();
     */
    public final function definition() {
        global $CFG;

        $mform = $this->_form;
        $context = $this->_customdata['context'];
        $cmid = $this->_customdata['cmid'];
        utils::add_mform_elements($mform, $context, $cmid, true);

        // Add the action buttons.
        $this->add_action_buttons(get_string('cancel'), get_string('savechangesanddisplay'));
    }

    /**
     * Convenience function: Adds an media upload
     *
     * @param string $name
     * @param int $count The count of the element to add
     * @param string $label, null means default
     * @param bool $required
     * @return void
     */
    protected final function add_media_upload($name, $count = -1, $label = null, $required = false) {
        if ($count > -1) {
            $name = $name . $count;
        }

        $this->_form->addElement(
            'filemanager',
            $name,
            $label,
            null,
            $this->filemanageroptions
        );
    }

    /**
     * Convenience function: Adds an media prompt upload
     *
     * @param string $label, null means default
     * @param bool $required
     * @return void
     */
    protected final function add_media_prompt_upload($label = null, $required = false) {
        return $this->add_media_upload(constants::AUDIOPROMPT, -1, $label, $required);
    }

    /**
     * Convenience function: Adds an response editor
     *
     * @param int $count The count of the element to add
     * @param string $label, null means default
     * @param bool $required
     * @return void
     */
    protected final function add_editorarearesponse($count, $label = null, $required = false) {
        if ($label === null) {
            $label = get_string('response', constants::M_COMPONENT);
        }
        $this->_form->addElement(
            'editor',
            constants::TEXTANSWER . $count . '_editor',
            $label,
            [
                'rows' => '4',
                'columns' => '80',
            ],
            $this->editoroptions
        );
        $this->_form->setDefault(
            constants::TEXTANSWER . $count . '_editor',
            [
                'text' => '',
                'format' => FORMAT_MOODLE,
            ]
        );
        if ($required) {
            $this->_form->addRule(constants::TEXTANSWER . $count . '_editor', get_string('required'), 'required', null, 'client');
        }
    }

    /**
     * Custom validation
     * @param array $data
     * @param array $files
     * @return array
     */
    public function validation($data, $files) {
        $errors = parent::validation($data, $files);
        if (!empty($data['viewend'])) {
            if ($data['viewend'] < $data['viewstart']) {
                $errors['viewend'] = "End date should be after Start Date";
            }
        }
        return $errors;
    }
}
