/**
 * Spacegame app javascript for Poodll minilesson
 *
 * @package    mod_minilesson
 * @copyright  2024 Justin Hunt (poodllsupport@gmail.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(["jquery","core/notification","mod_minilesson/definitions","core/log","core/templates","core/ajax","core/str"],(function($,notification,def,log,templates,Ajax,str){log.debug("MiniLesson Space Game: initialising");class Rectangle{constructor(left,top,width,height){this.left=left||0,this.top=top||0,this.width=width||0,this.height=height||0}right(){return this.left+this.width}bottom(){return this.top+this.height}Contains(point){return point.x>this.left&&point.x<this.right()&&point.y>this.top&&point.y<this.bottom()}Intersect(rectangle){return!(rectangle.left>this.right()||rectangle.right()<this.left||rectangle.top>this.bottom()||rectangle.bottom()<this.top)}}class GameObject{constructor(src,x,y){null!==src&&(this.image=this.loadImage(src)),this.x=x,this.y=y,this.velocity={x:0,y:0},this.direction={x:0,y:0},this.movespeed={x:5,y:3},this.alive=!0,this.decay=.7}loadImage(src){return this.image||(this.image=new Image),this.image.src=M.cfg.wwwroot+"/mod/minilesson/"+src,this.image}update(){this.velocity.x+=this.direction.x*this.movespeed.x,this.velocity.y+=this.direction.y*this.movespeed.y,this.x+=this.velocity.x,this.y+=this.velocity.y,this.velocity.y*=this.decay,this.velocity.x*=this.decay}draw(context){context.drawImage(this.image,this.x,this.y,this.image.width,this.image.height)}getRect(){return new Rectangle(this.x,this.y,this.image.width,this.image.height)}die(){this.alive=!1}}class Player extends GameObject{constructor(src,x,y){super(src,x,y),this.mouse={x:0,y:0},this.movespeed={x:6,y:4},this.lives=3,this.lastScore=0}update(bounds){(app.mouseDown||app.touchDown)&&(this.x<this.mouse.x-this.image.width?app.player.direction.x=1:this.x>this.mouse.x?app.player.direction.x=-1:app.player.direction.x=0,this.y<this.mouse.y-this.image.height?app.player.direction.y=1:this.y>this.mouse.y?app.player.direction.y=-1:app.player.direction.y=0),super.update(bounds),this.x<bounds.x-this.image.width?this.x=bounds.width:this.x>bounds.width&&(this.x=bounds.x-this.image.width),this.y<bounds.y?this.y=bounds.y:this.y>bounds.height-this.image.height&&(this.y=bounds.height-this.image.height)}Shoot(){app.playSound("laser");app.gameObjects.unshift(new Laser(app.player.x,app.player.y,this,!0,24)),app.canShoot=!1}die(){super.die(),app.playSound("explosion"),app.spray(this.x+this.image.width/2,this.y+this.image.height/2,200,"#FFCC00"),this.lastScore=app.score,app.endGame()}gotShot(shot){shot.alive&&(this.lives<=1?this.die():(this.lives--,app.spray(this.x+this.image.width/2,this.y+this.image.height/2,100,"#FFCC00")))}}class Planet extends GameObject{constructor(src,x,y){super(src,x,y)}update(bounds){this.image.width=app.displayRect.width,this.image.height=app.displayRect.height,super.update()}}class Enemy extends GameObject{constructor(src,x,y,text,itempoints,termid){super(src,x,y),this.xspeed=app.enemySpeed,this.yspeed=app.enemySpeed*(2+Math.random())/4,this.movespeed.x=0,this.movespeed.y=0,this.direction.y=1,this.text=text,this.itempoints=itempoints,this.movementClock=0,this.shotFrequency=80,this.shotClock=(1+Math.random())*this.shotFrequency,this.level=app.level,this.termid=termid}update(bounds){if(this.y<bounds.height/10||this.y>9*bounds.height/10?(this.movespeed.x=1*this.xspeed,this.movespeed.y=5*this.yspeed):(this.movespeed.x=this.xspeed,this.movespeed.y=this.yspeed),super.update(bounds),this.movementClock--,this.movementClock--,this.movementClock<=0&&(this.direction.x=Math.floor(3*Math.random())-1,this.movementClock=30*(2+Math.random())),this.shotClock-=app.enemySpeed,this.shotClock<=0&&this.y<.6*bounds.height){app.playSound("enemylaser");var laser=new Laser(this.x,this.y,this);laser.direction.y=1,laser.friendly=!1,app.gameObjects.unshift(laser),this.shotClock=(1+Math.random())*this.shotFrequency}this.x<bounds.x-this.image.width?this.x=bounds.width:this.x>bounds.width&&(this.x=bounds.x-this.image.width),this.y>bounds.height+this.image.height&&this.alive&&(this.alive=!1,this.itempoints>0&&(app.currentPointsLeft-=this.itempoints,app.score-=1e3*this.itempoints),app.shipReachedEnd.call(this))}draw(context){super.draw(context),context.fillStyle="#FFFFFF",context.font="20px Audiowide",context.textAlign="center",app.wrapText(context,this.text,!0,17,.2*app.displayRect.width,this.x+this.image.width/2,this.y-5)}die(){super.die(),app.spray(this.x+this.image.width,this.y+this.image.height,50+150*this.itempoints,"#FF0000"),app.score+=1e3*this.itempoints,app.reportSuccess(this.termid),app.playSound("explosion")}gotShot(shot){shot.die(),this.die()}}class Laser extends GameObject{constructor(x,y,shooter,friendly,laserSpeed){super(friendly?"pix/spacegame/laser.png":"pix/spacegame/enemylaser.png",x,y),this.x=this.x+(shooter.image.width-this.image.width)/2,this.direction.y=-1,this.friendly=friendly?1:0,this.laserSpeed=laserSpeed||12}update(bounds){super.update(bounds),(this.x<bounds.x-this.image.width||this.x>bounds.width||this.y<bounds.y-this.image.height||this.y>bounds.height)&&(this.alive=!1),this.velocity.y=this.laserSpeed*this.direction.y}deflect(){this.image=this.loadImage("pix/spacegame/enemylaser.png"),this.direction.y*=-1,this.friendly=!this.friendly,app.playSound("deflect")}}class Particle extends GameObject{constructor(x,y,velocity,colour){super(null,x,y),this.width=2,this.height=2,this.velocity.x=velocity.x,this.velocity.y=velocity.y,this.aliveTime=0,this.colour=colour,this.decay=1}update(bounds){super.update(bounds),(this.x<bounds.x-this.width||this.x>bounds.width||this.y<bounds.y-this.height||this.y>bounds.height)&&(this.alive=!1),this.aliveTime++,this.aliveTime>15*Math.random()+5&&(this.alive=!1)}getRect(){return new Rectangle(this.x,this.y,this.width,this.height)}draw(context){context.fillStyle=this.colour,context.fillRect(this.x,this.y,this.width,this.height),context.stroke()}}class Star extends GameObject{constructor(bounds){super(null,Math.random()*bounds.width,0),this.width=2,this.height=2,this.direction.y=1,this.movespeed.y=.2+Math.random()/2,this.aliveTime=0}update(bounds){super.update(bounds),this.y>bounds.height&&(this.alive=!1)}draw(context){context.fillStyle="#9999AA",context.fillRect(this.x,this.y,this.width,this.height),context.stroke()}}class MultiEnemy extends Enemy{constructor(x,y,text,itempoints,single,termid){super("pix/spacegame/ship-enemy-yellow-"+app.shipsize+".png",x,y,text,itempoints,termid),this.single=single}die(){super.die(),this.itempoints>0&&(app.currentPointsLeft-=this.itempoints),app.storeResult(this.termid,this.itempoints),(this.single&&1===this.itempoints&&this.itempoints>=1||this.itempoints>0&&app.currentPointsLeft<=0)&&(app.killAllAlive(),app.nextLevel())}gotShot(shot){this.itempoints>0?(shot.die(),this.die(),app.reportSuccess(this.termid)):(app.score+=600*(this.itempoints-.5),app.storeResult(this.termid,0),shot.deflect())}}class MatchEnemy extends Enemy{constructor(x,y,text,itempoints,pairid,stem,termid){super("pix/spacegame/ship-enemy-green-"+app.shipsize+".png",x,y,text,itempoints,termid),this.stem=!!stem,this.pairid=pairid,this.shotFrequency=160,this.hightlighted=!1}die(){app.currentPointsLeft-=this.itempoints,this.itempoints=0,super.die()}gotShot(shot){if(shot.alive&&this.alive)if(app.lastShot==-this.pairid){app.score+=1e3*this.itempoints*2,app.storeResult(this.termid,this.itempoints),app.reportSuccess(this.termid),shot.die(),this.die();var alives=0;app.currentTeam.forEach((function(match){match.pairid==app.lastShot&&match.die(),match.alive&&alives++})),alives<=0&&app.nextLevel()}else app.lastShot==this.pairid?shot.deflect():(shot.die(),this.hightlight(),app.lastShot=this.pairid)}hightlight(){app.currentTeam.forEach((function(match){match.unhightlight()})),this.stem,this.loadImage("pix/spacegame/ship-enemy-blue-"+app.shipsize+".png"),this.hightlighted=!0}unhightlight(){this.hightlighted&&(this.stem,this.loadImage("pix/spacegame/ship-enemy-green-"+app.shipsize+".png")),this.hightlighted=!1}}var app={isFreeMode:!1,strings:{shootthepairs:"Shoot the Pairs"},termAsAlien:"0",questions:[],quizgame:null,stage:null,score:0,particles:[],gameObjects:[],shipsize:"48",images:["pix/spacegame/icon.gif","pix/spacegame/planet.png","pix/spacegame/ship.png","pix/spacegame/ship-poodll-64.png","pix/spacegame/ship-enemy-green-64.png","pix/spacegame/ship-enemy-yellow-64.png","pix/spacegame/ship-enemy-blue-64.png","pix/spacegame/ship-poodll-48.png","pix/spacegame/ship-enemy-green-48.png","pix/spacegame/ship-enemy-yellow-48.png","pix/spacegame/ship-enemy-blue-48.png","pix/spacegame/space-bckg.png","pix/spacegame/enemy.png","pix/spacegame/enemystem.png","pix/spacegame/enemychoice.png","pix/spacegame/enemystemselected.png","pix/spacegame/enemychoiceselected.png","pix/spacegame/laser.png","pix/spacegame/enemylaser.png"],imagesLoaded:0,loadedImages:[],loaded:!1,player:null,planet:null,level:-1,displayRect:{x:0,y:0,width:0,height:0},question:"",interval:null,enemySpeed:null,touchDown:!1,mouseDown:!1,currentTeam:[],lastShot:0,currentPointsLeft:0,context:null,inFullscreen:!1,canShoot:!0,dryRun:!1,ttslanguage:"en-US",distractors:[],controls:{},results:[],timer:null,registerSpaceGameEvents:function(){document.onkeyup=this.keyup,document.onkeydown=this.keydown,document.onmouseup=this.mouseup,document.onmousedown=this.mousedown,document.onmousemove=this.mousemove,document.ontouchstart=this.touchstart,document.ontouchend=this.touchend,document.addEventListener("touchmove",this.touchmove,{passive:!1}),window.onresize=this.orientationChange,document.addEventListener("gesturestart",this.cancelled,!1),document.addEventListener("gesturechange",this.cancelled,!1),document.addEventListener("gestureend",this.cancelled,!1)},playSound:function(soundName){if(document.getElementById("mod_minilesson_spacegame_sound_on").checked){var soundElement=document.getElementById("mod_minilesson_sound_"+soundName);soundElement.currentTime=0,soundElement.play()}},smallscreen:function(){if(app.inFullscreen=!1,document.fullscreenElement)if(document.exitFullscreen){let exitPromise=document.exitFullscreen();exitPromise instanceof Promise?exitPromise.then((()=>console.log("Document Exited from Full screen mode"))).catch((err=>console.error(err))):console.log("Document Exited from Full screen mode")}else document.webkitExitFullscreen?(document.webkitExitFullscreen(),console.log("Document Exited from Full screen mode (webkit)")):document.msExitFullscreen?(document.msExitFullscreen(),console.log("Document Exited from Full screen mode (ms)")):console.error("Fullscreen exit is not supported by this browser");else console.log("Document is not in fullscreen mode");app.stage.removeAttribute("width"),app.stage.removeAttribute("height"),app.stage.removeAttribute("style"),app.stage.classList.remove("floating-game-canvas"),$("#button_container").removeClass("floating-button-container fixed-bottom"),app.displayRect.width=app.stage.clientWidth,app.displayRect.height=app.stage.clientHeight,app.stage.style.width=app.displayRect.width,app.stage.style.height=app.displayRect.height,app.sizeScreen(app.stage)},fschange:function(){this.inFullscreen&&app.smallscreen()},fullscreen:function(){var landscape=window.matchMedia("(orientation: landscape)").matches;try{app.stage.requestFullscreen?app.stage.requestFullscreen():app.stage.msRequestFullscreen?app.stage.msRequestFullscreen():app.stage.mozRequestFullScreen?app.stage.mozRequestFullScreen():console.error("Fullscreen API is not supported by this browser")}catch(e){log.debug(e,"Fullscreen error: ")}app.inFullscreen=!0;var buttonContainer=$("#button_container"),width=window.innerWidth,height=$(window).height();landscape&&width<height&&(height=[width,width=height][0]),height-=buttonContainer.height()+16,app.displayRect.width=width,app.displayRect.height=height,app.stage.style.width=width+"px",app.stage.style.height=height+"px",app.stage.classList.add("floating-game-canvas"),buttonContainer.addClass("floating-button-container fixed-bottom"),$("#mod_minilesson_spacegame_fullscreen_button").blur(),app.sizeScreen(app.stage)},sizeScreen:function(stage){stage.width=app.displayRect.width,stage.height=app.displayRect.height,app.context.imageSmoothingEnabled=!1},orientationChange:function(){app.inFullscreen?app.fullscreen():app.smallscreen()},clearEvents:function(){document.onkeydown=null,document.onkeyup=null,document.onmousedown=null,document.onmouseup=null,document.onmousemove=null,document.ontouchstart=null,document.ontouchend=null,document.ontouchmove=null,window.onresize=null},storeResult:function(termid,points){var theterm=!1;if(app.terms.forEach((function(aterm){aterm.id==termid&&(theterm=aterm)})),theterm){for(var result={question:app.strip_html(theterm.definition),selected:"",correct:theterm.term,points:points,id:theterm.id},i=0;i<app.results.length;i++)if(app.results[i].id==theterm.id){if(!(points>0&&0==app.results[i].points))return;app.results.splice(i,1)}app.results.push(result)}},reportSuccess:function(termid){app.dryRun},reportFailure:function(term1id,term2id){app.dryRun},menuEvents:function(){app.clearEvents(),document.onkeydown=app.menukeydown,document.onmouseup=app.menumousedown,document.ontouchend=app.menutouchend,window.onresize=app.orientationChange},loadGame:function(){app.shuffle(app.questions),app.loaded?app.startGame():(app.images.forEach((function(src){var absolute_src=M.cfg.wwwroot+"/mod/minilesson/"+src,image=new Image;image.src=absolute_src,image.onload=function(){app.loadedImages[src]=image,app.imagesLoaded++,console.log(app.imagesLoaded),app.imagesLoaded>=app.images.length&&app.gameLoaded()}})),app.loaded=!0)},endGame:function(){app.inFullscreen&&(log.debug("quitting full screen"),app.inFullscreen=!1,app.smallscreen()),clearInterval(app.timer.interval),$("#minilesson-gameboard, #minilesson-start-button").hide(),$("#minilesson-results").show();var tdata=[];tdata.allowretry=app.allowretry,tdata.nexturl=app.nexturl,tdata.results=app.results,tdata.total=app.questions.length;var totalcorrect=app.calc_total_points(app.results);tdata.totalcorrect=Math.round(10*totalcorrect)/10,tdata.gamescore=Math.round(app.score);var total_time=app.timer.count;tdata.prettytime=0==total_time?"00:00":app.pretty_print_secs(total_time),templates.render("mod_minilesson/feedback",tdata).then((function(html,js){$("#results-inner").html(html)}));app.results;this.killAllAlive(),this.clearEvents()},gameLoaded:function(){clearInterval(app.interval),app.interval=setInterval((function(){app.draw(app.context,app.displayRect,app.gameObjects,app.particles,app.question),app.update(app.displayRect,app.gameObjects,app.particles)}),40),app.startGame()},startGame:function(){app.score=0,app.gameObjects=[],app.particles=[],app.level=-1,app.enemySpeed=.5,app.touchDown=!1,app.mouseDown=!1,app.results=[],app.player=new Player("pix/spacegame/ship-poodll-"+app.shipsize+".png",0,0),app.player.x=app.displayRect.width/2,app.player.y=app.displayRect.height/2,app.gameObjects.push(app.player),app.planet=new Planet("pix/spacegame/planet.png",0,0),app.planet.image.width=app.displayRect.width,app.planet.image.height=app.displayRect.height,app.planet.direction.y=1,app.planet.movespeed.y=.7,app.particles.push(app.planet),app.timer={interval:setInterval((function(){app.timer.update()}),1e3),count:0,update:function(){app.timer.count++,$("#minilesson-time-counter").text(app.timer.count)}},app.nextLevel(),app.registerSpaceGameEvents()},nextLevel:function(){app.level++,app.level>=app.questions.length?app.player.die():app.question=app.runLevel(app.questions,app.level,app.displayRect)},runLevel:function(questions,level,bounds){switch(app.currentTeam=[],app.lastShot=0,app.currentPointsLeft=0,questions[level].type){case"matching":var i=0,itempoints=1/(2*questions[level].stems.length);app.currentPointsLeft+=1,questions[level].stems.forEach((function(stem){i++;var question=new MatchEnemy(Math.random()*bounds.width,-Math.random()*bounds.height/2,stem.question,itempoints,-i,!0,stem.termid),answer=new MatchEnemy(Math.random()*bounds.width,-Math.random()*bounds.height/2,stem.answer,itempoints,i,!1,stem.termid);app.currentTeam.push(question),app.currentTeam.push(answer),app.gameObjects.push(question),app.gameObjects.push(answer)}));break;case"multichoice":questions[level].answers.forEach((function(answer){var enemy=new MultiEnemy(Math.random()*bounds.width,-Math.random()*bounds.height/2,answer.text,answer.itempoints,questions[level].single,questions[level].termid);answer.itempoints<1&&(app.currentTeam.push(enemy),answer.itempoints>0&&(app.currentPointsLeft+=answer.itempoints)),app.gameObjects.push(enemy)}))}return questions[level].question},draw:function(context,displayRect,objects,particles,question){context.clearRect(0,0,displayRect.width,displayRect.height),app.drawSpaceBackground(context,displayRect);var i=0;for(i=0;i<particles.length;i++)particles[i].draw(context);for(i=0;i<objects.length;i++)objects[i].draw(context);app.player.alive?(context.fillStyle="#FFFFFF",context.font="18px Audiowide",context.textAlign="left",context.fillText(app.strings.score+" "+Math.round(app.score)+"  "+app.strings.lives+" "+app.player.lives,5,displayRect.height-20),context.textAlign="center",app.wrapText(context,question,!1,20,.9*displayRect.width,displayRect.width/2,20)):(context.fillStyle="#FFFFFF",context.font="18px Audiowide",context.textAlign="center",context.fillText(app.strings.endofgame+" "+Math.round(app.player.lastScore),displayRect.width/2,displayRect.height/2))},update:function(bounds,objects,particles){var i=0;for(i=0;i<3;i++)particles.push(new Star(bounds));for(i=0;i<particles.length;i++)particles[i].update(bounds),particles[i].alive||(particles.splice(i,1),i--);for(i=0;i<objects.length;i++){objects[i].update(bounds);for(var j=i+1;j<objects.length;j++)app.collide(objects[i],objects[j]);objects[i].alive||(objects.splice(i,1),i--)}},killAllAlive:function(){app.currentTeam.forEach((function(enemy){enemy.alive&&(enemy.itempoints=0,enemy.die())})),app.currentTeam=[]},collide:function(object1,object2){return object1.alive&&object2.alive&&(this.collideOrdered(object1,object2)||this.collideOrdered(object2,object1))},collideOrdered:function(object1,object2){return object1 instanceof Laser&&object2 instanceof Player&&!object1.friendly&&app.objectsIntersect(object1,object2)?(object2.gotShot(object1),object1.die(),!0):object1 instanceof Laser&&object2 instanceof Enemy&&object1.friendly&&app.objectsIntersect(object1,object2)?(object2.gotShot(object1),!0):!!(object1 instanceof Player&&object2 instanceof Enemy&&app.objectsIntersect(object1,object2))&&(object1.die(),!0)},objectsIntersect:function(object1,object2){var rect1=object1.getRect(),rect2=object2.getRect();return rect1.Intersect(rect2)},spray:function(x,y,num,colour){for(var i=0;i<num;i++)app.particles.push(new Particle(x,y,{x:16*(Math.random()-.5),y:16*(Math.random()-.5)+3},colour))},wrapText:function(context,input,wrapUpwards,textHeight,maxLineWidth,x,y){var drawLines=[],originalY=y,words=input.split(" "),line="",maxTextWidth=0;words.forEach((function(word){var tempLine="";tempLine=line+" "+word;var textWidth=context.measureText(tempLine).width;maxTextWidth=Math.max(maxTextWidth,textWidth),textWidth>maxLineWidth?(drawLines.push({text:line,y:y+=textHeight}),line=word):line=tempLine})),drawLines.push({text:line,y:y+=textHeight});var yOffset=y-originalY,boxmodifier=wrapUpwards?-(yOffset+textHeight+10):-(textHeight+10),borderColor=wrapUpwards?"transparent":"white";app.drawRoundRect(context,borderColor,maxTextWidth+20,textHeight*drawLines.length+20,x-(maxTextWidth+20)/2,y+boxmodifier),context.fillStyle="white",drawLines.forEach((function(drawLine){var modifier=wrapUpwards?-yOffset:0;context.fillText(drawLine.text,x,drawLine.y+modifier)}))},drawRoundRect:function(context,borderColor,width,height,x,y){"white"!==borderColor&&(borderColor="rgba(75, 71, 77, 0.5)"),context.fillStyle="rgba(75, 71, 77, 0.5)",context.fillRect(x,y,width,height),context.strokeStyle=borderColor,context.lineWidth=4,context.strokeRect(x-2,y-2,width+4,height+4)},drawSpaceBackground:function(context,displayRect){for(var img=app.loadedImages["pix/spacegame/space-bckg.png"],tilesX=Math.ceil(displayRect.width/img.width),tilesY=Math.ceil(displayRect.height/img.height),i=0;i<tilesX;i++)for(var j=0;j<tilesY;j++)context.drawImage(img,i*img.width,j*img.height,img.width,img.height)},shipReachedEnd:function(){0===app.currentTeam.filter((function(enemy){return enemy.alive})).length&&app.player.alive&&app.nextLevel()},menukeydown:function(e){-1!==[32,37,38,39,40].indexOf(e.keyCode)&&(e.preventDefault(),32===e.keyCode&&app.loadGame())},menumousedown:function(e){e.target===app.stage&&app.loadGame()},menutouchend:function(e){e.target===app.stage&&app.loadGame()},keydown:function(e){-1!==[32,37,38,39,40].indexOf(e.keyCode)&&(e.preventDefault(),32===e.keyCode&&app.player.alive&&app.canShoot?app.player.Shoot():37===e.keyCode?app.player.direction.x=-1:38===e.keyCode?app.player.direction.y=-1:39===e.keyCode?app.player.direction.x=1:40===e.keyCode&&(app.player.direction.y=1))},keyup:function(e){32===e.keyCode?app.canShoot=!0:-1!==[37,39].indexOf(e.keyCode)?app.player.direction.x=0:-1!==[38,40].indexOf(e.keyCode)&&(app.player.direction.y=0)},mousedown:function(e){e.target===app.stage&&(app.player.getRect().Contains({x:e.offsetX,y:e.offsetY})&&app.player.alive&&app.player.Shoot(),app.mouseDown||(app.player.mouse.x=e.offsetX,app.player.mouse.y=e.offsetY,app.mouseDown=!0))},mouseup:function(){app.player.direction.x=0,app.player.direction.y=0,app.mouseDown=!1},mousemove:function(e){app.player.mouse.x=e.offsetX,app.player.mouse.y=e.offsetY},cancelled:function(event){event.target===app.stage&&event.preventDefault()},touchstart:function(e){e.target===app.stage&&(app.player.alive&&e.touches.length>1?app.player.Shoot():(app.touchDown=!0,app.touchmove(e)),e.preventDefault())},touchend:function(e){0===e.touches.length&&(app.touchDown=!1),app.player.direction.x=0,app.player.direction.y=0,e.target===app.stage&&e.preventDefault()},touchmove:function(e){var rect=e.target.getBoundingClientRect(),x=e.touches[0].pageX-rect.left,y=e.touches[0].clientY-rect.top;window.stage=app.stage,app.player.mouse.x=x,app.player.mouse.y=y-2*app.player.image.height,e.target===app.stage&&e.preventDefault()},shuffle:function(array){for(var temporaryValue,randomIndex,currentIndex=array.length;0!==currentIndex;)randomIndex=Math.floor(Math.random()*currentIndex),temporaryValue=array[currentIndex-=1],array[currentIndex]=array[randomIndex],array[randomIndex]=temporaryValue;return array},strip_html:function(htmlstring){return htmlstring.replace(/<\/?[^>]+(>|$)/g,"")},clone:function(){return $.extend(!0,{},this)},split_array:function(array,chunkSize){null==chunkSize&&(chunkSize=4);for(var result=[],currentIndex=0;currentIndex<array.length;){const chunk=array.slice(currentIndex,currentIndex+chunkSize);if(chunk.length<chunkSize){const remaining=chunkSize-chunk.length;for(var i=0;i<remaining;i++)chunk.push(array[i])}result.push(chunk),currentIndex+=chunkSize}return result},shuffle_array:function(array){for(let i=array.length-1;i>0;i--){const j=Math.floor(Math.random()*(i+1));[array[i],array[j]]=[array[j],array[i]]}},calc_total_points:function(results){var total=0;return $.each(results,(function(i,o){null!=o.points&&(total+=o.points)})),total},pretty_print_secs:function(time){var minutes=Math.floor(time/60),seconds=time-60*minutes;return app.str_pad_left(minutes,"0",2)+":"+app.str_pad_left(seconds,"0",2)},str_pad_left:function(string,pad,length){return(new Array(length+1).join(pad)+string).slice(-length)},init_strings:function(){str.get_strings([{key:"shootthepairs",component:"mod_minilesson"},{key:"emptyquiz",component:"mod_minilesson"},{key:"score",component:"mod_minilesson"},{key:"lives",component:"mod_minilesson"},{key:"spacetostart",component:"mod_minilesson"}]).done((function(s){var i=0;app.strings.shootthepairs=s[i++],app.strings.emptyquiz=s[i++],app.strings.score=s[i++],app.strings.lives=s[i++],app.strings.spacetostart=s[i++]}))},reset:function(){clearInterval(app.interval),clearInterval(app.timer.interval),document.removeEventListener&&(document.removeEventListener("fullscreenchange",app.fschange,!1),document.removeEventListener("MSFullscreenChange",app.fschange,!1),document.removeEventListener("mozfullscreenchange",app.fschange,!1),document.removeEventListener("webkitfullscreenchange",app.fschange,!1)),$("#mod_minilesson_spacegame_fullscreen_button").off("click"),$("#results-inner").html(""),app.questions=[],app.terms=[],app.results=[],app.score=0,app.gameObjects=[],app.particles=[],app.player=null,app.planet=null,app.loaded=!1,app.process()},process:function(){var terms=app.itemdata.spacegameitems.map((function(item,index){var theitem=JSON.parse(item);return theitem.id=index,theitem})),multichoice_alien_chunksize=app.itemdata.aliencountmultichoice,matching_alien_chunksize=app.itemdata.aliencountmatching,include_matching_questions=app.itemdata.includematching;app.terms=terms,app.allowretry=app.itemdata.allowretry,app.shuffle_array(terms);var chunkSize=multichoice_alien_chunksize;terms.length<chunkSize&&(chunkSize=terms.length);for(var mc_levels=app.split_array(terms,chunkSize),thelevel=0;thelevel<mc_levels.length;thelevel++)for(var level=mc_levels[thelevel],i=0;i<level.length;i++){for(var answers=[],j=0;j<level.length;j++){var answertext=app.strip_html(level[j].definition);app.sgoptions===app.termAsAlien&&(answertext=level[j].term),answers.push({text:answertext,itempoints:i===j?1:0})}var questiontext=level[i].term;app.sgoptions===app.termAsAlien&&(questiontext=app.strip_html(level[i].definition)),app.questions.push({question:questiontext,termid:level[i].id,answers:answers,type:"multichoice",single:!0})}if(1==include_matching_questions){chunkSize=matching_alien_chunksize,terms.length<chunkSize&&(chunkSize=terms.length);var matching_levels=app.split_array(terms,chunkSize);for(thelevel=0;thelevel<matching_levels.length;thelevel++){level=matching_levels[thelevel];var subquestions=[];for(i=0;i<level.length;i++)subquestions.push({question:level[i].term,answer:app.strip_html(level[i].definition),termid:level[i].id});app.questions.push({question:app.strings.shootthepairs,stems:subquestions,type:"matching"})}}console.log("After process:",app.questions)},init_controls:function(){app.controls.gameboard=$("#minilesson-gameboard"),app.controls.time_counter=$("#minilesson-time-counter")},showMenu:function(){app.context.clearRect(0,0,app.displayRect.width,app.displayRect.height),app.context.fillStyle="#FFFFFF",app.context.font="18px Audiowide",app.context.textAlign="center",null!==app.questions&&app.questions.length>0?(app.context.fillText(app.strings.spacetostart,app.displayRect.width/2,app.displayRect.height/2),app.menuEvents()):app.context.fillText(app.strings.emptyquiz,app.displayRect.width/2,app.displayRect.height/2),0==app.stage.height&&app.orientationChange()},start:function(){app.results=[],app.controls.gameboard.show(),app.controls.time_counter.text("00:00"),app.timer={interval:setInterval((function(){app.timer.update()}),1e3),count:0,update:function(){app.timer.count++}},document.addEventListener&&(document.addEventListener("fullscreenchange",app.fschange,!1),document.addEventListener("MSFullscreenChange",app.fschange,!1),document.addEventListener("mozfullscreenchange",app.fschange,!1),document.addEventListener("webkitfullscreenchange",app.fschange,!1)),app.stage=document.getElementById("mod_minilesson_spacegame"),app.context=app.stage.getContext("2d"),app.smallscreen(),app.interval=setInterval((function(){app.questions&&app.questions.length>0?app.showMenu():console.log("Questions are not ready or empty.")}),500),$("#mod_minilesson_spacegame_fullscreen_button").on("click",(function(){app.inFullscreen?(app.inFullscreen=!1,app.smallscreen()):app.fullscreen()}))},next_question:function(){var stepdata={};stepdata.index=this.index,stepdata.hasgrade=!0,stepdata.totalitems=app.questions.length;var totalcorrect=app.calc_total_points(app.results);stepdata.correctitems=Math.round(10*totalcorrect)/10,stepdata.grade=Math.round(stepdata.correctitems/stepdata.totalitems*100),this.quizhelper.do_next(stepdata)},register_events:function(index,itemdata,quizhelper){app.index=index,app.quizhelper=quizhelper;var nextbutton=$("#"+itemdata.uniqueid+"_container .minilesson_nextbutton"),clickbutton=$("#"+itemdata.uniqueid+"_container .ml_sg_clickclick");nextbutton.on("click",(function(e){app.next_question(0)})),clickbutton.on("click",(function(e){app.start()})),$("body").on("click","#minilesson-try-again",(function(){app.reset(),app.start()})),$("body").on("click","#minilesson-close-results",(function(){var total_time=app.timer.count,url=app.nexturl.replace(/&amp;/g,"&")+"&localscattertime="+total_time;window.location.replace(url)}))},init:function(index,itemdata,quizhelper){log.debug("MiniLesson Space Game: init function"),app.itemdata=itemdata,app.init_strings(),app.register_events(index,itemdata,quizhelper),app.init_controls(),app.process(),app.start()}};return app}));

//# sourceMappingURL=spacegame.min.js.map