define(["jquery","core/log"],(function($,log){return log.debug("TT Azure Streamer initialising"),{speechtoken:null,socket:null,audiohelper:null,earlyaudio:[],partials:[],finals:[],ready:!1,finaltext:"",region:"westeurope",apidomain:"microsoft.com",lang:"en-US",clone:function(){return $.extend(!0,{},this)},init:function(speechtoken,theaudiohelper){switch(this.speechtoken=speechtoken,this.audiohelper=theaudiohelper,this.lang=theaudiohelper.therecorder.lang,this.sentHeader=!1,theaudiohelper.region){case"capetown":this.region="southafricanorth",this.apidomain="microsoft.com";break;case"ningxia":this.region="chinaeast2",this.apidomain="azure.cn";break;case"beijing":this.region="chinanorth2",this.apidomain="azure.cn";break;case"bahrain":case"dublin":case"frankfurt":case"london":case"westeurope":this.region="westeurope",this.apidomain="microsoft.com";break;default:this.region="eastus",this.apidomain="microsoft.com"}this.preparesocket()},preparesocket:async function(){var that=this,url="wss://".concat(this.region,".stt.speech.").concat(this.apidomain,"/speech/recognition/conversation/cognitiveservices/v1?language=").concat(this.lang);url+="&format=simple",url+="&Authorization=Bearer ".concat(this.speechtoken),this.socket=new WebSocket(url),log.debug("TT Azure Streamer socket prepared"),this.socket.binaryType="arraybuffer",this.requestId||(this.requestId=this.getUuid()),this.socket.onmessage=function(message){if("string"==typeof message.data)try{const bodyStartIndex=message.data.indexOf("{");if(-1===bodyStartIndex)return;const headerSection=message.data.substring(0,bodyStartIndex),bodySection=message.data.substring(bodyStartIndex),res=JSON.parse(bodySection);if(headerSection.includes("Path:speech.hypothesis")){let msg=res.Text;that.audiohelper.oninterimspeechcapture(that.finaltext+" "+msg)}else if(headerSection.includes("Path:speech.phrase")&&"Success"===res.RecognitionStatus){let msg=res.DisplayText;that.finaltext+=" "+msg,that.audiohelper.oninterimspeechcapture(that.finaltext),console.debug("Azure final: "+msg)}}catch(e){console.error("Error parsing Azure message:",e)}},this.socket.onopen=event=>{log.debug("TT Azure Streamer socket opened"),that.ready=!0,that.sentHeader=!1,that.audiohelper.onSocketReady("fromsocketopen")},this.socket.onerror=event=>{log.debug(event),that.socket.close()},this.socket.onclose=event=>{log.debug(event),that.socket=null,that.requestId=null}},updatetoken:function(newtoken){this.socket&&this.socket.close(),this.speechtoken=newtoken,this.preparesocket()},audioprocess:function(stereodata){const base64data=this.binarytobase64(stereodata[0]);if(void 0!==this.ready&&this.ready){if(this.earlyaudio.length>0){this.sentHeader||this.sendWavHeader();for(var i=0;i<this.earlyaudio.length;i++)this.sendaudio(this.earlyaudio[i]);this.earlyaudio=[]}this.sentHeader||this.sendWavHeader(),this.sendaudio(base64data)}else this.earlyaudio.push(base64data)},binarytobase64:function(monoaudiodata){var tempbuffer=[];for(let i=0;i<monoaudiodata.length;i++){const sample=Math.max(-1,Math.min(1,monoaudiodata[i])),intSample=sample<0?32768*sample:32767*sample;tempbuffer.push(255&intSample),tempbuffer.push(intSample>>8&255)}return new Uint8Array(tempbuffer)},sendWavHeader:function(){var buffer=new ArrayBuffer(44),view=new DataView(buffer);this.writeString(view,0,"RIFF"),view.setUint32(4,2147483647,!0),this.writeString(view,8,"WAVE"),this.writeString(view,12,"fmt "),view.setUint32(16,16,!0),view.setUint16(20,1,!0),view.setUint16(22,1,!0),view.setUint32(24,16e3,!0),view.setUint32(28,32e3,!0),view.setUint16(32,2,!0),view.setUint16(34,16,!0),this.writeString(view,36,"data"),view.setUint32(40,2147483647,!0);var headerBytes=new Uint8Array(buffer);this.sendaudio(headerBytes),this.sentHeader=!0},writeString:function(view,offset,string){for(var i=0;i<string.length;i++)view.setUint8(offset+i,string.charCodeAt(i))},getUuid:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(c){var r=16*Math.random()|0;return("x"==c?r:3&r|8).toString(16)}))},createBinaryMessage:function(data){var headers=["Path: audio","X-RequestId: "+(this.requestId?this.requestId:this.getUuid()),"X-Timestamp: "+(new Date).toISOString(),"Content-Type: audio/x-wav"].join("\r\n"),headerBytes=(new TextEncoder).encode(headers),headerLen=headerBytes.length,msg=new Uint8Array(2+headerLen+data.length);return msg[0]=headerLen>>8&255,msg[1]=255&headerLen,msg.set(headerBytes,2),msg.set(data,2+headerLen),msg},sendaudio:function(data){if(this.socket&&this.socket.readyState===WebSocket.OPEN){var binaryMsg=this.createBinaryMessage(data);this.socket.send(binaryMsg)}},finish:function(mimeType){this.socket;var that=this;setTimeout((function(){that.audiohelper.onfinalspeechcapture(that.finaltext),that.cleanup()}),1e3)},cancel:function(){this.ready=!1,this.earlyaudio=[],this.finaltext="",this.socket&&this.socket.close()},cleanup:function(){this.cancel()}}}));

//# sourceMappingURL=ttazure.min.js.map