define(["jquery","core/log","core/notification","core/ajax","mod_minilesson/ttaudiohelper","mod_minilesson/ttbrowserrec","core/str","mod_minilesson/timer","mod_minilesson/ttmsspeech","mod_minilesson/mediauploader"],(function($,log,notification,ajax,audioHelper,browserRec,str,timer,msspeech,mediauploader){return log.debug("TT Recorder: initialising"),{waveHeight:75,audio:{stream:null,blob:null,dataURI:null,start:null,end:null,isRecording:!1,isRecognizing:!1,isWaiting:!1,transcript:null},submitting:!1,owner:"",controls:{},uniqueid:null,audio_updated:null,maxtime:0,passagehash:null,region:null,asrurl:null,lang:null,browserrec:null,usebrowserrec:!1,currentTime:0,stt_guided:!1,currentPrompt:!1,speechtoken:"",speechtokenvalidseconds:"",speechtokentype:"",forcestreaming:!1,is_streaming:!1,using_msspeech:!1,msspeech_instance:null,savemedia:!1,uploader:null,strings:{},clone:function(){return $.extend(!0,{},this)},init:function(opts){var that=this;if(this.uniqueid=opts.uniqueid,this.callback=opts.callback,this.stt_guided=!!opts.stt_guided&&opts.stt_guided,this.init_strings(),this.prepare_html(),this.controls.recordercontainer.show(),this.register_events(),log.debug("ttr uploader savemedia: "+this.savemedia),this.savemedia){log.debug("ttr uploader creating: "),that.uploader=mediauploader.clone();var uconfig={};uconfig.wstoken=that.wstoken,uconfig.moodlewsrestformat="",uconfig.mediatype=that.mediatype,uconfig.parent=that.wwwroot,uconfig.appid=that.appid,uconfig.owner=that.owner,uconfig.region=that.savemediaregion,uconfig.expiredays=that.expiredays,uconfig.transcode=that.transcode?1:0,uconfig.cloudpoodllurl=that.cloudpoodllurl,uconfig.transcoder="default",uconfig.transcribe=0,uconfig.subtitle=0,uconfig.language=that.lang,uconfig.transcribevocab="none",uconfig.notificationurl="none",that.uploader.init(uconfig)}if(this.using_msspeech=this.can_msspeech(),this.using_msspeech){var referencetext=opts.referencetext;this.msspeech_instance=msspeech.clone(),this.msspeech_instance.init(this.speechtoken,this.region,this.lang,referencetext)}var handle_timer_update=function(){var displaytime=that.timer.fetch_display_time();that.controls.timerstatus.html(displaytime),log.debug("timer_seconds: "+that.timer.seconds),log.debug("displaytime: "+displaytime),0==that.timer.seconds&&that.timer.initseconds>0&&(that.update_audio("isRecognizing",!0),that.usebrowserrec?that.browserrec.stop():that.audiohelper.stop())},on_error=function(error){switch(error.name){case"PermissionDeniedError":case"NotAllowedError":notification.alert("Error",that.strings.allowmicaccess,"OK");break;case"DevicesNotFoundError":case"NotFoundError":notification.alert("Error",that.strings.nomicdetected,"OK");break;default:log.debug("Error",error.name)}},on_stopped=function(blob){if(that.timer.stop(),void 0!==blob){var newaudio={blob:blob,dataURI:URL.createObjectURL(blob),end:new Date,isRecording:!1,length:Math.round((that.audio.end-that.audio.start)/1e3)};if(that.update_audio(newaudio),that.savemedia){that.uploader.uploadBlob(that.audio.blob,"audio/wav");var message={type:"mediasaved"};message.mediaurl=that.uploader.config.s3root+that.uploader.config.s3filename,message.bloburl=newaudio.dataURI,log.debug("ttr uploader: callback mediasaved"),log.debug(message),that.callback(message)}that.usebrowserrec||that.is_streaming||(that.using_msspeech?that.do_msspeech(that.audio.blob,(function(response){that.gotMSResults(response),that.update_audio("isRecognizing",!1)})):that.upload_transcribe(that.audio.blob,(function(response){log.debug(response),"success"===response.data.result&&response.data.transcript?that.gotRecognition(response.data.transcript.trim()):notification.alert("Information",that.strings.speechnotrecognized,"OK"),that.update_audio("isRecognizing",!1)})))}},on_gotstream=function(stream){var newaudio={stream:stream,isRecording:!0,isWaiting:!1};that.update_audio(newaudio)};!browserRec.will_work_ok()||this.stt_guided||this.forcestreaming||this.using_msspeech?this.can_stream()&&!this.stt_guided?(this.is_streaming=!0,log.debug("using audio helper and streaming rec"),this.audiohelper=audioHelper.clone(),this.audiohelper.init(this.waveHeight,this.uniqueid,this),that.audiohelper.onError=on_error,that.audiohelper.onStop=on_stopped,that.audiohelper.onStream=on_gotstream,that.audiohelper.onfinalspeechcapture=function(speechtext){that.gotRecognition(speechtext),that.update_audio("isRecording",!1),that.update_audio("isRecognizing",!1)},that.audiohelper.oninterimspeechcapture=function(speechtext){that.gotInterimRecognition(speechtext)}):(log.debug("using upload_transcriber"),this.audiohelper=audioHelper.clone(),this.audiohelper.init(this.waveHeight,this.uniqueid,this),that.audiohelper.onError=on_error,that.audiohelper.onStop=on_stopped,that.audiohelper.onStream=on_gotstream):(log.debug("using browser rec"),this.browserrec=browserRec.clone(),this.browserrec.init(this.lang,this.waveHeight,this.uniqueid),this.usebrowserrec=!0,that.browserrec.onerror=on_error,that.browserrec.onStop=on_stopped,that.browserrec.onend=function(){},that.browserrec.onstart=function(){},that.browserrec.onfinalspeechcapture=function(speechtext){that.gotRecognition(speechtext),that.update_audio("isRecording",!1),that.update_audio("isRecognizing",!1)},that.browserrec.oninterimspeechcapture=function(speechtext){that.gotInterimRecognition(speechtext)}),log.debug("original speechtoken - "+this.speechtoken),log.debug("speechtokentype - "+this.speechtokentype),log.debug("speechtokenvalidseconds - "+this.speechtokenvalidseconds),this.init_token_refresh(),this.timer=timer.clone(),this.timer.init(this.maxtime,handle_timer_update),handle_timer_update()},can_stream:function(){return this.speechtoken&&"false"!==this.speechtoken&&("assemblyai"===this.speechtokentype||"iflytek"===this.speechtokentype||"azure"===this.speechtokentype)&&!this.stt_guided},can_msspeech:function(){return this.speechtoken&&"false"!==this.speechtoken&&"msspeech"===this.speechtokentype},update_currentprompt:function(targettext){this.currentPrompt=targettext,this.using_msspeech&&this.msspeech_instance.set_reference_text(targettext)},blobToArrayBuffer:function(blob){return new Promise(((resolve,reject)=>{const reader=new FileReader;reader.onload=function(event){resolve(event.target.result)},reader.onerror=function(error){reject(error)},reader.readAsArrayBuffer(blob)}))},init_strings:function(){var that=this;str.get_strings([{key:"allowmicaccess",component:"mod_minilesson"},{key:"nomicdetected",component:"mod_minilesson"},{key:"speechnotrecognized",component:"mod_minilesson"}]).done((function(s){var i=0;that.strings.allowmicaccess=s[i++],that.strings.nomicdetected=s[i++],that.strings.speechnotrecognized=s[i++]}))},prepare_html:function(){this.controls.recordercontainer=$("#ttrec_container_"+this.uniqueid),this.controls.recorderbutton=$("#"+this.uniqueid+"_recorderdiv"),this.controls.waveform=$("#"+this.uniqueid+"_waveform"),this.controls.timerstatus=$(".timerstatus_"+this.uniqueid),this.passagehash=this.controls.recorderbutton.data("passagehash"),this.region=this.controls.recorderbutton.data("region"),this.lang=this.controls.recorderbutton.data("lang"),this.asrurl=this.controls.recorderbutton.data("asrurl"),this.speechtoken=this.controls.recorderbutton.data("speechtoken"),this.speechtokenvalidseconds=this.controls.recorderbutton.data("speechtokenvalidseconds"),this.speechtokentype=this.controls.recorderbutton.data("speechtokentype"),this.forcestreaming=this.controls.recorderbutton.data("forcestreaming"),this.maxtime=this.controls.recorderbutton.data("maxtime"),this.waveHeight=this.controls.recorderbutton.data("waveheight"),this.savemedia=1===this.controls.recorderbutton.data("savemedia"),this.savemediaregion=this.controls.recorderbutton.data("savemediaregion"),this.wstoken=this.controls.recorderbutton.data("wstoken"),this.wwwroot=this.controls.recorderbutton.data("wwwroot"),this.appid=this.controls.recorderbutton.data("appid"),this.owner=this.controls.recorderbutton.data("owner"),this.transcode=1===this.controls.recorderbutton.data("transcode"),this.expiredays=this.controls.recorderbutton.data("expiredays"),this.mediatype=this.controls.recorderbutton.data("mediatype"),this.cloudpoodllurl=this.controls.recorderbutton.data("cloudpoodllurl")},init_token_refresh:function(){var that=this,validsecs=Number(that.speechtokenvalidseconds)||0;if(that.speechtoken&&validsecs>0){var refreshInterval=1e3*validsecs;log.debug("Refreshing "+that.speechtokentype+" token after "+refreshInterval+" milliseconds"),refreshInterval>0?setTimeout((function(){log.debug("Refreshing streaming token...");ajax.call([{methodname:"mod_minilesson_refresh_token",args:{type:that.speechtokentype,region:that.region},async:!1}])[0].then((ajaxresult=>{log.debug("New token ajaxresult:",ajaxresult);var newtoken=JSON.parse(ajaxresult);if(log.debug("New token received:",newtoken),newtoken&&newtoken.token){switch(that.speechtoken=newtoken.token,that.speechtokenvalidseconds=newtoken.validseconds,that.speechtokentype){case"assemblyai":case"iflytek":case"azure":that.helper.streamer.updatetoken(newtoken.token);break;case"msspeech":that.msspeech_instance.updatetoken(newtoken.token)}log.debug("Streaming token refreshed successfully."),that.init_token_refresh()}else log.debug("New token was not a token.")}))}),refreshInterval):log.debug("Refresh interval is 0. Not refreshing token.")}else log.debug("No valid streaming token available, skipping refresh setup.")},silence_detected:function(){this.audio.isRecording&&this.toggleRecording()},update_audio:function(newprops,val){if("string"==typeof newprops)log.debug("update_audio:"+newprops+":"+val),this.audio[newprops]!==val&&(this.audio[newprops]=val,this.audio_updated());else{for(var theprop in newprops)this.audio[theprop]=newprops[theprop],log.debug("update_audio:"+theprop+":"+newprops[theprop]);this.audio_updated()}},register_events:function(){var that=this;this.controls.recordercontainer.click((function(){that.toggleRecording()})),this.audio_updated=function(){that.audio.isRecognizing||that.audio.isWaiting?that.show_recorder_pointer("none"):that.show_recorder_pointer("auto"),that.audio.isRecognizing||that.audio.isWaiting?(this.controls.recorderbutton.removeClass("ttrec_ready"),this.controls.recorderbutton.removeClass("ttrec_waiting"),this.controls.waveform.removeClass("ttrec_waiting"),this.controls.recorderbutton.removeClass("ttrec_isrecording"),this.controls.recorderbutton.addClass("ttrec_engaged")):that.audio.isRecording?(this.controls.recorderbutton.removeClass("ttrec_ready"),this.controls.waveform.removeClass("ttrec_waiting"),this.controls.recorderbutton.removeClass("ttrec_waiting"),this.controls.recorderbutton.removeClass("ttrec_engaged"),this.controls.recorderbutton.addClass("ttrec_isrecording")):(that.audio.isWaiting,this.controls.recorderbutton.removeClass("ttrec_engaged"),this.controls.recorderbutton.removeClass("ttrec_waiting"),this.controls.recorderbutton.removeClass("ttrec_isrecording"),this.controls.waveform.removeClass("ttrec_waiting"),this.controls.recorderbutton.addClass("ttrec_ready")),that.controls.recorderbutton.html(that.recordBtnContent())}},show_recorder_pointer:function(show){show?this.controls.recorderbutton.css("pointer-events","none"):this.controls.recorderbutton.css("pointer-events","auto")},startedRecording:function(){var message={type:"recording",results:""};this.callback(message)},gotMSResults:function(results){log.debug(results);var message={type:"pronunciation_results"};message.results=results,this.callback(message)},gotRecognition:function(transcript){if(log.debug("transcript:"+transcript),""!=transcript.trim()){var message={type:"speech"};message.capturedspeech=transcript,this.callback(message)}},gotInterimRecognition:function(transcript){var message={type:"interimspeech"};message.capturedspeech=transcript,this.callback(message)},cleanWord:function(word){return word.replace(/['!"#$%&\\'()\*+,\-\.\/:;<=>?@\[\\\]\^_`{|}~']/g,"").toLowerCase()},recordBtnContent:function(){return this.audio.isRecognizing?'<i class="fa fa-spinner fa-spin">':this.audio.isRecording?'<i class="fa fa-stop">':this.audio.isWaiting?'<i class="fa fa-solid fa-cog fa-spin">':'<i class="fa fa-microphone">'},toggleRecording:function(){if(!this.audio.isRecognizing&&!this.audio.isWaiting)if(this.audio.isRecording)this.timer.stop(),this.usebrowserrec?(this.update_audio("isRecording",!1),this.update_audio("isRecognizing",!0),this.browserrec.stop()):(this.update_audio("isRecognizing",!0),this.audiohelper.stop());else{if(this.currentTime=0,this.timer.reset(),this.timer.start(),this.usebrowserrec)this.update_audio("isRecording",!0),this.browserrec.start();else{var newaudio={stream:null,blob:null,dataURI:null,start:new Date,end:null,isRecording:!1,isRecognizing:!1,isWaiting:!0,transcript:null};this.update_audio(newaudio),this.audiohelper.start()}this.startedRecording()}},upload_transcribe:function(blob,callback){var bodyFormData=new FormData,blobname=this.uniqueid+Math.floor(100*Math.random())+".wav";bodyFormData.append("audioFile",blob,blobname),bodyFormData.append("scorer",this.passagehash),this.stt_guided?bodyFormData.append("strictmode","false"):bodyFormData.append("strictmode","true"),!1!==this.currentPrompt&&bodyFormData.append("prompt",this.currentPrompt),bodyFormData.append("lang",this.lang),bodyFormData.append("wwwroot",M.cfg.wwwroot);var oReq=new XMLHttpRequest;oReq.open("POST",this.asrurl,!0),oReq.onUploadProgress=function(progressEvent){},oReq.onload=function(oEvent){200===oReq.status?callback(JSON.parse(oReq.response)):(callback({data:{result:"error"}}),log.debug(oReq.error))};try{oReq.send(bodyFormData)}catch(err){callback({data:{result:"error"}}),log.debug(err)}},do_msspeech:function(blob,callback){this.msspeech_instance.recognize(blob,callback)}}}));

//# sourceMappingURL=ttrecorder.min.js.map