define(["jquery","core/log"],(function($,log){return log.debug("TT Streamer initialising"),{speechtoken:null,socket:null,audiohelper:null,earlyaudio:[],finals:[],ready:!1,finaltext:"",lang:"en-US",clone:function(){return $.extend(!0,{},this)},init:function(speechtoken,speechregion,theaudiohelper){this.speechtoken=speechtoken,this.audiohelper=theaudiohelper,this.lang=theaudiohelper.therecorder.lang,this.preparesocket()},preparesocket:function(){var that=this,basehost="wss://streaming.assemblyai.com";switch(this.audiohelper.region){case"frankfurt":case"london":case"dublin":basehost="wss://streaming.eu.assemblyai.com";break;default:basehost="wss://streaming.assemblyai.com"}var themodel="universal-streaming-english";if("en"===this.lang.slice(0,2))themodel="universal-streaming-english";else themodel="universal-streaming-multilingual";var query="sample_rate=16000&encoding=pcm_s16le&speech_model="+themodel+"&token="+this.speechtoken,url="".concat(basehost,"/v3/ws?").concat(query);this.ready=!1,this.socket=new WebSocket(url),log.debug("TT Streamer socket prepared"),this.socket.onmessage=function(message){try{const payload=JSON.parse(message.data),eventType=payload.type||payload.message_type;switch(log.debug("TT Streamer message type: "+eventType),eventType){case"Begin":that.handlesessioncreated();break;case"Turn":that.handlefinalresponse(payload)}}catch(error){log.debug("\nError handling message: ".concat(error)),log.debug("Message data: ".concat(message))}},this.socket.onopen=event=>{log.debug("TT Streamer socket opened"),that.finaltext="",that.finals=[],that.audiohelper.onSocketReady("fromsocketopen")},this.socket.onerror=event=>{log.debug(event),that.doclosesocket()},this.socket.onclose=event=>{log.debug(event),that.socket=null}},updatetoken:function(newtoken){this.socket&&this.doclosesocket(),this.speechtoken=newtoken,this.preparesocket()},audioprocess:function(stereodata){var int16data=this.convertflattoint16(stereodata[0]);if(void 0!==this.ready&&this.ready)if(this.earlyaudio.length>0){for(var i=0;i<this.earlyaudio.length;i++)this.sendaudio(this.earlyaudio[i]);this.earlyaudio=[],this.sendaudio(int16data)}else this.sendaudio(int16data);else log.debug("TT Streamer storing audio"),this.earlyaudio.push(int16data)},convertflattoint16:function(monoaudiodata){var tempbuffer=[];for(let i=0;i<monoaudiodata.length;i++){const sample=Math.max(-1,Math.min(1,monoaudiodata[i])),intSample=sample<0?32768*sample:32767*sample;tempbuffer.push(255&intSample),tempbuffer.push(intSample>>8&255)}return new Uint8Array(tempbuffer)},sendaudio:function(audiodata){this.socket&&this.socket.readyState===WebSocket.OPEN&&this.socket.send(audiodata)},finish:function(mimeType){var that=this;void 0!==this.ready&&this.ready&&(log.debug("committing universal response"),this.doclosesocket(),log.debug("setting time out to build transcript"),setTimeout((function(){var finaltranscript=that.buildtranscript();log.debug("sending final speech capture event"),that.audiohelper.onfinalspeechcapture(finaltranscript),that.cleanup()}),1e3))},cancel:function(){this.ready=!1,this.earlyaudio=[],this.finals={},this.finaltext="",this.socket&&this.doclosesocket()},cleanup:function(){this.cancel()},doclosesocket:function(){if(this.socket&&[WebSocket.OPEN,WebSocket.CONNECTING].includes(this.socket.readyState)){try{if(this.socket.readyState===WebSocket.OPEN){const terminateMessage={type:"Terminate"};console.log("Sending termination message: ".concat(JSON.stringify(terminateMessage))),this.socket.send(JSON.stringify(terminateMessage))}this.socket.close()}catch(error){console.error("Error closing WebSocket: ".concat(error))}this.socket=null}},handlesessioncreated:function(){if(log.debug("TT Streamer session created"),this.ready=!0,this.earlyaudio.length>0){for(var i=0;i<this.earlyaudio.length;i++)this.sendaudio(this.earlyaudio[i]);this.earlyaudio=[]}this.audiohelper.onSocketReady("fromsessioncreated")},handlefinalresponse:function(payload){var thistranscript=payload.transcript||"";this.finals[payload.turn_order]=thistranscript,this.finaltext=this.buildtranscript(),this.audiohelper.oninterimspeechcapture(thistranscript),log.debug("TT Streamer final transcript update: "+thistranscript)},buildtranscript:function(){for(var combined="",i=0;i<this.finals.length;i++){var text=this.finals[i];text&&(combined+=(combined?" ":"")+text)}return combined.trim()}}}));

//# sourceMappingURL=ttstreamer.min.js.map