define(["jquery","core/log","mod_readaloud/ttwavencoder"],(function($,log,wavencoder){return log.debug("TT Audio Helper initialising"),{encoder:null,microphone:null,isRecording:!1,audioContext:null,processor:null,uniqueid:null,alreadyhadsound:!1,silencecount:0,silenceintervals:15,silencelevel:25,config:{bufferLen:4096,numChannels:2,mimeType:"audio/wav"},clone:function(){return $.extend(!0,{},this)},init:function(waveHeight,uniqueid,therecorder){this.waveHeight=waveHeight,this.uniqueid=uniqueid,this.therecorder=therecorder,this.prepare_html(),window.AudioContext=window.AudioContext||window.webkitAudioContext},onStop:function(){},onStream:function(){},onError:function(){},prepare_html:function(){this.canvas=$("#"+this.uniqueid+"_waveform"),this.canvasCtx=this.canvas[0].getContext("2d")},start:function(shadow){var that=this;this.audioContext=new AudioContext,this.audioContext.createJavaScriptNode?this.processor=this.audioContext.createJavaScriptNode(this.config.bufferLen,this.config.numChannels,this.config.numChannels):this.audioContext.createScriptProcessor?this.processor=this.audioContext.createScriptProcessor(this.config.bufferLen,this.config.numChannels,this.config.numChannels):log.debug("WebAudio API has no support on this browser."),this.processor.connect(this.audioContext.destination);var audioconstraints=!0;log.debug("Shadow is "+shadow),!0===shadow&&(audioconstraints={echoCancellation:!1,noiseSuppression:!1}),"audioSession"in navigator&&(navigator.audioSession.type="play-and-record",console.log("AudioSession API is supported")),navigator.mediaDevices.getUserMedia({audio:audioconstraints,video:!1}).then((function(stream){that.onStream(stream),that.isRecording=!0,that.therecorder.update_audio("isRecording",!0),that.tracks=stream.getTracks();for(var i=0;i<that.tracks.length;i++){var track=that.tracks[i];if("audio"==track.kind){var settings=track.getSettings();settings.noiseSuppression?log.debug("Noise Suppression is on"):log.debug("Noise Suppression is off"),settings.echoCancellation?log.debug("Echo Cancellation is on"):log.debug("Echo Cancellation is off")}}that.microphone=that.audioContext.createMediaStreamSource(stream),that.microphone.connect(that.processor),that.encoder=wavencoder.clone(),that.encoder.init(that.audioContext.sampleRate,2),that.processor.onaudioprocess=function(event){that.encoder.encode(that.getBuffers(event))},that.listener=that.audioContext.createAnalyser(),that.microphone.connect(that.listener),that.listener.fftSize=2048,that.bufferLength=that.listener.frequencyBinCount,that.analyserData=new Uint8Array(that.bufferLength),that.volumeData=new Uint8Array(that.bufferLength),that.canvasCtx.clearRect(0,0,2*that.canvas.width(),2*that.waveHeight),that.alreadyhadsound=!1,that.silencecount=0,that.interval=setInterval((function(){that.drawWave(),that.detectSilence()}),100)})).catch(this.onError)},stop:function(){clearInterval(this.interval),this.canvasCtx.clearRect(0,0,2*this.canvas.width(),2*this.waveHeight),this.isRecording=!1,this.silencecount=0,this.alreadyhadsound=!1,this.therecorder.update_audio("isRecording",!1),null!==this.audioContext&&"closed"!==this.audioContext.state&&this.audioContext.close(),this.processor.disconnect(),this.tracks.forEach((function(track){track.stop()})),this.onStop(this.encoder.finish())},getBuffers:function(event){for(var buffers=[],ch=0;ch<2;++ch)buffers[ch]=event.inputBuffer.getChannelData(ch);return buffers},detectSilence:function(){this.listener.getByteFrequencyData(this.volumeData);let sum=0;for(var vindex=0;vindex<this.volumeData.length;vindex++)sum+=this.volumeData[vindex]*this.volumeData[vindex];var volume=Math.sqrt(sum/this.volumeData.length);volume<this.silencelevel&&this.alreadyhadsound?(this.silencecount++,this.silencecount>=this.silenceintervals&&this.therecorder.silence_detected()):volume>this.silencelevel&&(this.alreadyhadsound=!0,this.silencecount=0)},drawWave:function(){var width=2*this.canvas.width();this.listener.getByteTimeDomainData(this.analyserData),this.canvasCtx.fillStyle="white",this.canvasCtx.fillRect(0,0,width,2*this.waveHeight),this.canvasCtx.lineWidth=5,this.canvasCtx.strokeStyle="gray",this.canvasCtx.beginPath();for(var slicewaveWidth=width/this.bufferLength,x=0,i=0;i<this.bufferLength;i++){var y=this.analyserData[i]/128*this.waveHeight;0===i||this.canvasCtx.lineTo(x,y),x+=slicewaveWidth}this.canvasCtx.lineTo(width,this.waveHeight),this.canvasCtx.stroke()}}}));

//# sourceMappingURL=ttaudiohelper.min.js.map