/**
 * Add a create new group modal to the page.
 *
 * @module     mod_solo/gradeform
 * @class      GradeForm
 * @package    mod_solo
 * @copyright  PoodLL
 * @copyright  Based on: 2017 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(["jquery","core/log","core/str","core/modal_factory","core/modal_events","core/fragment","core/ajax","core/yui"],(function($,log,Str,ModalFactory,ModalEvents,Fragment,Ajax,Y){const GradeForm=function(selector,contextid,grademethod){this.contextid=contextid,this.grademethod=grademethod,this.preinit(selector)};return GradeForm.prototype.modal=null,GradeForm.prototype.contextid=-1,GradeForm.prototype.grademethod="simple",GradeForm.prototype.preinit=function(selector){var triggers=selector,that=this;Str.get_string("dopopupgrade","mod_solo").then((function(title){that.formtitle=title})),$(triggers).on("click",(function(e){e.preventDefault(),that.studentid=$(this).attr("data-student-id"),that.cmid=$(this).attr("data-cm-id"),ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:that.formtitle+$(this).attr("data-student-name"),body:that.getBody()}).then((function(modal){return that.modal=modal,that.modal.setLarge(),that.modal.getRoot().on(ModalEvents.hidden,function(){that.modal.setBody(that.getBody())}.bind(that)),that.modal.getRoot().on(ModalEvents.shown,(function(){that.modal.getRoot().append("<style>[data-fieldtype=submit] { display: none ! important; }</style>")})),that.modal.getRoot().on(ModalEvents.save,that.submitForm.bind(that)),that.modal.getRoot().on("submit","form",that.submitFormAjax.bind(that)),that.modal.show(),that.modal}))}))},GradeForm.prototype.init=function(selector){var triggers=selector;return this.studentid=$(selector).attr("data-student-id"),this.cmid=$(selector).attr("data-cm-id"),Str.get_string("creategroup","core_group").then(function(title){return ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:title,body:this.getBody()},triggers)}.bind(this)).then(function(modal){return this.modal=modal,this.modal.setLarge(),this.modal.getRoot().on(ModalEvents.hidden,function(){this.modal.setBody(this.getBody())}.bind(this)),this.modal.getRoot().on(ModalEvents.shown,function(){this.modal.getRoot().append("<style>[data-fieldtype=submit] { display: none ! important; }</style>")}.bind(this)),this.modal.getRoot().on(ModalEvents.save,this.submitForm.bind(this)),this.modal.getRoot().on("submit","form",this.submitFormAjax.bind(this)),this.modal}.bind(this))},GradeForm.prototype.getBody=function(formdata){void 0===formdata&&(formdata={});var params={jsonformdata:JSON.stringify(formdata)};params.studentid=this.studentid,params.cmid=this.cmid;var theform="simple_grade_form";return"rubric"===this.grademethod&&(theform="rubric_grade_form"),Fragment.loadFragment("mod_solo",theform,this.contextid,params)},GradeForm.prototype.handleFormSubmissionResponse=function(){this.modal.hide(),Y.use("moodle-core-formchangechecker",(function(){M.core_formchangechecker.reset_form_dirty_state()}));var element=$(".card[data-original-student='"+this.studentid+"']");Ajax.call([{methodname:"mod_solo_get_grade_submission",args:{userid:this.studentid,cmid:this.cmid}}])[0].done((function(response){log.debug("promises-done"),log.debug(response),response&&response.response[0]&&(log.debug(response.response[0]),log.debug(element),$(element).find(".chatgrade").html(response.response[0].grade),$(element).find(".chatfeedback").html(response.response[0].feedback))})).fail((function(ex){}))},GradeForm.prototype.handleFormSubmissionFailure=function(data){this.modal.setBody(this.getBody(data)),$("[data-original-student]").trigger("change")},GradeForm.prototype.submitFormAjax=function(e){e.preventDefault();var changeEvent=document.createEvent("HTMLEvents");changeEvent.initEvent("change",!0,!0),this.modal.getRoot().find(":input").each((function(index,element){element.dispatchEvent(changeEvent)}));var invalid=$.merge(this.modal.getRoot().find('[aria-invalid="true"]'),this.modal.getRoot().find(".error"));if(invalid.length)invalid.first().focus();else{var formData=this.modal.getRoot().find("form").serialize(),methodName="mod_solo_submit_simple_grade_form";"rubric"===this.grademethod&&(methodName="mod_solo_submit_rubric_grade_form"),Ajax.call([{methodname:methodName,args:{contextid:this.contextid,jsonformdata:JSON.stringify(formData),studentid:parseInt(this.studentid)?parseInt(this.studentid):0,cmid:parseInt(this.cmid)?parseInt(this.cmid):0},done:this.handleFormSubmissionResponse.bind(this,formData),fail:this.handleFormSubmissionFailure.bind(this,formData)}]),this.modal.hide()}},GradeForm.prototype.submitForm=function(e){e.preventDefault(),this.modal.getRoot().find("form").submit()},{init:function(selector,contextid,grademethod){return new GradeForm(selector,contextid,grademethod)}}}));

//# sourceMappingURL=gradeform.min.js.map