<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * English strings for solo
 *
 * You can have a rather longer description of the file as well,
 * if you like, and it can span multiple lines.
 *
 * @package    mod_solo
 * @copyright  2015 Justin Hunt (poodllsupport@gmail.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['modulename'] = 'Poodll Solo';
$string['modulenameplural'] = 'Poodll Solo';
$string['modulename_help'] = 'Poodll Solo is an activity designed to give students speaking practice. Students record themselves speaking about a topic, transcribe their own speech and receive feedback on their work.';
// $string['solofieldset'] = 'Custom example fieldset';
$string['soloname'] = 'Poodll Solo';
$string['soloname_help'] = 'This is the content of the help tooltip associated with the soloname field. Markdown syntax is supported.';
$string['solo'] = 'solo';
$string['activitylink'] = 'Link to next activity';
$string['activitylink_help'] = 'To provide a link after the attempt to another activity in the course, select the activity from the dropdown list.';
$string['activitylinkname'] = 'Continue to next activity: {$a}';
$string['pluginadministration'] = 'Poodll Solo Administration';
$string['pluginname'] = 'Poodll Solo';
// $string['someadminsetting'] = 'Some Admin Setting';
// $string['someadminsetting_details'] = 'More info about Some Admin Setting';
// $string['someinstancesetting'] = 'Some Instance Setting';
// $string['someinstancesetting_details'] = 'More infor about Some Instance Setting';
$string['solosettings'] = 'Solo settings';
$string['solo:addinstance'] = 'Add a new Poodll Solo';
$string['solo:view'] = 'View Poodll Solo';
$string['solo:viewreports'] = 'View Poodll Solo reports';
$string['solo:selecttopics'] = 'Select topics for use in activity.';
$string['solo:managetopics'] = 'Manage topics (add/edit/delete)';
$string['solo:attemptview'] = 'View attempts';
$string['solo:attemptedit'] = 'Edit attempts';
$string['solo:manageattempts'] = 'Can manage Poodll Solo attempts';
$string['solo:manage'] = 'Can manage Poodll Solo instances';
$string['solo:submit'] = 'Can submit Poodll Solo attempts';
$string['solo:grades'] = 'View Solo grades';
$string['privacy:metadata'] = 'The Poodll Poodll Solo plugin does store personal data.';
$string['privacy:metadata:solo'] = 'The Poodll Poodll Solo plugin does store personal data.';
$string['privacy:metadata:attemptstable'] = 'The Poodll Poodll Solo attempts table.';
$string['privacy:metadata:attemptstatstable'] = 'Stores statistics and data about the students submission.';
$string['privacy:metadata:transcript'] = 'The transcript of student submission';
$string['privacy:metadata:grade'] = 'The final grade for the attempt';
$string['privacy:metadata:aigrade'] = 'The AI estimated grade for the attempt ';
$string['privacy:metadata:words'] = 'Total words in submission';
$string['privacy:metadata:uniquewords'] = 'Total unique words in submission';
$string['privacy:metadata:longwords'] = 'Total number of long words in submission';
$string['privacy:metadata:turns'] = 'Total sentences in submission';
$string['privacy:metadata:avturn'] = 'Average sentence length of submission';
$string['privacy:metadata:longestturn'] = 'Longest sentence length in submission';
$string['privacy:metadata:targetwords'] = 'Total target words in submission';
$string['privacy:metadata:totaltargetwords'] = 'Total target words in activity';
$string['privacy:metadata:aiaccuracy'] = 'Similarity between manual and AI transcript';
$string['privacy:metadata:cefrlevel'] = 'Estimated CEFR level';
$string['privacy:metadata:wpm'] = 'Words per minute speaking speed';
$string['privacy:metadata:speakingtime'] = 'Total speaking time (Seconds)';
$string['privacy:metadata:relevance'] = 'Estimated relevance of submission content to topic';
$string['id'] = 'ID';
$string['name'] = 'Name';
$string['timecreated'] = 'Time Created';
$string['basicheading'] = 'Basic Report';
$string['totalattempts'] = 'Attempts';
$string['overview'] = 'Overview';
$string['overview_help'] = 'Overview Help';
$string['view'] = 'View';
$string['preview'] = 'Preview';
$string['viewreports'] = 'View Reports';
$string['reports'] = 'My Reports';
$string['reports'] = 'Reports';
// $string['viewgrading']='View Grading';
$string['showingattempt'] = 'Showing attempt for: {$a}';
$string['basicreport'] = 'Basic Report';
$string['returntoreports'] = 'Return to Reports';
$string['returntotop'] = 'Return to Top';
$string['exportexcel'] = 'Export to CSV';
$string['deletealluserdata'] = 'Delete all user data';
// $string['maxattempts'] ='Max. Attempts';
// $string['unlimited'] ='unlimited';
// $string['defaultsettings'] ='Default Settings';
// $string['exceededattempts'] ='You have completed the maximum {$a} attempts.';
// $string['solotask'] ='Poodll Solo Task';
$string['gotnosound'] = 'We could not hear you. Please check the permissions and settings for microphone and try again.';
$string['done'] = 'Done';
$string['submit'] = 'Submit';
$string['processing'] = 'Processing';
$string['feedbackheader'] = 'Finished';
// $string['beginreading'] = 'Begin Reading';
$string['errorheader'] = 'Error';
// $string['uploadconverterror'] = 'An error occured while posting your file to the server. Your submission has NOT been received. Please refresh the page and try again.';
$string['attemptsreport'] = 'Attempts Report';
$string['submitted'] = 'submitted';
$string['id'] = 'ID';
$string['username'] = 'User';
$string['audiofile'] = 'Audio';
$string['timecreated'] = 'Time Created';
$string['nodataavailable'] = 'No Data Available Yet';
$string['saveandnext'] = 'Save .... and next';
$string['next'] = 'Next';
$string['start'] = "Start";
$string['startrecording'] = 'Click to start recording';
$string['stoprecording'] = 'Click again to stop recording';
$string['finish'] = 'Finish';
$string['done'] = 'Done';
$string['reattempt'] = 'Try Again';
$string['notgradedyet'] = 'Your submission has been received, but has not been graded yet';
$string['enabletts'] = 'Enable TTS(experimental)';
$string['enabletts_details'] = 'TTS is currently not implemented';
// we hijacked this setting for both TTS STT .... bad ... but they are always the same aren't they?
$string['ttslanguage'] = 'Target Language';
$string['deleteattemptconfirm'] = "Are you sure that you want to delete this attempt?";
$string['deletenow'] = '';
$string['attemptsperpage'] = 'Attempts per page';
$string['attemptsperpage_details'] = 'This sets the number of rows to be shown on reports or lists of attempts.';
$string['gradingsperpage'] = 'Gradings per page';
$string['gradingsperpage_details'] = 'This sets the number of attempts to grade manually to be shown on the grading page at the same time.';

$string['apiuser'] = 'Poodll API User ';
$string['apiuser_details'] = 'The Poodll account username that authorises Poodll on this site.';
$string['apisecret'] = 'Poodll API Secret ';
$string['apisecret_details'] = 'The Poodll API secret. See <a href= "https://support.poodll.com/support/solutions/articles/19000083076-cloud-poodll-api-secret">here</a> for more details';
$string['enableai'] = 'Enable AI';
$string['enableai_details'] = 'Poodll Solo can evaluate results from a student attempt using AI. Check to enable.';


$string['useast1'] = 'US East';
$string['tokyo'] = 'Tokyo, Japan';
$string['sydney'] = 'Sydney, Australia';
$string['dublin'] = 'Dublin, Ireland';
$string['ottawa'] = 'Ottawa, Canada';
$string['frankfurt'] = 'Frankfurt, Germany';
$string['london'] = 'London, U.K';
$string['saopaulo'] = 'Sao Paulo, Brazil';
$string['singapore'] = 'Singapore';
$string['mumbai'] = 'Mumbai, India';
$string['capetown'] = 'Capetown, South Africa';
$string['bahrain'] = 'Bahrain';
$string['ningxia'] = 'Ningxia, China';


$string['forever'] = 'Never expire';

$string['en-us'] = 'English (US)';
$string['en-nz'] = 'English (New Zealand)';
$string['en-za'] = 'English (South Africa)';
$string['es-us'] = 'Spanish (US)';
$string['en-au'] = 'English (Aus.)';
$string['en-gb'] = 'English (GB)';
$string['fr-ca'] = 'French (Can.)';
$string['fr-fr'] = 'French (FR)';
$string['fil-ph'] = 'Filipino';
$string['it-it'] = 'Italian (IT)';
$string['pt-br'] = 'Portuguese (BR)';
$string['en-in'] = 'English (IN)';
$string['es-es'] = 'Spanish (ES)';
$string['fr-fr'] = 'French (FR)';
$string['de-de'] = 'German (DE)';
$string['de-at'] = 'German (AT)';
$string['da-dk'] = 'Danish (DK)';
$string['hi-in'] = 'Hindi';
$string['ko-kr'] = 'Korean';
$string['ar-ae'] = 'Arabic (Gulf)';
$string['ar-sa'] = 'Arabic (Modern Standard)';
$string['zh-cn'] = 'Chinese (Mandarin-Mainland)';
$string['nl-nl'] = 'Dutch';
$string['nl-be'] = 'Dutch (BE)';
$string['en-ie'] = 'English (Ireland)';
$string['en-wl'] = 'English (Wales)';
$string['en-ab'] = 'English (Scotland)';
$string['fa-ir'] = 'Farsi';
$string['de-ch'] = 'German (Swiss)';
$string['he-il'] = 'Hebrew';
$string['id-id'] = 'Indonesian';
$string['ja-jp'] = 'Japanese';
$string['ms-my'] = 'Malay';
$string['pt-pt'] = 'Portuguese (PT)';
$string['ru-ru'] = 'Russian';
$string['ta-in'] = 'Tamil';
$string['te-in'] = 'Telugu';
$string['tr-tr'] = 'Turkish';

$string['uk-ua'] = 'Ukranian';
$string['eu-es'] = 'Basque';
$string['fi-fi'] = 'Finnish';
$string['hu-hu'] = 'Hungarian';

$string['sv-se'] = 'Swedish';
$string['no-no'] = 'Norwegian';
$string['nb-no'] = 'Norwegian';// unused
$string['pl-pl'] = 'Polish';
$string['ro-ro'] = 'Romanian';
$string['mi-nz'] = 'Maori';

$string['bg-bg'] = 'Bulgarian'; // Bulgarian
$string['cs-cz'] = 'Czech'; // Czech
$string['el-gr'] = 'Greek'; // Greek
$string['hr-hr'] = 'Croatian'; // Croatian
$string['hu-hu'] = 'Hungarian'; // Hungarian
$string['lt-lt'] = 'Lithuanian'; // Lithuanian
$string['lv-lv'] = 'Latvian'; // Latvian
$string['sk-sk'] = 'Slovak'; // Slovak
$string['sl-si'] = 'Slovenian'; // Slovenian
$string['is-is'] = 'Icelandic'; // Icelandic
$string['mk-mk'] = 'Macedonian'; // Macedonian
$string['no-no'] = 'Norwegian'; // Norwegian
$string['sr-rs'] = 'Serbian'; // Serbian
$string['vi-vn'] = 'Vietnamese'; // Serbian

// less used Indial languages here
$string['as-in'] = 'Assamese';
$string['aw-aw'] = 'Awadhi';
$string['bn-in'] = 'Bengali';
$string['bh-in'] = 'Bhojpuri';
$string['gu-in'] = 'Gujarati';
$string['kn-in'] = 'Kannada';
$string['ml-in'] = 'Malayalam';
$string['mr-in'] = 'Marathi';
$string['mw-in'] = 'Marwadi';
$string['or-in'] = 'Odia (Oriya)';
$string['pa-ing'] = 'Punjabi (Gurmukhi)';
$string['pa-in'] = 'Punjabi (Shahmukhi)';
$string['sa-in'] = 'Sanskrit';
$string['ur-in'] = 'Urdu';

$string['awsregion'] = 'AWS Region';
$string['region'] = 'AWS Region';
$string['expiredays'] = 'Days to keep file';
// $string['aigradenow']='AI Grade';

$string['attemptsperpage'] = "Attempts to show per page: ";
$string['backtotop'] = "Back to Course";
$string['transcript'] = "Transcript";
// $string['quickgrade']="Quick Grade";
$string['ok'] = "OK";

$string['notimelimit'] = 'Unlimited';
$string['xsecs'] = '{$a} seconds';
$string['onemin'] = '1 minute';
$string['xmins'] = '{$a} minutes';
$string['oneminxsecs'] = '1 minutes {$a} seconds';
$string['xminsecs'] = '{$a->minutes} minutes {$a->seconds} seconds';

$string['postattemptheader'] = 'Post attempt options';
$string['recordingaiheader'] = 'Recording and AI options';

// $string['grader']='Graded by';
// $string['grader_ai']='AI';
// $string['grader_human']='Human';
// $string['grader_ungraded']='Ungraded';

$string['displaysubs'] = '{$a->subscriptionname} : expires {$a->expiredate}';
$string['noapiuser'] = "No API user entered. Poodll Solo will not work correctly.";
$string['noapisecret'] = "No API secret entered. Poodll Solo will not work correctly.";
$string['credentialsinvalid'] = "The API user and secret entered could not be used to get access. Please check them.";
$string['appauthorised'] = "Poodll Poodll Solo is authorised for this site.";
$string['appnotauthorised'] = "Poodll Poodll Solo is NOT authorised for this site.";
$string['refreshtoken'] = "Refresh license information";
$string['notokenincache'] = "Refresh to see license information. Contact Poodll support if there is a problem.";
// these errors are displayed on activity page
// $string['nocredentials'] = 'API user and secret not entered. Please enter them on <a href="{$a}">the settings page.</a> You can get them from <a href="https://poodll.com/member">Poodll.com.</a>';
$string['novalidcredentials'] = 'API user and secret were rejected and could not gain access. Please check them on <a href="{$a}">the settings page.</a> You can get them from <a href="https://poodll.com/member">Poodll.com.</a>';
$string['nosubscriptions'] = "There is no current subscription for this site/plugin.";

$string['privacy:metadata:attemptid'] = 'The unique identifier of a users Poodll Solo attempt.';
$string['privacy:metadata:attempttable'] = 'Stores the scores and other user data associated with a Poodll Solo attempt.';
$string['privacy:metadata:cloudpoodllcom'] = 'The Poodll Solo plugin stores recordings in AWS S3 buckets via cloud.poodll.com.';
$string['privacy:metadata:cloudpoodllcom:userid'] = 'The Poodll Solo plugin includes the moodle userid in the urls of recordings and transcripts';
$string['privacy:metadata:filename'] = 'File urls of submitted recordings.';
$string['privacy:metadata:jsontranscriptpurpose'] = 'The full transcripts of recordings.';
$string['privacy:metadata:soloid'] = 'The unique identifier of a Poodll Solo activity instance.';
$string['privacy:metadata:timemodified'] = 'The last time attempt was modified for the attempt';
$string['privacy:metadata:transcriptpurpose'] = 'The recording short transcripts.';
$string['privacy:metadata:userid'] = 'The user id for the Poodll Solo attempt';

// attempts
// $string['durationgradesettings'] = 'Grade Settings ';
// $string['durationboundary']='{$a}: Completion time less than (seconds)';
// $string['boundarygrade']='{$a}: points ';
// $string['numeric']='Must be numeric ';
// $string['attemptinuse']= 'This attempt is part of users attempt history. It cannot be deleted.';
// $string['moveattemptup']='Up';
// $string['moveattemptdown']='Down';

$string['attempts'] = 'Attempts';
$string['manageattempts'] = 'Manage Attempts';
// $string['correctanswer'] ='Correct answer';
// $string['addnewattempt'] = 'Add a New attempt';
// $string['addingattempt'] = 'Adding a New attempt';
$string['editingattempt'] = 'Editing a attempt';
// $string['createaattempt'] = 'Create a attempt';
$string['attempt'] = 'Attempt';
$string['attempttitle'] = 'Attempt Title';
$string['attemptcontents'] = 'Attempt Description';
// $string['answer'] = 'Answer';
// $string['saveattempt'] = 'Save attempt';
// $string['audioattemptfile'] = 'attempt Audio(MP3)';
// $string['attemptname'] = 'Attempt Name';
// $string['attemptorder'] = 'Attempt Order';
// $string['correct'] = 'Correct';
// $string['attempttype'] = 'Attempt Type';
$string['actions'] = 'Actions';
// $string['editattempt'] = 'Edit attempt';
// $string['previewattempt'] = 'Preview attempt';
$string['deleteattempt'] = 'Delete attempt';
$string['confirmattemptdelete'] = 'Are you sure you want to <i>DELETE</i> attempt?';
$string['confirmattemptdeletetitle'] = 'Really Delete attempt?';
$string['confirmattemptdelete'] = 'Are you sure you want to <i>DELETE</i> this attempt?';
$string['confirmattemptdeletealltitle'] = 'Really Delete ALL Attempts?';
$string['confirmattemptdeleteall'] = 'Are you sure you want to <i>DELETE ALL</i> attempts?';
$string['noattempts'] = 'This activity contains no attempts';
$string['attemptdetails'] = 'attempt Details: {$a}';
$string['attemptsummary'] = 'attempt Summary: {$a}';
$string['viewreport'] = 'view report';

// $string['addrecordconversation'] = 'Record your speech';
// $string['adduserselections'] = 'User Selections';
// $string['addselftranscribe'] = 'Self Transcribe';


// $string['readtext'] = 'Text to read';
// $string['language_voice'] = 'Language and voice';
// $string['listen'] = 'Listen';
// $string['download'] = 'Download';
// $string['tagarea_solo_attempts'] = 'Poodll Solo Attempts';
$string['timemodified'] = 'Last Changed';

// $string['picturechoice'] = 'Picture Choice';
// $string['translate'] = 'Translate';
// $string['pictureitemfile'] = 'Picture Item File';
// $string['iscorrectlabel'] = 'Correct/Incorrect';
// $string['textchoice'] = 'Text Area Choice';
// $string['textboxchoice'] = 'Text Box Choice';
// $string['audioresponse'] = 'Audio response';
// $string['correcttranslationtitle'] = 'Correct Translation';
// $string['audiochoice'] = 'Audio Choice';
// $string['audioprompt'] = 'Audio Prompt';
$string['edit'] = 'Edit';
// $string['gotoactivity'] = 'Start Activity';
// $string['tryactivityagain'] = 'Try Again';
// $string['shuffleanswers'] = 'Shuffle Answers';
// $string['shufflequestions'] = 'Shuffle Questions';
$string['solo:attemptview'] = 'View attempts';
$string['solo:attemptedit'] = 'Edit attempts';
$string['attemptname'] = 'Attempt';
$string['nodataavailable'] = 'No data available';
$string['transcriber'] = 'Transcriber';
$string['transcriber_details'] = 'The transcription engine to use. ';
$string['transcriber_open'] = 'Open transcription';
// $string['transcriber_amazontranscribe'] = 'Regular transcription(AWS)';
// $string['transcriber_amazonstreaming'] = 'Instant Transcription(AWS)';
// $string['transcriber_googlechrome'] = 'Instant transcription (Chrome only)';
// $string['transcriber_googlecloud'] = 'Quick Transcription(Google)(audio length < 60s ony)';
$string['transcriber_none'] = 'No transcription';
$string['transcriptnotready'] = '<i>Transcript not ready yet</i>';
$string['transcripttitle'] = 'Transcript';

// $string['createattempt'] = 'Create Attempt';
// $string['addtopic'] = 'Add Topic';
// $string['deletetopic'] = 'Delete Topic';
// $string['edittopic'] = 'Edit Topic';
// $string['editingtopic'] = 'Editing Topic';
// $string['savetopic'] = 'Save Topic';
// $string['createtopic'] = 'Create Topic';
$string['topicformtitle'] = 'Add/edit Topic';
$string['topiclevelcustom'] = 'Custom';
$string['topiclevelcourse'] = 'Course';
$string['grades'] = 'Grades';
$string['managegrades'] = 'Manage Grades';
$string['topics'] = 'Topics';
$string['managetopics'] = 'Manage Topics';
// $string['topicselected'] = 'Selected';
$string['topicname'] = 'Topic';
$string['topiclevel'] = 'Level';
$string['topicicon'] = 'Icon';
$string['topictargetwords'] = 'Target Words';
$string['targetwords'] = 'Target Words';
$string['tips'] = 'Speaking Tips';
// $string['targettime'] = 'Target time';
$string['targetspeakingtime'] = 'Target Speaking Time';
// $string['type'] = 'Type';
// $string['confirmtopicdelete'] = 'Do you really want to delete topic: {$a}';
// $string['choosetopic'] = 'Choose Topic';
// $string['topicinstructions']='Add or edit topics. Custom topics will only be available here. Course level topics will be available course wide. Selected topics will be available for students to choose from in this activity. ';

$string['userselections'] = 'User Selection';
$string['selftranscribe'] = 'Transcribe your speech';
// $string['transcriptscompare'] = 'Compare Transcriptions';
// $string['comparetranscripts'] = 'Compare Transcriptions';
// $string['saveitem'] = 'Save';
$string['xminutes'] = '{$a}:00 minutes';
$string['convlength'] = 'Target Time';
// $string['mywords'] = 'My Target Words';
$string['words'] = 'Words';
$string['speakingtopic'] = 'Speaking Topic';
$string['speakingtips'] = 'Speaking Tips';
$string['speakingtips_details'] = '';
$string['speakingtips_default'] = 'Speak simply, slowly and clearly.';
// $string['chooseusers'] = 'Choose Partner(s)';
$string['users'] = 'Partners';
$string['topic'] = 'Topic';

$string['attempt_prepare'] = 'Prepare';
// $string['attempt_prepare_title'] = 'Prepare to Speak';
$string['attempt_record'] = 'Record';
$string['attempt_transcribe'] = 'Type';
$string['attempt_model'] = 'Model Answer';
// $string['attempt_review'] = 'Review';

// $string['step_preparetitle']='Prepare';
$string['step_prepareinstructions'] = 'Check the speaking topic and speaking targets from the options below. When you are ready, move to the next page and begin speaking';
$string['step_prepareinstructions_norecording'] = 'Check the topic and targets below. When you are ready, move to the next page and begin.';
// $string['step_mediarecordtitle']='Record';
$string['step_mediarecordinstructions'] = 'Use the recorder below to record yourself. Good luck.';
$string['step_posttranscriberecordinstructions'] = 'Use the recorder below to record yourself speaking.';
// $string['step_typetitle']='Enter Text';
// $string['step_typeinstructions']='Use the recorder below to record yourself. Try to use the target words. Good luck.';
// $string['step_selftranscribetitle']='Transcribe';
$string['step_selftranscribeinstructions'] = 'Listen to your recording and enter/check what you said in the editor below. Do not change what you said. You should fix any spelling or punctuation mistakes.';
$string['step_prerecord_transcribeinstructions'] = 'Check the instructions and speaking targets, then type your response in the text editor below.';
$string['step_writtensubmissioninstructions'] = 'Check the instructions and goals, then type your response in the text editor below.';


// $string['step_modeltitle']='Model Answer';
$string['step_modelinstructions'] = 'Check the model answer below.';

// $string['savesubtitles'] = 'Save Speech';
// $string['removesubtitles'] = 'Remove Speech';
// $string['addnew'] = 'Add new';
// $string['stepback'] = 'Step back';
// $string['stepahead'] = 'Step ahead';
// $string['playpause'] = 'Play/pause';
// $string['now'] = 'Now';
// $string['cancel'] = 'Cancel';
$string['audioreplay'] = 'Hear your audio for this attempt';
$string['videoreplay'] = 'See your video for this attempt';
$string['selftranscript'] = 'Self Transcript';
// $string['autotranscript'] = 'Auto Transcript';
$string['stats'] = 'Stats';
$string['stats_words_title'] = 'Words';
$string['stats_words'] = 'Total Words';
$string['stats_turns_title'] = 'Sentences';
$string['stats_turns'] = 'Total Sentences';
$string['stats_avturn'] = 'Av. Sentence Length';
$string['stats_longestturn'] = 'Longest Sentence Length';
$string['stats_targetwords'] = 'Target Words';
$string['stats_aiaccuracy'] = 'Speaking clarity';
$string['stats_uniquewords'] = 'Unique Words';
$string['stats_longwords'] = 'Long Words';
$string['stats_ideacount'] = 'Concepts';
$string['stats_cefrlevel'] = 'CEFR Level (est.)';
$string['stats_relevance'] = 'Relevance (est.)'; // AKA similarity
$string['stats_wpm'] = 'Words per Min.';
$string['more_stats'] = 'More stats';

// $string['transcripteditor']= 'Transcript Editor';
$string['multiattempts'] = 'Allow Multiple Attempts';
$string['multiattempts_details'] = 'If checked a student can choose to overwrite an existing attempt with a new one.';
$string['attemptsheading'] = 'Attempts';
$string['incompleteattemptsheading'] = 'Incomplete Attempts';
$string['incompleteattemptsreport'] = 'Incomplete Attempts';
$string['partners'] = 'Partners';
$string['turns'] = 'Sentences';
$string['ATL'] = 'Av Sent. Length';
$string['LTL'] = 'Longest Sent. Length';
$string['TW'] = 'Total Words';
$string['CEFR'] = 'CEFR';
$string['idnumber'] = 'ID-number';

$string['audiorecording'] = 'Audio Recording';
$string['videorecording'] = 'Video Recording';
$string['voicerecording'] = 'Voice Recording';
$string['attemptnumberheader'] = 'Attempt Number';
$string['attemptnumber'] = '{$a}';
// $string['summaryuserattemptheadertitle']= '(Attempt: {$a}) Speech Details';
$string['summaryuserattemptheadertitle'] = 'Speech Details';
$string['summaryuserattemptheaderintro'] = '';
$string['summaryheadertitle'] = 'Your Speech Details';
$string['summaryheadertitle_norecording'] = 'Attempt Results';
$string['summaryheaderintro'] = 'Check the details and the results of your speech below. What do you think? You should be getting better each time.';
// $string['leaveedittopic']= 'Edit (diff. activity)';
$string['fonticonexplanation'] = 'Add an icon graphic to represent the topic. Use FontAwesome for this. The pattern is fa-xxx where xxx is the icon name. Search for icons at: <a href="https://fontawesome.com/v4.7.0/icons">https://fontawesome.com/v4.7.0/icons</a>';

$string['targetwordsexplanation'] = 'Add target words each on a new line.';

// $string['confirmtopicdeletetitle']= 'Confirm Delete Topic:';

$string['maxconvlength_details'] = 'Audio recorder time limit';
$string['maxconvlength'] = 'Time limit';
$string['heard'] = 'Heard';
$string['SPL'] = 'Spell';
$string['ACC'] = 'Accuracy';

// $string['notopicsavailable'] = "No topics have been added by your teacher.";

$string['postattemptedit'] = 'Can edit after finished';
$string['postattemptedit_details'] = 'Allow student to edit their submission after they have submitted it.';
$string['dopostattemptedit'] = 'Edit the last attempt';
// $string['audiofilename'] = 'Audio';

// ID, Name, ai score, sentences, av sentence length
$string['gradesid'] = 'ID';
$string['gradesfirst'] = 'First';
$string['gradeslast'] = 'Last';
$string['gradesaiscore'] = 'AI Score';
$string['gradesclarity'] = 'Clarity';
$string['gradeswords'] = 'Total Words';
$string['gradestargetwords'] = 'Target Words';
$string['gradesmethod'] = 'Graded by';
$string['gradesturns'] = 'Sentences';
$string['gradesavturnlength'] = 'AV Sentence Length';
$string['gradesactions'] = 'Actions';
$string['gradesgraded'] = 'Graded';
$string['gradesgradedno'] = 'Ungraded';
$string['gradesgradedyes'] = 'Graded';
$string['gradesgrade'] = 'Grade';
$string['gradeschoose'] = 'Choose one:';
$string['gradesstudent'] = 'Student';
$string['gradesdatapoint'] = 'Data point';
$string['gradesrubric'] = 'Rubric';
$string['gradestranscript'] = 'Transcript';
$string['gradesfeedback'] = 'Feedback:';
$string['gradessubmit'] = 'Submit';
$string['gradesubmissions'] = 'Grade submissions';
$string['gradesgrader'] = 'Graded By';
$string['humangraded'] = 'Teacher';
$string['autograded'] = 'Auto';
$string['gradeheader'] = 'Grade';
$string['gradelabel'] = '{$a}%';


$string['gradeitem:solo'] = 'Poodll Solo';
$string['developer'] = 'Developer';
$string['dopopupgrade'] = 'Grading user: ';

$string['detailedattemptsreport'] = 'Researcher Report';
$string['detailedattemptsheading'] = 'Researcher Report';
$string['detailedattempts'] = 'Researcher Report';

$string['classprogressreport'] = 'Class Progress';
$string['classprogressheading'] = 'Class Progress';
$string['classprogress'] = 'Class Progress';

$string['myprogressreport'] = 'My Progress';
$string['myprogressheading'] = 'My Progress: {$a}';
$string['myprogress'] = 'My Progress';

$string['userattempts'] = 'User Attempts';
$string['userattemptsheading'] = '{$a} Attempts';
$string['userattempts'] = 'User Attempts';

$string['myattempts'] = 'My Attempts';
$string['myattemptsheading'] = 'My Attempts: {$a} ';
$string['myattempts'] = 'My Attempts';

$string['downloadaudio'] = 'Download Audio';
$string['downloadaudioheading'] = 'Download Audio';
$string['downloadaudioreport'] = 'Download Audio';
$string['file'] = 'File';
$string['teachereval'] = 'Teacher Evaluation';
$string['autoeval'] = 'Automatic Evaluation';
$string['spellingeval'] = 'Spelling Evaluation';
$string['grammareval'] = 'Grammar Evaluation';
$string['nogrammarerrors'] = 'No grammar mistakes.';
$string['possiblegrammarerrors'] = 'Possible grammar mistakes:';
$string['possiblespellingerrors'] = 'Possible spelling mistakes:';
$string['nospellingerrors'] = 'No spelling mistakes.';
$string['completedsteps'] = 'Steps Complete';
$string['completionallsteps'] = 'Complete when all steps completed';
$string['completiondetail:allsteps'] = 'Complete all steps in the activity';
$string['completionallsteps_help'] = 'Complete when all steps completed';
$string['yes'] = 'Yes';
$string['no'] = 'No';

$string['speakingtopic_help'] = 'Short instructions to students on what to speak about.';
$string['targetwords_help'] = 'Target words or phrases that student should try to use while speaking. Each on a new line.';

$string['avturns'] = 'Avg Sentences';
$string['avatl'] = 'Avg ASL';
$string['avltl'] = 'Avg LSL';
$string['avw'] = 'Avg Words';
$string['GRM'] = 'Grammar';
$string['avtw'] = 'Avg Target Words';
$string['avspell'] = 'Avg Spelling';
$string['avacc'] = 'Avg Acc';
$string['tabular'] = 'Table View';

$string['grade'] = 'Grade';

$string['reportmenuinstructions'] = "View reports by selecting the report from the buttons below.";
$string['totalgradeables'] = 'Grading {$a} students';

$string['myreports'] = 'My Reports';
$string['stats_autogrammarscore'] = 'Grammar';
$string['stats_autospellscore'] = 'Spelling';
$string['stats_clarity'] = 'Clarity';

$string['tnav_grammar'] = 'Grammar {$a}';
$string['tnav_spelling'] = 'Spelling {$a}';
$string['tnav_clarity'] = 'Clarity {$a}';

$string['bigword'] = 'big word';
$string['spellingmistake'] = 'spelling mistake';
$string['grammarmistake'] = 'grammar mistake';
$string['targetwordspoken'] = 'target word spoken';
$string['sentence'] = 'sentence';
$string['aggroup'] = 'Auto grading';
$string['aggroup_help'] = 'Set the formula which is used to auto grade the students speaking';

$string['recorderaudio'] = 'Audio Recorder';
$string['recordervideo'] = 'Video Recorder';
$string['recorderskin'] = 'Recorder Style';
$string['recordertype'] = 'Recording type';

$string['skinplain'] = 'Plain';
$string['skinbmr'] = 'Burnt Rose';
$string['skinfresh'] = 'Fresh (audio only)';
$string['skin123'] = 'One Two Three';
$string['skinonce'] = 'Once';
$string['skinsolo'] = 'Solo';
$string['skinupload'] = 'Upload';

$string['totalunique'] = 'Unique word total';
$string['totalwords'] = 'All word total';
$string['gradewordgoal'] = 'Total Words Goal';
$string['gradewordgoal_help'] = 'Sets the number of words the student should speak to get maximum points when using auto grading. See grading section of this form for more details.';
$string['displaygradewordgoal'] = '{$a} words';

$string['ag_overgradewordgoal'] = ' / Words goal ) x ';
$string['ag_pointsper'] = ' points per ';
$string['enabletranscription'] = 'Manual transcription';
$string['enabletranscription_details'] = 'Require students to manually transcribe their own speaking';
$string['enableautograde'] = 'Enable autograding';
$string['enableautograde_details'] = 'Autograding will calculate a preliminary grade for your students that you can later override or use as is.';
$string['rating_poor'] = 'Thank you';
$string['rating_fair'] = 'Thank you';
$string['rating_good'] = 'Good Job';
$string['rating_verygood'] = 'Very Good';
$string['rating_excellent'] = 'Excellent !';
$string['toggleplayinstructions'] = '(Press ESC key to start and stop the audio player.)';
$string['prerecordtranscriptinstructions'] = 'Enter your response in the text area below. In the next step you will read it aloud';


// reattempt
$string['reattempt'] = 'Try Again';
$string['reattempttitle'] = 'Really Try Again?';
$string['reattemptbody'] = 'If you continue your previous attempt will be replaced with this one. OK?';

$string['secs_till_check'] = 'checking for results in ... ';
$string['checking'] = ' ... checking ... ';
$string['notgradedyet'] = 'Your submission has been received, but has not been graded yet. It might take a few minutes.';
$string['evaluatedmessage'] = 'Your latest attempt has been received and the evaluation is shown below.';
$string['moreattemptdetails'] = "More Attempt Details";
$string['transcriptevaluation'] = "Transcript Evaluation";
$string['transcriptevaluationdetails'] = "Underlined words show differences between your transcript and the automatic transcript.";
$string['uploading'] = ' ... uploading ... ';

// media toggles
$string['mediaoptions'] = 'Media Options';
$string['addmedia'] = 'Add Media';
$string['addtext'] = 'Add Text';
$string['addiframe'] = 'Add iFrame';
$string['addttsaudio'] = 'Add TTS Audio';
$string['addytclip'] = 'Add YouTube/Vimeo';

$string['speakingtargetsheader'] = 'Speaking Targets';
$string['languageandrecordingheader'] = 'Language and Recording';
$string['autogradingheader'] = 'AutoGrading';
$string['enablesetuptab'] = "Enable setup tab";
$string['enablesetuptab_details'] = "Show a tab containing the activity instance settings to admins. Not super useful in most cases.";
$string['setup'] = "Setup";

$string['nosetup'] = "Activity is Not Ready";
$string['addsetup'] = "Setup Activity";
$string['waitforsetup'] = "There is no topic set yet for this activity. You will not be able to do the activity until your teacher adds one";
$string['letsaddsetup'] = "There is no topic set yet for this activity. Lets add one.";
$string['noattemptfound'] = "That attempt could be found";
$string['viewattempt'] = "View";
$string['attemptfor'] = 'Attempt: {$a}';
$string['audioandstats'] = "Audio and Stats";

$string['content_iframe_help'] = 'Paste iframe embed code (html only) for any media that should be shown to students.';
$string['content_media_help'] = 'Upload an audio/video or image file that will be shown to students.';
$string['content_tts_help'] = 'Text to speech content.';
$string['content_media'] = 'Image, audio or video content';
$string['content_iframe'] = 'Embed iframe code';
$string['content_text'] = 'Text content';
$string['content_text_help'] = 'Add text content to accompany your topic';
$string['content_tts'] = 'TTS text';
$string['content_ttsvoice'] = 'Speaker\'s voice';
$string['content_ttsspeed'] = 'Speaker speed';
$string['content_ytid'] = "Youtube Video ID";
$string['content_ytstart'] = "Start Secs";
$string['content_ytend'] = "End Secs";
$string['ytclipdetails'] = "Youtube/Vimeo Clip";
$string['freetrial'] = "Get Cloud Poodll API Credentials and a Free Trial";
$string['freetrial_desc'] = "A dialog should appear that allows you to register for a free trial with Poodll. After registering you should login to the members dashboard to get your API user and secret. And to register your site URL.";
// $string['memberdashboard'] = "Member Dashboard";
// $string['memberdashboard_desc'] = "";
$string['fillcredentials'] = "Set API user and secret with existing credentials";
$string['viewstart'] = "Activity open";
$string['viewend'] = "Activity close";
$string['viewstart_help'] = "If set, prevents a student from entering the activity before the start date/time.";
$string['viewend_help'] = "If set, prevents a student from entering the activity after the closing date/time.";
$string['activitydate:submissionsdue'] = 'Due:';
$string['activitydate:submissionsopen'] = 'Opens:';
$string['activitydate:submissionsopened'] = 'Opened:';
$string['activityisnotopenyet'] = "This activity is not open yet.";
$string['activityisclosed'] = "This activity is closed.";
$string['open'] = "Open: ";
$string['until'] = "Until: ";
$string['activityopenscloses'] = "Activity open/close dates";
$string['solo:preview'] = 'Can preview Solo activities';
$string['modelanswer'] = "Model Answer";
$string['modelanswerheader'] = "Model Answer";
$string['modelanswerinstructions'] = "The model answer is used as a 'good answer', against which similarity (relevance) scores may be calculated for automatic grading. It is not shown to students. Use the media options below the model answer to display a video or text-to-speech player to the students in the model answer step.";
$string['audiorec_heading'] = "Audio Recorder";
$string['videorec_heading'] = "Video Recorder";
$string['grammarcorrection'] = "Suggested Corrections:";
$string['step_none'] = 'None';
$string['step_record'] = 'Record';
$string['step_transcribe'] = 'Self Transcribe';
$string['step_model'] = 'Model';
$string['seq_PRTM'] = 'Prepare -> Record -> Transcribe -> Model (if set)';
$string['seq_PRMT'] = 'Prepare -> Record -> Model -> Transcript';
$string['seq_PRM'] = 'Prepare -> Record -> Model (if set)';
$string['seq_PTRM'] = 'Prepare -> Type -> Record -> Model (if set)';
$string['seq_PTM'] = 'Prepare -> Type -> Model (if set)';
$string['seq_RM'] = 'Record -> Model (if set)';
$string['activitysteps'] = "Activity Steps";
$string['preloadtranscript'] = 'Preload transcript';
$string['preloadtranscript_details'] = 'Preload transcript into transcript editor, so the student the student just has to edit it. NB the transcript can take several minutes to become available.';

$string['enabletts'] = 'Enable TTS';
$string['enabletts_help'] = 'Allow students to hear their transcript read aloud by a TTS voice';
$string['enabletts_details'] = 'Allow students to hear their transcript read aloud by a TTS voice';
$string['default_enabletts'] = 'Enable TTS (default)';

$string['nopasting'] = 'Disable paste';
$string['nopasting_help'] = 'Prevent users pasting text into the transcript/text area.';
$string['nopasting_details'] = 'Prevent users pasting text into the transcript/text area.';

$string['preloadtranscript'] = 'Preload Automatic Transcript';
$string['preloadtranscript_help'] = 'This will load the users automatic transcript into the manual transcript area. They can then simply adjust any mistranscriptions.';
$string['preloadtranscript_details'] = 'This will load the users automatic transcript into the manual transcript area. They can then simply adjust any mistranscriptions.';


$string['enablesuggestions'] = 'Enable AI Suggestions';
$string['enablesuggestions_help'] = 'Allow AI to suggest a more correct version of the student transcript. Results can be unpredictable. So it is not currently connected with grading. ';
$string['enablesuggestions_details'] = 'Allow AI to suggest a more correct version of the student transcript. Results can be unpredictable. So it is not currently connected with grading. ';
$string['default_enablesuggestions'] = 'Enable AI Suggestions (default)';

$string['enablegallery'] = 'Enable Gallery';
$string['enablegallery_help'] = 'Allow students to hear other student submissions on the topic';
$string['enablegallery_details'] = 'Allow students to hear other student submissions on the topic';
$string['nosuggestions'] = "No suggestions.";
$string['checkgrammarandspelling'] = 'Check grammar and spelling';
$string['grammarandspellingsuggestions'] = 'Get grammar and spelling suggestions';
$string['important'] = 'Important';
$string['noemptyselftranscript'] = 'Please enter something in the textbox before leaving this page.';
$string['noemptyrecording'] = 'Please record and upload before leaving this page.';
$string['donotwaitfortranscript'] = 'I do not want to wait for the transcript.';

$string['enablelocalpost'] = "Enable Local Post";
$string['enablelocalpost_details'] = "This is an experimental setting for users in mainland China. Local post will send audio recording submissions to the Moodle server, which will relay them onto our cloud servers. It *might* improve reliability for users with slow connections.";

$string['gradeequals'] = 'Grade = ';
$string['bonusgrade'] = 'Bonus Grades';
$string['relevancegrade'] = 'Auto grading - Similarity/Relevance';
$string['relevancegrade_help'] = 'Similarity is an AI generated measure of how semantically similar the students response is to the model answer text. When the students similarity score falls below the threshold (x %) their overall grade is reduced proportionally. Similarity is only calculated for responses in English.';
$string['relevancegrade_details'] = 'Reduce the score of English submissions to the extent that their semantic similarity to the model answer falls below the threshold (x %). If no model answer is specified, this is ignored.';
$string['relevance_none'] = 'Similarity not considered';
$string['relevance_broad'] = 'Broadly similar (50%)';
$string['relevance_quite'] = 'Quite similar (70%)';
$string['relevance_very'] = 'Very similar (80%)';
$string['relevance_extreme'] = 'Extremely similar (90%)';
$string['suggestionsgrade'] = 'Auto grading - Suggestions';
$string['suggestionsgrade_none'] = 'Suggestions do not affect grade';
$string['suggestionsgrade_use'] = 'Suggested corrections reduce grade';
$string['suggestionsgrade_details'] = 'If suggested corrections affect the grade, then the percentage difference between the transcript and suggestions text reduces the grade proportionally.';
$string['suggestionsgrade_help'] = 'If suggested corrections affect the grade, then the percentage difference between the transcript and suggestions text reduces the grade proportionally.';
$string['fetching_auto_transcript'] = 'Fetching the transcript. Please wait ...';
$string['no_grammar_corrections'] = 'No grammar corrections. Well done!';
$string['showcorrections'] = 'Show inline corrections';
$string['hidecorrections'] = 'Hide inline corrections';

$string['pushpage'] = 'Push page';
$string['pushinstructions'] = 'On this page you can select an activity setting, the value of that setting will be pushed to all other activities in this course. You can widen the scope to the whole site, if you are an admin. You can narrow the scope to only activities of the same name. <BR> <b>Be very very careful</b> there is no confirm step. It will just push immediately when you press save. Be sure that you want to do this.';
$string['pushformheading'] = 'Push Settings to other activities';
$string['pushaction'] = 'The setting to push';
$string['pushsitelevel'] = 'Apply Site Wide (else course wide)';
$string['pushsamename'] = 'Apply only to activities with the same name';
$string['pushdone'] = 'Push complete. {$a} records updated.';
$string['eventsolostepsubmitted'] = 'Solo step submitted';
$string['eventsoloattemptsubmitted'] = 'Solo attempt submitted';
$string['eventsoloattemptautograded'] = 'Solo attempt autograded';
$string['layout'] = 'Layout';
$string['layout_standard'] = 'Standard';
$string['layout_narrow'] = 'Narrow';
$string['showgrammar'] = "Show grammar eval.";
$string['showspelling'] = "Show spelling eval.";
$string['showopts_no'] = "Don't show.";
$string['showopts_yes'] = "Show.";

$string['ttsspeed'] = 'TTS Speed';
$string['mediumspeed'] = 'Medium';
$string['slowspeed'] = 'Slow';
$string['extraslowspeed'] = 'Extra Slow';
$string['modelanswer_help'] = 'Enter a good and complete sample answer to the topic. It will be used as part of the grading process.';
$string['backtotranscriptedit'] = "Back to Edit";
$string['waitingforteacher'] = "Your teacher will check your attempt. Thank You";
$string['gradesdate'] = 'Date';

$string['prompttester'] = 'AI Grade Tester';
$string['prompttester_help'] = 'Use this to test the AI grading. Enter a sample answer and see how it is graded.';
$string['sampleanswerempty'] = 'To test the AI grade you need to enter a sample answer.';
$string['sampleanswerevaluate'] = 'Evaluate';
$string['sampleanswer'] = 'Sample Answer';
$string['sampleanswerinstructions'] = 'The sample answer is to help you test the AI grade and feedback instructions in the autograding section above. Enter a sample answer that is similar to a real student response, and press \'evaluate\', to see how AI responds.';
$string['sampleanswer_help'] = 'Enter an answer that is similar to a real student response, and see how AI handles it.';
$string['markscheme'] = 'AI Grade Instructions';
$string['markscheme_help'] = 'Instructions to AI on how to grade the student\'s answer.';
$string['feedbackscheme'] = 'AI Feedback Instructions';
$string['feedbackscheme_help'] = 'Instructions to AI on how to give feedback on the student\'s answer.';
$string['feedbacklanguage'] = 'AI Feedback Language';
$string['stats_aigrade'] = 'AI Grade';
$string['relevance_model'] = 'Relevance - similarity to model answer';
$string['relevance_question'] = 'Relevance - to question topic';

$string['aifeedback'] = 'AI Feedback:';
$string['autogradelog'] = 'AutoGrade Log';
$string['yourtranscript'] = 'Your Transcript:';
$string['estimated'] = 'estimated';
$string['ideacount'] = 'Idea/concept';
$string['ideacount'] = 'Idea/concept';
$string['aigradepreviewheader'] = 'AI Grade Preview';
$string['showttspassage'] = 'Read Passage Aloud';
$string['resultsdisplay'] = 'Results Display';
$string['starrating_use'] = '5 star grade';
$string['starrating_none'] = '% grade + donut chart';
$string['starrating'] = 'Stars grade';
$string['starrating_help'] = 'Use a 5 star grade system for grading.';
$string['leveltypes'] = 'Estimated Levels';
$string['leveltypes_help'] = 'This setting affects which certification level estimates to show on screen. IELTS and TOEFL will only show if English is set as the target language.';
$string['showcefrlevel'] = 'CEFR Level';
$string['showieltslevel'] = 'IELTS Level';
$string['showtoefllevel'] = 'TOEFL Level';
$string['showgenericlevel'] = 'Generic Level';
$string['beginner'] = 'Beginner';
$string['intermediate'] = 'Intermediate';
$string['highintermediate'] = 'High Intermediate';
$string['lowadvanced'] = 'Low Advanced';
$string['advanced'] = 'Advanced';
$string['upperadvanced'] = 'Upper Advanced';
$string['stats_ieltslevel'] = 'IELTS Level';
$string['stats_toefllevel'] = 'TOEFL Level';
$string['stats_genericlevel'] = 'Language Level';
$string['enablenativelanguage'] = "Enable Native Language";
$string['enablenativelanguage_details'] = 'If set, the student can choose their native language, this will override the default language of the feedback language that AI returns with the results. The language must currently be <a href="https://support.poodll.com/en/support/solutions/articles/19000163890-definitions-in-user-s-native-language">set in Poodll WordCards</a>, and it is picked up here.';
$string['teacherfeedback'] = 'Teacher Feedback';
$string['cloudpoodllserver'] = 'Cloud Poodll Server';
$string['cloudpoodllserver_details'] = 'The server to use for Cloud Poodll. Only change this if Poodll has provided a different one.';