/**
 * This class manages the confirmation pop-up (also called the pre-flight check)
 * that is sometimes shown when a use clicks the start attempt button.
 *
 * This is also responsible for opening the pop-up window, if the quiz requires to be in one.
 *
 * @module    mod_wordcards/spacegame
 * @class     spacegame
 * @copyright  originally 2016 John Okely <john@moodle.com> , modified for Poodll 2023 Justin Hunt <justin@poodll.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define(["jquery","core/notification","mod_wordcards/a4e","core/log","core/templates","core/ajax"],(function($,notification,a4e,log,templates,Ajax){class Rectangle{constructor(left,top,width,height){this.left=left||0,this.top=top||0,this.width=width||0,this.height=height||0}right(){return this.left+this.width}bottom(){return this.top+this.height}Contains(point){return point.x>this.left&&point.x<this.right()&&point.y>this.top&&point.y<this.bottom()}Intersect(rectangle){return!(rectangle.left>this.right()||rectangle.right()<this.left||rectangle.top>this.bottom()||rectangle.bottom()<this.top)}}class GameObject{constructor(src,x,y){null!==src&&(this.image=this.loadImage(src)),this.x=x,this.y=y,this.velocity={x:0,y:0},this.direction={x:0,y:0},this.movespeed={x:5,y:3},this.alive=!0,this.decay=.7}loadImage(src){return this.image||(this.image=new Image),this.image.src=src,this.image}update(){this.velocity.x+=this.direction.x*this.movespeed.x,this.velocity.y+=this.direction.y*this.movespeed.y,this.x+=this.velocity.x,this.y+=this.velocity.y,this.velocity.y*=this.decay,this.velocity.x*=this.decay}draw(context){context.drawImage(this.image,this.x,this.y,this.image.width,this.image.height)}getRect(){return new Rectangle(this.x,this.y,this.image.width,this.image.height)}die(){this.alive=!1}}class Player extends GameObject{constructor(src,x,y){super(src,x,y),this.mouse={x:0,y:0},this.movespeed={x:6,y:4},this.lives=3,this.lastScore=0}update(bounds){(app.mouseDown||app.touchDown)&&(this.x<this.mouse.x-this.image.width?app.player.direction.x=1:this.x>this.mouse.x?app.player.direction.x=-1:app.player.direction.x=0,this.y<this.mouse.y-this.image.height?app.player.direction.y=1:this.y>this.mouse.y?app.player.direction.y=-1:app.player.direction.y=0),super.update(bounds),this.x<bounds.x-this.image.width?this.x=bounds.width:this.x>bounds.width&&(this.x=bounds.x-this.image.width),this.y<bounds.y?this.y=bounds.y:this.y>bounds.height-this.image.height&&(this.y=bounds.height-this.image.height)}Shoot(){app.playSound("laser");app.gameObjects.unshift(new Laser(app.player.x,app.player.y,this,!0,24)),app.canShoot=!1}die(){super.die(),app.playSound("explosion"),app.spray(this.x+this.image.width/2,this.y+this.image.height/2,200,"#FFCC00"),this.lastScore=app.score,app.endGame()}gotShot(shot){shot.alive&&(this.lives<=1?this.die():(this.lives--,app.spray(this.x+this.image.width/2,this.y+this.image.height/2,100,"#FFCC00")))}}class Planet extends GameObject{constructor(src,x,y){super(src,x,y)}update(bounds){this.image.width=app.displayRect.width,this.image.height=app.displayRect.height,super.update()}}class Enemy extends GameObject{constructor(src,x,y,text,itempoints,termid){super(src,x,y),this.xspeed=app.enemySpeed,this.yspeed=app.enemySpeed*(2+Math.random())/4,this.movespeed.x=0,this.movespeed.y=0,this.direction.y=1,this.text=text,this.itempoints=itempoints,this.movementClock=0,this.shotFrequency=80,this.shotClock=(1+Math.random())*this.shotFrequency,this.level=app.level,this.termid=termid}update(bounds){if(this.y<bounds.height/10||this.y>9*bounds.height/10?(this.movespeed.x=1*this.xspeed,this.movespeed.y=5*this.yspeed):(this.movespeed.x=this.xspeed,this.movespeed.y=this.yspeed),super.update(bounds),this.movementClock--,this.movementClock--,this.movementClock<=0&&(this.direction.x=Math.floor(3*Math.random())-1,this.movementClock=30*(2+Math.random())),this.shotClock-=app.enemySpeed,this.shotClock<=0&&this.y<.6*bounds.height){app.playSound("enemylaser");var laser=new Laser(this.x,this.y,this);laser.direction.y=1,laser.friendly=!1,app.gameObjects.unshift(laser),this.shotClock=(1+Math.random())*this.shotFrequency}this.x<bounds.x-this.image.width?this.x=bounds.width:this.x>bounds.width&&(this.x=bounds.x-this.image.width),this.y>bounds.height+this.image.height&&this.alive&&(this.alive=!1,this.itempoints>0&&(app.currentPointsLeft-=this.itempoints,app.score-=1e3*this.itempoints),app.shipReachedEnd.call(this))}draw(context){super.draw(context),context.fillStyle="#FFFFFF",context.font="20px Audiowide",context.textAlign="center",app.wrapText(context,this.text,!0,17,.2*app.displayRect.width,this.x+this.image.width/2,this.y-5)}die(){super.die(),app.spray(this.x+this.image.width,this.y+this.image.height,50+150*this.itempoints,"#FF0000"),app.score+=1e3*this.itempoints,app.reportSuccess(this.termid),app.playSound("explosion")}gotShot(shot){shot.die(),this.die()}}class Laser extends GameObject{constructor(x,y,shooter,friendly,laserSpeed){super(friendly?"pix/laser.png":"pix/enemylaser.png",x,y),this.x=this.x+(shooter.image.width-this.image.width)/2,this.direction.y=-1,this.friendly=friendly?1:0,this.laserSpeed=laserSpeed||12}update(bounds){super.update(bounds),(this.x<bounds.x-this.image.width||this.x>bounds.width||this.y<bounds.y-this.image.height||this.y>bounds.height)&&(this.alive=!1),this.velocity.y=this.laserSpeed*this.direction.y}deflect(){this.image=this.loadImage("pix/enemylaser.png"),this.direction.y*=-1,this.friendly=!this.friendly,app.playSound("deflect")}}class Particle extends GameObject{constructor(x,y,velocity,colour){super(null,x,y),this.width=2,this.height=2,this.velocity.x=velocity.x,this.velocity.y=velocity.y,this.aliveTime=0,this.colour=colour,this.decay=1}update(bounds){super.update(bounds),(this.x<bounds.x-this.width||this.x>bounds.width||this.y<bounds.y-this.height||this.y>bounds.height)&&(this.alive=!1),this.aliveTime++,this.aliveTime>15*Math.random()+5&&(this.alive=!1)}getRect(){return new Rectangle(this.x,this.y,this.width,this.height)}draw(context){context.fillStyle=this.colour,context.fillRect(this.x,this.y,this.width,this.height),context.stroke()}}class Star extends GameObject{constructor(bounds){super(null,Math.random()*bounds.width,0),this.width=2,this.height=2,this.direction.y=1,this.movespeed.y=.2+Math.random()/2,this.aliveTime=0}update(bounds){super.update(bounds),this.y>bounds.height&&(this.alive=!1)}draw(context){context.fillStyle="#9999AA",context.fillRect(this.x,this.y,this.width,this.height),context.stroke()}}class MultiEnemy extends Enemy{constructor(x,y,text,itempoints,single,termid){super("pix/ship-enemy-yellow-"+app.shipsize+".png",x,y,text,itempoints,termid),this.single=single}die(){super.die(),this.itempoints>0&&(app.currentPointsLeft-=this.itempoints),app.storeResult(this.termid,this.itempoints),(this.single&&1===this.itempoints&&this.itempoints>=1||this.itempoints>0&&app.currentPointsLeft<=0)&&(app.killAllAlive(),app.nextLevel())}gotShot(shot){this.itempoints>0?(shot.die(),this.die(),app.reportSuccess(this.termid)):(app.score+=600*(this.itempoints-.5),app.storeResult(this.termid,0),shot.deflect())}}class MatchEnemy extends Enemy{constructor(x,y,text,itempoints,pairid,stem,termid){super("pix/ship-enemy-green-"+app.shipsize+".png",x,y,text,itempoints,termid),this.stem=!!stem,this.pairid=pairid,this.shotFrequency=160,this.hightlighted=!1}die(){app.currentPointsLeft-=this.itempoints,this.itempoints=0,super.die()}gotShot(shot){if(shot.alive&&this.alive)if(app.lastShot==-this.pairid){app.score+=1e3*this.itempoints*2,app.storeResult(this.termid,this.itempoints),app.reportSuccess(this.termid),shot.die(),this.die();var alives=0;app.currentTeam.forEach((function(match){match.pairid==app.lastShot&&match.die(),match.alive&&alives++})),alives<=0&&app.nextLevel()}else app.lastShot==this.pairid?shot.deflect():(shot.die(),this.hightlight(),app.lastShot=this.pairid)}hightlight(){app.currentTeam.forEach((function(match){match.unhightlight()})),this.stem,this.loadImage("pix/ship-enemy-blue-"+app.shipsize+".png"),this.hightlighted=!0}unhightlight(){this.hightlighted&&(this.stem,this.loadImage("pix/ship-enemy-green-"+app.shipsize+".png")),this.hightlighted=!1}}var app={isFreeMode:!1,termAsAlien:"0",questions:[],quizgame:null,stage:null,score:0,particles:[],gameObjects:[],shipsize:"48",images:["pix/icon.gif","pix/planet.png","pix/ship.png","pix/ship-poodll-64.png","pix/ship-enemy-green-64.png","pix/ship-enemy-yellow-64.png","pix/ship-enemy-blue-64.png","pix/ship-poodll-48.png","pix/ship-enemy-green-48.png","pix/ship-enemy-yellow-48.png","pix/ship-enemy-blue-48.png","pix/space-bckg.png","pix/enemy.png","pix/enemystem.png","pix/enemychoice.png","pix/enemystemselected.png","pix/enemychoiceselected.png","pix/laser.png","pix/enemylaser.png"],imagesLoaded:0,loadedImages:[],loaded:!1,player:null,planet:null,level:-1,displayRect:{x:0,y:0,width:0,height:0},question:"",interval:null,enemySpeed:null,touchDown:!1,mouseDown:!1,currentTeam:[],lastShot:0,currentPointsLeft:0,context:null,inFullscreen:!1,canShoot:!0,dryRun:!1,ttslanguage:"en-US",distractors:[],controls:{},results:[],timer:null,registerWordcardsEvents:function(){$("body").on("click","#wordcards-start-button",(function(){app.start()})),$("body").on("click","#wordcards-try-again",(function(){location.reload()})),$("body").on("click","#wordcards-close-results",(function(){var total_time=app.timer.count,url=app.nexturl.replace(/&amp;/g,"&")+"&localscattertime="+total_time;window.location.replace(url)}))},registerSpaceGameEvents:function(){document.onkeyup=this.keyup,document.onkeydown=this.keydown,document.onmouseup=this.mouseup,document.onmousedown=this.mousedown,document.onmousemove=this.mousemove,document.ontouchstart=this.touchstart,document.ontouchend=this.touchend,document.addEventListener("touchmove",this.touchmove,{passive:!1}),window.onresize=this.orientationChange,document.addEventListener("gesturestart",this.cancelled,!1),document.addEventListener("gesturechange",this.cancelled,!1),document.addEventListener("gestureend",this.cancelled,!1)},playSound:function(soundName){if(document.getElementById("mod_wordcards_spacegame_sound_on").checked){var soundElement=document.getElementById("mod_wordcards_sound_"+soundName);soundElement.currentTime=0,soundElement.play()}},smallscreen:function(){this.inFullscreen=!1,document.exitFullscreen?document.exitFullscreen().then((()=>console.log("Document Exited from Full screen mode"))).catch((err=>console.error(err))):document.webkitExitFullscreen?document.webkitExitFullscreen():document.msExitFullscreen&&document.msExitFullscreen(),this.stage.removeAttribute("width"),this.stage.removeAttribute("height"),this.stage.removeAttribute("style"),this.stage.classList.remove("floating-game-canvas"),$("#button_container").removeClass("floating-button-container fixed-bottom"),this.displayRect.width=this.stage.clientWidth,this.displayRect.height=this.stage.clientHeight,this.stage.style.width=this.displayRect.width,this.stage.style.height=this.displayRect.height,this.sizeScreen(this.stage)},fschange:function(){this.inFullscreen&&this.smallscreen()},fullscreen:function(){var landscape=window.matchMedia("(orientation: landscape)").matches;try{this.stage.requestFullscreen?this.stage.requestFullscreen():this.stage.msRequestFullscreen?this.stage.msRequestFullscreen():this.stage.mozRequestFullScreen&&this.stage.mozRequestFullScreen()}catch(e){log.debug(e,"Fullscreen error: ")}this.inFullscreen=!0;var buttonContainer=$("#button_container"),width=window.innerWidth,height=$(window).height();landscape&&width<height&&(height=[width,width=height][0]),height-=buttonContainer.height()+16,this.displayRect.width=width,this.displayRect.height=height,this.stage.style.width=width+"px",this.stage.style.height=height+"px",this.stage.classList.add("floating-game-canvas"),buttonContainer.addClass("floating-button-container fixed-bottom"),$("#mod_wordcards_spacegame_fullscreen_button").blur(),this.sizeScreen(this.stage)},sizeScreen:function(stage){stage.width=this.displayRect.width,stage.height=this.displayRect.height,this.context.imageSmoothingEnabled=!1},orientationChange:function(){app.inFullscreen?app.fullscreen():app.smallscreen()},clearEvents:function(){document.onkeydown=null,document.onkeyup=null,document.onmousedown=null,document.onmouseup=null,document.onmousemove=null,document.ontouchstart=null,document.ontouchend=null,document.ontouchmove=null,window.onresize=null},storeResult:function(termid,points){var theterm=!1;if(app.definitions.terms.forEach((function(term){term.id==termid&&(theterm=term)})),theterm){for(var result={question:app.strip_html(theterm.definition),selected:"",correct:theterm.term,points:points,id:theterm.id},i=0;i<app.results.length;i++)if(app.results[i].id==theterm.id){if(!(points>0&&0==app.results[i].points))return;app.results.splice(i,1)}app.results.push(result)}},reportSuccess:function(termid){this.dryRun||Ajax.call([{methodname:"mod_wordcards_report_successful_association",args:{termid:termid,isfreemode:app.isFreeMode}}])},reportFailure:function(term1id,term2id){this.dryRun||Ajax.call([{methodname:"mod_wordcards_report_failed_association",args:{term1id:term1id,term2id:term2id,isfreemode:app.isFreeMode}}])},menuEvents:function(){this.clearEvents(),document.onkeydown=this.menukeydown,document.onmouseup=this.menumousedown,document.ontouchend=this.menutouchend,window.onresize=this.orientationChange},showMenu:function(){this.context.clearRect(0,0,this.displayRect.width,this.displayRect.height),this.context.fillStyle="#FFFFFF",this.context.font="18px Audiowide",this.context.textAlign="center",null!==this.questions&&this.questions.length>0?(this.context.fillText(M.util.get_string("spacetostart","mod_wordcards"),this.displayRect.width/2,this.displayRect.height/2),this.menuEvents()):this.context.fillText(M.util.get_string("emptyquiz","mod_wordcards"),this.displayRect.width/2,this.displayRect.height/2)},loadGame:function(){this.loaded?this.startGame():(this.images.forEach((function(src){var image=new Image;image.src=src,image.onload=function(){app.loadedImages[src]=image,app.imagesLoaded++,app.imagesLoaded>=app.images.length&&app.gameLoaded()}})),this.loaded=!0)},endGame:function(){app.inFullscreen&&(log.debug("quitting full screen"),app.inFullscreen=!1,app.smallscreen()),clearInterval(app.timer.interval),$("#wordcards-gameboard, #wordcards-start-button").hide(),$("#wordcards-results").show();var tdata=[];tdata.nexturl=this.nexturl,tdata.results=app.results,tdata.total=app.definitions.terms.length,tdata.totalcorrect=a4e.calc_total_points(app.results),tdata.gamescore=Math.round(app.score);var total_time=app.timer.count;tdata.prettytime=0==total_time?"00:00":a4e.pretty_print_secs(total_time),templates.render("mod_wordcards/feedback",tdata).then((function(html,js){$("#results-inner").html(html),require(["mod_wordcards/mywords"],(function(mywords){mywords.initFromFeedbackPage()}))}));app.results;app.isFreeMode||Ajax.call([{methodname:"mod_wordcards_report_step_grade",args:{modid:app.modid,correct:tdata.totalcorrect}}]),this.killAllAlive(),this.clearEvents()},gameLoaded:function(){clearInterval(app.interval),app.interval=setInterval((function(){app.draw(app.context,app.displayRect,app.gameObjects,app.particles,app.question),app.update(app.displayRect,app.gameObjects,app.particles)}),40),this.startGame()},startGame:function(){this.score=0,this.gameObjects=[],this.particles=[],this.level=-1,this.enemySpeed=.5,this.touchDown=!1,this.mouseDown=!1,this.results=[],this.player=new Player("pix/ship-poodll-"+app.shipsize+".png",0,0),this.player.x=this.displayRect.width/2,this.player.y=this.displayRect.height/2,this.gameObjects.push(this.player),this.planet=new Planet("pix/planet.png",0,0),this.planet.image.width=this.displayRect.width,this.planet.image.height=this.displayRect.height,this.planet.direction.y=1,this.planet.movespeed.y=.7,this.particles.push(this.planet),this.timer={interval:setInterval((function(){app.timer.update()}),1e3),count:0,update:function(){app.timer.count++,$("#wordcards-time-counter").text(a4e.pretty_print_secs(app.timer.count))}},this.nextLevel(),this.registerSpaceGameEvents()},nextLevel:function(){this.level++,this.level>=this.questions.length?app.player.die():this.question=this.runLevel(this.questions,this.level,this.displayRect)},runLevel:function(questions,level,bounds){switch(this.currentTeam=[],this.lastShot=0,this.currentPointsLeft=0,questions[level].type){case"matching":var i=0,itempoints=1/(2*questions[level].stems.length);this.currentPointsLeft+=1,questions[level].stems.forEach((function(stem){i++;var question=new MatchEnemy(Math.random()*bounds.width,-Math.random()*bounds.height/2,stem.question,itempoints,-i,!0,stem.termid),answer=new MatchEnemy(Math.random()*bounds.width,-Math.random()*bounds.height/2,stem.answer,itempoints,i,!1,stem.termid);app.currentTeam.push(question),app.currentTeam.push(answer),app.gameObjects.push(question),app.gameObjects.push(answer)}));break;case"multichoice":questions[level].answers.forEach((function(answer){var enemy=new MultiEnemy(Math.random()*bounds.width,-Math.random()*bounds.height/2,answer.text,answer.itempoints,questions[level].single,questions[level].termid);answer.itempoints<1&&(app.currentTeam.push(enemy),answer.itempoints>0&&(app.currentPointsLeft+=answer.itempoints)),app.gameObjects.push(enemy)}))}return questions[level].question},draw:function(context,displayRect,objects,particles,question){context.clearRect(0,0,displayRect.width,displayRect.height),app.drawSpaceBackground(context,displayRect);var i=0;for(i=0;i<particles.length;i++)particles[i].draw(context);for(i=0;i<objects.length;i++)objects[i].draw(context);this.player.alive?(context.fillStyle="#FFFFFF",context.font="18px Audiowide",context.textAlign="left",context.fillText(M.util.get_string("score","mod_wordcards",{score:Math.round(this.score),lives:this.player.lives}),5,displayRect.height-20),context.textAlign="center",this.wrapText(context,question,!1,20,.9*displayRect.width,displayRect.width/2,20)):(context.fillStyle="#FFFFFF",context.font="18px Audiowide",context.textAlign="center",context.fillText(M.util.get_string("endofgame","mod_wordcards",Math.round(this.player.lastScore)),displayRect.width/2,displayRect.height/2))},update:function(bounds,objects,particles){var i=0;for(i=0;i<3;i++)particles.push(new Star(bounds));for(i=0;i<particles.length;i++)particles[i].update(bounds),particles[i].alive||(particles.splice(i,1),i--);for(i=0;i<objects.length;i++){objects[i].update(bounds);for(var j=i+1;j<objects.length;j++)this.collide(objects[i],objects[j]);objects[i].alive||(objects.splice(i,1),i--)}},killAllAlive:function(){this.currentTeam.forEach((function(enemy){enemy.alive&&(enemy.itempoints=0,enemy.die())})),this.currentTeam=[]},collide:function(object1,object2){return object1.alive&&object2.alive&&(this.collideOrdered(object1,object2)||this.collideOrdered(object2,object1))},collideOrdered:function(object1,object2){return object1 instanceof Laser&&object2 instanceof Player&&!object1.friendly&&app.objectsIntersect(object1,object2)?(object2.gotShot(object1),object1.die(),!0):object1 instanceof Laser&&object2 instanceof Enemy&&object1.friendly&&app.objectsIntersect(object1,object2)?(object2.gotShot(object1),!0):!!(object1 instanceof Player&&object2 instanceof Enemy&&app.objectsIntersect(object1,object2))&&(object1.die(),!0)},objectsIntersect:function(object1,object2){var rect1=object1.getRect(),rect2=object2.getRect();return rect1.Intersect(rect2)},spray:function(x,y,num,colour){for(var i=0;i<num;i++)this.particles.push(new Particle(x,y,{x:16*(Math.random()-.5),y:16*(Math.random()-.5)+3},colour))},wrapText:function(context,input,wrapUpwards,textHeight,maxLineWidth,x,y){var drawLines=[],originalY=y,words=input.split(" "),line="",maxTextWidth=0;words.forEach((function(word){var tempLine="";tempLine=line+" "+word;var textWidth=context.measureText(tempLine).width;maxTextWidth=Math.max(maxTextWidth,textWidth),textWidth>maxLineWidth?(drawLines.push({text:line,y:y+=textHeight}),line=word):line=tempLine})),drawLines.push({text:line,y:y+=textHeight});var yOffset=y-originalY,boxmodifier=wrapUpwards?-(yOffset+textHeight+10):-(textHeight+10),borderColor=wrapUpwards?"transparent":"white";app.drawRoundRect(context,borderColor,maxTextWidth+20,textHeight*drawLines.length+20,x-(maxTextWidth+20)/2,y+boxmodifier),context.fillStyle="white",drawLines.forEach((function(drawLine){var modifier=wrapUpwards?-yOffset:0;context.fillText(drawLine.text,x,drawLine.y+modifier)}))},drawRoundRect:function(context,borderColor,width,height,x,y){"white"!==borderColor&&(borderColor="rgba(75, 71, 77, 0.5)"),context.fillStyle="rgba(75, 71, 77, 0.5)",context.fillRect(x,y,width,height),context.strokeStyle=borderColor,context.lineWidth=4,context.strokeRect(x-2,y-2,width+4,height+4)},drawSpaceBackground:function(context,displayRect){for(var img=app.loadedImages["pix/space-bckg.png"],tilesX=Math.ceil(displayRect.width/img.width),tilesY=Math.ceil(displayRect.height/img.height),i=0;i<tilesX;i++)for(var j=0;j<tilesY;j++)context.drawImage(img,i*img.width,j*img.height,img.width,img.height)},shipReachedEnd:function(){0===app.currentTeam.filter((function(enemy){return enemy.alive})).length&&app.player.alive&&app.nextLevel()},menukeydown:function(e){-1!==[32,37,38,39,40].indexOf(e.keyCode)&&(e.preventDefault(),32===e.keyCode&&app.loadGame())},menumousedown:function(e){e.target===app.stage&&app.loadGame()},menutouchend:function(e){e.target===app.stage&&app.loadGame()},keydown:function(e){-1!==[32,37,38,39,40].indexOf(e.keyCode)&&(e.preventDefault(),32===e.keyCode&&app.player.alive&&app.canShoot?app.player.Shoot():37===e.keyCode?app.player.direction.x=-1:38===e.keyCode?app.player.direction.y=-1:39===e.keyCode?app.player.direction.x=1:40===e.keyCode&&(app.player.direction.y=1))},keyup:function(e){32===e.keyCode?app.canShoot=!0:-1!==[37,39].indexOf(e.keyCode)?app.player.direction.x=0:-1!==[38,40].indexOf(e.keyCode)&&(app.player.direction.y=0)},mousedown:function(e){e.target===app.stage&&(app.player.getRect().Contains({x:e.offsetX,y:e.offsetY})&&app.player.alive&&app.player.Shoot(),app.mouseDown||(app.player.mouse.x=e.offsetX,app.player.mouse.y=e.offsetY,app.mouseDown=!0))},mouseup:function(){app.player.direction.x=0,app.player.direction.y=0,app.mouseDown=!1},mousemove:function(e){app.player.mouse.x=e.offsetX,app.player.mouse.y=e.offsetY},cancelled:function(event){event.target===app.stage&&event.preventDefault()},touchstart:function(e){e.target===app.stage&&(app.player.alive&&e.touches.length>1?app.player.Shoot():(app.touchDown=!0,app.touchmove(e)),e.preventDefault())},touchend:function(e){0===e.touches.length&&(app.touchDown=!1),app.player.direction.x=0,app.player.direction.y=0,e.target===app.stage&&e.preventDefault()},touchmove:function(e){var rect=e.target.getBoundingClientRect(),x=e.touches[0].pageX-rect.left,y=e.touches[0].clientY-rect.top;window.stage=app.stage,app.player.mouse.x=x,app.player.mouse.y=y-2*app.player.image.height,e.target===app.stage&&e.preventDefault()},shuffle:function(array){for(var temporaryValue,randomIndex,currentIndex=array.length;0!==currentIndex;)randomIndex=Math.floor(Math.random()*currentIndex),temporaryValue=array[currentIndex-=1],array[currentIndex]=array[randomIndex],array[randomIndex]=temporaryValue;return array},strip_html:function(htmlstring){return htmlstring.replace(/<\/?[^>]+(>|$)/g,"")},process:function(definitions){a4e.list_vocab("#vocab-list-inner",definitions.terms);var terms=definitions.terms;this.shuffle_array(terms);var chunkSize=5;terms.length&&(chunkSize=terms.length);for(var mc_levels=this.split_array(terms,chunkSize),thelevel=0;thelevel<mc_levels.length;thelevel++)for(var level=mc_levels[thelevel],i=0;i<level.length;i++){for(var answers=[],j=0;j<level.length;j++){var answertext=app.strip_html(level[j].definition);app.sgoptions===app.termAsAlien&&(answertext=level[j].term),answers.push({text:answertext,itempoints:i===j?1:0})}var questiontext=level[i].term;app.sgoptions===app.termAsAlien&&(questiontext=app.strip_html(level[i].definition)),this.questions.push({question:questiontext,termid:level[i].id,answers:answers,type:"multichoice",single:!0})}chunkSize=3;var matching_levels=this.split_array(terms,chunkSize);for(thelevel=0;thelevel<matching_levels.length;thelevel++){level=matching_levels[thelevel];var subquestions=[];for(i=0;i<level.length;i++)subquestions.push({question:level[i].term,answer:app.strip_html(level[i].definition),termid:level[i].id});this.questions.push({question:M.util.get_string("shootthepairs","mod_wordcards"),stems:subquestions,type:"matching"})}},shuffle_array:function(array){for(let i=array.length-1;i>0;i--){const j=Math.floor(Math.random()*(i+1));[array[i],array[j]]=[array[j],array[i]]}},split_array:function(array,chunkSize){null==chunkSize&&(chunkSize=4);for(var result=[],currentIndex=0;currentIndex<array.length;){const chunk=array.slice(currentIndex,currentIndex+chunkSize);if(chunk.length<chunkSize){const remaining=chunkSize-chunk.length;for(var i=0;i<remaining;i++)chunk.push(array[i])}result.push(chunk),currentIndex+=chunkSize}return result},init_controls:function(){app.controls.close_results=$("#wordcards-close-results"),app.controls.results=$("#wordcards-results"),app.controls.vocab_list=$("#wordcards-vocab-list"),app.controls.the_list=$("#speechcards_thelist"),app.controls.gameboard=$("#wordcards-gameboard"),app.controls.time_counter=$("#wordcards-time-counter")},init:function(props){var theid="#"+props.widgetid;this.dryRun=props.dryRun,this.nexturl=props.nexturl,this.modid=props.modid,this.isFreeMode=props.isfreemode,this.sgoptions=props.sgoptions;var configcontrol=$(theid).get(0);configcontrol?(this.definitions=JSON.parse(configcontrol.value),$(theid).remove(),this.questionid=props.modid,this.init_controls(),this.process(this.definitions),a4e.register_events(),a4e.init_audio(props.token,props.region,props.owner,props.cloudpoodllurl),this.registerWordcardsEvents()):log.debug("No config found on page. Giving up.")},start:function(){app.results=[],app.controls.vocab_list.hide(),app.controls.gameboard.show(),app.controls.time_counter.text("00:00"),app.timer={interval:setInterval((function(){app.timer.update()}),1e3),count:0,update:function(){app.timer.count++,app.controls.time_counter.text(a4e.pretty_print_secs(app.timer.count))}},document.addEventListener&&(document.addEventListener("fullscreenchange",this.fschange,!1),document.addEventListener("MSFullscreenChange",this.fschange,!1),document.addEventListener("mozfullscreenchange",this.fschange,!1),document.addEventListener("webkitfullscreenchange",this.fschange,!1)),this.stage=document.getElementById("mod_wordcards_spacegame"),this.context=this.stage.getContext("2d"),this.smallscreen(),this.interval=setInterval((function(){app.showMenu()}),500),$("#mod_wordcards_spacegame_fullscreen_button").on("click",(function(){app.inFullscreen?(app.inFullscreen=!1,app.smallscreen()):app.fullscreen()}))}};return app}));

//# sourceMappingURL=spacegame.min.js.map