# Behaviour Analytics for Moodle (`local_behavioranalytics`)

This plugin monitors user activity in Moodle to detect **unusual or risky behaviour patterns** — such as **multiple failed login attempts**, **logins from impossible locations**, **activity bursts**, or **unusual login hours**.
It computes a **per-user risk score**, displays administrator reports, and can automatically trigger **mitigation actions** (like suspending accounts or notifying admins).

It is designed to be **lightweight, auditable, and privacy-respecting**, while providing meaningful insights into suspicious or compromised accounts.

## 🧩 Installation

1. Place this plugin in:

   ```bash
   local/behavioranalytics
   ```

2. Visit **Site administration → Notifications** to complete installation.

3. A new **“Behaviour Analytics”** section will appear under:

   * **Site administration → Reports → Behaviour Analytics**
   * **Site administration → Plugins → Local plugins → Behaviour Analytics**

## ⚙️ Configuration

Go to
**Site administration → Plugins → Local plugins → Behaviour Analytics**

You can configure:

| Setting                        | Description                                                                      |
| ------------------------------ | -------------------------------------------------------------------------------- |
| **Persist risk profiles**      | Store computed user risk data for reporting and external access.                 |
| **Scoring strategy**           | Choose between *Weighted mean*, *Maximum rule risk*, or *Cumulative capped sum*. |
| **Detector weights**           | Adjust how strongly each detector influences the total score.                    |
| **Mitigation threshold**       | Risk score (0–100) above which mitigation actions are triggered.                 |
| **Enabled mitigation actions** | Select one or more automatic responses (e.g. inform admin, suspend user).        |

## 🧠 Detectors

Detectors analyse different aspects of user activity.
Each produces a normalized **risk value (0–100)** and a descriptive message.
Their results are combined according to the selected scoring strategy.

### 🔹 Failed Logins (`failed_logins`)

Detects repeated **consecutive failed login attempts** within a short time window, indicating possible brute-force or credential-stuffing attacks.

* Counts failed login events (`\core\event\user_login_failed`) since the last successful login.
* Ignores guest, deleted, and webservice accounts.
* Configurable **threshold** and **time window** in plugin settings.
* Returns a proportional risk score once the threshold is exceeded.

### 🔹 Unusual Login Time (`login_time`)

Flags users who log in primarily during **unusual hours** (e.g., 0–5 a.m.) relative to normal usage.

* Configurable **night start** and **end hours**.
* Ignores users with too few logins to determine normal patterns.
* Useful for detecting off-hours access or automation.

### 🔹 IP Velocity (`ip_velocity`)

Detects **impossible travel** based on login IP geolocation changes.

* Compares consecutive login IPs and estimates travel speed.
* If above the configured **velocity threshold (km/h)**, raises a high-risk alert.
* Uses a pluggable geolocation provider (default: `null_provider`).

### 🔹 Activity Burst (`activity_burst`)

Flags users producing an **abnormally high number of events** in a short timeframe.

* Example: more than 30 actions within 60 seconds.
* Excludes webservice and guest users automatically.
* Indicates potential automation or misuse.

Each detector has an adjustable **weight** and dedicated admin settings.

## 🚨 Mitigation Actions

When a user’s risk score meets or exceeds the configured threshold,
one or more actions can be executed automatically.

| Action                      | Description                                                                                 |
| --------------------------- | ------------------------------------------------------------------------------------------- |
| **Inform administrator(s)** | Sends a Moodle message to all site admins. Each user is only reported once per risk period. |
| **Suspend user**            | Temporarily disables login for the affected user account.                                   |
| **Kill sessions**           | Immediately terminates all active sessions for the user.                                    |

Actions can be enabled or disabled individually and extended through the API.

## 📊 Reporting

### Main Report

Accessible at
**Site administration → Reports → Behaviour Analytics**

Displays the top users ranked by risk score.

* Excludes **guest**, **deleted**, and **webservice** accounts.
* Shows profile pictures, names, scores, and risk levels.
* Links to detailed per-user analysis.

### Detail View

Shows the contribution of each detector, including:

* Raw risk value
* Weight applied
* Weighted score
* Detector message / explanation

Includes a “Back to report” navigation button.

## 🔁 Scheduled Task

The scheduled task:

```bash
local_behavioranalytics\task\scan_anomalies
```

runs periodically (default: once per hour) and performs:

1. Scans all active user accounts.
2. Computes and optionally stores per-user risk profiles.
3. Executes configured mitigation actions for high-risk users.
4. Avoids repeated notifications for the same user until their risk decreases.

You can adjust the frequency in
**Site administration → Server → Scheduled tasks**.

## 🔒 Privacy and Data Handling

* Fully implements Moodle’s **Privacy API**.
* Stores only derived **risk metrics**, never raw log data.
* **Guest**, **deleted**, and **webservice** users are excluded by design.
* Data can be deleted through Moodle’s privacy tools at any time.

## 🧪 Developer Notes

* Each detector extends `local_behavioranalytics\local\detector\base`.
* Each mitigation action extends `local_behavioranalytics\local\action\base`.
* Comprehensive PHPUnit tests cover detectors, actions, scoring, and persistence.
* Risk scoring strategies (`sumcap`, `maximum`, `weightedmean`) are modular and extensible.
* External services (e.g. `get_user_risk`) allow integration with dashboards or monitoring tools.

## 👤 Maintainer

**Christopher Reimann**
📧 [christopher@learningsecured.com](mailto:christopher@learningsecured.com)
License: [GPL v3+](https://www.gnu.org/licenses/gpl-3.0.html)

## 🧭 Summary

`local_behavioranalytics` provides a **modular, privacy-aware framework** for detecting behavioural anomalies in Moodle.
It combines configurable **detectors**, intelligent **risk scoring**, and **automated mitigation**, helping administrators identify and respond to risky user behaviour early — before security incidents occur.
