<?php
// This file is part of Moodle - https://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Behat context class for local_behavioranalytics plugin.
 *
 * @package     local_behavioranalytics
 * @category    test
 * @copyright   2025 Christopher Reimann
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace local_behavioranalytics\behat;

use Behat\Behat\Context\Context;

/**
 * Defines step definitions and page mappings for Behat features.
 *
 * This class is required so Moodle can resolve plugin-specific page
 * navigation such as:
 *   When I am on the "local_behavioranalytics > report" page
 */
final class behat_local_behavioranalytics implements Context {
    // You don't need to define any steps here yet — Moodle just needs this class to exist.
}
