<?php
// This file is part of Moodle - https://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Null geolocation provider (returns 0 km distance).
 *
 * @package     local_behavioranalytics
 * @copyright   2025 Christopher Reimann
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_behavioranalytics\local\geo;

/**
 * Dummy geolocation provider implementation.
 *
 * This provider always returns a distance of 0 km, effectively disabling
 * IP-based velocity calculations. It is used as a fallback when no real
 * geolocation backend is configured or available.
 *
 * @package     local_behavioranalytics
 */
class null_provider implements provider {
    /**
     * Return a fixed distance of 0.0 km between any two IPs.
     *
     * @param string $ip1 The first IP address.
     * @param string $ip2 The second IP address.
     * @return float Always 0.0.
     */
    public function distance_km(string $ip1, string $ip2): float {
        return 0.0;
    }
}
