<?php
// This file is part of Moodle - https://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Geolocation provider interface.
 *
 * @package     local_behavioranalytics
 * @copyright   2025 Christopher Reimann
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_behavioranalytics\local\geo;

/**
 * Interface for geolocation distance providers.
 *
 * Implementations of this interface supply a way to calculate the
 * geographic distance between two IP addresses in kilometres.
 *
 * This abstraction allows the plugin to support multiple
 * geolocation backends (for example, MaxMind, GeoLite2, or an
 * internal IP mapping service).
 *
 * @package     local_behavioranalytics
 */
interface provider {
    /**
     * Estimate the distance in kilometres between two IP addresses.
     *
     * Implementations should return 0.0 if distance cannot be determined.
     *
     * @param string $ip1 The first IP address.
     * @param string $ip2 The second IP address.
     * @return float Distance in kilometres (0.0 if unavailable).
     */
    public function distance_km(string $ip1, string $ip2): float;
}
