<?php
// This file is part of Moodle - https://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Upgrade steps for local_behavioranalytics.
 *
 * This file is used to handle database and configuration
 * schema upgrades when the plugin version changes.
 *
 * @package     local_behavioranalytics
 * @category    upgrade
 * @copyright   2025 Christopher Reimann
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Execute upgrade steps between plugin versions.
 *
 * This function is automatically called by the Moodle upgrade
 * system when the plugin's version number increases in version.php.
 *
 * @param int $oldversion The version we are upgrading from.
 * @return bool Always true if upgrade successful.
 */
function xmldb_local_behavioranalytics_upgrade(int $oldversion): bool {
    // Example upgrade step: ensure new savepoint.
    if ($oldversion < 2025110902) {
        // Nothing to upgrade currently, just bump savepoint.
        upgrade_plugin_savepoint(true, 2025110902, 'local', 'behavioranalytics');
    }

    return true;
}
