<?php
// This file is part of Moodle - https://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Language strings for local_behavioranalytics.
 *
 * @package     local_behavioranalytics
 * @category    string
 * @copyright   2025 Christopher Reimann
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['action_inform_admin'] = 'Inform administrator(s)';
$string['action_kill_sessions'] = 'Kill all user sessions';
$string['action_suspend_user'] = 'Suspend the user account';
$string['activityburst_events'] = 'Activity burst: events threshold';
$string['activityburst_events_desc'] = 'Number of events within the time window to consider a burst (default 30).';
$string['activityburst_window'] = 'Activity burst: time window (seconds)';
$string['activityburst_window_desc'] = 'Size of the window for counting events (default 60 seconds).';
$string['cap:manage'] = 'Manage behavior analytics';
$string['cap:view'] = 'View behavior analytics';
$string['detector'] = 'Detector';
$string['detector_activity_burst'] = 'Activity burst';
$string['detector_activity_burst_flag'] = 'High event rate: {$a->events} events in {$a->seconds}s window';
$string['detector_failed_logins'] = 'Failed login attempts';
$string['detector_failed_logins_flag'] = 'User has {$a->count} failed logins within {$a->minutes} minutes.';
$string['detector_ip_velocity'] = 'IP velocity';
$string['detector_ip_velocity_flag'] = 'Impossible travel detected (≈{$a->speed} km/h over ≈{$a->km} km)';
$string['detector_login_time'] = 'Unusual login time';
$string['detector_login_time_high'] = 'Strongly atypical: {$a}% of logins in night window';
$string['detector_login_time_medium'] = 'Atypical login window: {$a}% of logins in night window';
$string['enabledactions'] = 'Enabled mitigation actions';
$string['enabledactions_desc'] = 'Actions to execute when the threshold is exceeded.';
$string['enableipvelocity'] = 'Enable IP velocity detector';
$string['enableipvelocity_desc'] = 'Flag logins that imply impossible travel between IP geolocations.';
$string['event_mitigation_executed'] = 'Mitigation action executed';
$string['failedlogins_threshold'] = 'Failure threshold';
$string['failedlogins_threshold_desc'] = 'Number of consecutive failed login attempts before risk is raised.';
$string['failedlogins_window'] = 'Observation window (seconds)';
$string['failedlogins_window_desc'] = 'Time period (in seconds) to consider failed logins when evaluating risk.';
$string['generalsettings'] = 'General';
$string['generalsettings_desc'] = 'General configuration of Behaviour Analytics.';
$string['ipvelocity_kmph'] = 'Velocity threshold (km/h)';
$string['ipvelocity_kmph_desc'] = 'Above this speed between two consecutive logins for the same user is flagged.';
$string['message'] = 'Message';
$string['messageprovider:risk_alert'] = 'Risk alert notifications to administrators';
$string['mitigation_threshold'] = 'Risk score threshold for mitigation';
$string['mitigation_threshold_desc'] = 'If a user reaches or exceeds this score, the selected mitigation actions are executed automatically by the scheduled task.';
$string['nightendhour'] = 'Night window end hour';
$string['nightendhour_desc'] = '0–23. Used by the Unusual Login Time detector.';
$string['nightstarthour'] = 'Night window start hour';
$string['nightstarthour_desc'] = '0–23. Used by the Unusual Login Time detector.';
$string['no_data'] = 'No anomalies detected.';
$string['persistprofiles'] = 'Persist risk profiles';
$string['persistprofiles_desc'] = 'If enabled, the scheduled task writes risk profiles to the database for faster reporting.';
$string['pluginname'] = 'Behavior analytics';
$string['privacy:metadata:local_behavioranalytics_profile'] = 'Cached behaviour analytics profiles for users.';
$string['privacy:metadata:local_behavioranalytics_profile:findings'] = 'JSON structure describing individual detector findings.';
$string['privacy:metadata:local_behavioranalytics_profile:level'] = 'Risk level label (low, medium, high).';
$string['privacy:metadata:local_behavioranalytics_profile:score'] = 'Computed weighted risk score.';
$string['privacy:metadata:local_behavioranalytics_profile:timemodified'] = 'Timestamp of the last update of this record.';
$string['privacy:metadata:local_behavioranalytics_profile:userid'] = 'User ID of the profiled user.';
$string['raw_risk'] = 'Raw risk';
$string['report_details'] = 'Anomaly details';
$string['report_title'] = 'User anomaly report';
$string['risk_level_high'] = 'High';
$string['risk_level_low'] = 'Low';
$string['risk_level_medium'] = 'Medium';
$string['risk_score'] = 'Risk score';
$string['scoringstrategy'] = 'Scoring strategy';
$string['scoringstrategy_desc'] = 'Choose the aggregation algorithm used to compute total risk.';
$string['scoringstrategy_maximum'] = 'Maximum rule risk (alert on any high anomaly)';
$string['scoringstrategy_sumcap'] = 'Cumulative capped sum (add up multiple small risks)';
$string['scoringstrategy_weightedmean'] = 'Weighted mean (smooth average risk)';
$string['setting_activity_burst_weight'] = 'Weight: Activity burst';
$string['setting_failed_logins_weight'] = 'Failed logins weight';
$string['setting_failed_logins_weight_desc'] = 'Determines how strongly failed login attempts contribute to the overall risk score.';
$string['setting_ip_velocity_weight'] = 'Weight: IP velocity';
$string['setting_login_time_weight'] = 'Weight: Unusual login time';
$string['setting_weight'] = 'Weight for rule: {$a}';
$string['setting_weight_desc'] = 'Relative importance of the "{$a}" rule when calculating overall risk. Higher values increase its influence.';
$string['settings_mitigation'] = 'Mitigation';
$string['settings_mitigation_desc'] = 'Configure what happens when a user\'s risk score exceeds the defined threshold.';
$string['settings_rules'] = 'Rules (Detectors)';
$string['settings_rules_desc'] = 'Configure individual behaviour detectors and their weightings.';
$string['settings_scoring'] = 'Risk scoring';
$string['settings_scoring_desc'] = 'Configure how multiple rule risks are combined into a single overall user score.';
$string['task_scan_anomalies'] = 'Scan user behaviour for anomalies';
$string['view_details'] = 'View details';
$string['weight'] = 'Weight';
$string['weighted'] = 'Weighted';
