<?php
// This file is part of Moodle - https://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * PHPUnit tests for the inform_admin mitigation action.
 *
 * @package     local_behavioranalytics
 * @category    test
 * @copyright   2025 Christopher Reimann
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace local_behavioranalytics\tests;

use advanced_testcase;
use local_behavioranalytics\local\action\inform_admin;

/**
 * Tests for {@see local_behavioranalytics\local\action\inform_admin}.
 *
 * Ensures that messages are correctly sent to site administrators
 * when the mitigation action is executed.
 *
 * @covers \local_behavioranalytics\local\action\inform_admin
 */
final class inform_admin_test extends advanced_testcase {
    /**
     * Verify that a risk alert message is sent to all site administrators.
     *
     * @return void
     */
    public function test_inform_admin_sends_message(): void {
        $this->resetAfterTest(true);

        $user = self::getDataGenerator()->create_user(['username' => 'riskuser']);
        $sink = $this->redirectMessages();

        $action = new inform_admin();
        $action->execute($user, 87, 'High');

        $messages = $sink->get_messages();
        $sink->close();

        $this->assertNotEmpty($messages);
        $this->assertStringContainsString('risk', strtolower($messages[0]->subject));
        $this->assertStringContainsString('riskuser', strtolower($messages[0]->fullmessage));
    }
}
