<?php
// This file is part of Moodle - https://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * PHPUnit tests for risk profile persistence.
 *
 * @package     local_behavioranalytics
 * @category    test
 * @copyright   2025 Christopher Reimann
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace local_behavioranalytics\tests;

use advanced_testcase;

/**
 * Verifies creation and retrieval of persisted risk profiles.
 *
 * @coversNothing
 */
final class persistence_test extends advanced_testcase {
    /**
     * Ensure that a risk profile can be inserted and fetched from DB.
     *
     * @return void
     */
    public function test_risk_profile_persistence_works(): void {
        $this->resetAfterTest(true);

        global $DB;
        $user = $this->getDataGenerator()->create_user();

        $record = (object)[
            'userid' => $user->id,
            'score' => 77,
            'level' => 'High',
            'findings' => json_encode(['activity_burst' => 95]),
            'timecreated' => time(),
        ];

        $DB->insert_record('local_behavioranalytics_profile', $record);

        $this->assertTrue(
            $DB->record_exists('local_behavioranalytics_profile', ['userid' => $user->id]),
            'Inserted risk profile record should exist in DB.'
        );
    }
}
