<?php
// This file is part of Moodle - https://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * PHPUnit tests for mitigation action registry.
 *
 * @package     local_behavioranalytics
 * @category    test
 * @copyright   2025 Christopher Reimann
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace local_behavioranalytics\tests;

use advanced_testcase;
use local_behavioranalytics\local\action\registry;

/**
 * Unit tests for the mitigation action registry.
 *
 * Verifies that the registry auto-discovers built-in mitigation actions.
 *
 * @covers \local_behavioranalytics\local\action\registry
 */
final class registry_actions_test extends advanced_testcase {
    /**
     * Verify that built-in mitigation actions are correctly auto-discovered.
     *
     * Confirms that {@see registry::all()} locates all available actions
     * in the plugin’s namespace without manual registration.
     *
     * @return void
     */
    public function test_action_registry_discovers_builtin_actions(): void {
        $this->resetAfterTest();

        $actions = registry::all();

        $this->assertNotEmpty(
            $actions,
            'Registry should discover at least one mitigation action.'
        );

        $this->assertContains(
            'local_behavioranalytics\\local\\action\\suspend_user',
            $actions,
            'suspend_user action must be discovered automatically.'
        );
    }
}
