<?php
// This file is part of Moodle - https://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * PHPUnit tests for the suspend_user mitigation action.
 *
 * @package     local_behavioranalytics
 * @category    test
 * @copyright   2025 Christopher Reimann
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

declare(strict_types=1);

namespace local_behavioranalytics\tests;

use advanced_testcase;
use local_behavioranalytics\local\action\suspend_user;

/**
 * Tests for {@see local_behavioranalytics\local\action\suspend_user}.
 *
 * Validates that executing this action correctly suspends user accounts.
 *
 * @covers \local_behavioranalytics\local\action\suspend_user
 */
final class suspend_user_test extends advanced_testcase {
    /**
     * Verify that the execute() method suspends an active user.
     *
     * @return void
     */
    public function test_execute_suspends_user(): void {
        global $DB;

        $this->resetAfterTest(true);
        $user = self::getDataGenerator()->create_user(['suspended' => 0]);

        $action = new suspend_user();
        $action->execute($user, 90, 'High');

        $updated = $DB->get_field('user', 'suspended', ['id' => $user->id]);
        $this->assertEquals(1, $updated);
    }

    /**
     * Verify that already suspended users are not modified.
     *
     * @return void
     */
    public function test_already_suspended_user_remains_suspended(): void {
        global $DB;

        $this->resetAfterTest(true);
        $user = self::getDataGenerator()->create_user(['suspended' => 1]);

        $action = new suspend_user();
        $action->execute($user, 45, 'Medium');

        $this->assertEquals(1, $DB->get_field('user', 'suspended', ['id' => $user->id]));
    }
}
