define("local_chunkupload/chunkupload",["exports","jquery","core/str","core/notification"],(function(_exports,_jquery,_str,_notification){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Manage the upload in chunks.
   *
   * @module    local_chunkupload
   * @copyright  2020 Justus Dieckmann WWU
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=function(elementid,acceptedTypes,maxBytes,wwwroot,chunksize,browsetext){let wwwRoot,chunkSize,fileinput,filename,progress,progressicon,deleteicon,token;fileinput=(0,_jquery.default)("#"+elementid+"_file"),token=(0,_jquery.default)("#"+elementid).val();let parentelem=fileinput.next();function startUpload(file){let end=chunkSize<file.size?chunkSize:file.size,params={start:0,end:end,length:file.size,filename:file.name,id:token},slice=file.slice(0,end),xhr=new XMLHttpRequest;xhr.open("post",wwwRoot+"/local/chunkupload/startupload_ajax.php?"+_jquery.default.param(params)),xhr.upload.onprogress=e=>{setProgress(e.loaded,file.size)},xhr.onreadystatechange=()=>{if(4===xhr.readyState&&200===xhr.status){let response=JSON.parse(xhr.responseText);void 0!==response.error?notifyError(response.error):end<file.size&&proceedUpload(file,chunkSize)}},xhr.setRequestHeader("Content-Type","application/octet-stream"),xhr.send(slice)}function proceedUpload(file,start){let end=start+chunkSize<file.size?start+chunkSize:file.size,params={start:start,end:end,id:token},slice=file.slice(start,end),xhr=new XMLHttpRequest;xhr.open("post",wwwRoot+"/local/chunkupload/proceedupload_ajax.php?"+_jquery.default.param(params)),xhr.upload.onprogress=e=>{setProgress(e.loaded+start,file.size)},xhr.onreadystatechange=()=>{if(4===xhr.readyState&&200===xhr.status){let response=JSON.parse(xhr.responseText);void 0!==response.error?notifyError(response.error):end<file.size&&proceedUpload(file,end)}},xhr.onerror=()=>{reset(),_notification.default.alert("Error","Failure while uploading!","Ok")},xhr.setRequestHeader("Content-Type","application/octet-stream"),xhr.send(slice)}function reset(){setProgress(0,1),filename.text("")}function setProgress(loaded,total){loaded===total?progress.css("width","0"):progress.css("width",100*loaded/total+"%"),progressicon.prop("hidden",loaded!==total),deleteicon.prop("hidden",loaded!==total)}function notifyError(errorstring){reset(),"string"==typeof errorstring?(0,_str.get_strings)([{key:"error"},{key:"ok"}]).done((function(s){_notification.default.alert(s[0],errorstring,s[1])})).fail(_notification.default.exception):(0,_str.get_strings)([{key:"error"},errorstring,{key:"ok"}]).done((function(s){_notification.default.alert(s[0],s[1],s[2])})).fail(_notification.default.exception)}filename=parentelem.find(".chunkupload-filename"),progress=parentelem.find(".chunkupload-progress"),progressicon=parentelem.find(".chunkupload-icon"),deleteicon=parentelem.next(),wwwRoot=wwwroot,chunkSize=chunksize,fileinput.change((()=>{reset();let file=fileinput.get(0).files[0],fileextension=".";if(-1!==file.name.indexOf(".")){let splits=file.name.split(".");fileextension="."+splits[splits.length-1].toLowerCase()}return"*"===acceptedTypes||acceptedTypes instanceof Array&&(-1!==acceptedTypes.indexOf(fileextension)||-1!==acceptedTypes.indexOf("*"))?-1!==maxBytes&&file.size>maxBytes?(fileinput.val(null),void notifyError({key:"errorpostmaxsize",component:"core_repository"})):(filename.text(file.name),void startUpload(file)):(fileinput.val(null),void notifyError({key:"invalidfiletype",component:"core_repository",param:fileextension}))})),deleteicon.on("click",(event=>{reset();let params={id:token},xhr=new XMLHttpRequest;xhr.open("post",wwwRoot+"/local/chunkupload/deleteupload_ajax.php?"+_jquery.default.param(params)),xhr.send(null),filename.text(browsetext),fileinput.val(null),event.stopPropagation()}))},_jquery=_interopRequireDefault(_jquery),_notification=_interopRequireDefault(_notification)}));

//# sourceMappingURL=chunkupload.min.js.map