<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Definition of Moodleoverflow scheduled tasks.
 *
 * @package   mod_moodleoverflow
 * @copyright 2017 Kennet Winter <k_wint10@uni-muenster.de>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$tasks = [

    // Deliver mail notification about posts that need to be reviewed.
    [
        'classname' => 'mod_moodleoverflow\task\send_review_mails',
        'blocking' => 0,
        'minute' => '*',
        'hour' => '*',
        'day' => '*',
        'month' => '*',
        'dayofweek' => '*',
    ],

    // Clean old read records.
    [
        'classname' => 'mod_moodleoverflow\task\clean_readrecords',
        'blocking' => 0,
        'minute' => '*',
        'hour' => '*',
        'day' => '*',
        'month' => '*',
        'dayofweek' => '*',
    ],

    // Send daily digest mail of unread posts.
    [
        'classname' => 'mod_moodleoverflow\task\send_daily_mails',
        'blocking' => 0,
        'minute' => '0',
        'hour' => '17',
        'day' => '*',
        'month' => '*',
        'dayofweek' => '*',
    ],

    // Task to send mail notification of new posts in subscribed discussions.
    [
        'classname' => 'mod_moodleoverflow\task\send_mails',
        'blocking' => 0,
        'minute' => '*',
        'hour' => '*',
        'day' => '*',
        'month' => '*',
        'dayofweek' => '*',
    ],
];
