<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * English language pack for local_learnwise
 *
 * @package    local_learnwise
 * @category   string
 * @copyright  2025 LearnWise <help@learnwise.ai>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesstoken'] = 'Access Token';
$string['apidisabled'] = 'API disabled';
$string['assistantid'] = 'Assistant ID';
$string['cleanuptokentask'] = 'Clean up tokens task';
$string['clientid'] = 'Client ID';
$string['clientsecret'] = 'Client Secret';
$string['completed'] = 'Completed';
$string['copied'] = 'Copied!';
$string['coursecontentsintegration'] = 'Course Contents Integration';
$string['coursecontentsintegration_desc'] = 'This allows the assistant to ingest the course contents from Moodle, allowing to answer questions about the contents of a course.';
$string['coursecontentsintegration_label'] = 'Enable webservice for course content ingestion';
$string['courseids'] = 'Course IDs';
$string['courseids_desc'] = 'Enter courseids as comma-separated values (e.g. 2,3,5).';
$string['enableliveapiintegration'] = 'Enable Live API Integration';
$string['enablelti'] = 'Enable LTI';
$string['enablelti_tooltip'] = 'Please specify Assistant ID to configure LTI';
$string['enterassistantid'] = 'Enter Assistant ID';
$string['entercourseids'] = 'Enter Courseids';
$string['environment'] = 'Environment';
$string['environment_desc'] = 'Always use Production, unless directed otherwise by Learnwise.';
$string['environmentdevelopment'] = 'Development';
$string['environmentproduction'] = 'Production';
$string['environmentsandbox'] = 'Sandbox';
$string['externaltoken'] = 'Token';
$string['floatingbuttonconfig'] = 'Floating Button Configuration';
$string['floatingbuttonconfigdesc'] = 'This allows showing the Learnwise assistant as a floating chat button that opens a small frame on the bottom of the screen.';
$string['gradingdisabled'] = 'Grading disabled';
$string['integration_listpage'] = 'Learnwise Integration';
$string['liveapiintegration'] = 'Live API Integration';
$string['liveapiintegration_desc'] = 'This allows the assistant to dynamically query the Moodle API to get up-to-date information that is user-specific for answering user queries.';
$string['lticonfig'] = 'LTI Configuration';
$string['lticonfig_desc'] = 'This allows configuring the assistant as an LTI application that can be included within course activities.';
$string['lticonfig_note'] = 'Note: It is possible to configure separate assistants for LTI and floating button, although not recommended.';
$string['onlygraded'] = 'graded';
$string['onlysubmitted'] = 'submitted';
$string['permission_list'] = '<p>This will allow the assistant to give you personal questions about your upcoming assignments, announcements, course contents, and much more.</p>';
$string['permission_question'] = '<p>Do you want to allow Learnwise to access your Moodle account?</p>';
$string['pluginname'] = 'Learnwise';
$string['privacy:metadata:local_learnwise_accesstoken'] = 'Information about the access tokens issued to users.';
$string['privacy:metadata:local_learnwise_accesstoken:timeexpiry'] = 'The expiration time of the access token.';
$string['privacy:metadata:local_learnwise_accesstoken:token'] = 'The access token issued to the user.';
$string['privacy:metadata:local_learnwise_authcode'] = 'Information about the authorization codes issued to users.';
$string['privacy:metadata:local_learnwise_authcode:code'] = 'The authorization code issued to the user.';
$string['privacy:metadata:local_learnwise_authcode:timeexpiry'] = 'The expiration time of the authorization code.';
$string['privacy:metadata:local_learnwise_authcode:token'] = 'The token issued to the user.';
$string['privacy:metadata:local_learnwise_refreshtoken'] = 'Information about the refresh tokens issued to users.';
$string['privacy:metadata:local_learnwise_refreshtoken:timeexpiry'] = 'The expiration time of the refresh token.';
$string['privacy:metadata:local_learnwise_refreshtoken:token'] = 'The refresh token issued to the user.';
$string['privacy:metadata:local_learnwise_userauth'] = 'Information about user has granted to an OAuth2 client.';
$string['privacy:metadata:local_learnwise_userauth:clientid'] = 'The ID of the OAuth2 client.';
$string['privacy:metadata:local_learnwise_userauth:userid'] = 'The ID of the user who granted client.';
$string['privacy:request:notexportedsecurity'] = 'Not exported for security reasons';
$string['redirecturl'] = 'Redirect URL';
$string['redirecturl_desc'] = 'Input multiple redirect URL in new lines';
$string['region'] = 'Region';
$string['removelticonfig'] = 'Remove LTI Configuration';
$string['removelticonfig_desc'] = 'Are you sure you want to disable LTI? This will break any existing LTI placements that are currently configured in your courses.';
$string['removelticonfig_no'] = 'Cancel';
$string['removelticonfig_yes'] = 'Remove LTI';
$string['removeltisetup'] = 'Remove LTI Setup';
$string['removetoken'] = 'Remove webservice';
$string['savechanges'] = 'Save changes';
$string['setupltisetup'] = 'Set-up LTI Placements';
$string['setuptoken'] = 'Setup webservice';
$string['showfloatingbutton'] = 'Show floating button';
$string['showfloatingbuttontooltip'] = 'Please specify Assistant ID to enable floating button';
$string['statusdisabled'] = 'Disabled';
$string['statusenabled'] = 'Enabled';
$string['submitted'] = 'Submitted';
$string['toolnotconfigured'] = 'This tool is not configured correctly, please contact your institution';
$string['unsubmitted'] = 'unsubmitted';
