/**
 * LearnWise setup module for managing plugin configuration interface.
 * Handles floating button, LTI integration, web services, and live API settings.
 *
 * @module     local_learnwise/setup
 * @copyright  2025 LearnWise <help@learnwise.ai>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("local_learnwise/setup",[M.cfg.wwwroot+"/local/learnwise/vendorjs/zenorocha/clipboard.min.js","core/str","core/notification","core/fragment","core/config","core/templates"],(function(ClipboardJS,Str,Notification,Fragment,Config,Templates){var state={environment:"sandbox",floatingButtonAssistantId:"",showFloatingButton:!1,ltiAssistantId:"",ltiEnabled:!1,webServicesEnabled:!1,liveApiEnabled:!1,aiAssessmentEnabled:!1,courseIds:""},elements={form:document.getElementById("form1"),floatingButtonAssistantId:document.getElementById("floatingButtonAssistantId"),floatingButtonSwitch:document.getElementById("floatingButtonSwitch"),floatingButtonStatus:document.getElementById("floatingButtonStatus"),floatingButtonSwitchWrapper:document.getElementById("floatingButtonSwitchWrapper"),floatingButtonTooltip:document.getElementById("floatingButtonTooltip"),ltiAssistantId:document.getElementById("ltiAssistantId"),ltiSwitch:document.getElementById("ltiSwitch"),ltiStatus:document.getElementById("ltiStatus"),ltiSwitchWrapper:document.getElementById("ltiSwitchWrapper"),ltiTooltip:document.getElementById("ltiTooltip"),ltiConfig:document.getElementById("ltiConfig"),webServicesSwitch:document.getElementById("webServicesSwitch"),webServicesStatus:document.getElementById("webServicesStatus"),webServicesConfig:document.getElementById("webServicesConfig"),liveApiSwitch:document.getElementById("liveApiSwitch"),liveApiStatus:document.getElementById("liveApiStatus"),liveApiConfig:document.getElementById("liveApiConfig"),ltiRemovalModal:document.getElementById("ltiRemovalModal"),closeLtiModal:document.getElementById("closeLtiModal"),confirmLtiRemoval:document.getElementById("confirmLtiRemoval"),aiAssessmentSwitch:document.getElementById("aiAssessmentSwitch"),aiAssessmentStatus:document.getElementById("aiAssessmentStatus"),courseIds:document.getElementById("courseIds")};function initializeEventListeners(){elements.floatingButtonAssistantId.addEventListener("input",(function(e){state.floatingButtonAssistantId=e.target.value,updateFloatingButtonSwitch()})),elements.ltiAssistantId&&elements.ltiAssistantId.addEventListener("input",(function(e){state.ltiAssistantId=e.target.value,updateLtiSwitch()})),elements.floatingButtonSwitch.addEventListener("click",(function(){canEnableFloatingButton()&&(state.showFloatingButton=!state.showFloatingButton,updateFloatingButtonSwitch())})),elements.webServicesSwitch.addEventListener("click",(function(){state.webServicesEnabled=!state.webServicesEnabled,updateWebServicesSwitch()})),elements.liveApiSwitch.addEventListener("click",(function(){state.liveApiEnabled=!state.liveApiEnabled,updateLiveApiSwitch()})),elements.aiAssessmentSwitch.addEventListener("click",(function(){state.aiAssessmentEnabled=!state.aiAssessmentEnabled,updateAiAssessmentSwitch()})),elements.courseIds.addEventListener("input",(function(e){state.courseIds=e.target.value,function(){var pattern=/^(\d+)(,\d+)*$/,saveBtn=document.getElementById("save-btn"),inputEl=elements.courseIds;if(!(state.courseIds||"").trim())return inputEl.classList.remove("border-danger"),saveBtn.disabled=!1,void(saveBtn.className="save-btn");var isValid=pattern.test(state.courseIds);inputEl.classList.toggle("border-danger",!isValid),saveBtn.disabled=!isValid,saveBtn.className=isValid?"save-btn":"save-btn bg-gray text-dark"}()})),elements.ltiRemovalModal.addEventListener("click",(function(e){e.target===elements.closeLtiModal&&closeLtiModal(),e.target===elements.confirmLtiRemoval&&(state.ltiEnabled=!1,updateLtiSwitch(),closeLtiModal()),e.target===elements.ltiRemovalModal&&closeLtiModal()})),document.querySelectorAll('input[name="environment"]').forEach((function(radio){radio.checked&&(state.environment=radio.value),radio.addEventListener("change",(function(e){e.target.checked&&(state.environment=e.target.value,updateLtiConfig())}))})),elements.ltiSwitch&&elements.ltiSwitch.addEventListener("click",(function(){canEnableLti()&&(state.ltiEnabled?elements.ltiRemovalModal.style.display="flex":(state.ltiEnabled=!0,updateLtiSwitch()))})),new ClipboardJS(".copy-btn").on("success",(function(e){e.clearSelection(),Str.get_string("copied","local_learnwise").then((function(str){return state.showToast?require(["core/toast"],(function(Toast){Toast.add(str)})):alert(str),null})).catch(Notification.exception)}))}function canEnableFloatingButton(){return state.floatingButtonAssistantId.trim().length>0}function canEnableLti(){return state.ltiAssistantId.trim().length>0}function updateFloatingButtonSwitch(){canEnableFloatingButton()?(elements.floatingButtonSwitch.classList.remove("disabled"),elements.floatingButtonSwitchWrapper.style.cursor="pointer",elements.floatingButtonTooltip.style.display="none",state.showFloatingButton?(elements.floatingButtonSwitch.classList.add("active"),Str.get_string("statusenabled","local_learnwise").then((function(str){return elements.floatingButtonStatus.textContent=str,null})).fail(Notification.exception)):(elements.floatingButtonSwitch.classList.remove("active"),Str.get_string("statusdisabled","local_learnwise").then((function(str){return elements.floatingButtonStatus.textContent=str,null})).fail(Notification.exception))):(elements.floatingButtonSwitch.classList.remove("active"),elements.floatingButtonSwitch.classList.add("disabled"),elements.floatingButtonSwitchWrapper.style.cursor="not-allowed",Str.get_string("statusdisabled","local_learnwise").then((function(str){return elements.floatingButtonStatus.textContent=str,null})).fail(Notification.exception),state.showFloatingButton=!1),elements.form.elements.floatingButtonStatus.value=state.showFloatingButton?1:0}function updateLtiConfig(){elements.ltiConfig&&canEnableLti()&&state.ltiEnabled&&Fragment.loadFragment("local_learnwise","process_setup",Config.contextid,{formdata:"enablelti="+(state.ltiEnabled?1:0)+"&assistantid="+encodeURIComponent(elements.ltiAssistantId.value)+"&environment="+encodeURIComponent(state.environment)}).then((function(html,js){return Templates.replaceNodeContents(elements.ltiConfig,html,js),null})).catch(Notification.exception)}function updateLtiSwitch(){elements.ltiAssistantId&&(canEnableLti()?(elements.ltiSwitch.classList.remove("disabled"),elements.ltiSwitchWrapper.style.cursor="pointer",elements.ltiTooltip.style.display="none",state.ltiEnabled?(elements.ltiSwitch.classList.add("active"),Str.get_string("statusenabled","local_learnwise").then((function(str){return elements.ltiStatus.textContent=str,null})).catch(Notification.exception),elements.ltiConfig.style.display="block"):(elements.ltiSwitch.classList.remove("active"),Str.get_string("statusdisabled","local_learnwise").then((function(str){return elements.ltiStatus.textContent=str,null})).catch(Notification.exception),elements.ltiConfig.style.display="none"),updateLtiConfig()):(elements.ltiSwitch.classList.remove("active"),elements.ltiSwitch.classList.add("disabled"),elements.ltiSwitchWrapper.style.cursor="not-allowed",Str.get_string("statusdisabled","local_learnwise").then((function(str){return elements.ltiStatus.textContent=str,null})).catch(Notification.exception),elements.ltiConfig.style.display="none",state.ltiEnabled=!1),elements.form.elements.ltiStatus.value=state.ltiEnabled?1:0)}function updateAiAssessmentSwitch(){state.aiAssessmentEnabled?(elements.aiAssessmentSwitch.classList.add("active"),Str.get_string("statusenabled","local_learnwise").then((function(str){return elements.aiAssessmentStatus.textContent=str,null})).catch(Notification.exception)):(elements.aiAssessmentSwitch.classList.remove("active"),Str.get_string("statusdisabled","local_learnwise").then((function(str){return elements.aiAssessmentStatus.textContent=str,null})).catch(Notification.exception)),elements.form.elements.aiAssessmentStatus.value=state.aiAssessmentEnabled?1:0}function updateWebServicesSwitch(){state.webServicesEnabled?(elements.webServicesSwitch.classList.add("active"),Str.get_string("statusenabled","local_learnwise").then((function(str){return elements.webServicesStatus.textContent=str,null})).catch(Notification.exception),elements.webServicesConfig.style.display="block"):(elements.webServicesSwitch.classList.remove("active"),Str.get_string("statusdisabled","local_learnwise").then((function(str){return elements.webServicesStatus.textContent=str,null})).catch(Notification.exception),elements.webServicesConfig.style.display="none"),Fragment.loadFragment("local_learnwise","process_setup",Config.contextid,{formdata:"enablewebservice="+(state.webServicesEnabled?1:0)}).then((function(html,js){return Templates.replaceNodeContents(elements.webServicesConfig,html,js),null})).catch(Notification.exception),elements.form.elements.webServicesStatus.value=state.webServicesEnabled?1:0}function updateLiveApiSwitch(){state.liveApiEnabled?(elements.liveApiSwitch.classList.add("active"),Str.get_string("statusenabled","local_learnwise").then((function(str){return elements.liveApiStatus.textContent=str,null})).catch(Notification.exception),elements.liveApiConfig.style.display="block"):(elements.liveApiSwitch.classList.remove("active"),Str.get_string("statusdisabled","local_learnwise").then((function(str){return elements.liveApiStatus.textContent=str,null})).catch(Notification.exception),elements.liveApiConfig.style.display="none"),elements.form.elements.liveApiStatus.value=state.liveApiEnabled?1:0}function closeLtiModal(){elements.ltiRemovalModal.style.display="none"}return elements.floatingButtonAssistantId&&(state.floatingButtonAssistantId=elements.floatingButtonAssistantId.value),elements.ltiAssistantId&&(state.ltiAssistantId=elements.ltiAssistantId.value),elements.floatingButtonStatus&&(state.showFloatingButton=1===parseInt(elements.form.elements.floatingButtonStatus.value)),elements.ltiStatus&&(state.ltiEnabled=1===parseInt(elements.form.elements.ltiStatus.value)),elements.webServicesStatus&&(state.webServicesEnabled=1===parseInt(elements.form.elements.webServicesStatus.value)),elements.liveApiStatus&&(state.liveApiEnabled=1===parseInt(elements.form.elements.liveApiStatus.value)),elements.aiAssessmentStatus&&(state.aiAssessmentEnabled=1===parseInt(elements.form.elements.aiAssessmentStatus.value)),elements.courseIds&&(state.courseIds=elements.courseIds.value),{init:function(showToast){state.showToast=showToast,initializeEventListeners(),updateFloatingButtonSwitch(),updateLtiSwitch(),updateWebServicesSwitch(),updateLiveApiSwitch(),updateAiAssessmentSwitch()}}}));

//# sourceMappingURL=setup.min.js.map