# Privacy Policy for Alphabees Moodle Plugin  

## Introduction  

The **Alphabees Moodle Plugin** enhances Moodle with AI-powered functionalities while maintaining a strong commitment to data protection and user privacy. We strictly comply with GDPR and other relevant data protection regulations, ensuring that all data is processed securely and transparently.  

---

## Data Collection  

- **No Personal Data**:  
  - We do not collect or store Moodle user IDs or any other personal information about users.  
  - The plugin processes chat history on a session basis using a non-personal session ID, which is deleted after the session ends.  

- **Chat History**:  
  - Chat interactions are processed temporarily during the session to provide AI-powered responses.  
  - No chat history or user-specific data is stored permanently.  

---

## Data Storage and Transmission  

- **Encrypted Data**:  
  - Data at rest is encrypted using **AES-256** encryption.  
  - Data in transit is encrypted using **TLS 1.2+** to ensure secure communication.  

- **Server Locations**:  
  - Our servers are hosted by **Contabo GmbH** in Munich and operate exclusively within German or European data centers.  
  - We comply fully with GDPR requirements, ensuring data protection and security.  

- **No AI Training**:  
  - Client data, including chat interactions and uploaded files, is not used to train AI models.  

- **Data Processing Agreements**:  
  - We maintain data processing agreements with Contabo GmbH to ensure compliance with GDPR and other applicable regulations.  

---

## User Rights  

We adhere to GDPR principles, ensuring users and administrators have full control over their data.  

- **Transparency**:  
  - We clearly inform users about what data is processed and how it is handled.  

- **Access and Deletion**:  
  - Since no personal data is stored, there is no need for access or deletion requests.  
  - Chat history and session data are deleted immediately after the session ends.  

---

## External Services  

The Alphabees Moodle Plugin interacts with external AI services through secure, encrypted connections to provide tutoring functionalities.  

- **Data Minimization**:  
  - Only non-personal session data is temporarily processed to provide AI responses.  
  - No personal or identifiable information is transmitted to external services.  

- **Consent**:  
  - Admins configure and control the plugin to ensure compliance with their institution’s data protection policies.  

---

## Security  

We implement industry-standard measures to ensure data security:  

- **Data Encryption**:  
  - All data at rest is encrypted with **AES-256**.  
  - Data in transit is encrypted with **TLS 1.2+**.  

- **Access Control**:  
  - Only authorized personnel can access plugin configurations and server data.  

---

## Compliance  

- We strictly comply with GDPR and all relevant European data protection regulations.  
- Our servers are hosted exclusively in Europe, ensuring data sovereignty.  

---

## Contact  

For privacy-related inquiries or concerns, please contact us at:  
- **Email**: [support@alphabees.de](mailto:support@alphabees.de)  

---

This privacy policy reflects our commitment to protecting user privacy and maintaining compliance with GDPR. No personal or user-specific data is stored or used in any way beyond the immediate functionality of the plugin.  
