define("mod_learninggoalwidget/form_settings",["exports","jquery","core/templates","core/modal_save_cancel","core/modal_events","core/str"],(function(_exports,_jquery,_templates,_modal_save_cancel,_modal_events,CoreStr){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * @copyright  University of Technology Graz
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
/**
   * Javascript to initialise the Learning Goals Widget.
   *
   * @copyright  University of Technology Graz
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_templates=_interopRequireDefault(_templates),_modal_save_cancel=_interopRequireDefault(_modal_save_cancel),_modal_events=_interopRequireDefault(_modal_events),CoreStr=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(CoreStr);var TEMPLATES_GOAL_MODAL_VIEW="mod_learninggoalwidget/editor/goalmodalview",TEMPLATES_TOPIC_MODAL_VIEW="mod_learninggoalwidget/editor/topicmodalview",TEMPLATES_TOPIC="mod_learninggoalwidget/editor/topic",TEMPLATES_GOAL="mod_learninggoalwidget/editor/goal",MODAL_ITEM_SELECTORS_ITEM_TITLE_FIELD='[data-action="itemtitle"]',MODAL_ITEM_SELECTORS_ITEM_SHORTNAME_FIELD='[data-action="itemshortname"]',MODAL_ITEM_SELECTORS_ITEM_URL_FIELD='[data-action="itemurl"]';var taxonomy=null,selectedTopic=null,selectedTopicElement=null;const loadTopics=async()=>{(0,_jquery.default)("#topics-list").children().remove(),taxonomy.children.sort(((a,b)=>a.ranking-b.ranking));let nTopics=0;for(let topic of taxonomy.children){if("deleted"in topic&&topic.deleted)continue;nTopics++;const topicContext={topicname:topic.name,topicid:topic.topicid},html=await _templates.default.render(TEMPLATES_TOPIC,topicContext);(0,_jquery.default)("#notopics").addClass("d-none"),(0,_jquery.default)("#topics-list").append(html);const topicid=topic.topicid;(0,_jquery.default)("#topic-item-"+topicid).click(clickedTopicName);const baseID="#".concat(topicid,"-action-");(0,_jquery.default)(baseID+"edit").click(clickedEditTopic),(0,_jquery.default)(baseID+"delete").click(clickedDeleteTopic),(0,_jquery.default)(baseID+"moveup").click(clickedMoveupTopic),(0,_jquery.default)(baseID+"movedown").click(clickedMovedownTopic)}if(0===nTopics&&(0,_jquery.default)("#notopics").removeClass("d-none"),!selectedTopic||-1==selectedTopic){const showGoalStr=await CoreStr.get_string("settings:showgoals","mod_learninggoalwidget");return(0,_jquery.default)("#learninggoals-list").children().remove(),(0,_jquery.default)("#goalsfortopic").removeClass("d-none"),void(0,_jquery.default)("#goalsfortopicstatusmessage").html(showGoalStr)}const selectedTopicObj=getTopicById(selectedTopic);(selectedTopicElement=document.querySelector("#topic-item-".concat(selectedTopic))).style.backgroundColor="gainsboro",loadGoals(selectedTopicObj)},loadGoals=async topic=>{(0,_jquery.default)("#learninggoals-list").children().remove(),topic.children.sort(((a,b)=>a.ranking-b.ranking)),(0,_jquery.default)("#goalsfortopic").addClass("d-none");const topicid=topic.topicid;let nGoals=0;for(let goal of topic.children){if("deleted"in goal&&goal.deleted)continue;nGoals++;const goalid=goal.goalid;var goalContext={topicid:topicid,goalid:goalid,learninggoaltitle:goal.name};const html=await _templates.default.render(TEMPLATES_GOAL,goalContext);(0,_jquery.default)("#learninggoals-list").append(html);const baseID="#".concat(topicid,"-goal-").concat(goalid,"-action-");(0,_jquery.default)(baseID+"edit").click(clickedEditGoal),(0,_jquery.default)(baseID+"delete").click(clickedDeleteGoal),(0,_jquery.default)(baseID+"moveup").click(clickedMoveupGoal),(0,_jquery.default)(baseID+"movedown").click(clickedMovedownGoal)}if(!nGoals){const noGoalStr=await CoreStr.get_string("settings:nogoals","mod_learninggoalwidget");return(0,_jquery.default)("#goalsfortopic").removeClass("d-none"),void(0,_jquery.default)("#goalsfortopicstatusmessage").html(noGoalStr)}},clickedTopicName=e=>{e.preventDefault();var topicId=(0,_jquery.default)(e.currentTarget).data("topicid");let topic=getTopicById(topicId);topic&&(loadGoals(topic),selectedTopic=topicId,null!==selectedTopicElement&&(selectedTopicElement.style.backgroundColor="white"),(selectedTopicElement=e.currentTarget).style.backgroundColor="gainsboro")},clickedNewTopic=async()=>{let strings=[{key:"settings:topic",component:"mod_learninggoalwidget"},{key:"settings:description",component:"mod_learninggoalwidget"},{key:"settings:addtopic",component:"mod_learninggoalwidget"},{key:"settings:url",component:"mod_learninggoalwidget"},{key:"settings:save",component:"mod_learninggoalwidget"}];try{const results=await CoreStr.get_strings(strings),context={title:results[0],shortname:results[1],weburl:results[3]};let[modal,topicName,topicShortname,topicUrl]=await showModal(context,results[2],TEMPLATES_TOPIC_MODAL_VIEW,results[4]);modal.hide(),addLocalTopic(topicName,topicShortname,topicUrl),updateTaxonomyValue(),loadTopics()}catch(e){}},clickedEditTopic=async e=>{e.preventDefault();var topicid=(0,_jquery.default)(e.currentTarget).data("topicid");let topic=getTopicById(topicid);if(!topic)return;const oldTopicTitle=topic.name,oldTopicShortname=topic.shortname,oldTopicUrl=topic.url;let strings=[{key:"settings:topic",component:"mod_learninggoalwidget"},{key:"settings:description",component:"mod_learninggoalwidget"},{key:"settings:edittopic",component:"mod_learninggoalwidget"},{key:"settings:url",component:"mod_learninggoalwidget"},{key:"settings:save",component:"mod_learninggoalwidget"}];try{const results=await CoreStr.get_strings(strings);var context={title:results[0],shortname:results[1],weburl:results[3],topictitle:oldTopicTitle,topicshortname:oldTopicShortname,topicurl:oldTopicUrl};const[modal,topicName,topicShortname,topicUrl]=await showModal(context,results[2],TEMPLATES_TOPIC_MODAL_VIEW,results[4]);modal.hide();updateLocalTopic(topic,{name:topicName,shortname:topicShortname,url:topicUrl}),updateTaxonomyValue(),loadTopics()}catch(e){}},clickedDeleteTopic=async e=>{e.preventDefault();const topicid=(0,_jquery.default)(e.currentTarget).data("topicid");let topicToDelete=getTopicById(topicid);if(!topicToDelete)return;let strings=[{key:"settings:deletetopic",component:"mod_learninggoalwidget"},{key:"settings:deletetopicmsg",component:"mod_learninggoalwidget"},{key:"settings:delete",component:"mod_learninggoalwidget"}];try{const results=await CoreStr.get_strings(strings);(await showMessage(results[0],results[1],results[2])).hide();let newSelectedTopicId=-1,newSelectedTopicRanking=-1;for(let i=taxonomy.children.length-1;i>=0;i--){const topic=taxonomy.children[i];"deleted"in topic||topic.deleted||topic.topicid===topicToDelete.topicid||(newSelectedTopicRanking<topicToDelete.ranking&&topic.ranking<newSelectedTopicRanking&&-1!==newSelectedTopicRanking||topic.ranking>newSelectedTopicRanking&&-1!==newSelectedTopicRanking||(newSelectedTopicId=topic.topicid,newSelectedTopicRanking=topic.ranking))}deleteLocalTopic(topicToDelete),updateTaxonomyValue(),selectedTopic=newSelectedTopicId,loadTopics()}catch(e){}},clickedMoveupTopic=e=>{e.preventDefault();var topicid=(0,_jquery.default)(e.currentTarget).data("topicid");let topicToMove=getTopicById(topicid);if(topicToMove&&1!=topicToMove.ranking){for(let topic of taxonomy.children)if(topic.ranking===topicToMove.ranking-1){updateLocalTopic(topic,{ranking:topic.ranking+1}),updateLocalTopic(topicToMove,{ranking:topicToMove.ranking-1});break}updateTaxonomyValue(),loadTopics()}},clickedMovedownTopic=e=>{e.preventDefault();var topicid=(0,_jquery.default)(e.currentTarget).data("topicid");let topicToMove=getTopicById(topicid);if(topicToMove){for(let topic of taxonomy.children)if(topic.ranking===topicToMove.ranking+1){updateLocalTopic(topic,{ranking:topic.ranking-1}),updateLocalTopic(topicToMove,{ranking:topicToMove.ranking+1});break}updateTaxonomyValue(),loadTopics()}},clickedNewGoal=async()=>{if(null===selectedTopic)return;const topic=getTopicById(selectedTopic);if(!topic)return;const topicTitle=topic.name;let strings=[{key:"settings:topic",component:"mod_learninggoalwidget"},{key:"settings:goal",component:"mod_learninggoalwidget"},{key:"settings:description",component:"mod_learninggoalwidget"},{key:"settings:url",component:"mod_learninggoalwidget"},{key:"settings:addgoal",component:"mod_learninggoalwidget"},{key:"settings:save",component:"mod_learninggoalwidget"}];try{const results=await CoreStr.get_strings(strings),context={topiclabel:results[0],title:results[1],shortname:results[2],weburl:results[3],topictitle:topicTitle},[modal,goalName,goalShortname,goalUrl]=await showModal(context,results[4],TEMPLATES_GOAL_MODAL_VIEW,results[5]);modal.hide(),addLocalGoal(topic,goalName,goalShortname,goalUrl),updateTaxonomyValue(),loadGoals(topic)}catch(e){}},clickedEditGoal=async e=>{e.preventDefault();var topicid=(0,_jquery.default)(e.currentTarget).data("topicid"),goalid=(0,_jquery.default)(e.currentTarget).data("goalid");const topic=getTopicById(topicid),goal=getGoalById(goalid,topic);if(!topic||!goal)return;const topicTitle=topic.name,oldGoalTitle=goal.name,oldGoalShortname=goal.shortname,oldGoalUrl=goal.url;let strings=[{key:"settings:topic",component:"mod_learninggoalwidget"},{key:"settings:goal",component:"mod_learninggoalwidget"},{key:"settings:description",component:"mod_learninggoalwidget"},{key:"settings:url",component:"mod_learninggoalwidget"},{key:"settings:editgoal",component:"mod_learninggoalwidget"},{key:"settings:save",component:"mod_learninggoalwidget"}];try{const results=await CoreStr.get_strings(strings),context={topiclabel:results[0],topictitle:topicTitle,title:results[1],shortname:results[2],weburl:results[3],goaltitle:oldGoalTitle,goalshortname:oldGoalShortname,goalurl:oldGoalUrl},[modal,goalName,goalShortname,goalUrl]=await showModal(context,results[4],TEMPLATES_GOAL_MODAL_VIEW,results[5]);modal.hide();updateLocalGoal(goal,{name:goalName,shortname:goalShortname,url:goalUrl}),updateTaxonomyValue(),loadGoals(topic)}catch(e){}},clickedDeleteGoal=async e=>{e.preventDefault();const topicid=(0,_jquery.default)(e.currentTarget).data("topicid"),goalid=(0,_jquery.default)(e.currentTarget).data("goalid"),topic=getTopicById(topicid),goalToDelete=getGoalById(goalid,topic);if(!topic||!goalToDelete)return;let strings=[{key:"settings:deletegoal",component:"mod_learninggoalwidget"},{key:"settings:deletegoalmsg",component:"mod_learninggoalwidget"},{key:"settings:delete",component:"mod_learninggoalwidget"}];try{const results=await CoreStr.get_strings(strings);(await showMessage(results[0],results[1],results[2])).hide(),deleteLocalGoal(goalToDelete,topic,!0),updateTaxonomyValue(),loadGoals(topic)}catch(e){}},clickedMoveupGoal=e=>{e.preventDefault();const topicid=(0,_jquery.default)(e.currentTarget).data("topicid"),goalid=(0,_jquery.default)(e.currentTarget).data("goalid"),topic=getTopicById(topicid),goalToMove=getGoalById(goalid,topic);if(topic&&goalToMove&&1!=goalToMove.ranking){for(let goal of topic.children)if(goal.ranking===goalToMove.ranking-1){updateLocalGoal(goal,{ranking:goal.ranking+1}),updateLocalGoal(goalToMove,{ranking:goalToMove.ranking-1});break}updateTaxonomyValue(),loadGoals(topic)}},clickedMovedownGoal=e=>{e.preventDefault();const topicid=(0,_jquery.default)(e.currentTarget).data("topicid"),goalid=(0,_jquery.default)(e.currentTarget).data("goalid"),topic=getTopicById(topicid),goalToMove=getGoalById(goalid,topic);if(topic&&goalToMove){for(let goal of topic.children)if(goal.ranking===goalToMove.ranking+1){updateLocalGoal(goal,{ranking:goal.ranking-1}),updateLocalGoal(goalToMove,{ranking:goalToMove.ranking+1});break}updateTaxonomyValue(),loadGoals(topic)}},showModal=async(context,title,templateName,btnSaveText)=>{const results=await CoreStr.get_strings([{key:"validation:missingtitle",component:"mod_learninggoalwidget"},{key:"validation:invalidurl",component:"mod_learninggoalwidget"}]),modal=await _modal_save_cancel.default.create({title:title,body:_templates.default.render(templateName,context)});return modal.setSaveButtonText(btnSaveText),modal.show(),modal.getRoot().on(_modal_events.default.hidden,(()=>{modal.destroy()})),new Promise(((resolve,reject)=>modal.getRoot().on(_modal_events.default.save,(event=>{var titleInputfield=modal.getRoot().find(MODAL_ITEM_SELECTORS_ITEM_TITLE_FIELD),shortnameInputfield=modal.getRoot().find(MODAL_ITEM_SELECTORS_ITEM_SHORTNAME_FIELD),urlInputfield=modal.getRoot().find(MODAL_ITEM_SELECTORS_ITEM_URL_FIELD);let titleValid=!1,urlValid=!1;void 0!==titleInputfield[0].value&&""!==titleInputfield[0].value&&(titleValid=!0),isValidUrl(urlInputfield[0].value)&&(urlValid=!0),titleValid&&urlValid?resolve([modal,titleInputfield[0].value,shortnameInputfield[0].value,urlInputfield[0].value]):(event.preventDefault(),event.stopPropagation(),!1===titleValid&&(modal.getRoot().find('[data-action="titlefeedback"]').text(results[0]),modal.getRoot().find('[data-action="titlefeedback"]').css("display","inline"),reject("Title invalid")),!1===urlValid&&(modal.getRoot().find('[data-action="urlfeedback"]').text(results[1]),modal.getRoot().find('[data-action="urlfeedback"]').css("display","inline"),reject("Url invalid")))}))))},showMessage=async(title,text,btnSaveText)=>{const modal=await _modal_save_cancel.default.create({title:title,body:text});return modal.setSaveButtonText(btnSaveText),modal.getRoot().on(_modal_events.default.hidden,(()=>{modal.destroy()})),modal.show(),new Promise((resolve=>modal.getRoot().on(_modal_events.default.save,(()=>resolve(modal)))))},isValidUrl=urlString=>{if(null===urlString||""==urlString)return!0;let isValid=!1,regex=new RegExp(/https?:\/\/(www\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\.[a-zA-Z0-9()]{1,6}\b([-a-zA-Z0-9()@:%_+.~#?&//=]*)?/gi);return urlString.match(regex)&&(isValid=!0),isValid},isValidTopicJSON=topic=>{if(!("name"in topic)||null===topic.name||void 0===topic.name)return{error:!0,code:"validation:jsontopic1",codeParam:void 0};if("string"!=typeof topic.name)return{error:!0,code:"validation:jsontopic2",codeParam:topic.name};if("url"in topic){if("string"!=typeof topic.url)return{error:!0,code:"validation:jsontopic3",codeParam:topic.name};if(!isValidUrl(topic.url))return{error:!0,code:"validation:jsontopic4",codeParam:topic.name}}else{if("shortname"in topic&&"string"!=typeof topic.shortname)return{error:!0,code:"validation:jsontopic5",codeParam:topic.name};if(!("children"in topic)||null===topic.children||void 0===topic.children)return{error:!1};if(!Array.isArray(topic.children))return{error:!0,code:"validation:jsontopic6",codeParam:topic.name}}return{error:!1}},isValidGoalJSON=(topicName,goal)=>{if(!("name"in goal)||null===goal.name||void 0===goal.name)return{error:!0,code:"validation:jsongoal1",codeParam:topicName};if("string"!=typeof goal.name)return{error:!0,code:"validation:jsongoal2",codeParam:topicName};if("url"in goal){if("string"!=typeof goal.url)return{error:!0,code:"validation:jsongoal3",codeParam:goal.name};if(!isValidUrl(goal.url))return{error:!0,code:"validation:jsongoal4",codeParam:goal.name}}else if("shortname"in goal&&"string"!=typeof goal.shortname)return{error:!0,code:"validation:jsongoal5",codeParam:goal.name};return{error:!1}},parseJSON=async json=>{const res=(json=>"name"in json&&null!==json.name&&void 0!==json.name?"children"in json&&null!==json.children&&void 0!==json.children?Array.isArray(json.children)?0===json.children.length?{error:!0,code:"validation:jsontop4"}:{error:!1}:{error:!0,code:"validation:jsontop3"}:{error:!0,code:"validation:jsontop2"}:{error:!0,code:"validation:jsontop1"})(json);if(res.error)return res.msg=await CoreStr.get_string(res.code,"mod_learninggoalwidget"),res;let preview="<pre>";for(let topicIdx=0;topicIdx<json.children.length;topicIdx++){const topic=json.children[topicIdx],check=isValidTopicJSON(topic);if(check.error)return check.msg=await CoreStr.get_string(check.code,"mod_learninggoalwidget",check.codeParam),check;preview+="".concat(topic.name.replaceAll("&","&amp").replaceAll("<","&lt").replaceAll(">","&gt"),"\n");for(let goalIdx=0;goalIdx<topic.children.length;goalIdx++){const goal=topic.children[goalIdx],goalCheck=isValidGoalJSON(topic.name,goal);if(goalCheck.error)return goalCheck.msg=await CoreStr.get_string(goalCheck.code,"mod_learninggoalwidget",goalCheck.codeParam),goalCheck;let isLast=goalIdx==topic.children.length-1;preview+=" |- ".concat(goal.name.replaceAll("&","&amp").replaceAll("<","&lt").replaceAll(">","&gt"),"\n").concat(isLast?"\n\n":"\n")}}return preview+="</pre>",{error:!1,preview:preview}},clickedJSONUpload=()=>{const fileInput=document.querySelector("#json-file");if(0===fileInput.files.length)return;const reader=new FileReader;reader.readAsText(fileInput.files[0],"UTF-8"),reader.onload=async evt=>{if(null!==evt.target)try{const parsed=JSON.parse(reader.result),check=await parseJSON(parsed);let strings=[{key:"validation:invalid",component:"mod_learninggoalwidget"},{key:"validation:invalidfile",component:"mod_learninggoalwidget"},{key:"validation:close",component:"mod_learninggoalwidget"},{key:"settings:newtaxonomyheader",component:"mod_learninggoalwidget"},{key:"settings:newtaxonomymsg",component:"mod_learninggoalwidget"},{key:"settings:replace",component:"mod_learninggoalwidget"}];const results=await CoreStr.get_strings(strings);if(check.error){return void(await showMessage(results[0],results[1]+":<br/>"+check.msg,results[2])).hide()}(await showMessage(results[3],results[4]+"\n"+check.preview,results[5])).hide(),taxonomy.children.forEach((topic=>{topic.children.forEach((goal=>{deleteLocalGoal(goal,topic,!1)})),deleteLocalTopic(topic,!1)})),(0,_jquery.default)("#topics-list").children().remove(),(0,_jquery.default)("#learninggoals-list").children().remove(),parsed.children.forEach((topic=>{const addedTopic=addLocalTopic(topic.name,topic.shortname,topic.url);topic.children.forEach((goal=>{addLocalGoal(addedTopic,goal.name,goal.shortname,goal.url)}))})),updateTaxonomyValue(),document.querySelector("input[name='name']").value=parsed.name,selectedTopic=null,selectedTopicElement=null,loadTopics()}catch(e){}}},clickedJSONDownload=async()=>{const jsonTaxonomy=JSON.parse(document.querySelector("input[name='taxonomy']").value);let newTaxonomy={name:document.querySelector("input[name='name']").value,children:[]};jsonTaxonomy.children.sort(((a,b)=>a.ranking-b.ranking)),jsonTaxonomy.children.forEach((topic=>{var _topic$name,_topic$shortname,_topic$url;if("deleted"in topic&&topic.deleted)return;let goals=[],topicObj={name:null!==(_topic$name=topic.name)&&void 0!==_topic$name?_topic$name:"",shortname:null!==(_topic$shortname=topic.shortname)&&void 0!==_topic$shortname?_topic$shortname:"",url:null!==(_topic$url=topic.url)&&void 0!==_topic$url?_topic$url:""};"children"in topic&&(topic.children.sort(((a,b)=>a.ranking-b.ranking)),topic.children.forEach((goal=>{var _goal$name,_goal$shortname,_goal$url;"deleted"in goal&&goal.deleted||goals.push({name:null!==(_goal$name=goal.name)&&void 0!==_goal$name?_goal$name:"",shortname:null!==(_goal$shortname=goal.shortname)&&void 0!==_goal$shortname?_goal$shortname:"",url:null!==(_goal$url=goal.url)&&void 0!==_goal$url?_goal$url:""})}))),topicObj.children=goals,newTaxonomy.children.push(topicObj)}));const blob=new Blob([JSON.stringify(newTaxonomy,null,2)],{type:"text/csv"});window.navigator.msSaveOrOpenBlob&&window.navigator.msSaveBlob(blob,"taxonomy.json");const element=document.createElement("a");element.setAttribute("href",window.URL.createObjectURL(blob)),element.setAttribute("download","taxonomy.json"),element.style.display="none",document.body.appendChild(element),element.click(),document.body.removeChild(element)},clickedJSONDownloadTemplate=async()=>{const blob=new Blob([JSON.stringify({name:"Learning Goal's taxonomy",children:[{name:"Topic 1 Name",shortname:"Topic 1 Shortname",url:"https://example.com",children:[{name:"Learning Goal 1 of Topic 1",shortname:"Goal 1 Shortname",url:"https://example.com"},{name:"Learning Goal 2 of Topic 1",shortname:"Goal 2 Shortname",url:"https://example.com"}]},{name:"Topic 2 Name",shortname:"Topic 2 Shortname",url:"https://example.com",children:[{name:"Learning Goal 1 of Topic 2",shortname:"Goal 1 Shortname",url:"https://example.com"},{name:"Learning Goal 2 of Topic 2",shortname:"Goal 2 Shortname",url:"https://example.com"}]}]},null,2)],{type:"text/csv"});window.navigator.msSaveOrOpenBlob&&window.navigator.msSaveBlob(blob,"taxonomy.json");const element=document.createElement("a");element.setAttribute("href",window.URL.createObjectURL(blob)),element.setAttribute("download","taxonomy.json"),element.style.display="none",document.body.appendChild(element),element.click(),document.body.removeChild(element)},getTopicById=topicid=>{for(let topic of taxonomy.children)if(topic.topicid==topicid)return topic;return null},getNextTopicRanking=()=>{let ranking=0;return taxonomy.children.forEach((topic=>{ranking=Math.max(topic.ranking,ranking)})),ranking+1},getNextTopicId=()=>{let id=0;return taxonomy.children.forEach((topic=>{id=Math.max(topic.topicid,id)})),id+1},getGoalById=function(goalid){let topic=arguments.length>1&&void 0!==arguments[1]?arguments[1]:void 0;if(topic){for(let goal of topic.children)if(goal.goalid==goalid)return goal;return null}for(let topic of taxonomy.children)for(let goal of topic.children)if(goal.goalid==goalid)return goal;return null},getNextGoalRanking=topic=>{let ranking=0;return topic.children.forEach((goal=>{ranking=Math.max(goal.ranking,ranking)})),ranking+1},getNextGoalId=()=>{let id=0;return taxonomy.children.forEach((topic=>{topic.children.forEach((goal=>{id=Math.max(goal.goalid,id)}))})),id+1},addLocalTopic=(name,shortname,url)=>{let newTopic={name:null!=name?name:"",shortname:null!=shortname?shortname:"",url:null!=url?url:"",ranking:getNextTopicRanking(),topicid:getNextTopicId(),children:[],type:"topic",new:!0};return taxonomy.children.push(newTopic),newTopic},updateLocalTopic=(topic,update)=>{Object.keys(update).forEach((key=>{topic[key]=update[key]})),topic.edit=!0},deleteLocalTopic=(topicToDelete,reorder)=>{reorder&&taxonomy.children.forEach((topic=>{topic.ranking>topicToDelete.ranking&&(topic.ranking--,topic.edit=!0)})),topicToDelete.deleted=!0,topicToDelete.ranking=-1},addLocalGoal=(topic,name,shortname,url)=>{let newGoal={name:null!=name?name:"",shortname:null!=shortname?shortname:"",url:null!=url?url:"",ranking:getNextGoalRanking(topic),goalid:getNextGoalId(),type:"goal",new:!0};return topic.children.push(newGoal),newGoal},updateLocalGoal=(goal,update)=>{Object.keys(update).forEach((key=>{goal[key]=update[key]})),goal.edit=!0},deleteLocalGoal=(goalToDelete,topic,reorder)=>{reorder&&topic.children.forEach((goal=>{goal.ranking>goalToDelete.ranking&&(goal.ranking--,goal.edit=!0)})),goalToDelete.deleted=!0,goalToDelete.ranking=-1},updateTaxonomyValue=()=>{document.querySelector("input[name='taxonomy']").value=JSON.stringify(taxonomy)};var _default={init:()=>{taxonomy=JSON.parse(document.querySelector("input[name='taxonomy']").value),loadTopics(),(0,_jquery.default)("#newtopic").click(clickedNewTopic),(0,_jquery.default)("#newgoal").click(clickedNewGoal),(0,_jquery.default)("#json-upload").click(clickedJSONUpload),(0,_jquery.default)("#json-download").click(clickedJSONDownload),(0,_jquery.default)("#json-download-template").click(clickedJSONDownloadTemplate)}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=form_settings.min.js.map