define("mod_learninggoalwidget/treemap_main",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;let d3=null;const U_ELLIPSIS="&#"+8230..toString()+";";let widgetTitle="",data=null,treemapId=null,treemapaccessibilitytext=null,taxonomy=null,isStudent=!1,updateProgressCallback=null,highlightedGoals=null,confirmationBoxesActive=null;async function getSvgNode(){var _rectWidth;let clientWidth=document.getElementById(treemapId).clientWidth,width=clientWidth;if(0===width)return;const stdHeight=.9*window.innerHeight;let height=stdHeight;height=600;let isLandscapeMode=width>height,isSmallScreen=clientWidth<1100,hasTouchscreen=function(){let hasTouchScreen=!1;if("maxTouchPoints"in navigator)hasTouchScreen=navigator.maxTouchPoints>0;else if("msMaxTouchPoints"in navigator)hasTouchScreen=navigator.msMaxTouchPoints>0;else{let mQ=window.matchMedia&&matchMedia("(pointer:coarse)");mQ&&"(pointer:coarse)"===mQ.media?hasTouchScreen=!!mQ.matches:"orientation"in window&&(hasTouchScreen=!0)}return hasTouchScreen}();let colorSchemesNames=["Rainbow","Plasma","Warm","Cool","Reds","Greens","Blues","RdBu","RdGy","protanopia","grayscaleLight","PuOr","deuteranopia","grayscaleDark","grayscaleMiddle"],additionalColors={protanopia:["#D1D0DE","#BDB6AB","#636D97"],deuteranopia:["#C59434","#6F7498","#092C48"],grayscaleLight:["#ddd","#eaeaea"],grayscaleDark:["#050505","#030303"],grayscaleMiddle:["#ddd","#030303"]},colorblindSchemes=["PuOr","deuteranopia","grayscaleDark","grayscaleMiddle"],color=d3.scaleOrdinal(d3.quantize(function(){let savedColorschemes=localStorage.getItem("treemapColorscheme"),name="";if(savedColorschemes)try{savedColorschemes=JSON.parse(savedColorschemes),treemapId in savedColorschemes&&colorSchemesNames.includes(savedColorschemes[treemapId])||(savedColorschemes[treemapId]="Rainbow",localStorage.setItem("treemapColorscheme",JSON.stringify(savedColorschemes))),name=savedColorschemes[treemapId]}catch(e){name="Rainbow"}else{name="Rainbow";let newObj={};newObj[treemapId]=name,localStorage.setItem("treemapColorscheme",JSON.stringify(newObj))}let interpolate=null;interpolate=name in additionalColors?d3.interpolateRgbBasis(additionalColors[name]):d3["interpolate".concat(name)];return interpolate}(),data.children.length+2)),isZoomedIn=!1,zooming=!1,urlEnlarged=!1,resizingUrl=!1,currentTextZoom=0,zoomDelta=isSmallScreen?.5:2,isZoomInDisabled=!1,allElementSmallEnough=!0,{numberOfTopics:numberOfTopics,highestNumberChildren:highestNumberChildren}=function(data){var _data$children$length;const numberOfTopics=null!==(_data$children$length=data.children.length)&&void 0!==_data$children$length?_data$children$length:0;let highestNumberChildren=0;if(0===numberOfTopics)return{numberOfTopics:numberOfTopics,highestNumberChildren:highestNumberChildren};return data.children.forEach((child=>{child.children.length>highestNumberChildren&&(highestNumberChildren=child.children.length)})),highestNumberChildren+=1,{numberOfTopics:numberOfTopics,highestNumberChildren:highestNumberChildren}}(data);height=Math.max(numberOfTopics*(highestNumberChildren-1)*26,stdHeight);const root=(data=>{const root=d3.hierarchy(data).each((d=>{d.children&&!d.children[0].children&&d.children.forEach((child=>{child.siblingsCount=d.children.length}))})).sum((d=>d.children?highestNumberChildren-d.children.length:1));return root.value=highestNumberChildren*root.children.length,d3.partition().size([height,(root.height+1)*width/3]).padding(.7)(root)})(taxonomy);widgetTitle=root.data.name;const svg=d3.create("svg:svg").attr("aria-labelledby","vis-title").attr("class","mainSvg").style("z-index",0).attr("viewBox",[0,0,width,height]);d3.select("#"+treemapId).style("position","relative"),d3.select("#"+treemapId).style("width","100%"),d3.select("#"+treemapId).append((()=>svg.node())),svg.append("title").classed("vis-title",!0),function(svg){let gradient=svg.append("svg:defs").append("svg:linearGradient").attr("id","gradient-"+treemapId).attr("x1","0%").attr("y1","0%").attr("x2","100%").attr("y2","100%");gradient.append("svg:stop").style("offset","0%").style("stop-color","#eee"),gradient.append("svg:stop").style("offset","100%").style("stop-color","#ddd")}(svg);let tempEl=svg.append("text").text("100%"),tempElLen=d3.select(d3.select(tempEl).node()._groups[0]).node()[0].getComputedTextLength(),mainCircleRadius=Math.min(Math.max(rectHeight(root.children[0])/6,2*tempElLen/3),Math.min(30,rectHeight(root.children[0])/2.5));tempEl.remove();let topicCellPadding=.5*mainCircleRadius,mainCircleWidth=2*mainCircleRadius,subCircleRadius=.8*mainCircleRadius,subCircleWidth=2*subCircleRadius,lastY=function(root,highestNumberChildren){let rootWidthReduction=7;root.y1/=rootWidthReduction,root.y1-root.y0>50&&(root.y1=root.y0+50);let learningGoalPadding=.5,lastY=0;return root.each((d=>{if(0!==d.depth)if(1===d.depth){let tempY0=d.y0;d.y0=root.y1+.7,d.y1-=tempY0-d.y0,d.y1-d.y0>300&&(d.y1=d.y0+300),d.tabindex=(5*d.value+1)*d.parent.children.indexOf(d)+2}else{d.y0=d.parent.y1+.7,d.y1-=300;rectWidth(d)<=0&&(d.y1=d.y0+1);const blockSize=(d.parent.x1-d.parent.x0-learningGoalPadding*(d.siblingsCount-1))/d.siblingsCount;let idx=d.parent.children.indexOf(d);d.x0=d.parent.x0+idx*blockSize+learningGoalPadding*idx,d.x1=d.x0+blockSize,d.proY0=d.y1-d.y0,d.proY1=d.proY0+(d.parent.x1-d.parent.x0-learningGoalPadding*(d.siblingsCount-1))/highestNumberChildren,d.proX0=(d.x1-d.x0-(d.proY1-d.proY0))/2,d.proX1=d.proX0+(d.proY1-d.proY0),lastY=d.y1+d.proY1-d.proY0}else d.x1+=.1})),lastY}(root,highestNumberChildren),depth1Child=root.children[0],depth2Child=function(root){if(!root.children||!root.children.length)return null;for(let i=0;i<root.children.length;i++)if(root.children[i].children&&root.children[i].children.length)return root.children[i].children[0];return null}(root);isSmallScreen&&depth2Child&&root.each((d=>{1==d.depth&&(d.y1=depth2Child.y1)}));let depth1Width=rectWidth(depth1Child),depth2Width=null!==(_rectWidth=rectWidth(depth2Child))&&void 0!==_rectWidth?_rectWidth:1,{urlContainerSize:urlContainerSize,urlIconSize:urlIconSize}=function(){let urlContainerSize=Math.min(Math.min(3*mainCircleRadius/2,30),rectHeight(depth1Child)/3.5),urlIconSize=.75*urlContainerSize;isSmallScreen&&isLandscapeMode&&(urlContainerSize*=1.5,urlIconSize*=1.5);return{urlContainerSize:urlContainerSize,urlIconSize:urlIconSize}}(),changingProgress=!1,lastMousePosition=null,objectToMove=null,currentProgress=null,circleEnlargeFactor=function(depth2Child,isLandscapeMode,isSmallScreen,hasTouchscreen){let val=depth2Child?Math.min(4,86/sliderSize(depth2Child)):0;isLandscapeMode&&isSmallScreen&&hasTouchscreen&&(val*=1.5);return val}(depth2Child,isLandscapeMode,isSmallScreen,hasTouchscreen),sliderCircleIconSize=depth2Child?Math.min(sliderSize(depth2Child),20.13):0,sliderCircleRadius=depth2Child?Math.min(sliderSize(depth2Child)/1.5,16):0;lastY=depth2Child?depth2Child.y1+sliderSize(depth2Child):depth1Child.y1;let colorPaletteSize=function(isSmallScreen,isLandscapeMode,lastY,width){let colorPaletteSize=25;isSmallScreen&&!isLandscapeMode?colorPaletteSize=(width-lastY)/8:isSmallScreen&&(colorPaletteSize=(width-lastY)/14);return Math.max(colorPaletteSize,0)}(isSmallScreen,isLandscapeMode,lastY,width),colorPaletteBgRadius=colorPaletteSize,yShift=colorPaletteSize/2+3,colorSchemeHolderPadding=function(isSmallScreen){return isSmallScreen?10:25}(isSmallScreen),cornerRadius=colorSchemeHolderPadding/3,colorBoxWidth=function(isSmallScreen,width,lastY,cornerRadius,data,colorPaletteBgRadius){return isSmallScreen?7:Math.min((.7*(width-lastY)-2*cornerRadius)/(data.children.length+1),colorPaletteBgRadius*Math.sqrt(2)-2*cornerRadius)}(isSmallScreen,width,lastY,cornerRadius,data,colorPaletteBgRadius),colorBoxHeight=colorBoxWidth,colorSchemeHolderHeight=colorBoxWidth+2*cornerRadius,colorSchemeHolderWidth=colorBoxWidth*(data.children.length+1)+2*cornerRadius,useDoubleColumnColorScheme=yShift+2*colorPaletteBgRadius+(colorSchemeHolderHeight+10)*(colorSchemesNames.length-1)+colorSchemeHolderHeight+5*colorPaletteSize>height,colorSchemeTouchRects=!0,colorBoxFactor=.7;for(;useDoubleColumnColorScheme&&colorSchemeTouchRects&&colorBoxFactor>=.1;)yShift=colorPaletteSize/2+3,colorSchemeHolderPadding=13,cornerRadius=colorSchemeHolderPadding/3,colorBoxWidth=Math.max(Math.min(((width-lastY)*colorBoxFactor-2*cornerRadius)/(data.children.length+1),colorPaletteBgRadius*Math.sqrt(2)-2*cornerRadius),1),colorBoxHeight=colorBoxWidth,colorSchemeHolderHeight=colorBoxWidth+2*cornerRadius,colorSchemeHolderWidth=colorBoxWidth*(data.children.length+1)+2*cornerRadius,useDoubleColumnColorScheme=yShift+2*colorPaletteBgRadius+(colorSchemeHolderHeight+10)*(colorSchemesNames.length-1)+colorSchemeHolderHeight+5*colorPaletteSize>height,colorSchemeTouchRects=lastY>(width-lastY)/4+lastY-colorSchemeHolderWidth/2,colorBoxFactor-=.1;let colorData=[];colorSchemesNames.forEach(((color,index)=>colorData.push({index:index,colorscheme:color,colorblind:colorblindSchemes.includes(color)})));let toolBar=svg.append("g"),colorSchemePickerG=toolBar.append("g").attr("transform","translate(".concat(0,",",5*colorPaletteSize,")")).classed("colorSchemePicker",!0).attr("aria-hidden",!0),colorSchemeSample=colorSchemePickerG.append("g").classed("colorSchemesContainer",!0).selectAll(null).data(colorData).join("svg").attr("x",(width-lastY-colorSchemeHolderWidth)/2+lastY).attr("y",yShift+colorPaletteSize/2-colorSchemeHolderHeight/2).attr("width",colorSchemeHolderWidth).attr("height",colorSchemeHolderHeight).attr("viewBox","0 0 ".concat(colorSchemeHolderWidth," ").concat(colorSchemeHolderHeight," ")).style("fill",(d=>d.colorblind?"#383866":"url(#gradient-".concat(treemapId,")"))).style("cursor","pointer").style("filter","drop-shadow(".concat("1px 1px 1px"," rgba(0,0,0,0.5))")).on("click",((e,d)=>function(e,name){let savedColorschemes;e.preventDefault();try{savedColorschemes=localStorage.getItem("treemapColorscheme"),savedColorschemes=savedColorschemes?JSON.parse(savedColorschemes):{}}catch(e){savedColorschemes={}}savedColorschemes[treemapId]=name,localStorage.setItem("treemapColorscheme",JSON.stringify(savedColorschemes));let interpolate=null;interpolate=name in additionalColors?d3.interpolateRgbBasis(additionalColors[name]):d3["interpolate".concat(name)];color=d3.scaleOrdinal(d3.quantize(interpolate,data.children.length+2));let t=d3.transition().duration(300);rect.transition(t).attr("fill",(d=>{if(!d.depth)return color(d.data.name);for(;d.depth>1;)d=d.parent;return color(d.data.name)})),isStudent&&learningGoalProgressBar.transition(t).attr("fill",(d=>color(d.parent.data.name)));urlContainer.transition(t).attr("fill",(d=>color(d.depth>1?d.parent.data.name:d.data.name))),urlContainer.style("filter",(d=>{let alphaArray=parseRGB(color(1===d.depth?d.data.name:d.parent.data.name));return alphaArray.push(.8),"drop-shadow(".concat("1px 1px 1px"," ").concat(convertRGBArrayToString(alphaArray),")")})),urlIconSvg.transition(t).attr("stroke",(d=>contrastCorrectedColor(d,.7,!0))).attr("stroke-opacity",(d=>"white"===contrastCorrectedColor(d,.7,!0)?1:.5)),isStudent&&(sliderSvg.transition(t).attr("fill",(d=>color(d.parent.data.name))),sliderText.transition(t).attr("fill",(d=>contrastCorrectedColor(d,1,!1))),sliderAcceptSvg.transition(t).attr("fill",(d=>color(d.parent.data.name,1,!1))),sliderRejectSvg.transition(t).attr("fill",(d=>color(d.parent.data.name,1,!1))),sliderRejectIcon.transition(t).attr("stroke",(d=>contrastCorrectedColor(d,1,!1))),sliderAcceptIcon.transition(t).attr("stroke",(d=>contrastCorrectedColor(d,1,!1))),topicProgressContainerBG.style("filter",(d=>{let alphaArray=parseRGB(color(d.data.name));return alphaArray.push(.8),"drop-shadow(".concat("1px 1px 1px"," ").concat(convertRGBArrayToString(alphaArray),")")})),topicProgressContainerBG.transition(t).attr("stroke",(d=>convertRGBAtoRGB(color(d.data.name),"black",.8,!0))).attr("fill",(d=>{let bgColor=convertRGBAtoRGB(color(d.data.name),"white",.6);return convertRGBAtoRGB(color(d.data.name),bgColor,.4,!0)})),topicProgressContainer.transition(t).attr("fill",(d=>convertRGBAtoRGB(color(d.data.name),"black",.94,!0))),topicProgressTextSvg.transition(t).attr("stroke",(d=>convertRGBAtoRGB(color(d.data.name),"black",.8,!0))).attr("fill",(d=>convertRGBAtoRGB(color(d.data.name),"white",.6,!0))),topicProgressText.transition(t).attr("fill",(d=>contrastCorrectedColor(d,.6,!1))));maintspan.transition(d3.transition().duration(300)).attr("fill",(d=>contrastCorrectedColor(d,.6,2===d.depth)))}(e,d.colorscheme))),colorSchemeSamplePath=colorSchemeSample.append("path").attr("d",roundedCornersRect(colorSchemeHolderWidth,colorSchemeHolderHeight,colorBoxWidth+2*cornerRadius,colorSchemeHolderHeight,cornerRadius)),colorSchemeBox=colorSchemeSample.selectAll(null).data((d=>function(name,colorschemeIndex){let colors,n=data.children.length+2,interpolate=null;interpolate=name in additionalColors?d3.interpolateRgbBasis(additionalColors[name]):d3["interpolate".concat(name)];colors=[];for(let i=0;i<n-1;++i){let correctedColor=convertRGBAtoRGB(parseRGB(interpolate(i/(n-1))),"white",.6,!0);colors.push({index:i,parentIndex:colorschemeIndex,colorscheme:name,color:d3.rgb(correctedColor).hex()})}return colors}(d.colorscheme,d.index))).join("rect").attr("y",(colorSchemeHolderHeight-colorBoxHeight)/2).attr("x",(colorSchemeHolderWidth-colorBoxWidth)/2).attr("height",colorBoxHeight).attr("width",colorBoxWidth).style("fill",(d=>d.color)),colorPaletteIconG=colorSchemePickerG.append("g").classed("colorPaletteIconG",!0),colorPaletteBg=colorPaletteIconG.append("circle").style("filter","drop-shadow(".concat("1px 1px 1px"," rgba(0,0,0,0.5))")).attr("cx",(width-lastY)/2+lastY).attr("cy",yShift+colorPaletteSize/2).attr("r",colorPaletteBgRadius).style("cursor","pointer").style("fill","url(#gradient-".concat(treemapId,")")).on("click",toggleColorSchemes),colorPaletteSvg=colorPaletteIconG.append("svg").attr("x",(width-lastY-colorPaletteSize)/2+lastY).attr("y",yShift).attr("width",colorPaletteSize).attr("height",colorPaletteSize).attr("viewBox","0 0 512 512").style("cursor","pointer").style("fill","rgb(40, 40, 40)").on("click",toggleColorSchemes);colorPaletteSvg.append("path").attr("d","M491.514,148.498c27.293-27.293,27.293-71.701,0-98.994L442.017,0.007l-43.382,43.382 C356.067,14.713,306.619-0.279,254.762,0.004C114.059,0.68-0.22,115.717,0.017,256.44c0.115,68.288,26.794,132.471,75.125,180.724 c48.335,48.26,112.571,74.837,180.875,74.837c13.478,0,27.011-1.059,40.224-3.146c20.168-3.188,37.24-15.365,46.838-33.411 c9.753-18.337,10.29-39.698,1.471-58.605c-9.644-20.677-14.533-42.827-14.533-65.837c0-29.521,8.28-58.253,23.945-83.089 c11.303-17.92,26.072-33.28,43.344-45.235l8.777,254.863l0.008,0.19c0.906,19.217,16.687,34.27,35.926,34.27 c19.239,0,35.02-15.054,35.926-34.27l8.904-258.531c3.239-4.215,5.17-9.484,5.17-15.199v-40c0-4.636-1.273-8.979-3.482-12.705 C489.549,150.392,490.547,149.466,491.514,148.498z M392.017,164.001v26.484c-25.685,15.062-47.458,36.102-63.429,61.423 c-18.691,29.634-28.571,63.899-28.571,99.093c0,27.424,5.835,53.841,17.345,78.517c4.8,10.291,4.519,21.896-0.769,31.839 c-5.133,9.65-14.258,16.162-25.035,17.865c-11.669,1.845-23.627,2.779-35.541,2.779c-60.299,0-117.007-23.463-159.679-66.066 c-42.666-42.599-66.219-99.26-66.321-159.545C29.808,132.156,130.693,30.601,254.906,30.004 c44.89-0.212,87.796,12.497,124.892,36.882c-5.077,9.81-7.781,20.752-7.781,32.115c0,18.698,7.282,36.276,20.503,49.497 c0.968,0.968,1.966,1.894,2.979,2.798C393.29,155.022,392.017,159.365,392.017,164.001z M447.972,476.381 c-0.182,3.156-2.786,5.62-5.956,5.62s-5.773-2.464-5.956-5.62l-8.519-247.38h28.949L447.972,476.381z M462.017,199.001h-40v-30h40 V199.001z M470.3,127.285c-7.555,7.556-17.6,11.716-28.284,11.716c-10.684,0-20.729-4.16-28.284-11.716h-0.001 c-15.596-15.596-15.596-40.973,0-56.568l28.285-28.284l28.285,28.284c7.555,7.555,11.715,17.6,11.715,28.284    C482.016,109.685,477.856,119.73,470.3,127.285z");appendEmptyCirclePath(colorPaletteSvg,238,74,45,2),appendEmptyCirclePath(colorPaletteSvg,124,263,45,2),appendEmptyCirclePath(colorPaletteSvg,145,143,45,2),appendEmptyCirclePath(colorPaletteSvg,211,346,45,2);let zoomIconG=toolBar.append("g").classed("zoomIconG",!0).attr("transform","translate(".concat((width-lastY)/2+lastY-colorPaletteSize,",").concat(2.5*colorPaletteSize,")")).on("click",null);zoomIconG.append("circle").attr("cx",colorPaletteSize).attr("cy",colorPaletteSize).attr("r",colorPaletteBgRadius).style("filter","drop-shadow(".concat("1px 1px 1px"," rgba(0,0,0,0.5))")).style("fill","url(#gradient-".concat(treemapId,")"));let zoomBG=zoomIconG.append("svg").attr("viewBox","0 0 100 100").attr("height",2*colorPaletteSize).attr("width",2*colorPaletteSize).attr("x",0).attr("y",0).classed("zoomHalvesContainer",!0),zoomLeftHalfSvg=zoomBG.append("svg").classed("zoomLeftHalf",!0).style("cursor","pointer").on("click",zoomOutText),zoomLeftHalf=zoomLeftHalfSvg.append("path").attr("d","M 50,1 a 49 49 0 0 0 0,98 a 99999 9999  0 0 0 0,-98  z").style("fill","url(#gradient-".concat(treemapId,")"));zoomLeftHalfSvg.append("path").attr("d","M ".concat(17,",50  h ").concat(20)).classed("zoom-half-svg",!0);let zoomRightHalfSvg=zoomBG.append("svg").style("cursor","pointer").classed("zoomRightHalf",!0).on("click",zoomInText),zoomRightHalf=zoomRightHalfSvg.append("path").attr("d","M 50,1 a 49 49 0 0 1 0,98 a 99999 9999  0 0 1 0,-98  z").style("fill","url(#gradient-".concat(treemapId,")"));zoomRightHalfSvg.append("path").attr("d","M ".concat(63,", 50 h ").concat(20)+" M ".concat(73,",").concat(40,"  v ").concat(20," ")).classed("zoom-half-svg",!0),zoomBG.append("path").attr("d","M 50,1 v 98").classed("zoom-bg",!0);let accessibilityIconG=toolBar.append("g").classed("accessibilityIcon",!0).on("click",toggleAccessibilityDialog),accessibilityWidth=width-lastY-10,accessibilityBG=accessibilityIconG.append("circle").attr("cx",(width-lastY)/2+lastY).attr("cy",yShift+colorPaletteSize/2).attr("r",colorPaletteBgRadius).style("filter","drop-shadow(".concat("1px 1px 1px"," rgba(0,0,0,0.5))")).style("cursor","pointer").style("fill","url(#gradient-".concat(treemapId,")")),accessibilityIcon=accessibilityIconG.append("svg").attr("x",(width-lastY-colorPaletteSize)/2+lastY).attr("y",yShift).attr("width",colorPaletteSize).attr("height",colorPaletteSize).attr("viewBox","0 0 100 100").classed("accessibility-icon",!0);accessibilityIcon.append("path").attr("d","M50,35L50,40A90,90 0 0 1 35,95M50,40A90,90 1 0 0 65,95 M50,35 A 100,100 1 0 0 85,20M50,35 A 100,100 0 0 1 15,20"),accessibilityIcon.append("circle").attr("cx",50).attr("cy",10).attr("r",5);const cell=svg.append("g").selectAll("g").data(root.descendants()).join("g").classed("svg-cell",!0).attr("role","listitem").attr("aria-labelledby",((d,i)=>"depth".concat(d.depth,"_idx").concat(i))).attr("transform",(d=>d.depth<2||!isSmallScreen?"translate(".concat(d.y0,",").concat(d.x0,")"):"translate(".concat(d.parent.y1,",").concat(d.x0,")")));cell.filter((d=>0===d.depth)).attr("id","root-rect"+treemapId);const rect=cell.append("rect").attr("width",(d=>d.y1-d.y0)).attr("height",(d=>d.x1-d.x0)).style("display",(d=>d.depth<2||!isSmallScreen?"initial":"none")).classed("rect",!0).attr("fill",(d=>{if(!d.depth)return color(d.data.name);for(;d.depth>1;)d=d.parent;return color(d.data.name)}));depth2Child&&rect.filter((d=>d.depth>0)).on("click",clicked),rect.filter((d=>0===d.depth)).attr("tabindex",0).attr("aria-label","Learning goal widget for ".concat(root.data.name,".\n").concat(root.children.length," topic").concat(root.children.lenght>1?"s":""," present.")),setDepth1AriaLabel(),rect.filter((d=>1===d.depth)).on("keydown",((evt,d)=>{(evt=evt||window.event).ctrlKey&&13==evt.keyCode&&d.data.url?window.open(d.data.url.replaceAll("\\/","/"),""):13==evt.keyCode&&clicked(null,d)})),rect.filter((d=>2===d.depth)).attr("aria-live","polite").attr("aria-labelledby",((d,i)=>"depth".concat(d.depth,"_idx").concat(i)));let learningGoalTitle=function(rect){const learningGoalTitle=rect.filter((d=>2===d.depth)).append("title").attr("class",((d,i)=>"depth".concat(d.depth,"_idx").concat(i)));isStudent?learningGoalTitle.text((d=>"".concat(d.data.name," - Progress ").concat(parseInt(100*computeProgress(d)),"%.\n        ").concat(d.data.url?"External url is available, press control and enter to open it.":""))):learningGoalTitle.text((d=>"".concat(d.data.name,".\n        ").concat(d.data.url?"External url is available, press control and enter to open it.":"")));return learningGoalTitle}(rect),isEnteringValue=!1,newProgress="";rect.filter((d=>2===d.depth)).on("keydown",(function(evt,d){var _evt;evt=evt||window.event,null===(_evt=evt)||void 0===_evt||_evt.preventDefault(),!isEnteringValue&&evt.ctrlKey&&evt.shiftKey&&13==evt.keyCode?(isEnteringValue=!0,learningGoalTitle.filter((d2=>2===d2.depth&&d2==d)).text((d=>"The current progress for the learning goal ".concat(d.data.name," is ").concat(d.data.pro,"%.\n        Please enter now the new value. You can save the changes by pressing ctrl shift enter\n        or reject them by pressing ctrl shift delete.")))):!isEnteringValue&&evt.ctrlKey&&13==evt.keyCode&&d.data.url?window.open(d.data.url.replaceAll("\\/","/"),""):isEnteringValue&&function(evt,d){const KEY_0=48,KEY_9=57,KEY_BACKSPACE=8,KEY_TAB=9,KEY_ENTER=13;if(evt.keyCode>=KEY_0&&evt.keyCode<=KEY_9)!function(evt,d){newProgress+=String.fromCharCode(evt.keyCode);let text=parseInt(newProgress)>100?"The entered value is ".concat(newProgress,", but it should between 0 and 100,\n      please change it. You can press delete to remove the last digit or ctrl shift \n      delete to exit."):"New value ".concat(newProgress,". Press ctrl shift enter to confirm.");learningGoalTitle.filter((d2=>2===d2.depth&&d2==d)).text(text)}(evt,d);else if(evt.ctrlKey&&evt.shiftKey&&evt.keyCode==KEY_BACKSPACE)!function(evt,d){learningGoalTitle.filter((d2=>2===d2.depth&&d2===d)).text("Changes aborted. Progress is set to its previous value ".concat(d.data.pro,"%.")),setTimeout((()=>{learningGoalTitle.filter((d2=>2===d2.depth&&d2===d)).text((d=>"Learning goal ".concat(d.data.name,".\n                                Progress ").concat(parseInt(100*computeProgress(d)),"%.\n                                ").concat(d.data.url?"External url is available, press control and enter to open it.":" ")))}),5e3),newProgress="",isEnteringValue=!1}(0,d);else if(evt.ctrlKey&&evt.shiftKey&&evt.keyCode==KEY_ENTER)!function(evt,d){let newProInt=parseInt(newProgress);if(newProInt<0||newProInt>100)return void learningGoalTitle.filter((d2=>2===d2.depth&&d2==d)).text("The entered value is ".concat(newProgress,", but it should between 0 and 100,\n        please change it. You can press delete to remove the last digit or ctrl shift delete to exit."));let currentProg=Math.round(100*computeProgress(d.parent))/100;d.data.pro=newProInt,learningGoalTitle.filter((d2=>2===d2.depth&&d2==d)).text("Confirmed changes. New progress ".concat(d.data.pro,"%.")),setTimeout((()=>{learningGoalTitle.filter((d2=>2===d2.depth&&d2==d)).text((d=>"Learning goal ".concat(d.data.name,".\n                          Progress ").concat(parseInt(100*computeProgress(d)),"%.\n                          ").concat(d.data.url?"External url is available, press control and enter to open it.":" ")))}),5e3);let trans=d3.transition().duration(300).ease(d3.easeExp);resetSlider((d2=>2===d2.depth&&d2===d),trans,!1),learningGoalProgressBar.filter((d2=>2===d2.depth&&d2==d)).transition(trans).attr("width",(d=>computeLearningGoalProgressBarWidth(d))),sliderSvg.filter((d2=>2===d2.depth&&d2==d)).transition(trans).attr("x",(d=>{let newVal=computeCircleContainerXPosition(d);return 100===d.data.pro?newVal+1:newVal})),sliderText.filter((d2=>2===d2.depth&&d2==d)).transition(trans).text(newProgress+"%").attr("x",(d=>{let newVal=computeCircleTextXPosition(d);return 100===d.data.pro?newVal+1:newVal}));let newProg=Math.round(100*computeProgress(d.parent))/100;changeProgressDegree(currentProg,currentProg>newProg?-.01:.01,currentProg,newProg,d.parent,300),newProgress="",isEnteringValue=!1}(0,d);else if(evt.keyCode==KEY_BACKSPACE)newProgress=newProgress.substr(0,newProgress.length-1),learningGoalTitle.filter((d2=>2===d2.depth&&d2==d)).text("New value ".concat(newProgress,". Press ctrl shift enter to confirm or ctrl shift delete to abort."));else if(evt.keyCode==KEY_TAB||evt.Tab)newProgress=newProgress.substr(0,newProgress.length-1),learningGoalTitle.filter((d2=>2===d2.depth&&d2==d)).text("Please confirm or reject the changes before moving to another learning goal.\n      The entered value is ".concat(newProgress,". Press ctrl shift enter to confirm\n      or ctrl shift delete to abort.")),evt.preventDefault();else if(evt.ctrlKey||evt.shiftKey||evt.keyCode==KEY_ENTER)return;learningGoalTitle.filter((d2=>2===d2.depth&&d2==d)).text("You can enter only digits currently. Press control shift delete to exit."+" The number entered is ".concat(""!==newProgress?newProgress:"still empty."))}(evt,d)}));let learningGoalProgressBar=function(cell){if(!isStudent)return null;return cell.filter((d=>2===d.depth)).append("rect").attr("width",(d=>isSmallScreen?0:rectWidth(d)*computeProgress(d))).attr("height",(d=>rectHeight(d))).attr("y",0).attr("fill-opacity",.6).attr("fill",(d=>color(d.parent.data.name))).on("click",depth2Child?clicked:null)}(cell);const text=cell.append("text").attr("aria-hidden",!0).attr("width",(d=>d.y1-d.y0)).classed("text-element",!0);text.filter((d=>0===d.depth)).classed("vertical-text",!0),text.filter((d=>2===d.depth)).classed("text-element-d2".concat(isSmallScreen?"-sm":""),!0);const maintspan=text.append("tspan").text((d=>d.data.name)).attr("dx",0).attr("x",4).attr("y",(d=>(d.depth,rectHeight(d)/2))).attr("fill",(d=>contrastCorrectedColor(d,.6,2===d.depth))).classed("maintspan",!0).style("font",(d=>"".concat(fontSize(d),"px sans-serif")));maintspan.filter((d=>1===d.depth)).classed("maintspan-d1",!0).attr("x",(d=>(rectWidth(d)-2.5*mainCircleRadius)/2)),maintspan.filter((d=>0===d.depth)).attr("y",(d=>rectHeight(d)/2)).attr("x",(d=>rectWidth(d)/2)).classed("vertical-tspan",!0),maintspan.filter((d=>1===d.depth)).call(wrapText,depth1Width-mainCircleWidth-3*topicCellPadding,!1,(el=>rectHeight(el)),topicCellPadding);let rootNode=null,rootText=null;maintspan.filter((d=>0===d.depth)).each(((_,i,n)=>{rootText=n[i].parentNode,rootNode=rootText.parentNode})),d3.select(rootText).classed("rootText",!0),d3.select(rootNode).classed("rootNode",!0),rootText.getBBox().height>=rootNode.querySelector(".rect").getBBox().height&&(text.filter((d=>0===d.depth)).style("letter-spacing","0.3em"),rootText.getBBox().height>=rootNode.querySelector(".rect").getBBox().height&&truncateTitle(rootText,rootNode,maintspan.filter((d=>0===d.depth)))),maintspan.filter((d=>2===d.depth)).classed("maintspan-d2",!0).call(truncateText,.95*depth2Width,!0);let sliderG=null,sliderRejectG=null,sliderRejectSvg=null,sliderRejectCircle=null,sliderRejectIcon=null,sliderAcceptG=null,sliderAcceptSvg=null,sliderAcceptCircle=null,sliderAcceptIcon=null,sliderSvg=null,sliderPath=null,sliderText=null,showSliderPercent=null,topicProgressG=null,topicProgressContainerBG=null,topicProgressContainer=null,topicProgressPie=null,topicProgressTextSvg=null,topicProgressText=null;isStudent&&(sliderG=cell.filter((d=>2===d.depth)).append("g").classed("sliderG",!0),sliderRejectG=sliderG.append("g").classed("circleReject",!0),sliderRejectSvg=setupSliderSvg(sliderRejectG,"reject",(function(){let t=d3.transition().duration(200).ease(d3.easeLinear);t.end().then((()=>{sliderAcceptCircle.style("visibility","hidden"),sliderAcceptIcon.style("visibility","hidden"),sliderRejectCircle.style("visibility","hidden"),sliderRejectIcon.style("visibility","hidden")})).catch((()=>{})),sliderSvg.filter((d=>d===objectToMove)).transition(t).attr("x",(d=>computeCircleContainerXPosition(d))),learningGoalProgressBar.filter((d=>d===objectToMove)).transition(t).attr("width",(d=>computeLearningGoalProgressBarWidth(d))),sliderText.filter((d=>d===objectToMove)).transition(t).text(objectToMove.data.pro+"%").attr("x",(d=>computeCircleTextXPosition(d))),resetSlider((d=>d===objectToMove),t,!1);let oldPro=objectToMove.data.pro;objectToMove.data.pro=currentProgress;let currentProg=Math.round(100*computeProgress(objectToMove.parent))/100;objectToMove.data.pro=oldPro;let newProg=Math.round(100*computeProgress(objectToMove.parent))/100;changeProgressDegree(currentProg,currentProg>newProg?-.01:.01,currentProg,newProg,objectToMove.parent,200),confirmationDialogShown=!1,reduceSlider(objectToMove),setTimeout((()=>{xTouchStart=-1,finalizingChanges=!1}),200)})),sliderRejectCircle=setupSliderCircles(sliderRejectSvg),sliderRejectIcon=setupSliderCircleIcon(sliderRejectSvg,"reject"),sliderAcceptG=sliderG.append("g").attr("class","circleAccept"),sliderAcceptSvg=setupSliderSvg(sliderAcceptG,"accept",acceptChanges),sliderAcceptCircle=setupSliderCircles(sliderAcceptSvg),sliderAcceptIcon=setupSliderCircleIcon(sliderAcceptSvg,"accept"),sliderSvg=sliderG.append("svg").attr("aria-label",(d=>"Progress slider, current progress ".concat(d.data.pro,"%. ")+"Press enter and then use the arrow keys to adjust. Press enter when you are done.")).attr("x",(d=>isSmallScreen?0:d.proY0)).attr("y",(d=>(rectHeight(d)-sliderSize(d))/2)).attr("class","slider").attr("width",(d=>sliderSize(d))).attr("height",(d=>sliderSize(d))).attr("viewBox","0 0 100 100").attr("fill",(d=>color(d.parent.data.name))),function(sliderSvg){hasTouchscreen?sliderSvg.on("touchstart",((e,d)=>function(event,d){if(!isZoomedIn)return;if(confirmationBoxesActive&&confirmationDialogShown&&d!==objectToMove)return void shakeConfirmationDialog();const pt=d3.select("#"+treemapId).select("svg").node().createSVGPoint();pt.x=event.touches.item(0).clientX;const svgP=pt.matrixTransform(d3.select("#"+treemapId).select("svg").node().getScreenCTM().inverse());xTouchStart=svgP.x,objectToMove=d,changingProgress=!0}(e,d))).on("touchmove",(e=>sliderTouchMove(e))).on("touchend",(()=>function(){if(!isZoomedIn||!changingProgress)return;if(changingProgress=!1,Math.abs(currentProgress-objectToMove.data.pro)<.01)return;confirmationBoxesActive?(confirmationDialogShown=!0,toggleConfirmationDialog()):acceptChanges()}())):sliderSvg.on("mouseenter",((e,d)=>resizeSlider(e,d))).on("mouseleave",((e,d)=>resizeSlider(e,d))).on("mousedown",((e,d)=>function(e,d){if(e.preventDefault(),!isZoomedIn)return;highlightedGoals&&highlightedGoals.includes(d)&&unhighlightLearningGoals();if(confirmationBoxesActive&&confirmationDialogShown&&d!==objectToMove)return void shakeConfirmationDialog();const pt=d3.select("#"+treemapId).select("svg").node().createSVGPoint();pt.x=e.clientX;const svgP=pt.matrixTransform(d3.select("#"+treemapId).select("svg").node().getScreenCTM().inverse());objectToMove=d,currentProgress=d.data.pro,changingProgress=!0,lastMousePosition=svgP.x,svg.on("mousemove",(e=>performChanges(e))).on("mouseup",stopChangingProgress)}(e,d)))}(sliderSvg),sliderPath=sliderSvg.append("path").attr("d","M 50 50 m 49, 0 a 49,49 0 1,0 -98,0 a 49,49 0 1,0 98,0 "),sliderText=sliderG.append("text").text("100%").classed("slider-text",!0).attr("x",(d=>isSmallScreen?sliderSize(d)/2:d.proY0+sliderSize(d)/2)).attr("y",(d=>rectHeight(d)/2)).attr("fill",(d=>contrastCorrectedColor(d,1,!1))).style("font",(d=>"".concat(sliderTextSize(d,!0),"px sans-serif"))),showSliderPercent=function(){let textFits=!0;return sliderText.each(((_,i,n)=>{n[i].getBoundingClientRect().width>=n[i].parentNode.getElementsByClassName("slider")[0].getBoundingClientRect().width&&(textFits=!1)})),textFits}(),sliderText.text((d=>d.data.pro+(showSliderPercent?"%":""))),topicProgressG=cell.filter((d=>1===d.depth)).append("g").on("click",clicked).attr("transform",(d=>"translate(".concat(rectWidth(d)-mainCircleWidth-topicCellPadding,",")+" ".concat(rectHeight(d)/2-mainCircleRadius,")"))),topicProgressContainerBG=topicProgressG.append("svg").attr("width",mainCircleWidth).attr("height",mainCircleWidth).attr("viewBox","0 0 100 100").attr("x",0).style("filter",(d=>{let alphaArray=parseRGB(color(d.data.name));return alphaArray.push(.8),"drop-shadow(".concat("1px 1px 1px"," ").concat(convertRGBArrayToString(alphaArray),")")})).attr("stroke",(d=>convertRGBAtoRGB(color(d.data.name),"black",.8,!0))).classed("base-stroke",!0).attr("fill",(d=>{let bgColor=convertRGBAtoRGB(color(d.data.name),"white",.6);return convertRGBAtoRGB(color(d.data.name),bgColor,.4,!0)})),topicProgressContainerBG.append("path").attr("d","M 50 50 m 49, 0 a 49,49 0 1,0 -98,0 a 49,49 0 1,0 98,0 "),topicProgressContainer=topicProgressG.append("svg").attr("width",mainCircleWidth).attr("height",mainCircleWidth).attr("x",0).attr("viewBox","0 0 100 100").attr("fill-opacity",1).attr("fill",(d=>convertRGBAtoRGB(color(d.data.name),"black",.94,!0))),topicProgressPie=topicProgressContainer.append("path").attr("d",(d=>{let angle=2*Math.PI*computeProgress(d);if(angle===2*Math.PI)return"M 50 50 m 49, 0 a 49,49 0 1,0 -98,0 a 49,49 0 1,0 98,0 z";let sin=Math.sin(angle),cos=Math.cos(angle);return"M 50 50 v -49 A 49,49 0 ".concat(angle>=Math.PI?1:0,",1 ").concat(49*sin+50," ").concat(49*-cos+50," z")})),topicProgressTextSvg=topicProgressG.append("svg").attr("x",mainCircleRadius-subCircleRadius).attr("y",mainCircleRadius-subCircleRadius).attr("width",subCircleWidth).attr("height",subCircleWidth).attr("viewBox","0 0 100 100").attr("stroke",(d=>convertRGBAtoRGB(color(d.data.name),"black",.8,!0))).classed("base-stroke",!0).attr("fill",(d=>convertRGBAtoRGB(color(d.data.name),"white",.6,!0))),topicProgressTextSvg.append("path").classed("topic-prog-text-svg",!0).attr("d","M 50 50 m 48, 0 a 48,48 0 1,0 -96,0 a 48,48 0 1,0 96,0 "),topicProgressText=topicProgressG.append("text").attr("aria-hidden",!0).style("transform-origin","".concat(mainCircleWidth,"px ",0,"px")).text((d=>"".concat(parseInt(100*computeProgress(d)),"%"))).attr("y",mainCircleRadius).attr("x",mainCircleRadius).attr("fill",(d=>contrastCorrectedColor(d,.6,!1))).classed("topic-prog-text",!0).style("font","".concat(subCircleWidth/2.7,"px sans-serif")));let urlContainerG=cell.filter((d=>d.depth>=1&&d.data.url)).append("g").attr("class","urlContainerG").attr("width",(d=>d.depth<2||!isSmallScreen?urlContainerSize:1)).attr("height",(d=>d.depth<2||!isSmallScreen?urlContainerSize:1)).on("mouseenter",((_,p)=>changeUrlFocus(p,urlContainerG,!0))).on("mouseleave",((_,p)=>changeUrlFocus(p,urlContainerG,!1))).on("click",((_,d)=>window.open(d.data.url?d.data.url.replaceAll("\\/","/"):"https://www.know-center.tugraz.at/en/","_blank"))),urlContainer=createElement(!1);urlContainer.attr("aria-label",(d=>"Open url of ".concat(d.data.name))).style("filter",(d=>{let alphaArray=parseRGB(color(1===d.depth?d.data.name:d.parent.data.name));return alphaArray.push(.8),"drop-shadow(".concat("1px 1px 1px"," ").concat(convertRGBArrayToString(alphaArray),")")})),urlContainer.append("path").attr("d",function(radius){return"M0,0h"+radius+"a"+radius+","+radius+" 0 0 1 "+-radius+","+radius+"z"}(urlContainerSize));let urlIconSvg=createElement(!0);urlIconSvg.append("path").attr("d","M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"),urlIconSvg.append("path").attr("d","M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71");let backArrowSvg=cell.filter((d=>1===d.depth)).append("g").on("click",clicked).attr("cursor","zoom-out").append("svg").attr("width",0).attr("height",0).attr("viewBox","0 0 100 100").attr("x",0).attr("y",0).attr("stroke",(d=>contrastCorrectedColor(d,.7,!0))).classed("back-arrow",!0);backArrowSvg.append("path").attr("d","M 90,50 l -80,0 l 20,-20 M 10, 50 l 20, 20"),depth2Child&&toggleZoomCursor();let confirmationDialogShown=!1,blurDiv=d3.select("#"+treemapId).append("div").style("max-width","".concat(width,"px")).style("z-index",-1).classed("blur-div",!0).classed("mainDiv",!0);const accessibilitySvg=blurDiv.append("svg").attr("aria-labelledby","visualization-title").attr("aria-describedby","visualization-desc").attr("height",height).attr("width",width).classed("accessibility-svg",!0).attr("viewBox",[0,0,width,height]);let accessibilityCloseBG=accessibilitySvg.append("circle").attr("filter","drop-shadow(".concat("1px 1px 1px"," rgba(0,0,0,0.5))")).attr("cx",(width-lastY)/2+lastY).attr("cy",yShift+colorPaletteSize/2).attr("r",colorPaletteBgRadius).attr("cursor","pointer").attr("fill","url(#gradient-".concat(treemapId,")")).on("click",toggleAccessibilityDialog);accessibilitySvg.append("svg").attr("x",(width-lastY-colorPaletteSize)/2+lastY).attr("y",yShift).attr("width",colorPaletteSize).attr("height",colorPaletteSize).attr("viewBox","0 0 30 30").classed("accessibility-close-icon",!0).append("path").attr("d","M6,6 L26,26 M6,26 L26,6").on("click",toggleAccessibilityDialog);let accessibilityData=[{data:treemapaccessibilitytext}],accessibilityFontSize=Math.max(accessibilityWidth/19,14),accessibilityDialogSVGHeight=20+(14===accessibilityFontSize?17:accessibilityFontSize+2)*blurDiv.append("div").style("text-align","center").style("max-width","".concat(width,"px")).style("height","".concat(height,"px")).style("top","0").style("position","absolute").selectAll(null).data(accessibilityData).join("p").style("margin-inline","".concat(100*(2*colorPaletteSize+(width-lastY)/2)/width,"%")).attr("id","accessibility-dialog").attr("tabindex",1).html((d=>d.data)).style("font","".concat(accessibilityFontSize,"px sans-serif"))._groups[0][0].children.length;blurDiv.attr("height",accessibilityDialogSVGHeight+2*colorPaletteBgRadius).style("top","".concat(-accessibilityDialogSVGHeight-2*colorPaletteBgRadius,"%")),accessibilitySvg.attr("height",accessibilityDialogSVGHeight+2*colorPaletteBgRadius+10).attr("viewBox","0 0 ".concat(width," ").concat(accessibilityDialogSVGHeight+2*colorPaletteBgRadius+10));let clickedTopic=null,savedTopic=null,addedTopic=null;function clicked(e,p){if(null==e||e.preventDefault(),zooming)return;if(!isZoomedIn&&highlightedGoals&&highlightedGoals.includes(p)&&unhighlightLearningGoals(),2===p.depth&&(p=p.parent),clickedTopic=p,confirmationDialogShown)return void shakeConfirmationDialog();svg.attr("viewBox",[0,0,width,isZoomedIn?height:stdHeight]),zooming=!0,focus=focus===p?p=p.parent:p;const appliedHeight=isZoomedIn?height:stdHeight;root.each((d=>{!isZoomedIn&&isSmallScreen&&1===d.depth?d.target={x0:(d.x0-p.x0)/(p.x1-p.x0)*appliedHeight,x1:(d.x1-p.x0)/(p.x1-p.x0)*appliedHeight,y0:d.y0-p.y0,y1:isZoomedIn?d.y1-p.y0:d.parent.y1}:!isZoomedIn&&isSmallScreen&&2===d.depth?d.target={x0:(d.x0-p.x0)/(p.x1-p.x0)*appliedHeight,x1:(d.x1-p.x0)/(p.x1-p.x0)*appliedHeight,y0:isZoomedIn?d.y0-p.y0:depth1Child.parent.y1,y1:d.y1-p.y0}:d.target={x0:(d.x0-p.x0)/(p.x1-p.x0)*appliedHeight,x1:(d.x1-p.x0)/(p.x1-p.x0)*appliedHeight,y0:d.y0-p.y0,y1:d.y1-p.y0}})),isZoomedIn&&isSmallScreen&&root.each((d=>{2===d.depth&&(d.target.y0=depth2Child?depth2Child.y1:d.target.y0,d.target.y1=d.target.y0)}));let t=cell.transition().duration(750).attr("transform",(d=>"translate(".concat(d.target.y0,",").concat(d.target.x0,")")));isSmallScreen&&(isZoomedIn?(addedTopic.classed("visible",!1),text.filter((d=>d===clickedTopic)).text("").append((()=>savedTopic.node())),text.filter((d=>d===clickedTopic)).classed("text-element-clicked",!0).transition().duration(750).attr("y",(d=>rectHeight(d)/2)).attr("x",4).style("font",(d=>"".concat(fontSize(d),"px sans-serif"))).end().then((()=>maintspan.filter((d=>d===clickedTopic)).attr("opacity",1).attr("fill-opacity",1))).catch((()=>{})),addedTopic=null,savedTopic=null):(rect.filter((d=>2===d.depth)).style("display","initial"),savedTopic=maintspan.filter((d=>d===clickedTopic)).classed("invisible",!0),savedTopic.remove(),addedTopic=text.filter((d=>d===clickedTopic)).append("tspan").text((d=>d.data.name)).attr("y",0).attr("x",0).attr("fill",(d=>contrastCorrectedColor(d,.6,2===d.depth))).style("font",(d=>"".concat(rectWidth(d.target)/2,"px sans-serif"))).classed("added-topic-zoomed",!0),text.filter((d=>d===clickedTopic)).classed("text-element-clicked",!1),setTimeout((()=>{!function(){let topicNode=null,topicText=null;addedTopic.each(((_,i,n)=>{topicText=n[i],topicNode=topicText.parentNode.parentNode}));let padding=30;const currentClickedTopic=clickedTopic;for(let em=.2;em>0;em-=.1){if(!(topicText.getBBox().height+2*padding>=topicNode.querySelector(".rect").getBBox().height))return;text.filter((d=>d===currentClickedTopic)).style("letter-spacing","".concat(em,"em"))}let currentSize=parseFloat(text.filter((d=>d===clickedTopic)).style("font").split("p")[0]),minWidth=17;const lastCurrentSize=currentSize;for(;currentSize>minWidth&&topicText.getBBox().height+2*padding>=topicNode.querySelector(".rect").getBBox().height;)currentSize=parseFloat(d3.select(topicText).style("font").split("p")[0]),d3.select(topicText).style("font","".concat(lastCurrentSize-zoomDelta,"px sans-serif"));if(topicText.getBBox().height+2*padding<topicNode.querySelector(".rect").getBBox().height)return;let originalText=addedTopic.html();for(;topicText.getBBox().height+2*padding>=topicNode.querySelector(".rect").getBBox().height;)if(originalText=originalText.substring(0,originalText.length-1),addedTopic.html(originalText+U_ELLIPSIS),originalText.length<1)return}(),addedTopic.filter((d=>d===clickedTopic)).attr("x",(d=>rectWidth(d.target)/2)).attr("y",((d,i,n)=>rectHeight(d.target)/2-n[i].getBBox().width/2+30)),addedTopic.classed("visible",!0)}),750)),toggleUrlButton(urlContainer.filter((d=>d===clickedTopic)),t,!1,!isZoomedIn),toggleUrlButton(urlIconSvg.filter((d=>d===clickedTopic)),t,!0,!isZoomedIn),backArrowSvg.filter((d=>d===clickedTopic)).transition(t).attr("width",(d=>isZoomedIn?0:.8*rectWidth(d.target))).attr("height",(d=>isZoomedIn?0:.8*rectWidth(d.target))).attr("x",(d=>isZoomedIn?0:.1*rectWidth(d.target)))),isZoomedIn?(rect.filter((d=>0===d.depth)).attr("tabindex",0),rect.filter((d=>2===d.depth)).attr("tabindex",null),setDepth1AriaLabel()):(rect.filter((d=>2===d.depth&&d.parent===p)).attr("tabindex",0),rect.filter((d=>0===d.depth)).attr("tabindex",null),rect.filter((d=>1===d.depth&&d!==p)).attr("tabindex",null),rect.filter((d=>1===d.depth&&d===p)).attr("aria-label",(d=>{let content="Topic ".concat(d.data.name,". Progress ").concat(parseInt(100*computeProgress(d)),"%.");return"children"in d&&(content+="".concat(d.children.length," learning goal").concat(d.children.length>1?"s":"",", ")+"press enter to go back to the topic view. Use tab to navigate through it."),content+="".concat(d.data.url?"External url is available, press control and enter to open it.":" "),content}))),rect.transition(t).attr("height",(d=>isZoomedIn?d.x1-d.x0:rectHeight(d.target))).attr("width",(d=>isZoomedIn?d.depth<2||!isSmallScreen?d.y1-d.y0:0:rectWidth(d.target))),toggleUrlButton(urlContainer.filter((d=>2===d.depth)),t,!1,isZoomedIn),toggleUrlButton(urlIconSvg.filter((d=>2===d.depth)),t,!0,isZoomedIn);const currentZoomState=isZoomedIn;let newT=d3.transition().duration(750);if(isStudent){learningGoalProgressBar.transition(t).attr("y",(d=>isZoomedIn?0:rectHeight(d.target)-learningGoalProgressBarHeight(d))).attr("height",(d=>learningGoalProgressBarHeight(d))).attr("width",(d=>{if(isZoomedIn&&isSmallScreen)return 0;let progress=computeProgress(d);return isZoomedIn?rectWidth(d)*progress:!isZoomedIn&&isSmallScreen?computeLearningGoalProgressBarWidth(d,progress):computeLearningGoalProgressBarWidth(d)})),function(t){topicProgressG.transition(t).attr("transform",(d=>{let tempWidth=rectWidth(d.target),tempHeight=rectHeight(d.target);return isZoomedIn&&!isSmallScreen?"translate(".concat(tempWidth-mainCircleWidth-topicCellPadding,", ").concat(tempHeight/2-mainCircleRadius,")"):isZoomedIn&&isSmallScreen?"translate(".concat(rectWidth(d)-mainCircleWidth-topicCellPadding,", ").concat(rectHeight(d)/2-mainCircleRadius,")"):!isZoomedIn&&isSmallScreen?"translate(".concat((width-lastY)/2+lastY-topicProgressSizeFactor()*mainCircleWidth/2,",\n            ").concat(height/2-topicProgressSizeFactor()*mainCircleRadius,")"):"translate(".concat(tempWidth/2-(topicProgressSizeFactor()+1)*mainCircleRadius,",\n      ").concat(tempHeight-4*topicProgressSizeFactor()*mainCircleRadius,")")})),topicProgressContainerBG.transition(t).attr("x",isSmallScreen||isZoomedIn?0:mainCircleRadius).attr("width",isZoomedIn?mainCircleWidth:topicProgressSizeFactor()*mainCircleWidth).attr("height",isZoomedIn?mainCircleWidth:topicProgressSizeFactor()*mainCircleWidth),topicProgressContainer.transition(t).attr("x",isSmallScreen||isZoomedIn?0:mainCircleRadius).attr("width",isZoomedIn?mainCircleWidth:topicProgressSizeFactor()*mainCircleWidth).attr("height",isZoomedIn?mainCircleWidth:topicProgressSizeFactor()*mainCircleWidth),topicProgressTextSvg.transition(t).attr("width",isZoomedIn?subCircleWidth:topicProgressSizeFactor()*subCircleWidth).attr("height",isZoomedIn?subCircleWidth:topicProgressSizeFactor()*subCircleWidth).attr("x",(()=>isZoomedIn?mainCircleRadius-subCircleRadius:!isZoomedIn&&isSmallScreen?topicProgressSizeFactor()*(mainCircleRadius-subCircleRadius):topicProgressSizeFactor()*(mainCircleRadius-subCircleRadius)+mainCircleRadius)).attr("y",isZoomedIn?mainCircleRadius-subCircleRadius:topicProgressSizeFactor()*(mainCircleRadius-subCircleRadius)),topicProgressText.transition(t).style("font","".concat((isZoomedIn?1:topicProgressSizeFactor())*subCircleWidth/2.7,"px sans-serif")).attr("y",isZoomedIn?mainCircleRadius:topicProgressSizeFactor()*mainCircleRadius).attr("x",(()=>isZoomedIn?mainCircleRadius:!isZoomedIn&&isSmallScreen?topicProgressSizeFactor()*mainCircleRadius:(1+topicProgressSizeFactor())*mainCircleRadius))}(t),resetSlider((()=>!0),newT,isZoomedIn);const xAttrSvg=d=>{if(currentZoomState)return isSmallScreen?0:d.proY0;let newVal=computeCircleContainerXPosition(d);return 100===d.data.pro?newVal+1:newVal},yAttrSvg=d=>currentZoomState?(rectHeight(d)-sliderSize(d))/2:computeCircleContainerYPosition(d,!0),widthHeightAttr=d=>currentZoomState?sliderSize(d):circleEnlargeFactor*sliderSize(d),xAttrText=d=>{if(currentZoomState)return isSmallScreen?sliderSize(d)/2:d.proY0+sliderSize(d)/2;let newVal=computeCircleTextXPosition(d);return 100===d.data.pro?newVal+1:newVal},yAttrText=d=>currentZoomState?rectHeight(d)/2:rectHeight(d.target)-4.5,content=d=>d.data.pro+(!currentZoomState||sliderTextShowPercent(d)?"%":""),font=d=>"".concat(sliderTextSize(d,currentZoomState),"px sans-serif");sliderSvg.attr("cursor",isZoomedIn?"":"pointer").transition(newT).attr("x",xAttrSvg).attr("y",yAttrSvg).attr("width",widthHeightAttr).attr("height",widthHeightAttr),sliderText.style("dominant-baseline",isZoomedIn?"central":"auto").text(content).transition(newT).style("font",font).attr("x",xAttrText).attr("y",yAttrText),sliderPath.transition(t).attr("d",isZoomedIn?"M 50 50 m 49, 0 a 49,49 0 1,0 -98,0 a 49,49 0 1,0 98,0":"M 50 100 m 49, 0 a 49,49 0 1,0 -98,0 a 49,49 0 1,0 98,0")}isZoomedIn=!isZoomedIn,maintspan.filter((d=>d.depth>0)).classed("invisible",!0).style("font",(d=>"".concat(fontSize(d),"px sans-serif"))),maintspan.filter((d=>d.depth>0)).transition("reduceWidth").duration(750).attr("width",(d=>d.target.y1-d.target.y0)).end().then((()=>{text.filter((d=>2===d.depth)).style("display","initial"),toggleZoomCursor(),isZoomedIn?isSmallScreen?(maintspan.filter((d=>2===d.depth)).classed("invisible",!1),maintspan.filter((d=>2===d.depth)).call(wrapText,rectWidth(depth2Child.target)-2*topicCellPadding,!1,(el=>computeCircleContainerYPosition(el,!0)-circleEnlargeFactor*sliderSize(el)/4),topicCellPadding),maintspan.filter((d=>1===d.depth)).call(wrapText,depth1Width-2*topicCellPadding,!1,(el=>rectHeight(el.target)-4*topicProgressSizeFactor()*mainCircleRadius),topicCellPadding)):(maintspan.filter((d=>2===d.depth)).call(wrapText,depth2Width-2*topicCellPadding,!1,(el=>computeCircleContainerYPosition(el,!0)+circleEnlargeFactor*sliderSize(el)/4),topicCellPadding),maintspan.filter((d=>1===d.depth)).call(wrapText,depth1Width-2*topicCellPadding,!1,(el=>rectHeight(el.target)-4*topicProgressSizeFactor()*mainCircleRadius),topicCellPadding)):(maintspan.filter((d=>2===d.depth)).call(truncateText,.95*depth2Width,!0),maintspan.filter((d=>1===d.depth)).call(wrapText,depth1Width-mainCircleWidth-3*topicCellPadding,!1,(el=>rectHeight(el.target)),topicCellPadding)),isSmallScreen?(maintspan.filter((d=>1===d.depth)).classed("invisible",!1),setTimeout((()=>{zooming=!1}),100),isZoomedIn&&(maintspan.filter((d=>2===d.depth)).classed("invisible",!1),setTimeout((()=>{zooming=!1}),100))):(maintspan.filter((d=>d.depth>0)).classed("invisible",!1),setTimeout((()=>{zooming=!1}),100))})).catch((()=>{})),isZoomedIn||maintspan.filter((d=>2===d.depth)).transition("resetChild2Align").duration(750).attr("y",(d=>rectHeight(d.target)/2)),maintspan.filter((d=>0===d.depth)).transition("resetTitlePos").duration(750).attr("y",(d=>rectHeight(d.target)/2))}function contrastCorrectedColor(element,alpha,isDoubled){let rgba=parseRGB(color(2===element.depth?element.parent.data.name:element.data.name)),rgb=convertRGBAtoRGB(rgba,"white",alpha),doubledRgb=convertRGBAtoRGB(rgba,rgb,alpha),L1=computeLuminance(rgb),L2=computeLuminance(doubledRgb),blackLuminance=computeLuminance([0,0,0]),whiteLuminance=computeLuminance([240,240,240]),contrastWhite=computeContrastRatio(whiteLuminance,L1),contrastBlack=computeContrastRatio(L1,blackLuminance),contrastWhiteDoubled=computeContrastRatio(whiteLuminance,L2),contrastBlackDoubled=computeContrastRatio(L2,blackLuminance);return isDoubled?contrastWhiteDoubled>contrastBlackDoubled?"rgb(240, 240, 240)":"black":contrastWhite>contrastBlack?"rgb(240, 240, 240)":"black"}function changeUrlFocus(p,el,isFocused){if(zooming||!el||isFocused&&urlEnlarged||!isFocused&&!urlEnlarged||resizingUrl)return;isFocused&&(urlEnlarged=!0),resizingUrl=!0;let t=cell.transition().duration(300);resizeUrlElement(urlContainer.filter((d=>d===p)),isFocused?1.2*urlContainerSize:urlContainerSize,t),resizeUrlElement(urlIconSvg.filter((d=>d===p)),isFocused?1.2*urlIconSize:urlIconSize,t).end().then((()=>{resizingUrl=!1,isFocused||(urlEnlarged=!1)})).catch((()=>{}))}function resizeUrlElement(element,size,trans){return element.transition(trans).attr("width",size).attr("height",size)}function computeProgress(d){if("pro"in d.data)return d.data.pro/100;let percent=0;return d.data.children.forEach((child=>{percent+=child.pro})),d.data.children.length?percent/d.data.children.length/100:0}function toggleUrlButton(el,trans,isIcon,hide){let size=isIcon?urlIconSize:urlContainerSize,viewBox=isIcon?23:urlContainerSize;el.transition(trans).attr("width",hide?1e-4:size).attr("height",hide?1e-4:size).attr("viewBox","0 0 ".concat(viewBox," ").concat(viewBox))}function truncateText(text,width){let begin=arguments.length>2&&void 0!==arguments[2]&&arguments[2];text.each((function(){var text=d3.select(this),line=text.data()[0].data.name.split(/\s+/),x=text.attr("x"),tspan=text.text(null).append("tspan").attr("x",x).attr("dy","0em"),depth=text.data()[0].depth;tspan.text(line.join(" "));let currentWidth=depth<2?2.3*width:1.35*width;for(begin&&(currentWidth=width),tspan.node().getComputedTextLength()>currentWidth&&(line.pop(),line.push(" ..."),tspan.text(line.join(" ")));tspan.node().getComputedTextLength()>currentWidth;)line.pop(),line.pop(),line.push(" ..."),tspan.text(line.join(" "))}))}function truncateTitle(rootText,rootNode,rootTspan){let padding=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,originalText=widgetTitle;for(;rootText.getBBox().height+2*padding>=rootNode.querySelector(".rect").getBBox().height&&(originalText=originalText.substring(0,originalText.length-1),rootTspan.html(originalText+U_ELLIPSIS),!(originalText.length<1)););}function wrapText(element,width,dynamicResizing,computeMaxHeight){let padding=arguments.length>4&&void 0!==arguments[4]?arguments[4]:0,retryN=arguments.length>5&&void 0!==arguments[5]?arguments[5]:0,retry=!1,elDepth=0;if(element.each((function(){var word,text=d3.select(this),nodeData=text.data()[0],line=[],tspan=text.text(null).append("tspan").attr("text-anchor","middle").attr("x",0).attr("dx",0),added=[],textNode=text._groups[0][0];let maxHeight=computeMaxHeight(nodeData);elDepth=nodeData.depth;let{lineHeight:lineHeight,words:words,currentWidth:currentWidth}=handleDynamicResizing(dynamicResizing,nodeData,width);for(;word=words.pop();)if(line.push(word),added.push(word),tspan.html(line.join(" ")),!isZoomedIn&&1===nodeData.depth&&tspan.node().getComputedTextLength()>depth1Width-mainCircleWidth-1.5*topicCellPadding&&1===line.length)retry=!0;else if(tspan.node().getComputedTextLength()>currentWidth&&line.length>1){if(line.pop(),textNode.getBoundingClientRect().height+2*lineHeight>maxHeight){line.pop(),line.push(U_ELLIPSIS),tspan.html(line.join(" "));break}tspan.text(line.join(" ")),line=[word],tspan=text.append("tspan").attr("dy",lineHeight+"px").attr("text-anchor","middle").attr("x",0).html(word)}text.attr("y",(maxHeight-lineHeight*(text.node().childNodes.length-1.5))/2);let someLineNonEmpty=!1;for(let child of text.node().childNodes)d3.select(child).attr("x",padding+width/2),(1===nodeData.depth&&child.getComputedTextLength()>width+1.5*topicCellPadding||child.getBBox().height>rect.filter((d=>d===nodeData)).node().getBBox().height)&&!isZoomInDisabled?(allElementSmallEnough=!1,disableZoomIn()):1===nodeData.depth&&child.getComputedTextLength()>width+1.5*topicCellPadding?allElementSmallEnough=!1:d3.select(child).html()!==String.fromCharCode(8230)&&(someLineNonEmpty=!0);1!==nodeData.depth||someLineNonEmpty||isZoomInDisabled||zoomOutText().then((()=>{allElementSmallEnough=!1,disableZoomIn()})).catch((()=>{}))})),1===elDepth&&retry&&retryN<50)return currentTextZoom-=zoomDelta,maintspan.style("font",(d=>"".concat(fontSize(d),"px sans-serif"))),void wrapText(element,width,dynamicResizing,computeMaxHeight,padding,retryN+1);allElementSmallEnough&&isZoomInDisabled&&enableZoomIn()}function toggleZoomIn(newVal){zoomRightHalfSvg.attr("cursor",isZoomInDisabled?"pointer":"default").on("click",isZoomInDisabled?zoomInText:null),zoomRightHalf.attr("fill",isZoomInDisabled?"url(#gradient-".concat(treemapId,")"):"#ababab"),isZoomInDisabled=newVal}function disableZoomIn(){toggleZoomIn(!0)}function enableZoomIn(){toggleZoomIn(!1)}function createElement(isIcon){let size=isIcon?urlIconSize:urlContainerSize,viewBox=isIcon?23:urlContainerSize;return urlContainerG.append("svg").attr("width",(d=>1===d.depth?size:1e-4)).attr("height",(d=>1===d.depth?size:1e-4)).attr("viewBox","0 0 ".concat(viewBox," ").concat(viewBox)).attr("x",isIcon?1:0).attr("y",isIcon?1:0).classed("urlIconSvg",isIcon).attr("stroke-opacity",(d=>"white"===contrastCorrectedColor(d,.7,!0)?1:.5)).attr("stroke",(d=>isIcon?contrastCorrectedColor(d,.7,!0):"none")).classed(isIcon?"svg-element-icon":"svg-element",!0).attr("fill",(d=>isIcon?"none":color(d.depth>1?d.parent.data.name:d.data.name)))}let colorschemesOpened=!1;function toggleColorSchemes(e){e.preventDefault(),isSmallScreen||colorPaletteBg.transition().duration(100).attr("fill","#fefefe").end().then((()=>colorPaletteBg.transition().duration(100).attr("fill","url(#gradient-".concat(treemapId,")")))).catch((()=>{}));let tempWidth=0;colorschemesOpened?(tempWidth=colorSchemeHolderHeight,colorSchemeSamplePath.transition().ease(d3.easeExp).duration((d=>500+100*d.index)).attr("d",roundedCornersRect(colorSchemeHolderWidth,colorSchemeHolderHeight,tempWidth,colorSchemeHolderHeight,cornerRadius)),colorSchemeBox.transition().ease(d3.easeExp).duration((d=>500+100*d.parentIndex)).attr("x",(colorSchemeHolderWidth-colorBoxWidth)/2).end().then((()=>{colorSchemeSample.transition().ease(d3.easeExp).duration((d=>500+100*d.index)).attr("y",yShift+colorPaletteSize/2-colorSchemeHolderHeight/2).attr("x",(width-lastY-colorSchemeHolderWidth)/2+lastY)})).catch((()=>{}))):(tempWidth=colorSchemeHolderWidth,colorSchemeSample.transition().ease(d3.easeBack).duration((d=>1e3+100*d.index)).attr("y",(d=>useDoubleColumnColorScheme?yShift+2*colorPaletteBgRadius+(colorSchemeHolderHeight+10)*(d.index%Math.ceil(colorSchemesNames.length/2)):yShift+2*colorPaletteBgRadius+(colorSchemeHolderHeight+10)*d.index)).attr("x",(d=>useDoubleColumnColorScheme?d.index<Math.ceil(colorSchemesNames.length/2)?(width-lastY)/4+lastY-colorSchemeHolderWidth/2:3*(width-lastY)/4+lastY-colorSchemeHolderWidth/2:(width-lastY-colorSchemeHolderWidth)/2+lastY)).end().then((()=>{colorSchemeSamplePath.transition().ease(d3.easeExp).duration((d=>500+100*d.index)).attr("d",roundedCornersRect(colorSchemeHolderWidth,colorSchemeHolderHeight,tempWidth,colorSchemeHolderHeight,cornerRadius)),colorSchemeBox.transition().ease(d3.easeExp).duration((d=>500+100*d.parentIndex)).attr("x",(d=>cornerRadius+d.index*colorBoxWidth))})).catch((()=>{}))),colorschemesOpened=!colorschemesOpened}function roundedCornersRect(viewBoxWidth,viewBoxHeight,width,height,radius){return"M ".concat(viewBoxWidth/2,",").concat((viewBoxHeight-height)/2,"\nh ").concat(width/2-radius,"\na ").concat(radius," ").concat(radius," 0 0 1 ").concat(radius," ").concat(radius,"\nv ").concat(height-2*radius,"\na ").concat(radius," ").concat(radius," 0 0 1 ").concat(-radius," ").concat(radius,"\nh ").concat(-(width-2*radius),"\na ").concat(radius," ").concat(radius," 0 0 1 ").concat(-radius," ").concat(-radius,"\nv ").concat(-(height-2*radius),"\na ").concat(radius," ").concat(radius," 0 0 1 ").concat(radius," ").concat(-radius," z")}function appendEmptyCirclePath(element,cx,cy,radius,innerRadiusFactor){return element.append("path").attr("d","M ".concat(cx,",").concat(cy," A ").concat(radius," ").concat(radius," 0 1 0 ").concat(cx," ").concat(cy+2*radius," ")+"A ".concat(radius," ").concat(radius," 0 1 0 ").concat(cx," ").concat(cy," Z M ").concat(cx," ").concat(cy+radius/innerRadiusFactor," ")+"A ".concat(radius/innerRadiusFactor," ").concat(radius/innerRadiusFactor," 0 1 1 ").concat(cx," ").concat(cy+3*radius/innerRadiusFactor," ")+"A ".concat(radius/innerRadiusFactor," ").concat(radius/innerRadiusFactor," 0 1 1 ").concat(cx," ").concat(cy+radius/innerRadiusFactor," Z"))}let magnifyIncrease=depth2Child?sliderSize(depth2Child)/3.6:1;function performChanges(e){if(!isZoomedIn||!changingProgress||!objectToMove)return;let svgP=null,xValue=null;sliderSvg.filter((d=>d===objectToMove)).attr("x",((d,idx,nodes)=>{let parent=nodes[idx].parentElement.parentElement,parentRightBorder=parent.childNodes[0].getBoundingClientRect().right,parentLeftBorder=parent.childNodes[0].getBoundingClientRect().left,currentAttribute=parseFloat(d3.select(nodes[idx]).attr("x"));if(e.clientX>parentRightBorder||e.clientX<parentLeftBorder)return currentProgress=e.clientX>parentRightBorder?100:0,currentAttribute=e.clientX<parentLeftBorder?0:circleContainerBarWidth(d,-magnifyIncrease)+1,xValue=currentAttribute,currentAttribute;const pt=d3.select("#"+treemapId).select("svg").node().createSVGPoint();pt.x=e.clientX,svgP=pt.matrixTransform(d3.select("#"+treemapId).select("svg").node().getScreenCTM().inverse());let val=currentAttribute-lastMousePosition+svgP.x;lastMousePosition=svgP.x;let barWidth=circleContainerBarWidth(d,-magnifyIncrease);return val<0&&(val=0),val>barWidth&&(val=barWidth+1),currentProgress=parseInt(100*val/barWidth),xValue=val,val})),learningGoalProgressBar.filter((d=>d===objectToMove)).attr("width",(d=>computeLearningGoalProgressBarWidth(d,currentProgress/100))),sliderText.filter((d=>d===objectToMove)).text(currentProgress+"%").attr("x",(d=>xValue+circleEnlargeFactor*sliderSize(d)/2+magnifyIncrease/2)),sliderAcceptSvg.filter((d=>d===objectToMove)).attr("x",(d=>xValue-circleEnlargeFactor*sliderSize(d))),sliderRejectSvg.filter((d=>d===objectToMove)).attr("x",(d=>xValue-circleEnlargeFactor*sliderSize(d))),topicProgressText.filter((d=>d===objectToMove.parent)).text((d=>{let oldPro=objectToMove.data.pro;objectToMove.data.pro=currentProgress;let newVal="".concat(parseInt(100*computeProgress(d)),"%");return objectToMove.data.pro=oldPro,newVal})),topicProgressPie.filter((d=>d===objectToMove.parent)).attr("d",(d=>{let oldPro=objectToMove.data.pro;objectToMove.data.pro=currentProgress;let angle=2*Math.PI*computeProgress(d);if(objectToMove.data.pro=oldPro,angle===2*Math.PI)return"M 50 50 m 49, 0 a 49,49 0 1,0 -98,0 a 49,49 0 1,0 98,0 ";let sin=Math.sin(angle),cos=Math.cos(angle);return"M 50 50 v -49 A 49,49 0 ".concat(angle>=Math.PI?1:0,",1 ").concat(49*sin+50," ").concat(49*-cos+50," L 50 50 z")}))}function stopChangingProgress(){isZoomedIn&&changingProgress&&(changingProgress=!1,Math.abs(currentProgress-objectToMove.data.pro)<.01||(svg.on("mousemove",null).on("mouseup",null),confirmationBoxesActive?(confirmationDialogShown=!0,toggleConfirmationDialog()):acceptChanges()))}let finalizingChanges=!1;function toggleConfirmationDialog(){finalizingChanges=!0;let t=d3.transition().duration(400).ease(d3.easeBack);sliderRejectCircle.filter((d=>d===objectToMove)).transition(t).style("visibility","visible").attr("cy",(d=>circleEnlargeFactor*sliderSize(d)/2)).attr("cx",(d=>circleEnlargeFactor*sliderSize(d))),sliderRejectIcon.filter((d=>d===objectToMove)).transition(t).style("visibility","visible").attr("y",(d=>circleEnlargeFactor*sliderSize(d)/2-sliderCircleIconSize/2)).attr("x",(d=>circleEnlargeFactor*sliderSize(d)-sliderCircleIconSize/2)),sliderAcceptCircle.filter((d=>d===objectToMove)).transition(t).style("visibility","visible").attr("cy",(d=>circleEnlargeFactor*sliderSize(d)/2)).attr("cx",(d=>2*circleEnlargeFactor*sliderSize(d)+magnifyIncrease)),sliderAcceptIcon.filter((d=>d===objectToMove)).transition(t).style("visibility","visible").attr("x",(d=>2*circleEnlargeFactor*sliderSize(d)+magnifyIncrease-sliderCircleIconSize/2)).attr("y",(d=>circleEnlargeFactor*sliderSize(d)/2-sliderCircleIconSize/2))}function acceptChanges(){objectToMove.data.pro=currentProgress,null!==updateProgressCallback&&updateProgressCallback(this,objectToMove,currentProgress);let t=d3.transition().duration(200).ease(d3.easeBack);t.end().then((()=>{sliderAcceptCircle.style("visibility","hidden"),sliderAcceptIcon.style("visibility","hidden"),sliderRejectCircle.style("visibility","hidden"),sliderRejectIcon.style("visibility","hidden")})).catch((()=>{})),resetSlider((d=>d===objectToMove),t,!1),confirmationDialogShown=!1,reduceSlider(objectToMove),setTimeout((()=>{xTouchStart=-1,currentProgress=null,finalizingChanges=!1}),500)}function changeProgressDegree(prog,sign,startValue,finishValue,el,duration){let actualProg=Math.round(100*prog)/100;topicProgressText.filter((d=>d===el)).transition().duration(duration/(100*Math.abs(finishValue-startValue))).text("".concat(parseInt(100*actualProg),"%")),topicProgressPie.filter((d=>d===el)).transition().duration(duration/(100*Math.abs(finishValue-startValue))).attr("d",(()=>{let newAngle=2*Math.PI*actualProg;if(newAngle===2*Math.PI)return"M 50 50 m 49, 0 a 49,49 0 1,0 -98,0 a 49,49 0 1,0 98,0 z";let sin=Math.sin(newAngle),cos=Math.cos(newAngle);return"M 50 50 v -49 A 49,49 0 ".concat(newAngle>=Math.PI?1:0,",1 ").concat(49*sin+50," ").concat(49*-cos+50," z")})).end().then((()=>{if(Math.round(100*Math.abs(actualProg-finishValue))/100!=0)return changeProgressDegree(null===prog?null:prog+sign,sign,startValue,finishValue,el,duration);currentProgress=null,lastMousePosition=null,confirmationDialogShown=!1})).catch((()=>{}))}let isShaking=!1;function shakeConfirmationDialog(){if(!isShaking){if(isShaking=!0,!confirmationDialogShown)throw new Error("No dialog is open, what is going on");shake(sliderAcceptG.filter((d=>d===objectToMove)),1,4),shake(sliderRejectG.filter((d=>d===objectToMove)),-1,4,!0)}}function shake(element,startValue,recursion){let stopShaking=arguments.length>3&&void 0!==arguments[3]&&arguments[3],t=d3.transition().duration(50);return!recursion&&stopShaking?element.transition(t).attr("transform","").end().then((()=>{isShaking=!1})).catch((()=>{})):recursion?element.transition(t).attr("transform","translate(".concat(1*startValue,",0)")).end().then((()=>shake(element,-1*startValue,recursion-1,stopShaking))):element.transition(t).attr("transform","")}function resizeSlider(e,p){if(!isZoomedIn||confirmationDialogShown||changingProgress||finalizingChanges||zooming)return;let increasing="mouseenter"===e.type,posDiff=0;sliderSvg.filter((d=>d===p)).transition().duration(300).attr("x",(d=>{let rectWidthVal=rectWidth(d.target);if(increasing){let newVal=computeCircleContainerXPosition(d)-magnifyIncrease/2,endVal=newVal+circleEnlargeFactor*sliderSize(d)+magnifyIncrease;return newVal<0?(posDiff=newVal,newVal=0):endVal>rectWidthVal&&(posDiff=endVal-rectWidthVal-1,newVal-=posDiff),newVal}let position=computeCircleContainerXPosition(d);return 100===d.data.pro?position+1:position})).attr("y",(d=>increasing?computeCircleContainerYPosition(d,!0,magnifyIncrease):computeCircleContainerYPosition(d,!0))).attr("width",(d=>increasing?circleEnlargeFactor*sliderSize(d)+magnifyIncrease:circleEnlargeFactor*sliderSize(d))).attr("height",(d=>increasing?circleEnlargeFactor*sliderSize(d)+magnifyIncrease:circleEnlargeFactor*sliderSize(d))),sliderText.filter((d=>d===p)).transition().duration(300).attr("x",((d,idx,nodes)=>increasing?parseFloat(d3.select(nodes[idx]).attr("x"))-posDiff:computeCircleTextXPosition(d)))}function reduceSlider(p){isZoomedIn&&(confirmationDialogShown?shakeConfirmationDialog():(sliderSvg.filter((d=>d===p)).transition().duration(300).attr("x",(d=>computeCircleContainerXPosition(d))).attr("y",(d=>computeCircleContainerYPosition(d,!0))).attr("width",(d=>circleEnlargeFactor*sliderSize(d))).attr("height",(d=>circleEnlargeFactor*sliderSize(d))),sliderText.filter((d=>d===p)).transition().duration(300).attr("x",(d=>computeCircleTextXPosition(d)))))}function computeCircleTextXPosition(d){return computeCircleContainerXPosition(d)+circleEnlargeFactor*sliderSize(d)/2}function circleContainerBarWidth(d){let extraFactor=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return isSmallScreen&&!hasTouchscreen||isSmallScreen?rectWidth(d.target)-circleEnlargeFactor*sliderSize(d)+extraFactor:rectWidth(d)-circleEnlargeFactor*sliderSize(d)+extraFactor}function computeCircleContainerXPosition(d){let extraFactor=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1;return circleContainerBarWidth(d,extraFactor)*d.data.pro/100}function computeCircleContainerYPosition(d){let useTarget=arguments.length>1&&void 0!==arguments[1]&&arguments[1],extraValue=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;return rectHeight(useTarget?d.target:d)-circleEnlargeFactor*sliderSize(d)-extraValue}function computeLearningGoalProgressBarWidth(d){let progress=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;return null===progress&&(progress=d.data.pro/100),progress>=.9?rectWidth(hasTouchscreen&&-1===xTouchStart?d:d.target)*(progress-.05):progress<.05&&progress>0?rectWidth(hasTouchscreen&&-1===xTouchStart?d:d.target)*(progress+.05):rectWidth(hasTouchscreen&&-1===xTouchStart?d:d.target)*progress}function sliderSize(d){return isSmallScreen?Math.min(d.proY1-d.proY0,40):Math.min(d.proY1-d.proY0,56)}function topicProgressSizeFactor(){return!isZoomedIn&&isSmallScreen?1.5*(width-lastY)/((2*mainCircleWidth>100?100/mainCircleWidth:2)*mainCircleWidth):2*mainCircleWidth>100?100/mainCircleWidth:2}function changeSliderSvg(element,smallVersion){return element.attr("width",(d=>smallVersion?sliderSize(d):3*circleEnlargeFactor*sliderSize(d))).attr("height",(d=>smallVersion?sliderSize(d):circleEnlargeFactor*sliderSize(d))).attr("x",(d=>smallVersion?d.proY0:computeCircleContainerXPosition(d)-circleEnlargeFactor*sliderSize(d))).attr("y",(d=>smallVersion?(rectHeight(d)-sliderSize(d))/2:rectHeight(d.target)-circleEnlargeFactor*sliderSize(d)))}function changeSliderCircles(element,smallVersion){return element.attr("cx",(d=>smallVersion?sliderCircleIconSize/2:3*circleEnlargeFactor*sliderSize(d)/2)).attr("cy",(d=>smallVersion?sliderCircleIconSize/2:(circleEnlargeFactor-.5)*sliderSize(d)))}function changeSliderCircleIcon(element,smallVersion){return element.attr("x",(d=>smallVersion?0:(3*circleEnlargeFactor*sliderSize(d)-sliderCircleIconSize)/2)).attr("y",(d=>smallVersion?0:(circleEnlargeFactor-.5)*sliderSize(d)-sliderCircleIconSize/2))}function resetSlider(compFunc,trans,smallVersion){changeSliderSvg(sliderAcceptSvg.filter((d=>compFunc(d))).transition(trans),smallVersion),changeSliderSvg(sliderRejectSvg.filter((d=>compFunc(d))).transition(trans),smallVersion),changeSliderCircles(sliderAcceptCircle.filter((d=>compFunc(d))).transition(trans),smallVersion),changeSliderCircles(sliderRejectCircle.filter((d=>compFunc(d))).transition(trans),smallVersion),changeSliderCircleIcon(sliderAcceptIcon.filter((d=>compFunc(d))).transition(trans),smallVersion),changeSliderCircleIcon(sliderRejectIcon.filter((d=>compFunc(d))).transition(trans),smallVersion)}function setupSliderSvg(parentElement,label,func){return changeSliderSvg(parentElement.append("svg"),!0).attr("aria-label",label).attr("cursor","pointer").attr("fill",(d=>color(d.parent.data.name))).on("click",func)}function setupSliderCircles(parentElement){return changeSliderCircles(parentElement.append("circle"),!0).attr("r",sliderCircleRadius).style("visibility","hidden")}function setupSliderCircleIcon(parentElement,path){let el=changeSliderCircleIcon(parentElement.append("svg"),!0).attr("viewBox","0 0 ".concat(32," ").concat(32)).attr("width",sliderCircleIconSize).attr("height",sliderCircleIconSize).attr("stroke",(d=>contrastCorrectedColor(d,1,!1))).classed("slider-circle",!0);return el.append("path").attr("d","reject"===path?"M6,6 L26,26 M6,26 L26,6":"M2,18 L11,27 L30,5"),el}let isAccessibilityDialogShown=!1;function toggleAccessibilityDialog(e){e.preventDefault(),isSmallScreen||isAccessibilityDialogShown?isSmallScreen||accessibilityCloseBG.transition("blur2-"+treemapId).duration(100).attr("fill","#fefefe").end().then((()=>accessibilityCloseBG.transition().duration(100).attr("fill","url(#gradient-".concat(treemapId,")")))).catch((()=>{})):accessibilityBG.transition("blur-"+treemapId).duration(100).attr("fill","#fefefe").end().then((()=>accessibilityBG.transition().duration(100).attr("fill","url(#gradient-".concat(treemapId,")")))).catch((()=>{})),accessibilityIconG.transition("transform-"+treemapId).duration(700).ease(d3.easePolyInOut.exponent(4)).attr("transform",isAccessibilityDialogShown?"translate(0,0)":"translate(0,-200)"),isAccessibilityDialogShown||blurDiv.style("z-index",50),blurDiv.transition("changeTop-"+treemapId).duration(700).ease(d3.easePolyInOut.exponent(4)).style("top","".concat(isAccessibilityDialogShown?-accessibilityDialogSVGHeight-2*colorPaletteBgRadius:0,"%")).end().then((()=>{isAccessibilityDialogShown||blurDiv.style("z-index",-1)})).catch((()=>{})),isAccessibilityDialogShown=!isAccessibilityDialogShown}function sliderTextSize(el,smallVersion){if(!smallVersion)return circleEnlargeFactor*sliderSize(el)/3.5;let val=sliderTextShowPercent(el)?13:.57*(el.proX1-el.proX0),elSize=sliderSize(el);return.58*val*4>elSize?val=elSize/4/.58:val>elSize&&(val=elSize/2),val}function sliderTextShowPercent(el){return!isSmallScreen&&13<.57*(el.proX1-el.proX0)}function learningGoalProgressBarHeight(d){return isZoomedIn?rectHeight(d.target):isSmallScreen&&isLandscapeMode?.8*Math.min(rectHeight(d.target),12):isSmallScreen?Math.min(rectHeight(d.target),12):Math.min(rectHeight(d),14)}function fontSize(el){var _el$target3,_el$target,_el$target2;return isSmallScreen?isZoomedIn&&0===el.depth?Math.min(rectHeight(el.children[0].target)/6,17.0185)+currentTextZoom:isZoomedIn&&1===el.depth?Math.min(rectHeight(el.target)/6,17.0185)+currentTextZoom+5:isZoomedIn?Math.min(rectHeight(el.target)-.5,12.6302)+currentTextZoom+3:0===el.depth?rectWidth(null!==(_el$target=el.target)&&void 0!==_el$target?_el$target:el)/2+currentTextZoom+5:1===el.depth?Math.min(rectHeight(null!==(_el$target2=el.target)&&void 0!==_el$target2?_el$target2:el)/6,17.0185)+currentTextZoom+5:Math.min(rectHeight(null!==(_el$target3=el.target)&&void 0!==_el$target3?_el$target3:el)-.5,12.6302)+currentTextZoom+3:isZoomedIn&&0===el.depth?Math.min(rectHeight(el.children[0].target)/6,20.0185)+currentTextZoom:isZoomedIn&&1===el.depth?Math.min(rectHeight(el.target)/6,25.0185)+currentTextZoom:isZoomedIn?Math.min(rectHeight(el.target)-.5,20.6302)+currentTextZoom+5:0===el.depth?rectWidth(el)/2+currentTextZoom:1===el.depth?Math.min(rectHeight(el)/6,20.0185)+currentTextZoom:Math.min(rectHeight(el)-.5,11.6302)+currentTextZoom+5}function handleDynamicResizing(dynamicResizing,nodeData,width){let words=nodeData.data.name.split(/\s+/).reverse().filter((el=>el)),lineHeight=fontSize(nodeData),currentWidth=width;return dynamicResizing&&(lineHeight/=4+(1===nodeData.depth?25:8),0===nodeData.depth?(currentWidth=1,words=nodeData.data.name.split("").reverse()):1===nodeData.depth?currentWidth*=.4:currentWidth*=.8),{lineHeight:lineHeight,words:words,currentWidth:currentWidth}}function toggleZoomCursor(){let newCursor=isZoomedIn?"zoom-out":"zoom-in";isStudent&&(topicProgressG.attr("cursor",newCursor),learningGoalProgressBar.attr("cursor",newCursor)),rect.filter((d=>d.depth>0)).attr("cursor",newCursor)}function updateTextFormatting(){maintspan.style("font",(d=>"".concat(fontSize(d),"px sans-serif"))),isZoomedIn&&isSmallScreen?(maintspan.filter((d=>2===d.depth)).call(wrapText,rectWidth(depth2Child.target)-2*topicCellPadding,!1,(el=>computeCircleContainerYPosition(el,!0)+circleEnlargeFactor*sliderSize(el)/4),topicCellPadding),maintspan.filter((d=>1===d.depth)).call(wrapText,depth1Width-2*topicCellPadding,!1,(el=>rectHeight(el.target)-4*topicProgressSizeFactor()*mainCircleRadius),topicCellPadding)):isZoomedIn?(maintspan.filter((d=>2===d.depth)).call(wrapText,depth2Width-2*topicCellPadding,!1,(()=>computeCircleContainerYPosition(depth2Child,!0)+circleEnlargeFactor*sliderSize(depth2Child)/4),topicCellPadding),maintspan.filter((d=>1===d.depth)).call(wrapText,depth1Width-2*topicCellPadding,!1,(el=>rectHeight(el.target)-4*topicProgressSizeFactor()*mainCircleRadius),topicCellPadding)):(maintspan.filter((d=>1===d.depth)).call(wrapText,depth1Width-mainCircleWidth-3*topicCellPadding,!1,(el=>rectHeight(el)),topicCellPadding),maintspan.filter((d=>2===d.depth)).call(truncateText,.95*depth2Width,!0)),maintspan.filter((d=>0===d.depth)).text(widgetTitle),text.filter((d=>0===d.depth)).style("letter-spacing","1em"),rootText.getBBox().height>=rootNode.querySelector(".rect").getBBox().height&&(text.filter((d=>0===d.depth)).style("letter-spacing","0.3em"),rootText.getBBox().height>=rootNode.querySelector(".rect").getBBox().height&&truncateTitle(rootText,rootNode,maintspan.filter((d=>0===d.depth))))}function zoomInText(e){e.preventDefault(),currentTextZoom+=zoomDelta,isSmallScreen?updateTextFormatting():zoomRightHalf.transition().duration(100).attr("fill","#fefefe").end().then((()=>zoomRightHalf.transition().duration(100).attr("fill","url(#gradient-".concat(treemapId,")")).end())).then(updateTextFormatting).catch((()=>{}))}async function zoomOutText(e){e.preventDefault(),currentTextZoom-=zoomDelta,isSmallScreen||zoomLeftHalf.transition().duration(100).attr("fill","#fefefe").end().then((()=>zoomLeftHalf.transition().duration(100).attr("fill","url(#gradient-".concat(treemapId,")")))).catch((()=>{})),updateTextFormatting(),isZoomInDisabled&&enableZoomIn()}function setDepth1AriaLabel(){rect.filter((d=>1===d.depth)).attr("tabindex",0).attr("aria-label",(d=>{let content="Topic ".concat(d.data.name,". Progress ").concat(parseInt(100*computeProgress(d)),"%.");return"children"in d&&(content+="".concat(d.children.length," learning goal").concat(d.children.length>1?"s":"",", press enter to expand the list.\n                   Use tab to navigate through it.")),content+="".concat(d.data.url?"External url is available, press control and enter to open it.":" "),content}))}let xTouchStart=-1;function sliderTouchMove(e){if(!isZoomedIn||!changingProgress)return;e.preventDefault();let svgP=null,xValue=null;sliderSvg.filter((d=>d===objectToMove)).attr("x",((d,idx,nodes)=>{let parent=nodes[idx].parentElement.parentElement,parentRightBorder=parent.childNodes[0].getBoundingClientRect().right,parentLeftBorder=parent.childNodes[0].getBoundingClientRect().left,currentAttribute=parseFloat(d3.select(nodes[idx]).attr("x"));if(e.touches.item(0).clientX>parentRightBorder||e.touches.item(0).clientX<parentLeftBorder)return currentProgress=e.touches.item(0).clientX>parentRightBorder?100:0,currentAttribute=e.touches.item(0).clientX<parentLeftBorder?0:circleContainerBarWidth(d,-magnifyIncrease)+1,xValue=currentAttribute,currentAttribute;const pt=d3.select("#"+treemapId).select("svg").node().createSVGPoint();pt.x=e.touches.item(0).clientX,svgP=pt.matrixTransform(d3.select("#"+treemapId).select("svg").node().getScreenCTM().inverse());let val=currentAttribute-xTouchStart+svgP.x;xTouchStart=svgP.x;let barWidth=circleContainerBarWidth(d,-magnifyIncrease);return val<0&&(val=0),val>barWidth&&(val=barWidth+1),currentProgress=parseInt(100*val/barWidth),xValue=val,val})),learningGoalProgressBar.filter((d=>d===objectToMove)).attr("width",(d=>computeLearningGoalProgressBarWidth(d,currentProgress/100))),sliderText.filter((d=>d===objectToMove)).text(currentProgress+"%").attr("x",(d=>xValue+circleEnlargeFactor*sliderSize(d)/2+magnifyIncrease/2)),sliderAcceptSvg.filter((d=>d===objectToMove)).attr("x",(d=>xValue-circleEnlargeFactor*sliderSize(d))),sliderRejectSvg.filter((d=>d===objectToMove)).attr("x",(d=>xValue-circleEnlargeFactor*sliderSize(d))),topicProgressText.filter((d=>d===objectToMove.parent)).text((d=>{let oldPro=objectToMove.data.pro;objectToMove.data.pro=currentProgress;let newVal="".concat(parseInt(100*computeProgress(d)),"%");return objectToMove.data.pro=oldPro,newVal})),topicProgressPie.filter((d=>d===objectToMove.parent)).attr("d",(d=>{let oldPro=objectToMove.data.pro;objectToMove.data.pro=currentProgress;let angle=2*Math.PI*computeProgress(d);if(objectToMove.data.pro=oldPro,angle===2*Math.PI)return"M 50 50 m 49, 0 a 49,49 0 1,0 -98,0 a 49,49 0 1,0 98,0 ";let sin=Math.sin(angle),cos=Math.cos(angle);return"M 50 50 v -49 A 49,49 0 ".concat(angle>=Math.PI?1:0,",1 ").concat(49*sin+50," ").concat(49*-cos+50," L 50 50 z")}))}}function unhighlightLearningGoals(){d3.select("#"+treemapId).selectAll(".rect").filter((d=>highlightedGoals.includes(d))).attr("class","rect"),d3.select("#"+treemapId).selectAll(".prog-bar").filter((d=>highlightedGoals.includes(d))).attr("class","prog-bar"),highlightedGoals=null}async function setupSvg(){await getSvgNode();let addedSvgs=d3.select("#"+treemapId).selectAll(".mainSvg");for(let i=0;i<addedSvgs._groups[0].length-1;i++)d3.select("#"+treemapId).select(".mainSvg").remove();let addedDivs=d3.select("#"+treemapId).selectAll(".mainDiv");for(let i=0;i<addedDivs._groups[0].length-1;i++)d3.select("#"+treemapId).select(".mainDiv").remove()}function computeContrastRatio(lum1,lum2){return(lum1+.05)/(lum2+.05)}function computeLuminance(rgb){let sRGB=[0,0,0];return rgb.forEach(((color,index)=>{let temp=color/255;sRGB[index]=temp<=.03928?temp/12.92:((temp+.055)/1.055)**2.4})),.2126*sRGB[0]+.7152*sRGB[1]+.0722*sRGB[2]}function convertRGBAtoRGB(rgba,bg,alpha){let returnString=arguments.length>3&&void 0!==arguments[3]&&arguments[3],savedRGBA=rgba;if("string"==typeof bg&&(bg.includes("rgb")||bg.includes("#"))?bg=parseRGB(bg):"string"==typeof bg&&0===bg.localeCompare("black")?bg=[0,0,0]:"string"==typeof bg&&0===bg.localeCompare("white")&&(bg=[255,255,255]),rgba.includes("rgb")||rgba.includes("#")){let rgbaArray=parseRGB(rgba);rgba=rgbaArray.slice(0,3),4===rgbaArray.length&&(alpha=rgbaArray[3])}if(void 0===alpha)throw new Error("Alpha is undefined for color ".concat(savedRGBA));let rgb=[0,0,0];return rgba.forEach(((color,index)=>{rgb[index]=(1-alpha)*bg[index]+alpha*color})),returnString?convertRGBArrayToString(rgb):rgb}function parseRGB(element){let rgb=[0,0,0];if(-1!==element.indexOf("#")){let channelLength=(element.length-1)/3,channelFactor=2===channelLength?1:2;return rgb[0]=parseInt(element.slice(1,channelLength+1).repeat(channelFactor),16),rgb[1]=parseInt(element.slice(channelLength+1,2*channelLength+1).repeat(channelFactor),16),rgb[2]=parseInt(element.slice(2*channelLength+1,3*channelLength+1).repeat(channelFactor),16),rgb}return element.replace(/^(rgb|rgba)\(/,"").replace(/\)$/,"").replace(/\s/g,"").split(",")}function convertRGBArrayToString(colorArray){let str=3===colorArray.length?"rgb(":"rgba(";return colorArray.forEach(((color,index)=>{str+=3===index?parseFloat(color):parseInt(color),index!==colorArray.length-1&&(str+=", ")})),str+")"}function rectWidth(d){return d?d.y1-d.y0-Math.min(1,(d.y1-d.y0)/2):null}function rectHeight(d){return d?d.x1-d.x0-Math.min(1,(d.x1-d.x0)/2):null}var _default={setupTreemap:function(taxonomyObj,d3v7){let id=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"treemap-1",accessibilityText=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"No text found",showConfirmation=arguments.length>4?arguments[4]:void 0,callback=arguments.length>5?arguments[5]:void 0;d3=d3v7,data=taxonomyObj,taxonomy=taxonomyObj,isStudent=taxonomy.student,treemapId=id,treemapaccessibilitytext=accessibilityText,confirmationBoxesActive=showConfirmation,updateProgressCallback=callback,window.onresize=setupSvg},setupSvg:setupSvg};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=treemap_main.min.js.map