define("mod_learninggoalwidget/sunburst",["exports","jquery","mod_learninggoalwidget/controller","core/config","core/notification","core/templates","core/modal_save_cancel","core/modal_events","core/str"],(function(_exports,_jquery,_controller,_config,_notification,_templates,_modal_save_cancel,_modal_events,CoreStr){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * @copyright University of Technology Graz
   * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_controller=_interopRequireDefault(_controller),_config=_interopRequireDefault(_config),_notification=_interopRequireDefault(_notification),_templates=_interopRequireDefault(_templates),_modal_save_cancel=_interopRequireDefault(_modal_save_cancel),_modal_events=_interopRequireDefault(_modal_events),CoreStr=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(CoreStr);var progressModalsDict={};let taxonomy=null;var TEMPLATES_EDIT_PROGRESS_VALUES="mod_learninggoalwidget/widget/sunburst-edit-progress-view",changeView=function(element,sunburstId){"Overview"==element?((0,_jquery.default)(document.querySelector("div[data-region='"+sunburstId+"-content-view']")).removeClass("d-none"),(0,_jquery.default)(document.querySelector("div[data-region='"+sunburstId+"-exam-view']")).addClass("d-none")):((0,_jquery.default)(document.querySelector("div[data-region='"+sunburstId+"-content-view']")).addClass("d-none"),(0,_jquery.default)(document.querySelector("div[data-region='"+sunburstId+"-exam-view']")).removeClass("d-none"))},renderTextualBulletPointList=function(courseTaxonomy,sunburstId){var rootElement=document.getElementById(sunburstId+"-listing-view");rootElement.style.position="relative",addChildren(rootElement,courseTaxonomy.children,sunburstId)},addChildren=function(element,children,sunburstId){var unorderedListNode=document.createElement("ul");unorderedListNode.style="list-style: none",children.forEach((function(child){"topic"==child.type&&appendTopic(sunburstId,(0,_jquery.default)("#"+sunburstId+"-listing-view"),child),"goal"==child.type&&appendGoal(sunburstId,unorderedListNode,child),child.children&&addChildren((0,_jquery.default)("#"+sunburstId+"-listing-view"),child.children,sunburstId)})),(0,_jquery.default)("#"+sunburstId+"-listing-view").append(unorderedListNode)},appendTopic=function(sunburstId,element,topic){var paragraphNode=document.createElement("p");paragraphNode.setAttribute("id",sunburstId+"-topic-"+topic.topicid);var spanNode=document.createElement("span"),topicText="";if(topicText=""!=topic.shortname?topic.shortname+" - "+topic.name:topic.name,topic.url){var urlNode=document.createElement("a");urlNode.setAttribute("href",topic.url),urlNode.setAttribute("target","_blank"),urlNode.textContent=topicText,spanNode.appendChild(urlNode)}else spanNode.textContent=topicText;paragraphNode.appendChild(spanNode),element.append(paragraphNode)},appendGoal=function(sunburstId,element,goal){var listItemNode=document.createElement("li");listItemNode.setAttribute("id",sunburstId+"-goal-"+goal.goalid);var bulletPoint=document.createElement("span");bulletPoint.className="bulletPoint",listItemNode.appendChild(bulletPoint);var goalText="";if(goalText=""!=goal.shortname?goal.shortname+" - "+goal.name:goal.name,goal.url){var urlNode=document.createElement("a");urlNode.setAttribute("href",goal.url),urlNode.setAttribute("target","_blank"),urlNode.textContent=goalText,listItemNode.appendChild(urlNode)}else{var spanNode=document.createElement("span");spanNode.textContent=goalText,listItemNode.appendChild(spanNode)}element.append(listItemNode)},updateItemInTextualHierachy=function(sunburstId,item,color,highlight){let element;if("goal"===item.data.type&&(element=(0,_jquery.default)("#"+sunburstId+"-goal-"+item.data.goalid)),"topic"===item.data.type&&(element=(0,_jquery.default)("#"+sunburstId+"-topic-"+item.data.topicid)),element){let bulletPointElement;highlight?(element.addClass("taxItemHighlighted"),bulletPointElement=element[0].querySelector(".bulletPoint"),bulletPointElement&&color&&(bulletPointElement.style.background=color),item.children&&childrenHighlight(sunburstId,item.children,!0),scrollToTopic(sunburstId,item)):(element.removeClass("taxItemHighlighted"),bulletPointElement=element[0].querySelector(".bulletPoint"),bulletPointElement&&(bulletPointElement.style.background="black"),item.children&&childrenHighlight(sunburstId,item.children,!1))}},scrollToTopic=function(sunburstId,item){let element;if("data"in item&&"type"in item.data){switch(item.data.type){case"goal":element=document.getElementById(sunburstId+"-goal-"+item.data.goalid);break;case"topic":element=document.getElementById(sunburstId+"-topic-"+item.data.topicid);break;default:throw new Error("Unknown type: "+item.data.type)}element.scrollIntoView({behavior:"smooth",block:"nearest"})}},childrenHighlight=function(sunburstId,children,highlight){children.forEach((child=>{let element,bulletPointElement;if("goal"===child.data.type&&(element=(0,_jquery.default)("#"+sunburstId+"-goal-"+child.data.goalid)),"topic"===child.data.type&&(element=(0,_jquery.default)("#"+sunburstId+"-topic-"+child.data.topicid)),element)if(highlight){element.addClass("taxItemHighlighted"),bulletPointElement=element[0].querySelector(".bulletPoint");var color=getColor(percentage(child));bulletPointElement&&color&&(bulletPointElement.style.background=color)}else element.removeClass("taxItemHighlighted"),bulletPointElement=element[0].querySelector(".bulletPoint"),bulletPointElement&&(bulletPointElement.style.background="black");child.children&&childrenHighlight(sunburstId,child.children,highlight)}))},renderSunburstView=function(courseTaxonomy,sunburstId){require(["d3v7"],(function(d3){d3.select("#"+sunburstId+"-taxonomy").append("p").attr("class","skipLine");var div=d3.select("#"+sunburstId+"-container").append("div").attr("id",sunburstId+"-taxonomy-fullgoal").style("opacity",0).style("position","absolute").style("vertical-align","center").style("text-align","center").style("width","12vw").style("min-height","4vh").style("font","sans-serif").style("background","rgb(106, 115, 123)").style("border","1px solid rgb(91, 99, 105)").style("color","white").style("border-radius","0.2rem").style("padding-inline","5px").style("pointer-events","none"),radius=Math.min(360,360)/2,g=d3.select("#"+sunburstId+"-taxonomy").append("svg").attr("class","svgChart").attr("viewBox","0 0 360 360").append("g").attr("transform","translate(180,180)").attr("class","mainG");d3.select("#"+sunburstId+"-text-path-storage").append("svg").attr("id",sunburstId+"-PathBlock").attr("height","0%").attr("width","0%").style("display","none");var partition=d3.partition().size([2*Math.PI,radius]),root=d3.hierarchy(courseTaxonomy).eachBefore((d=>{let sum=1;if(d.depth>0)for(let i=0;i<d.depth;i++){let el=d;for(let j=0;j<i+1;j++)el=el.parent;sum*=el.children.length}d.value=1/sum,d.data.size=d.value}));partition(root);var arc=d3.arc().startAngle((function(d){return d.x0})).endAngle((function(d){return d.x1})).innerRadius((function(d){return d.y0})).outerRadius((function(d){return d.y1}));const container=document.querySelector("#"+sunburstId+"-container");g.selectAll("g").data(root.descendants()).enter().append("g").attr("class","node").append("path").attr("class",(function(d){return d.data.name})).attr("display",(function(d){return d.depth?null:"none"})).style("stroke","#fff").attr("stroke-width","3").style("fill","#e5e5e5").style("cursor",(function(d){return d.data.url?"pointer":"default"})).attr("d",arc).on("mouseover",(function(e,d){const rect=container.getBoundingClientRect();div.transition().duration(200).style("opacity",.95),div.html(d.data.name).style("left",e.clientX-rect.x+"px").style("top",e.clientY-36-rect.y+"px"),updateItemInTextualHierachy(sunburstId,d,getColor(percentage(d)),!0)})).on("mouseout",(function(_,d){div.transition().duration(500).style("opacity",0),updateItemInTextualHierachy(sunburstId,d,getColor(percentage(d)),!1)})).on("click",(function(_,d){if(d.depth>=1){d.data.url&&window.open(d.data.url);const sunburstClickEvent=new CustomEvent("sunburstclick",{bubbles:!0,detail:{data:()=>d.data}});(0,_jquery.default)("#"+sunburstId+"-taxonomy")[0].dispatchEvent(sunburstClickEvent)}})).each((function(d,i){if(d.depth>0){var newArc=function(d,arc){let newArc;if(1==d.depth&&1==d.parent.children.length||2==d.depth&&1==d.parent.children.length&&1==d.parent.parent.children.length)return newArc=arc.replace(/,/g," "),newArc=/^([^A]*A[^A]*)/.exec(newArc)[1],newArc;newArc=/(^.+?)L/.exec(arc)[1],newArc=newArc.replace(/,/g," ");var angle=(d.x0+d.x1)/Math.PI*90;if(angle>90&&angle<270){var newStart=/0 0 1 (.*?)$/.exec(newArc)[1],newEnd=/M(.*?)A/.exec(newArc)[1];return newArc="M"+newStart+"A"+/A(.*?)0 0 1/.exec(newArc)[1]+"0 0 0 "+newEnd,newArc}return newArc}(d,d3.select(this).attr("d"));d3.select("#"+sunburstId+"-PathBlock").append("path").attr("id",sunburstId+"skillArc_"+i).attr("d",newArc).style("fill","none")}}));var getDepth=nodes=>{var depth=0;return nodes.children&&nodes.children.forEach((d=>{var cur=getDepth(d);cur>depth&&(depth=cur)})),1+depth},VerNum=18/getDepth(root)-1;g.selectAll(".node").data(root.descendants()).append("text").text((d=>{if(d.depth>0&&d.data.size<=.1){var title=d.data.name.toString();return d.data.shortname.length>0&&(title=d.data.shortname),title.length>VerNum?title.substring(0,VerNum)+"...":title}})).attr("transform",(d=>{if(d.depth>0&&d.data.size<=.1)return"translate("+arc.centroid(d)+")rotate("+function(d){var angle=(d.x0+d.x1)/Math.PI*90;return angle<=90&&angle>=0?angle-90:angle>90&&angle<180?-1*(90-angle):angle>=180?angle-270:0}(d)+")"})).style("font-size",12).style("pointer-events","none").attr("dx","-20").attr("dy",".5em");var maxLetters=90;courseTaxonomy.children.length>1&&(maxLetters-=2*courseTaxonomy.children.length),g.selectAll(".node").data(root.descendants()).append("text").attr("dy",(function(d){if(1==d.depth&&1==d.parent.children.length||2==d.depth&&1==d.parent.children.length&&1==d.parent.parent.children.length)return 30;var angle=(d.x0+d.x1)/Math.PI*90;return angle>90&&angle<270?-25:30})).append("textPath").attr("xlink:href",(function(d,i){return"#"+sunburstId+"skillArc_"+i})).style("text-anchor","middle").attr("startOffset","50%").style("font-size",12).style("pointer-events","none").attr("letter-spacing",2.75).text((d=>{if(d.depth>0&&d.data.size>.1){var CharNum=Math.round(d.data.size*maxLetters),title=d.data.name;return d.data.shortname.length>0&&(title=d.data.shortname),title.length>CharNum?title.substring(0,CharNum-3)+"...":title}}))}))},renderSunburstWithProgressView=function(courseTaxonomy,sunburstId,progresslegendlabel){require(["d3v7"],(function(d3){d3.select("#"+sunburstId+"-taxonomy-userprogress-chart").append("p").attr("class","skipLine");var div=d3.select("#"+sunburstId+"-container").append("div").attr("id",sunburstId+"-taxonomy-userprogress-chart-fullgoal").style("opacity",0).style("position","absolute").style("vertical-align","center").style("text-align","center").style("width","12vw").style("min-height","4vh").style("font","sans-serif").style("background","rgb(106, 115, 123)").style("border","1px solid rgb(91, 99, 105)").style("color","white").style("border-radius","0.2rem").style("padding-inline","5px").style("pointer-events","none"),radius=Math.min(360,360)/2,g=d3.select("#"+sunburstId+"-taxonomy-userprogress-chart").append("svg").attr("class","svgChart").attr("viewBox","0 0 360 360").append("g").attr("transform","translate(180,180)").attr("class","mainG"),partition=d3.partition().size([2*Math.PI,radius]);let root=d3.hierarchy(courseTaxonomy).eachBefore((d=>{let sum=1;if(d.depth>0)for(let i=0;i<d.depth;i++){let el=d;for(let j=0;j<i+1;j++)el=el.parent;sum*=el.children.length}d.value=1/sum,d.data.size=d.value}));partition(root);var arc=d3.arc().startAngle((function(d){return d.x0})).endAngle((function(d){return d.x1})).innerRadius((function(d){return d.y0})).outerRadius((function(d){return d.y1}));const container=document.querySelector("#"+sunburstId+"-container");g.selectAll("g").data(root.descendants()).enter().append("g").attr("class","node").append("path").attr("class",(function(d){return d.data.name})).attr("display",(function(d){return d.depth?null:"none"})).style("stroke","#fff").attr("stroke-width","3").style("fill",(d=>{var per=percentage(d);return null==per?getColor(0):per.toString().length>0?getColor(per):void 0})).style("cursor",(d=>{if(!d.children)return"pointer"})).attr("id",((d,i)=>{if(1==d.depth)return"ArcNum"+i})).attr("d",arc).on("mouseover",((e,d)=>{const rect=container.getBoundingClientRect();div.transition().duration(200).style("opacity",.95),div.html(d.data.name).style("left",e.clientX-rect.x+"px").style("top",e.clientY-36-rect.y+"px"),updateItemInTextualHierachy(sunburstId,d,getColor(percentage(d)),!0)})).on("mouseout",((_,d)=>{div.transition().duration(500).style("opacity",0),updateItemInTextualHierachy(sunburstId,d,getColor(percentage(d)),!1)})).on("click",(async function(e,d){if(2===d.depth){var instanceid=getInstanceId(this),sunburstId=getSunburstId(this),goalId=d.data.goalid,goalProgressValue=0,topicId=d.parent.data.topicid,modalId=(new Date).getTime(),context={progressValue:d.data.pro,modalId:modalId},modalProgress=progressModalsDict[d.data.name];if(modalProgress)modalProgress.show();else{const modalTitle=await CoreStr.get_string("editprogress","mod_learninggoalwidget"),modal=await _modal_save_cancel.default.create({title:"".concat(modalTitle," '").concat(d.data.name,"':"),body:_templates.default.render(TEMPLATES_EDIT_PROGRESS_VALUES,context)});progressModalsDict[d.data.name]=modal,modal.getRoot().on(_modal_events.default.save,(function(e){e.preventDefault(),goalProgressValue=document.getElementById("progressvalue-"+modalId).value,saveProgress(sunburstId,instanceid,topicId,goalId,goalProgressValue),modal.hide()})),modal.getRoot().find("progressvalue-"+modalId),(0,_jquery.default)(modal.getRoot()).on("input","#progressvalue-"+modalId,(function(){updateLearningProgress(modalId)})),modal.show()}}}));var getDepth=function(nodes){var depth=0;return nodes.children&&nodes.children.forEach((function(d){var cur=getDepth(d);cur>depth&&(depth=cur)})),1+depth},VerNum=18/getDepth(root)-1;g.selectAll(".node").data(root.descendants()).append("text").style("pointer-events","none").text((d=>{if(d.depth>0&&d.data.size<=.1){var title=d.data.name.toString(),per=percentage(d);return null!==per&&per.toString().length>0&&(title=d.data.shortname.length>0?per+"% "+d.data.shortname:per+"% "+title),d.depth>1&&(VerNum=28/getDepth(root)-1),title.length>VerNum?title.substring(0,VerNum)+"...":title}})).attr("transform",(d=>{if(d.depth>0&&d.data.size<=.1)return"translate("+arc.centroid(d)+")rotate("+function(d){var angle=(d.x0+d.x1)/Math.PI*90;return angle<=90&&angle>=0?angle-90:angle>90&&angle<180?-1*(90-angle):angle>=180?angle-270:0}(d)+")"})).style("font-size",(function(d){return d.depth>1?10:12})).attr("dx","-20").attr("dy",".5em");var maxLetters=90;courseTaxonomy.children.length>1&&(maxLetters-=2*courseTaxonomy.children.length),g.selectAll(".node").data(root.descendants()).append("text").style("pointer-events","none").attr("dy",(function(d){if(1==d.depth&&1==d.parent.children.length||2==d.depth&&1==d.parent.children.length&&1==d.parent.parent.children.length)return 30;var angle=(d.x0+d.x1)/Math.PI*90;return angle>90&&angle<270?-25:30})).append("textPath").attr("xlink:href",(function(d,i){return"#"+sunburstId+"skillArc_"+i})).style("text-anchor","middle").attr("startOffset","50%").style("font-size",(function(d){return d.depth>1?10:12})).attr("letter-spacing",2.75).text((d=>{if(d.depth>0&&d.data.size>.1){var CharNum=Math.round(d.data.size*maxLetters),title=d.data.name;return d.data.shortname.length>0&&(title=d.data.shortname),title.length>CharNum?title.substring(0,CharNum-3)+"...":title}})),g.selectAll(".node").data(root.descendants()).append("text").style("pointer-events","none").attr("dy",(function(d){if(1==d.depth&&1==d.parent.children.length||2==d.depth&&1==d.parent.children.length&&1==d.parent.parent.children.length)return 40;var angle=(d.x0+d.x1)/Math.PI*90;return angle>90&&angle<270?-10:50})).append("textPath").attr("xlink:href",(function(d,i){return"#"+sunburstId+"skillArc_"+i})).style("text-anchor","middle").attr("startOffset","50%").style("font-size",(function(d){return d.depth>1?10:12})).attr("letter-spacing",2.75).text((d=>{if(d.depth>0&&d.data.size>.1){var per=percentage(d);if(null!==per&&per.toString().length>0)return per+"%"}}));let legendSvg=d3.select("#"+sunburstId+"-taxonomy-userprogress-legend").append("svg").attr("class","svgLegend").attr("viewBox","0 0 360 45");legendSvg.append("defs").append("linearGradient").attr("id","legendGradientMulti").attr("x1","0%").attr("y1","0%").attr("x2","100%").attr("y2","0%").selectAll("stop").data([{offset:"0%",color:getColorForPercentage(0)},{offset:"12.5%",color:getColorForPercentage(.125)},{offset:"25%",color:getColorForPercentage(.25)},{offset:"37.5%",color:getColorForPercentage(.375)},{offset:"50%",color:getColorForPercentage(.5)},{offset:"62.5%",color:getColorForPercentage(.625)},{offset:"75%",color:getColorForPercentage(.75)},{offset:"87.5%",color:getColorForPercentage(.875)},{offset:"100%",color:getColorForPercentage(1)}]).enter().append("stop").attr("offset",(function(d){return d.offset})).attr("stop-color",(function(d){return d.color}));var legendSvgWrapper=legendSvg.append("g").attr("class","legendWrapper").attr("transform","translate(180,20)");legendSvgWrapper.append("rect").attr("class","legendRect").attr("x",-90).attr("y",0).attr("rx",4).attr("width",180).attr("height",8).style("fill","url(#legendGradientMulti)"),legendSvgWrapper.append("text").attr("class","legendTitle").attr("x",0).attr("y",-8).style("text-anchor","middle").text(progresslegendlabel);var scale=d3.scaleLinear().range([-90,90]).domain([0,100]),xAxis=d3.axisBottom().ticks(5).tickFormat((function(d){return d+"%"})).scale(scale);legendSvgWrapper.append("g").attr("class","axis").attr("transform","translate(0,8)").call(xAxis)}))},percentColors=[{pct:0,color:{r:204,g:0,b:0}},{pct:.5,color:{r:255,g:255,b:0}},{pct:1,color:{r:0,g:102,b:0}}],getColorForPercentage=function(pct){let i;for(i=1;i<percentColors.length-1&&!(pct<percentColors[i].pct);i++);var lower=percentColors[i-1],upper=percentColors[i],range=upper.pct-lower.pct,rangePct=(pct-lower.pct)/range,pctLower=1-rangePct,pctUpper=rangePct;return"#"+((1<<24)+(Math.floor(lower.color.r*pctLower+upper.color.r*pctUpper)<<16)+(Math.floor(lower.color.g*pctLower+upper.color.g*pctUpper)<<8)+Math.floor(lower.color.b*pctLower+upper.color.b*pctUpper)).toString(16).slice(1)},getColor=function(value){if(null==value)return"";if(!taxonomy.student)return"#e5e5e5";switch(!0){case value<=0:return"#e5e5e5";case value<=12.5:return getColorForPercentage(.125);case value<=25:return getColorForPercentage(.25);case value<=37.5:return getColorForPercentage(.375);case value<=50:case value<=62.5:return getColorForPercentage(.5);case value<=75:return getColorForPercentage(.75);case value<=87.5:case value<=100:return getColorForPercentage(.875);default:throw new Error("Cant get the coloring, the progress value is over 100% !")}},percentage=function(d){if(d.children){for(var sum=0,i=0;i<d.children.length;i++)sum+=percentage(d.children[i]);return void 0===(sum=Math.round(sum/d.children.length))||isNaN(sum)?"":sum}return d.data.pro},saveProgress=function(sunburstId,instanceid,topicId,goalId,goalProgressValue){_controller.default.updateUserProgress({instanceid:instanceid,topicid:topicId,goalid:goalId,progress:goalProgressValue}).then((taxonomy=>{var loadedTaxonomy=JSON.parse(taxonomy);if(loadedTaxonomy.children.length>0){(0,_jquery.default)("div#"+sunburstId+"-taxonomy-userprogress-chart-fullgoal").remove(),(0,_jquery.default)("#"+sunburstId+"-taxonomy-userprogress-chart").empty(),(0,_jquery.default)("#"+sunburstId+"-taxonomy-userprogress-legend").empty(),renderSunburstWithProgressView(loadedTaxonomy,sunburstId);const updateLearningGoalProgressEvent=new CustomEvent("update_learning_goal_progress",{bubbles:!0,detail:{sender:"sunburst",taxonomy:loadedTaxonomy,sunburstId:sunburstId}});(0,_jquery.default)("#"+sunburstId+"-taxonomy")[0].dispatchEvent(updateLearningGoalProgressEvent)}})).catch(_notification.default.exception)},updateLearningProgress=function(modalId){var progressvalue=document.getElementById("progressvalue-"+modalId),progressvaluelabel=document.getElementById("progressvaluelabel-"+modalId);progressvalue&&progressvaluelabel&&(progressvaluelabel.innerHTML=progressvalue.value+"%")},getSunburstId=function(element){var learningGoalWidgetElement=(0,_jquery.default)(element).closest("div.learninggoalwidget");return(0,_jquery.default)(learningGoalWidgetElement).data("sunburst-id")},getInstanceId=function(element){var learningGoalWidgetElement=(0,_jquery.default)(element).closest("div.learninggoalwidget");return(0,_jquery.default)(learningGoalWidgetElement).data("instance-id")},_default={renderSunburst:function(sunburstId,userid,courseid,coursemoduleid,instanceid,progresslegendlabel){require.config({paths:{d3v7:_config.default.wwwroot+"/mod/learninggoalwidget/js/d3.v7.min"}}),_controller.default.getLearningGoals({instanceid:instanceid}).then((jsonLearningGoals=>{var loadedTaxonomy=JSON.parse(jsonLearningGoals);taxonomy=loadedTaxonomy,loadedTaxonomy.children.length>0&&(renderSunburstView(loadedTaxonomy,sunburstId),renderTextualBulletPointList(loadedTaxonomy,sunburstId));const progressButton=document.getElementById(sunburstId+"-ClickedPreparation");return loadedTaxonomy.student?(renderSunburstWithProgressView(loadedTaxonomy,sunburstId,progresslegendlabel),progressButton.onclick=function(){changeView("Preparation",getSunburstId(this))}):progressButton.remove(),0})).catch(_notification.default.exception),document.getElementById(sunburstId+"-ClickedOverview").onclick=function(){changeView("Overview",getSunburstId(this))},document.querySelector("div[data-region='"+sunburstId+"-content-view']").parentElement.style.position="relative",document.querySelector("div[data-region='"+sunburstId+"-content-view']").style.width="33%",document.querySelector("div[data-region='"+sunburstId+"-content-view']").style.height="100%",document.querySelector("div[data-region='"+sunburstId+"-exam-view']").style.width="33%",document.querySelector("div[data-region='"+sunburstId+"-exam-view']").style.height="100%",(0,_jquery.default)(document.querySelector("div[data-region='"+sunburstId+"-content-view']")).removeClass("d-none"),(0,_jquery.default)(document.querySelector("div[data-region='"+sunburstId+"-exam-view']")).addClass("d-none")},renderSunburstWithProgressView:renderSunburstWithProgressView,UpdateLearningProgress:updateLearningProgress};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=sunburst.min.js.map