<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Trait shared by topics and goals
 *
 * @package   mod_learninggoalwidget
 * @copyright 2025 Know Center GmbH
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace mod_learninggoalwidget\local;

/**
 * Trait shared by topics and goals
 *
 * @package   mod_learninggoalwidget
 * @copyright 2025 Know Center GmbH
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
trait shared {
    /**
     * Check that a child obj has the properties
     * - name (str)
     * - shortname (str)
     * - url (str)
     * - ranking (int)
     *
     * @param stdClass $child Child to check
     * @return bool is child valid
     */
    public static function validate_children_properties(&$child) {
        // Ensure required properties exist and have correct types.
        $isvalid = true;
        if (!(isset($child->name) && is_string($child->name))) {
            $isvalid = false;
            $child->namevalid = false;
        }
        if (!(isset($child->shortname) && is_string($child->shortname))) {
            $isvalid = false;
            $child->shortnamevalid = false;
        }
        if (!(isset($child->url) && is_string($child->url))) {
            $isvalid = false;
            $child->urlvalid = false;
        }
        if (!(isset($child->ranking) && is_int($child->ranking))) {
            $isvalid = false;
            $child->rankingvalid = false;
        }

        $child->valid = $isvalid;
        return $child->valid;
    }
}
