define("tool_vault/vault",["exports","core/modal_factory","core/modal_events","core/templates","core/notification","core/str","core/pending","core/fragment"],(function(_exports,_modal_factory,_modal_events,_templates,_notification,_str,_pending,_fragment){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Javascript events for the `tool_vault` subsystem.
   *
   * @module tool_vault/vault
   * @copyright 2022 Marina Glancy
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.initStartRestore=_exports.initStartDryRun=_exports.initStartBackup=_exports.initResumeRestore=_exports.initCollapseExpandBackupLogs=void 0,_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events),_templates=_interopRequireDefault(_templates),_notification=_interopRequireDefault(_notification),_pending=_interopRequireDefault(_pending),_fragment=_interopRequireDefault(_fragment);const SELECTORS_START_BACKUP='form[data-action="startbackup"]',SELECTORS_START_DRYRUN='form[data-action="startdryrun"]',SELECTORS_START_RESTORE='form[data-action="startrestore"]',SELECTORS_RESUME_RESTORE='form[data-action="resumerestore"]',submitForm=(backupForm,modal)=>{const popupBody=modal.getBody()[0];for(let i of["passphrase","description","bucket","expiredays"]){const el1=popupBody.querySelector('[name="'.concat(i,'"]')),el2=backupForm.querySelector('input[name="'.concat(i,'"]'));el1&&el2&&(el2.value=el1.value)}backupForm.setAttribute("action",backupForm.getAttribute("data-url")),backupForm.submit()};_exports.initStartBackup=()=>{const backupForm=document.querySelector(SELECTORS_START_BACKUP);if(!backupForm)return;const contextid=backupForm.getAttribute("data-contextid");backupForm.addEventListener("submit",(async event=>{event.preventDefault();const pendingPromise=new _pending.default("tool/vault:startBackupPopup"),[title,tempBody,saveButtonText]=await(0,_str.get_strings)([{key:"startbackup",component:"tool_vault"},{key:"pleasewait",component:"tool_vault"},{key:"startbackup",component:"tool_vault"}]),fragment=await async function(title,tempBody,fragmentName,contextid){let args=arguments.length>4&&void 0!==arguments[4]?arguments[4]:{},activeModal=null,fragment=null;try{activeModal=await _modal_factory.default.create({type:_modal_factory.default.types.CANCEL,title:title,body:tempBody}),activeModal.show(),fragment=await _fragment.default.loadFragment("tool_vault",fragmentName,contextid,args),activeModal.destroy()}catch(e){activeModal?activeModal.setBody(e.message):_notification.default.exception(e)}return fragment}(title,tempBody,"start_backup",contextid);if(!fragment)return void pendingPromise.resolve();const modal=await _modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:title,body:fragment,buttons:{save:saveButtonText},removeOnClose:!0});modal.show(),modal.getRoot().on(_modal_events.default.save,(()=>submitForm(backupForm,modal))),modal.getRoot().on(_modal_events.default.cancel,(()=>modal.hide())),pendingPromise.resolve()}))};_exports.initStartDryRun=backupkey=>{const dryrunForm=document.querySelector(SELECTORS_START_DRYRUN+'[data-backupkey="'.concat(backupkey,'"]'));dryrunForm&&dryrunForm.addEventListener("submit",(event=>{event.preventDefault(),_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:(0,_str.get_string)("startdryrun","tool_vault"),body:_templates.default.render("tool_vault/start_restore_popup",{dryrun:1,encrypted:parseInt(dryrunForm.getAttribute("data-encrypted"))}),buttons:{save:(0,_str.get_string)("startdryrun","tool_vault")},removeOnClose:!0}).then((function(modal){return modal.show(),modal.getRoot().on(_modal_events.default.save,(()=>submitForm(dryrunForm,modal))),modal.getRoot().on(_modal_events.default.cancel,(()=>modal.hide())),modal})).catch(_notification.default.exception)}))};_exports.initStartRestore=backupkey=>{const restoreForm=document.querySelector(SELECTORS_START_RESTORE+'[data-backupkey="'.concat(backupkey,'"]'));restoreForm&&restoreForm.addEventListener("submit",(event=>{event.preventDefault(),_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:(0,_str.get_string)("startrestore","tool_vault"),body:_templates.default.render("tool_vault/start_restore_popup",{dryrun:0,encrypted:parseInt(restoreForm.getAttribute("data-encrypted"))}),buttons:{save:(0,_str.get_string)("startrestore","tool_vault")},removeOnClose:!0}).then((function(modal){return modal.show(),modal.getRoot().on(_modal_events.default.save,(()=>submitForm(restoreForm,modal))),modal.getRoot().on(_modal_events.default.cancel,(()=>modal.hide())),modal})).catch(_notification.default.exception)}))};_exports.initResumeRestore=restoreid=>{const restoreForm=document.querySelector(SELECTORS_RESUME_RESTORE+'[data-restoreid="'.concat(restoreid,'"]'));restoreForm&&restoreForm.addEventListener("submit",(event=>{event.preventDefault(),_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:(0,_str.get_string)("resumerestore","tool_vault"),body:_templates.default.render("tool_vault/start_restore_popup",{dryrun:0,resume:1,encrypted:parseInt(restoreForm.getAttribute("data-encrypted"))}),buttons:{save:(0,_str.get_string)("resume","tool_vault")},removeOnClose:!0}).then((function(modal){return modal.show(),modal.getRoot().on(_modal_events.default.save,(()=>submitForm(restoreForm,modal))),modal.getRoot().on(_modal_events.default.cancel,(()=>modal.hide())),modal})).catch(_notification.default.exception)}))};_exports.initCollapseExpandBackupLogs=()=>{const logslong=document.querySelector('[data-vault-purpose="logslong"]'),logsshort=document.querySelector('[data-vault-purpose="logsshort"]');return logslong&&logsshort&&(logslong.querySelector('[data-vault-purpose="togglelogs"]').addEventListener("click",(event=>{event.preventDefault(),logsshort.style.display="block",logslong.style.display="none"})),logsshort.querySelector('[data-vault-purpose="togglelogs"]').addEventListener("click",(event=>{event.preventDefault(),logsshort.style.display="none",logslong.style.display="block"}))),!1}}));

//# sourceMappingURL=vault.min.js.map