<?php
// This file is part of plugin tool_vault - https://lmsvault.io
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Code to be executed after the plugin's database scheme has been installed is defined here.
 *
 * @package     tool_vault
 * @category    upgrade
 * @copyright   2022 Marina Glancy <marina.glancy@gmail.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Custom code to be run on installing the plugin.
 */
function xmldb_tool_vault_install() {

    if (defined('BEHAT_UTIL') && BEHAT_UTIL) {
        // Do not run the checks in every scenario that runs cron,
        // also default timeouts in Behat are not long enough to wait for vault checks.
        return true;
    }

    if (defined('PHPUNIT_UTIL') && PHPUNIT_UTIL) {
        // Run the test only once in tests/install_test.php!
        return true;
    }

    \tool_vault\local\checks\check_base::get_all_checks();

    return true;
}
