define("mod_panopto/getauth",["exports","core/ajax","core/modal","core/str","core/templates"],(function(_exports,_ajax,_modal,_str,_templates){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Polls a web service to obtain a Panopto auth url and redirect the user,
   * and displays a modal with a progress bar while the user is waiting.
   *
   * See templates:   mod_panopto/progress
   *
   * @module      mod_panopto/getauth
   * @class       getauth
   * @copyright   2020 Tony Butler <a.butler4@lancaster.ac.uk>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_ajax=_interopRequireDefault(_ajax),_modal=_interopRequireDefault(_modal),_templates=_interopRequireDefault(_templates);_exports.init=async(contextId,panoptoId)=>{const templateContext={id:panoptoId,idnumber:"panopto_progress",width:400,class:"",value:0,error:0};(await _modal.default.create({title:await(0,_str.getString)("preparing","mod_panopto"),body:await _templates.default.render("core/progress_bar",templateContext),isVerticallyCentered:!0,removeOnClose:!0,show:!0})).getRoot().find(".modal-dialog").css({width:"400px"});const progress=document.getElementById("panopto_progress"),progressBar=document.getElementById("panopto_progress_bar");let intervalId;(()=>{let value=progressBar.getAttribute("value");intervalId=setInterval((()=>{if(progressBar.getAttribute("value")<100&&value<99.9){value+=1-value/100;const increment=new CustomEvent("update",{detail:{percent:value}});progress.dispatchEvent(increment)}else clearInterval(intervalId)}),100)})();const getAuthUrl=async(contextId,panoptoId)=>{const request=_ajax.default.call([{methodname:"mod_panopto_get_auth",args:{contextid:contextId,panoptoid:panoptoId}}]);try{const authUrl=await request[0];if("string"==typeof authUrl){const done=new CustomEvent("update",{detail:{percent:100}});progress.dispatchEvent(done),window.location.replace(authUrl)}setTimeout((()=>{getAuthUrl(contextId,panoptoId)}),1e3)}catch(exception){const message=await(0,_str.getString)(exception.errorcode,"mod_panopto"),failed=new CustomEvent("update",{detail:{percent:0,error:1,message:message}});progress.dispatchEvent(failed),clearInterval(intervalId);document.getElementById("panopto_progress_status").classList.remove("text-truncate")}};await getAuthUrl(contextId,panoptoId)}}));

//# sourceMappingURL=getauth.min.js.map