<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Renders the HTML to display an instance of mod_panopto.
 *
 * @package     mod_panopto
 * @copyright   2020 Tony Butler <a.butler4@lancaster.ac.uk>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace mod_panopto\output;

use core\output\plugin_renderer_base;

/**
 * Panopto renderer class.
 *
 * @package     mod_panopto
 * @copyright   2020 Tony Butler <a.butler4@lancaster.ac.uk>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class renderer extends plugin_renderer_base {
    /**
     * Renders a Panopto instance.
     *
     * @param panopto $panopto Panopto renderable
     * @return string The HTML to output
     */
    protected function render_panopto(panopto $panopto) {
        if (!has_capability('mod/panopto:view', $panopto->context)) {
            return $this->output->notification(get_string('nopermissions', 'mod_panopto'), 'error');
        }

        $params = [
            'contextid' => $panopto->context->id,
            'panoptoid' => $panopto->id,
        ];
        $this->page->requires->js_call_amd('mod_panopto/getauth', 'init', $params);

        return $this->output->container('', '', 'panopto_info');
    }
}
