/**
 * Scroll to highlighted text in course modules
 *
 * @module     mod_coursesearch/scrolltohighlight
 * @copyright  2025
 * @license    http://www.gnu.org/licenses/gpl-3.0.html GNU GPL v3 or later
 */
define("mod_coursesearch/scrolltohighlight",["jquery"],(function($){let hasHighlighted=!1;function getVisibleTextNodes(element){const walker=document.createTreeWalker(element,NodeFilter.SHOW_TEXT,{acceptNode:function(node){return node.textContent.trim()?function(el,boundary){let parent=el;for(;parent&&parent!==boundary;){const classList=parent.classList,style=window.getComputedStyle(parent);if(classList.contains("sr-only")||classList.contains("visually-hidden")||classList.contains("hidden")||"none"===style.display||"hidden"===style.visibility||"absolute"===style.position&&"rect(0px, 0px, 0px, 0px)"===style.clip)return!0;parent=parent.parentElement}return!1}(node.parentElement,element)?NodeFilter.FILTER_REJECT:NodeFilter.FILTER_ACCEPT:NodeFilter.FILTER_REJECT}},!1);let node;const textNodes=[];for(;null!==(node=walker.nextNode());)textNodes.push(node);return textNodes}function applyHighlight(el){const originalBg=el.style.backgroundColor;el.style.setProperty("background-color","#ffff99","important"),setTimeout((function(){originalBg?el.style.setProperty("background-color",originalBg):el.style.removeProperty("background-color")}),3e3)}function findHighlightParent(node,boundary,validTags){let parent=node.parentElement;for(;parent&&parent!==boundary&&parent!==document.body;){const tagName=parent.tagName.toUpperCase();if(validTags.includes(tagName))break;parent=parent.parentElement}return parent&&parent!==boundary&&parent!==document.body&&parent!==document.documentElement?parent:null}function scrollToText(element,searchText){if(!element||!searchText)return!1;const textNodes=getVisibleTextNodes(element),searchLower=searchText.toLowerCase(),normalizedSearch=searchLower.replace(/[\u00A0\s]+/g," ");let combinedText="";for(let i=0;i<textNodes.length;i++)combinedText+=textNodes[i].textContent;const combinedIndex=combinedText.replace(/[\u00A0\s]+/g," ").toLowerCase().indexOf(normalizedSearch);if(-1!==combinedIndex){let foundNodeIndex=-1;for(let i=0;i<textNodes.length;i++){if(-1!==textNodes[i].textContent.replace(/[\u00A0\s]+/g," ").toLowerCase().indexOf(normalizedSearch)){foundNodeIndex=i;break}}if(-1===foundNodeIndex){const firstWord=normalizedSearch.split(" ")[0];let charCount=0;const nodePositions=[];for(let i=0;i<textNodes.length;i++){const normalizedNode=textNodes[i].textContent.replace(/[\u00A0\s]+/g," ").toLowerCase();nodePositions.push({nodeIndex:i,start:charCount,end:charCount+normalizedNode.length,text:normalizedNode}),charCount+=normalizedNode.length}for(let i=0;i<nodePositions.length;i++){const np=nodePositions[i];if(np.end>combinedIndex&&np.start<=combinedIndex+normalizedSearch.length&&-1!==np.text.indexOf(firstWord)){foundNodeIndex=i;break}}if(-1===foundNodeIndex)for(let i=0;i<nodePositions.length;i++)if(combinedIndex>=nodePositions[i].start&&combinedIndex<nodePositions[i].end){foundNodeIndex=i;break}}if(-1!==foundNodeIndex){const blockTags=["P","DIV","LI","TD","TH","BLOCKQUOTE","ARTICLE","SECTION"],parent=findHighlightParent(textNodes[foundNodeIndex],element,blockTags);if(parent){const rect=parent.getBoundingClientRect(),scrollY=window.scrollY+rect.top-100;return window.scrollTo({top:scrollY,behavior:"smooth"}),applyHighlight(parent),!0}}}for(let i=0;i<textNodes.length;i++){if(-1!==textNodes[i].textContent.toLowerCase().indexOf(searchLower)){const range=document.createRange(),textNode=textNodes[i],originalIndex=textNode.textContent.toLowerCase().indexOf(searchLower);if(-1!==originalIndex)try{range.setStart(textNode,originalIndex),range.setEnd(textNode,originalIndex+searchText.length);const rect=range.getBoundingClientRect(),scrollY=window.scrollY+rect.top-100;window.scrollTo({top:scrollY,behavior:"smooth"});const span=document.createElement("span");span.style.setProperty("background-color","#ffff99","important"),span.style.setProperty("padding","2px","important"),span.style.setProperty("border-radius","2px","important"),span.style.setProperty("color","inherit","important"),span.style.setProperty("display","inline","important"),span.className="coursesearch-highlight-temp";let highlighted=!1;try{(range.startContainer===range.endContainer||range.startContainer.nodeType===Node.TEXT_NODE&&range.endContainer.nodeType===Node.TEXT_NODE)&&(range.surroundContents(span),highlighted=!0,setTimeout((function(){if(span.parentNode){const spanParent=span.parentNode;spanParent.replaceChild(document.createTextNode(span.textContent),span),spanParent.normalize()}}),3e3))}catch(e){highlighted=!1}if(!highlighted){const parent=findHighlightParent(textNode,element,["P","DIV","SPAN","A","LI","TD","TH","LABEL","H1","H2","H3","H4","H5","H6","STRONG","EM","B","I","U"]);parent&&applyHighlight(parent)}return!0}catch(e){const elementTop=element.getBoundingClientRect().top+window.scrollY;return window.scrollTo({top:elementTop-100,behavior:"smooth"}),!0}}}return!1}function init(){if(hasHighlighted)return;let highlightText=new URLSearchParams(window.location.search).get("highlight"),storedModuleId=null;if(!highlightText&&"undefined"!=typeof sessionStorage){const storedHighlight=sessionStorage.getItem("coursesearch_highlight");storedModuleId=sessionStorage.getItem("coursesearch_moduleId");const timestamp=sessionStorage.getItem("coursesearch_timestamp");if(timestamp&&Date.now()-parseInt(timestamp,10)>1e4)return sessionStorage.removeItem("coursesearch_highlight"),sessionStorage.removeItem("coursesearch_moduleId"),sessionStorage.removeItem("coursesearch_timestamp"),void sessionStorage.removeItem("coursesearch_shouldScroll");if(storedHighlight){try{highlightText=JSON.parse(storedHighlight),"string"!=typeof highlightText&&(highlightText=null)}catch(e){highlightText=storedHighlight}sessionStorage.removeItem("coursesearch_highlight"),sessionStorage.removeItem("coursesearch_moduleId"),sessionStorage.removeItem("coursesearch_timestamp"),sessionStorage.removeItem("coursesearch_shouldScroll")}}if(!highlightText)return;hasHighlighted=!0;const searchText=decodeURIComponent(highlightText).trim();searchText&&$(document).ready((function(){setTimeout((function(){(function(searchText){return new Promise((function(resolve){const searchLower=searchText.toLowerCase(),collapsedSections=document.querySelectorAll(".collapse:not(.show)");let foundInCollapsed=null,triggerButton=null;for(let i=0;i<collapsedSections.length;i++){const section=collapsedSections[i];if(-1!==section.textContent.toLowerCase().indexOf(searchLower)){foundInCollapsed=section;const sectionId=section.id;sectionId&&(triggerButton=document.querySelector('[data-target="#'+sectionId+'"]')||document.querySelector('[data-bs-target="#'+sectionId+'"]')||document.querySelector('[href="#'+sectionId+'"]')),!triggerButton&&sectionId&&(triggerButton=document.querySelector('[aria-controls="'+sectionId+'"]'));break}}foundInCollapsed&&triggerButton?($(foundInCollapsed).one("shown.bs.collapse",(function(){setTimeout(resolve,100)})),triggerButton.click(),setTimeout((function(){resolve()}),1e3)):foundInCollapsed?($(foundInCollapsed).collapse("show"),$(foundInCollapsed).one("shown.bs.collapse",(function(){setTimeout(resolve,100)})),setTimeout((function(){resolve()}),1e3)):resolve()}))})(searchText).then((function(){let moduleId=storedModuleId;const hash=window.location.hash;if(!moduleId&&hash){const match=hash.match(/^#module-(\d+)$/);match&&(moduleId=match[1])}if(moduleId&&!/^\d+$/.test(moduleId)&&(moduleId=null),moduleId){const moduleElement=document.getElementById("module-"+moduleId);if(moduleElement){if(!scrollToText(moduleElement,searchText)&&!scrollToText(document.body,searchText)){const elementTop=moduleElement.getBoundingClientRect().top+window.scrollY;window.scrollTo({top:elementTop-100,behavior:"smooth"})}}else scrollToText(document.body,searchText)}else scrollToText(document.body,searchText)}))}),500)}))}function autoInit(){if(-1===window.location.pathname.indexOf("/course/view.php"))return;let highlightText=new URLSearchParams(window.location.search).get("highlight");if(!highlightText&&"undefined"!=typeof sessionStorage){const storedHighlight=sessionStorage.getItem("coursesearch_highlight");if(storedHighlight)try{highlightText=JSON.parse(storedHighlight),"string"!=typeof highlightText&&(highlightText=null)}catch(e){highlightText=storedHighlight}}highlightText&&init()}return"loading"===document.readyState?document.addEventListener("DOMContentLoaded",(function(){setTimeout(autoInit,500)})):setTimeout(autoInit,500),{init:init}}));

//# sourceMappingURL=scrolltohighlight.min.js.map