<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Custom admin setting for floating widget vertical offset with validation.
 *
 * @package    mod_coursesearch
 * @copyright  2025 Yurii Lysak
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// phpcs:ignore moodle.Files.MoodleInternal.MoodleInternalNotNeeded -- Required for Moodle security
defined('MOODLE_INTERNAL') || die();

/**
 * Custom admin setting for floating widget vertical offset with validation.
 *
 * @package    mod_coursesearch
 * @copyright  2025 Yurii Lysak
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class admin_setting_configtext_floatingwidgetoffset extends admin_setting_configtext {
    /**
     * Validate the setting value.
     *
     * @param string $value The value to validate
     * @return mixed True if valid, error string if invalid
     */
    public function validate($value) {
        $value = (int)$value;
        if ($value < 0) {
            return get_string('floatingwidgetverticaloffset_invalid', 'coursesearch');
        }
        return true;
    }
}
