<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This script controls the display of the qpractice reports.
 *
 * @package    mod_qpractice
 * @copyright  2013 Jayesh Anandani
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once(dirname(__FILE__) . '/renderer.php');
require_once("$CFG->libdir/formslib.php");

$sessionid = required_param('sessionid', PARAM_INT); // Course-Module id.
$cmid = required_param('cmid', PARAM_INT); // Course-Module id.


if ($cmid) {
    if (!$cm = get_coursemodule_from_id('qpractice', $cmid)) {
        throw new moodle_exception('invalidcoursemoduleid', 'error', '', $cmid);
    }
    if (!$course = $DB->get_record('course', ['id' => $cm->course])) {
        throw new \moodle_exception('coursemisconf');
    }
    $qpractice = $DB->get_record('qpractice', ['id' => $cm->instance]);
}

require_login($course, true, $cm);

$context = context_module::instance($cm->id);

$report = \core_reportbuilder\system_report_factory::create(
    \mod_qpractice\reportbuilder\local\systemreports\qpractice_session_categories_report::class,
    $context
);

$backurl = new moodle_url('/mod/qpractice/view.php', ['id' => $sessionid]);
$backtext = get_string('backurl', 'qpractice');
$PAGE->set_pagelayout('admin');
$PAGE->set_url('/mod/qpractice/report_by_category.php');

echo $OUTPUT->header();
$t = new html_table();
$t->head = [get_string('category', 'qpractice'), get_string('marksobtained', 'qpractice'), get_string('totalmarks', 'qpractice')];
$t->data = $categories;
$columns = [
    'category_name' => 'category_name',
    'marksobtained' => get_string('marksobtained', 'qpractice'),
    'categorytotal' => get_string('totalmarks', 'qpractice'),
];
$headers = [
    get_string('category', 'qpractice'),
    'Question count',
     'Sum of marks',
];

$table = new flexible_table('questioncategories');
$table->sortable(true, 'category_name', SORT_ASC);
$table->set_control_variables([
    TABLE_VAR_SORT    => 'ssort',
    TABLE_VAR_IFIRST  => 'sifirst',
    TABLE_VAR_ILAST   => 'silast',
    TABLE_VAR_PAGE    => 'spage',
    ]);

$table->no_sorting('select');
$table->no_sorting('status');


$table->define_headers($headers);
$table->define_columns($columns);
$table->column_style('restore', 'text-align', 'center');
$table->column_style('delete', 'text-align', 'center');
$table->define_baseurl($PAGE->url);
$table->set_attribute('id', 'questioncategoryable');
$table->setup();
if ($table->get_sql_sort()) {
    $sort = $table->get_sql_sort();
} else {
    $sort = '';
}


$sql = "SELECT qa.questionid,qa.maxmark, qas.fraction, qbe.questioncategoryid as categoryid FROM {question_usages} qu
        JOIN {question_attempts} qa  ON qa.questionusageid = qu.id
        JOIN {qpractice_session} session ON session.questionusageid = qu.id
        JOIN {question_attempt_steps} qas ON qas.questionattemptid = qa.id
        JOIN {question_versions} qver ON qver.questionid = qa.questionid
        JOIN {question_bank_entries} qbe ON qbe.id = qver.questionbankentryid
        WHERE qu.contextid = :contextid
        AND qas.fraction IS NOT NULL
        AND session.id = :sessionid";
$qusage = $DB->get_records_sql($sql, ['contextid' => $context->id, 'sessionid' => $sessionid]);


$sql = "SELECT distinct qcats.id, qcats.name as category_name, session.totalmarks
        FROM {qpractice} qp
        JOIN {qpractice_session} session ON session.qpracticeid = qp.id
        JOIN {qpractice_session_cats} sessioncats ON session.id = sessioncats.session
        JOIN {question_categories} qcats ON sessioncats.category = qcats.id
        WHERE session.id = :sessionid ";
        $sql .= ' ORDER BY ' . $sort;

$categories = $DB->get_records_sql($sql, ['sessionid' => $sessionid]);

foreach ($categories as $category) {
        $categorytotal = 0;
        $questioncount = 0;
    foreach ($qusage as $q) {
        if ($q->categoryid == $category->id) {
            $categorytotal += $q->fraction;
            $questioncount++;
        }
    }
        $category->questioncount = $questioncount;
        $category->marksobtained = $categorytotal;
}

foreach ($categories as $category) {
    unset($category->id);
    $table->add_data((array) $category);
}

$table->finish_output();

echo $OUTPUT->footer();
