/*!

 diff v7.0.0

BSD 3-Clause License

Copyright (c) 2009-2015, Kevin Decker <kpdecker@gmail.com>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

@license
*/
var global,factory;global=window,factory=function(exports){function Diff(){}function buildValues(diff,lastComponent,newString,oldString,useLongestToken){for(var nextComponent,components=[];lastComponent;)components.push(lastComponent),nextComponent=lastComponent.previousComponent,delete lastComponent.previousComponent,lastComponent=nextComponent;components.reverse();for(var componentPos=0,componentLen=components.length,newPos=0,oldPos=0;componentPos<componentLen;componentPos++){var component=components[componentPos];if(component.removed)component.value=diff.join(oldString.slice(oldPos,oldPos+component.count)),oldPos+=component.count;else{if(!component.added&&useLongestToken){var value=newString.slice(newPos,newPos+component.count);value=value.map((function(value,i){var oldValue=oldString[oldPos+i];return oldValue.length>value.length?oldValue:value})),component.value=diff.join(value)}else component.value=diff.join(newString.slice(newPos,newPos+component.count));newPos+=component.count,component.added||(oldPos+=component.count)}}return components}Diff.prototype={diff:function(oldString,newString){var _options$timeout,options=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},callback=options.callback;"function"==typeof options&&(callback=options,options={});var self=this;function done(value){return value=self.postProcess(value,options),callback?(setTimeout((function(){callback(value)}),0),!0):value}oldString=this.castInput(oldString,options),newString=this.castInput(newString,options),oldString=this.removeEmpty(this.tokenize(oldString,options));var newLen=(newString=this.removeEmpty(this.tokenize(newString,options))).length,oldLen=oldString.length,editLength=1,maxEditLength=newLen+oldLen;null!=options.maxEditLength&&(maxEditLength=Math.min(maxEditLength,options.maxEditLength));var maxExecutionTime=null!==(_options$timeout=options.timeout)&&void 0!==_options$timeout?_options$timeout:1/0,abortAfterTimestamp=Date.now()+maxExecutionTime,bestPath=[{oldPos:-1,lastComponent:void 0}],newPos=this.extractCommon(bestPath[0],newString,oldString,0,options);if(bestPath[0].oldPos+1>=oldLen&&newPos+1>=newLen)return done(buildValues(self,bestPath[0].lastComponent,newString,oldString,self.useLongestToken));var minDiagonalToConsider=-1/0,maxDiagonalToConsider=1/0;function execEditLength(){for(var diagonalPath=Math.max(minDiagonalToConsider,-editLength);diagonalPath<=Math.min(maxDiagonalToConsider,editLength);diagonalPath+=2){var basePath=void 0,removePath=bestPath[diagonalPath-1],addPath=bestPath[diagonalPath+1];removePath&&(bestPath[diagonalPath-1]=void 0);var canAdd=!1;if(addPath){var addPathNewPos=addPath.oldPos-diagonalPath;canAdd=addPath&&0<=addPathNewPos&&addPathNewPos<newLen}var canRemove=removePath&&removePath.oldPos+1<oldLen;if(canAdd||canRemove){if(basePath=!canRemove||canAdd&&removePath.oldPos<addPath.oldPos?self.addToPath(addPath,!0,!1,0,options):self.addToPath(removePath,!1,!0,1,options),newPos=self.extractCommon(basePath,newString,oldString,diagonalPath,options),basePath.oldPos+1>=oldLen&&newPos+1>=newLen)return done(buildValues(self,basePath.lastComponent,newString,oldString,self.useLongestToken));bestPath[diagonalPath]=basePath,basePath.oldPos+1>=oldLen&&(maxDiagonalToConsider=Math.min(maxDiagonalToConsider,diagonalPath-1)),newPos+1>=newLen&&(minDiagonalToConsider=Math.max(minDiagonalToConsider,diagonalPath+1))}else bestPath[diagonalPath]=void 0}editLength++}if(callback)!function exec(){setTimeout((function(){if(editLength>maxEditLength||Date.now()>abortAfterTimestamp)return callback();execEditLength()||exec()}),0)}();else for(;editLength<=maxEditLength&&Date.now()<=abortAfterTimestamp;){var ret=execEditLength();if(ret)return ret}},addToPath:function(path,added,removed,oldPosInc,options){var last=path.lastComponent;return last&&!options.oneChangePerToken&&last.added===added&&last.removed===removed?{oldPos:path.oldPos+oldPosInc,lastComponent:{count:last.count+1,added:added,removed:removed,previousComponent:last.previousComponent}}:{oldPos:path.oldPos+oldPosInc,lastComponent:{count:1,added:added,removed:removed,previousComponent:last}}},extractCommon:function(basePath,newString,oldString,diagonalPath,options){for(var newLen=newString.length,oldLen=oldString.length,oldPos=basePath.oldPos,newPos=oldPos-diagonalPath,commonCount=0;newPos+1<newLen&&oldPos+1<oldLen&&this.equals(oldString[oldPos+1],newString[newPos+1],options);)newPos++,oldPos++,commonCount++,options.oneChangePerToken&&(basePath.lastComponent={count:1,previousComponent:basePath.lastComponent,added:!1,removed:!1});return commonCount&&!options.oneChangePerToken&&(basePath.lastComponent={count:commonCount,previousComponent:basePath.lastComponent,added:!1,removed:!1}),basePath.oldPos=oldPos,newPos},equals:function(left,right,options){return options.comparator?options.comparator(left,right):left===right||options.ignoreCase&&left.toLowerCase()===right.toLowerCase()},removeEmpty:function(array){for(var ret=[],i=0;i<array.length;i++)array[i]&&ret.push(array[i]);return ret},castInput:function(value){return value},tokenize:function(value){return Array.from(value)},join:function(chars){return chars.join("")},postProcess:function(changeObjects){return changeObjects}};var characterDiff=new Diff;function longestCommonPrefix(str1,str2){var i;for(i=0;i<str1.length&&i<str2.length;i++)if(str1[i]!=str2[i])return str1.slice(0,i);return str1.slice(0,i)}function longestCommonSuffix(str1,str2){var i;if(!str1||!str2||str1[str1.length-1]!=str2[str2.length-1])return"";for(i=0;i<str1.length&&i<str2.length;i++)if(str1[str1.length-(i+1)]!=str2[str2.length-(i+1)])return str1.slice(-i);return str1.slice(-i)}function replacePrefix(string,oldPrefix,newPrefix){if(string.slice(0,oldPrefix.length)!=oldPrefix)throw Error("string ".concat(JSON.stringify(string)," doesn't start with prefix ").concat(JSON.stringify(oldPrefix),"; this is a bug"));return newPrefix+string.slice(oldPrefix.length)}function replaceSuffix(string,oldSuffix,newSuffix){if(!oldSuffix)return string+newSuffix;if(string.slice(-oldSuffix.length)!=oldSuffix)throw Error("string ".concat(JSON.stringify(string)," doesn't end with suffix ").concat(JSON.stringify(oldSuffix),"; this is a bug"));return string.slice(0,-oldSuffix.length)+newSuffix}function removePrefix(string,oldPrefix){return replacePrefix(string,oldPrefix,"")}function removeSuffix(string,oldSuffix){return replaceSuffix(string,oldSuffix,"")}function maximumOverlap(string1,string2){return string2.slice(0,function(a,b){var startA=0;a.length>b.length&&(startA=a.length-b.length);var endB=b.length;a.length<b.length&&(endB=a.length);var map=Array(endB),k=0;map[0]=0;for(var j=1;j<endB;j++){for(b[j]==b[k]?map[j]=map[k]:map[j]=k;k>0&&b[j]!=b[k];)k=map[k];b[j]==b[k]&&k++}k=0;for(var i=startA;i<a.length;i++){for(;k>0&&a[i]!=b[k];)k=map[k];a[i]==b[k]&&k++}return k}(string1,string2))}function hasOnlyWinLineEndings(string){return string.includes("\r\n")&&!string.startsWith("\n")&&!string.match(/[^\r]\n/)}function hasOnlyUnixLineEndings(string){return!string.includes("\r\n")&&string.includes("\n")}var extendedWordChars="a-zA-Z0-9_\\u{C0}-\\u{FF}\\u{D8}-\\u{F6}\\u{F8}-\\u{2C6}\\u{2C8}-\\u{2D7}\\u{2DE}-\\u{2FF}\\u{1E00}-\\u{1EFF}",tokenizeIncludingWhitespace=new RegExp("[".concat(extendedWordChars,"]+|\\s+|[^").concat(extendedWordChars,"]"),"ug"),wordDiff=new Diff;function dedupeWhitespaceInChangeObjects(startKeep,deletion,insertion,endKeep){if(deletion&&insertion){var oldWsPrefix=deletion.value.match(/^\s*/)[0],oldWsSuffix=deletion.value.match(/\s*$/)[0],newWsPrefix=insertion.value.match(/^\s*/)[0],newWsSuffix=insertion.value.match(/\s*$/)[0];if(startKeep){var commonWsPrefix=longestCommonPrefix(oldWsPrefix,newWsPrefix);startKeep.value=replaceSuffix(startKeep.value,newWsPrefix,commonWsPrefix),deletion.value=removePrefix(deletion.value,commonWsPrefix),insertion.value=removePrefix(insertion.value,commonWsPrefix)}if(endKeep){var commonWsSuffix=longestCommonSuffix(oldWsSuffix,newWsSuffix);endKeep.value=replacePrefix(endKeep.value,newWsSuffix,commonWsSuffix),deletion.value=removeSuffix(deletion.value,commonWsSuffix),insertion.value=removeSuffix(insertion.value,commonWsSuffix)}}else if(insertion)startKeep&&(insertion.value=insertion.value.replace(/^\s*/,"")),endKeep&&(endKeep.value=endKeep.value.replace(/^\s*/,""));else if(startKeep&&endKeep){var newWsFull=endKeep.value.match(/^\s*/)[0],delWsStart=deletion.value.match(/^\s*/)[0],delWsEnd=deletion.value.match(/\s*$/)[0],newWsStart=longestCommonPrefix(newWsFull,delWsStart);deletion.value=removePrefix(deletion.value,newWsStart);var newWsEnd=longestCommonSuffix(removePrefix(newWsFull,newWsStart),delWsEnd);deletion.value=removeSuffix(deletion.value,newWsEnd),endKeep.value=replacePrefix(endKeep.value,newWsFull,newWsEnd),startKeep.value=replaceSuffix(startKeep.value,newWsFull,newWsFull.slice(0,newWsFull.length-newWsEnd.length))}else if(endKeep){var endKeepWsPrefix=endKeep.value.match(/^\s*/)[0],overlap=maximumOverlap(deletion.value.match(/\s*$/)[0],endKeepWsPrefix);deletion.value=removeSuffix(deletion.value,overlap)}else if(startKeep){var _overlap=maximumOverlap(startKeep.value.match(/\s*$/)[0],deletion.value.match(/^\s*/)[0]);deletion.value=removePrefix(deletion.value,_overlap)}}wordDiff.equals=function(left,right,options){return options.ignoreCase&&(left=left.toLowerCase(),right=right.toLowerCase()),left.trim()===right.trim()},wordDiff.tokenize=function(value){var parts,options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(options.intlSegmenter){if("word"!=options.intlSegmenter.resolvedOptions().granularity)throw new Error('The segmenter passed must have a granularity of "word"');parts=Array.from(options.intlSegmenter.segment(value),(function(segment){return segment.segment}))}else parts=value.match(tokenizeIncludingWhitespace)||[];var tokens=[],prevPart=null;return parts.forEach((function(part){/\s/.test(part)?null==prevPart?tokens.push(part):tokens.push(tokens.pop()+part):/\s/.test(prevPart)?tokens[tokens.length-1]==prevPart?tokens.push(tokens.pop()+part):tokens.push(prevPart+part):tokens.push(part),prevPart=part})),tokens},wordDiff.join=function(tokens){return tokens.map((function(token,i){return 0==i?token:token.replace(/^\s+/,"")})).join("")},wordDiff.postProcess=function(changes,options){if(!changes||options.oneChangePerToken)return changes;var lastKeep=null,insertion=null,deletion=null;return changes.forEach((function(change){change.added?insertion=change:change.removed?deletion=change:((insertion||deletion)&&dedupeWhitespaceInChangeObjects(lastKeep,deletion,insertion,change),lastKeep=change,insertion=null,deletion=null)})),(insertion||deletion)&&dedupeWhitespaceInChangeObjects(lastKeep,deletion,insertion,null),changes};var wordWithSpaceDiff=new Diff;function diffWordsWithSpace(oldStr,newStr,options){return wordWithSpaceDiff.diff(oldStr,newStr,options)}wordWithSpaceDiff.tokenize=function(value){var regex=new RegExp("(\\r?\\n)|[".concat(extendedWordChars,"]+|[^\\S\\n\\r]+|[^").concat(extendedWordChars,"]"),"ug");return value.match(regex)||[]};var lineDiff=new Diff;function diffLines(oldStr,newStr,callback){return lineDiff.diff(oldStr,newStr,callback)}lineDiff.tokenize=function(value,options){options.stripTrailingCr&&(value=value.replace(/\r\n/g,"\n"));var retLines=[],linesAndNewlines=value.split(/(\n|\r\n)/);linesAndNewlines[linesAndNewlines.length-1]||linesAndNewlines.pop();for(var i=0;i<linesAndNewlines.length;i++){var line=linesAndNewlines[i];i%2&&!options.newlineIsToken?retLines[retLines.length-1]+=line:retLines.push(line)}return retLines},lineDiff.equals=function(left,right,options){return options.ignoreWhitespace?(options.newlineIsToken&&left.includes("\n")||(left=left.trim()),options.newlineIsToken&&right.includes("\n")||(right=right.trim())):options.ignoreNewlineAtEof&&!options.newlineIsToken&&(left.endsWith("\n")&&(left=left.slice(0,-1)),right.endsWith("\n")&&(right=right.slice(0,-1))),Diff.prototype.equals.call(this,left,right,options)};var sentenceDiff=new Diff;sentenceDiff.tokenize=function(value){return value.split(/(\S.+?[.!?])(?=\s+|$)/)};var cssDiff=new Diff;function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread2(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){_defineProperty(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}function _toPropertyKey(t){var i=function(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}(t,"string");return"symbol"==typeof i?i:i+""}function _typeof(o){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _defineProperty(obj,key,value){return(key=_toPropertyKey(key))in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _toConsumableArray(arr){return function(arr){if(Array.isArray(arr))return _arrayLikeToArray(arr)}(arr)||function(iter){if("undefined"!=typeof Symbol&&null!=iter[Symbol.iterator]||null!=iter["@@iterator"])return Array.from(iter)}(arr)||function(o,minLen){if(o){if("string"==typeof o)return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);return"Object"===n&&o.constructor&&(n=o.constructor.name),"Map"===n||"Set"===n?Array.from(o):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?_arrayLikeToArray(o,minLen):void 0}}(arr)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function _arrayLikeToArray(arr,len){(null==len||len>arr.length)&&(len=arr.length);for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}cssDiff.tokenize=function(value){return value.split(/([{}:;,]|\s+)/)};var jsonDiff=new Diff;function canonicalize(obj,stack,replacementStack,replacer,key){var i,canonicalizedObj;for(stack=stack||[],replacementStack=replacementStack||[],replacer&&(obj=replacer(key,obj)),i=0;i<stack.length;i+=1)if(stack[i]===obj)return replacementStack[i];if("[object Array]"===Object.prototype.toString.call(obj)){for(stack.push(obj),canonicalizedObj=new Array(obj.length),replacementStack.push(canonicalizedObj),i=0;i<obj.length;i+=1)canonicalizedObj[i]=canonicalize(obj[i],stack,replacementStack,replacer,key);return stack.pop(),replacementStack.pop(),canonicalizedObj}if(obj&&obj.toJSON&&(obj=obj.toJSON()),"object"===_typeof(obj)&&null!==obj){stack.push(obj),canonicalizedObj={},replacementStack.push(canonicalizedObj);var _key,sortedKeys=[];for(_key in obj)Object.prototype.hasOwnProperty.call(obj,_key)&&sortedKeys.push(_key);for(sortedKeys.sort(),i=0;i<sortedKeys.length;i+=1)canonicalizedObj[_key=sortedKeys[i]]=canonicalize(obj[_key],stack,replacementStack,replacer,_key);stack.pop(),replacementStack.pop()}else canonicalizedObj=obj;return canonicalizedObj}jsonDiff.useLongestToken=!0,jsonDiff.tokenize=lineDiff.tokenize,jsonDiff.castInput=function(value,options){var undefinedReplacement=options.undefinedReplacement,_options$stringifyRep=options.stringifyReplacer,stringifyReplacer=void 0===_options$stringifyRep?function(k,v){return void 0===v?undefinedReplacement:v}:_options$stringifyRep;return"string"==typeof value?value:JSON.stringify(canonicalize(value,null,null,stringifyReplacer),stringifyReplacer,"  ")},jsonDiff.equals=function(left,right,options){return Diff.prototype.equals.call(jsonDiff,left.replace(/,([\r\n])/g,"$1"),right.replace(/,([\r\n])/g,"$1"),options)};var arrayDiff=new Diff;function unixToWin(patch){return Array.isArray(patch)?patch.map(unixToWin):_objectSpread2(_objectSpread2({},patch),{},{hunks:patch.hunks.map((function(hunk){return _objectSpread2(_objectSpread2({},hunk),{},{lines:hunk.lines.map((function(line,i){var _hunk$lines;return line.startsWith("\\")||line.endsWith("\r")||null!==(_hunk$lines=hunk.lines[i+1])&&void 0!==_hunk$lines&&_hunk$lines.startsWith("\\")?line:line+"\r"}))})}))})}function winToUnix(patch){return Array.isArray(patch)?patch.map(winToUnix):_objectSpread2(_objectSpread2({},patch),{},{hunks:patch.hunks.map((function(hunk){return _objectSpread2(_objectSpread2({},hunk),{},{lines:hunk.lines.map((function(line){return line.endsWith("\r")?line.substring(0,line.length-1):line}))})}))})}function isUnix(patch){return Array.isArray(patch)||(patch=[patch]),!patch.some((function(index){return index.hunks.some((function(hunk){return hunk.lines.some((function(line){return!line.startsWith("\\")&&line.endsWith("\r")}))}))}))}function isWin(patch){return Array.isArray(patch)||(patch=[patch]),patch.some((function(index){return index.hunks.some((function(hunk){return hunk.lines.some((function(line){return line.endsWith("\r")}))}))}))&&patch.every((function(index){return index.hunks.every((function(hunk){return hunk.lines.every((function(line,i){var _hunk$lines2;return line.startsWith("\\")||line.endsWith("\r")||(null===(_hunk$lines2=hunk.lines[i+1])||void 0===_hunk$lines2?void 0:_hunk$lines2.startsWith("\\"))}))}))}))}function parsePatch(uniDiff){var diffstr=uniDiff.split(/\n/),list=[],i=0;function parseIndex(){var index={};for(list.push(index);i<diffstr.length;){var line=diffstr[i];if(/^(\-\-\-|\+\+\+|@@)\s/.test(line))break;var header=/^(?:Index:|diff(?: -r \w+)+)\s+(.+?)\s*$/.exec(line);header&&(index.index=header[1]),i++}for(parseFileHeader(index),parseFileHeader(index),index.hunks=[];i<diffstr.length;){var _line=diffstr[i];if(/^(Index:\s|diff\s|\-\-\-\s|\+\+\+\s|===================================================================)/.test(_line))break;if(/^@@/.test(_line))index.hunks.push(parseHunk());else{if(_line)throw new Error("Unknown line "+(i+1)+" "+JSON.stringify(_line));i++}}}function parseFileHeader(index){var fileHeader=/^(---|\+\+\+)\s+(.*)\r?$/.exec(diffstr[i]);if(fileHeader){var keyPrefix="---"===fileHeader[1]?"old":"new",data=fileHeader[2].split("\t",2),fileName=data[0].replace(/\\\\/g,"\\");/^".*"$/.test(fileName)&&(fileName=fileName.substr(1,fileName.length-2)),index[keyPrefix+"FileName"]=fileName,index[keyPrefix+"Header"]=(data[1]||"").trim(),i++}}function parseHunk(){var chunkHeaderIndex=i,chunkHeader=diffstr[i++].split(/@@ -(\d+)(?:,(\d+))? \+(\d+)(?:,(\d+))? @@/),hunk={oldStart:+chunkHeader[1],oldLines:void 0===chunkHeader[2]?1:+chunkHeader[2],newStart:+chunkHeader[3],newLines:void 0===chunkHeader[4]?1:+chunkHeader[4],lines:[]};0===hunk.oldLines&&(hunk.oldStart+=1),0===hunk.newLines&&(hunk.newStart+=1);for(var addCount=0,removeCount=0;i<diffstr.length&&(removeCount<hunk.oldLines||addCount<hunk.newLines||null!==(_diffstr$i=diffstr[i])&&void 0!==_diffstr$i&&_diffstr$i.startsWith("\\"));i++){var _diffstr$i,operation=0==diffstr[i].length&&i!=diffstr.length-1?" ":diffstr[i][0];if("+"!==operation&&"-"!==operation&&" "!==operation&&"\\"!==operation)throw new Error("Hunk at line ".concat(chunkHeaderIndex+1," contained invalid line ").concat(diffstr[i]));hunk.lines.push(diffstr[i]),"+"===operation?addCount++:"-"===operation?removeCount++:" "===operation&&(addCount++,removeCount++)}if(addCount||1!==hunk.newLines||(hunk.newLines=0),removeCount||1!==hunk.oldLines||(hunk.oldLines=0),addCount!==hunk.newLines)throw new Error("Added line count did not match for hunk at line "+(chunkHeaderIndex+1));if(removeCount!==hunk.oldLines)throw new Error("Removed line count did not match for hunk at line "+(chunkHeaderIndex+1));return hunk}for(;i<diffstr.length;)parseIndex();return list}function distanceIterator(start,minLine,maxLine){var wantForward=!0,backwardExhausted=!1,forwardExhausted=!1,localOffset=1;return function iterator(){if(wantForward&&!forwardExhausted){if(backwardExhausted?localOffset++:wantForward=!1,start+localOffset<=maxLine)return start+localOffset;forwardExhausted=!0}if(!backwardExhausted)return forwardExhausted||(wantForward=!0),minLine<=start-localOffset?start-localOffset++:(backwardExhausted=!0,iterator())}}function applyPatch(source,uniDiff){var options=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if("string"==typeof uniDiff&&(uniDiff=parsePatch(uniDiff)),Array.isArray(uniDiff)){if(uniDiff.length>1)throw new Error("applyPatch only works with a single input.");uniDiff=uniDiff[0]}(options.autoConvertLineEndings||null==options.autoConvertLineEndings)&&(hasOnlyWinLineEndings(source)&&isUnix(uniDiff)?uniDiff=unixToWin(uniDiff):hasOnlyUnixLineEndings(source)&&isWin(uniDiff)&&(uniDiff=winToUnix(uniDiff)));var lines=source.split("\n"),hunks=uniDiff.hunks,compareLine=options.compareLine||function(lineNumber,line,operation,patchContent){return line===patchContent},fuzzFactor=options.fuzzFactor||0,minLine=0;if(fuzzFactor<0||!Number.isInteger(fuzzFactor))throw new Error("fuzzFactor must be a non-negative integer");if(!hunks.length)return source;for(var prevLine="",removeEOFNL=!1,addEOFNL=!1,i=0;i<hunks[hunks.length-1].lines.length;i++){var line=hunks[hunks.length-1].lines[i];"\\"==line[0]&&("+"==prevLine[0]?removeEOFNL=!0:"-"==prevLine[0]&&(addEOFNL=!0)),prevLine=line}if(removeEOFNL){if(addEOFNL){if(!fuzzFactor&&""==lines[lines.length-1])return!1}else if(""==lines[lines.length-1])lines.pop();else if(!fuzzFactor)return!1}else if(addEOFNL)if(""!=lines[lines.length-1])lines.push("");else if(!fuzzFactor)return!1;function applyHunk(hunkLines,toPos,maxErrors){for(var hunkLinesI=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,lastContextLineMatched=!(arguments.length>4&&void 0!==arguments[4])||arguments[4],patchedLines=arguments.length>5&&void 0!==arguments[5]?arguments[5]:[],patchedLinesLength=arguments.length>6&&void 0!==arguments[6]?arguments[6]:0,nConsecutiveOldContextLines=0,nextContextLineMustMatch=!1;hunkLinesI<hunkLines.length;hunkLinesI++){var hunkLine=hunkLines[hunkLinesI],operation=hunkLine.length>0?hunkLine[0]:" ",content=hunkLine.length>0?hunkLine.substr(1):hunkLine;if("-"===operation){if(!compareLine(toPos+1,lines[toPos],operation,content))return maxErrors&&null!=lines[toPos]?(patchedLines[patchedLinesLength]=lines[toPos],applyHunk(hunkLines,toPos+1,maxErrors-1,hunkLinesI,!1,patchedLines,patchedLinesLength+1)):null;toPos++,nConsecutiveOldContextLines=0}if("+"===operation){if(!lastContextLineMatched)return null;patchedLines[patchedLinesLength]=content,patchedLinesLength++,nConsecutiveOldContextLines=0,nextContextLineMustMatch=!0}if(" "===operation){if(nConsecutiveOldContextLines++,patchedLines[patchedLinesLength]=lines[toPos],!compareLine(toPos+1,lines[toPos],operation,content))return nextContextLineMustMatch||!maxErrors?null:lines[toPos]&&(applyHunk(hunkLines,toPos+1,maxErrors-1,hunkLinesI+1,!1,patchedLines,patchedLinesLength+1)||applyHunk(hunkLines,toPos+1,maxErrors-1,hunkLinesI,!1,patchedLines,patchedLinesLength+1))||applyHunk(hunkLines,toPos,maxErrors-1,hunkLinesI+1,!1,patchedLines,patchedLinesLength);patchedLinesLength++,lastContextLineMatched=!0,nextContextLineMustMatch=!1,toPos++}}return patchedLinesLength-=nConsecutiveOldContextLines,toPos-=nConsecutiveOldContextLines,patchedLines.length=patchedLinesLength,{patchedLines:patchedLines,oldLineLastI:toPos-1}}for(var resultLines=[],prevHunkOffset=0,_i=0;_i<hunks.length;_i++){for(var hunk=hunks[_i],hunkResult=void 0,maxLine=lines.length-hunk.oldLines+fuzzFactor,toPos=void 0,maxErrors=0;maxErrors<=fuzzFactor;maxErrors++){for(var iterator=distanceIterator(toPos=hunk.oldStart+prevHunkOffset-1,minLine,maxLine);void 0!==toPos&&!(hunkResult=applyHunk(hunk.lines,toPos,maxErrors));toPos=iterator());if(hunkResult)break}if(!hunkResult)return!1;for(var _i2=minLine;_i2<toPos;_i2++)resultLines.push(lines[_i2]);for(var _i3=0;_i3<hunkResult.patchedLines.length;_i3++){var _line=hunkResult.patchedLines[_i3];resultLines.push(_line)}minLine=hunkResult.oldLineLastI+1,prevHunkOffset=toPos+1-hunk.oldStart}for(var _i4=minLine;_i4<lines.length;_i4++)resultLines.push(lines[_i4]);return resultLines.join("\n")}function structuredPatch(oldFileName,newFileName,oldStr,newStr,oldHeader,newHeader,options){if(options||(options={}),"function"==typeof options&&(options={callback:options}),void 0===options.context&&(options.context=4),options.newlineIsToken)throw new Error("newlineIsToken may not be used with patch-generation functions, only with diffing functions");if(!options.callback)return diffLinesResultToPatch(diffLines(oldStr,newStr,options));var _callback=options.callback;function diffLinesResultToPatch(diff){if(diff){diff.push({value:"",lines:[]});for(var hunks=[],oldRangeStart=0,newRangeStart=0,curRange=[],oldLine=1,newLine=1,_loop=function(){var text,hasTrailingNl,result,current=diff[i],lines=current.lines||(text=current.value,hasTrailingNl=text.endsWith("\n"),result=text.split("\n").map((function(line){return line+"\n"})),hasTrailingNl?result.pop():result.push(result.pop().slice(0,-1)),result);if(current.lines=lines,current.added||current.removed){var _curRange;if(!oldRangeStart){var prev=diff[i-1];oldRangeStart=oldLine,newRangeStart=newLine,prev&&(curRange=options.context>0?contextLines(prev.lines.slice(-options.context)):[],oldRangeStart-=curRange.length,newRangeStart-=curRange.length)}(_curRange=curRange).push.apply(_curRange,_toConsumableArray(lines.map((function(entry){return(current.added?"+":"-")+entry})))),current.added?newLine+=lines.length:oldLine+=lines.length}else{if(oldRangeStart)if(lines.length<=2*options.context&&i<diff.length-2){var _curRange2;(_curRange2=curRange).push.apply(_curRange2,_toConsumableArray(contextLines(lines)))}else{var _curRange3,contextSize=Math.min(lines.length,options.context);(_curRange3=curRange).push.apply(_curRange3,_toConsumableArray(contextLines(lines.slice(0,contextSize))));var _hunk={oldStart:oldRangeStart,oldLines:oldLine-oldRangeStart+contextSize,newStart:newRangeStart,newLines:newLine-newRangeStart+contextSize,lines:curRange};hunks.push(_hunk),oldRangeStart=0,newRangeStart=0,curRange=[]}oldLine+=lines.length,newLine+=lines.length}},i=0;i<diff.length;i++)_loop();for(var _i=0,_hunks=hunks;_i<_hunks.length;_i++)for(var hunk=_hunks[_i],_i2=0;_i2<hunk.lines.length;_i2++)hunk.lines[_i2].endsWith("\n")?hunk.lines[_i2]=hunk.lines[_i2].slice(0,-1):(hunk.lines.splice(_i2+1,0,"\\ No newline at end of file"),_i2++);return{oldFileName:oldFileName,newFileName:newFileName,oldHeader:oldHeader,newHeader:newHeader,hunks:hunks}}function contextLines(lines){return lines.map((function(entry){return" "+entry}))}}diffLines(oldStr,newStr,_objectSpread2(_objectSpread2({},options),{},{callback:function(diff){var patch=diffLinesResultToPatch(diff);_callback(patch)}}))}function formatPatch(diff){if(Array.isArray(diff))return diff.map(formatPatch).join("\n");var ret=[];diff.oldFileName==diff.newFileName&&ret.push("Index: "+diff.oldFileName),ret.push("==================================================================="),ret.push("--- "+diff.oldFileName+(void 0===diff.oldHeader?"":"\t"+diff.oldHeader)),ret.push("+++ "+diff.newFileName+(void 0===diff.newHeader?"":"\t"+diff.newHeader));for(var i=0;i<diff.hunks.length;i++){var hunk=diff.hunks[i];0===hunk.oldLines&&(hunk.oldStart-=1),0===hunk.newLines&&(hunk.newStart-=1),ret.push("@@ -"+hunk.oldStart+","+hunk.oldLines+" +"+hunk.newStart+","+hunk.newLines+" @@"),ret.push.apply(ret,hunk.lines)}return ret.join("\n")+"\n"}function createTwoFilesPatch(oldFileName,newFileName,oldStr,newStr,oldHeader,newHeader,options){var _options2;if("function"==typeof options&&(options={callback:options}),null===(_options2=options)||void 0===_options2||!_options2.callback){var patchObj=structuredPatch(oldFileName,newFileName,oldStr,newStr,oldHeader,newHeader,options);if(!patchObj)return;return formatPatch(patchObj)}var _callback2=options.callback;structuredPatch(oldFileName,newFileName,oldStr,newStr,oldHeader,newHeader,_objectSpread2(_objectSpread2({},options),{},{callback:function(patchObj){patchObj?_callback2(formatPatch(patchObj)):_callback2()}}))}function arrayStartsWith(array,start){if(start.length>array.length)return!1;for(var i=0;i<start.length;i++)if(start[i]!==array[i])return!1;return!0}function calcLineCount(hunk){var _calcOldNewLineCount=calcOldNewLineCount(hunk.lines),oldLines=_calcOldNewLineCount.oldLines,newLines=_calcOldNewLineCount.newLines;void 0!==oldLines?hunk.oldLines=oldLines:delete hunk.oldLines,void 0!==newLines?hunk.newLines=newLines:delete hunk.newLines}function loadPatch(param,base){if("string"==typeof param){if(/^@@/m.test(param)||/^Index:/m.test(param))return parsePatch(param)[0];if(!base)throw new Error("Must provide a base reference or pass in a patch");return structuredPatch(void 0,void 0,base,param)}return param}function fileNameChanged(patch){return patch.newFileName&&patch.newFileName!==patch.oldFileName}function selectField(index,mine,theirs){return mine===theirs?mine:(index.conflict=!0,{mine:mine,theirs:theirs})}function hunkBefore(test,check){return test.oldStart<check.oldStart&&test.oldStart+test.oldLines<check.oldStart}function cloneHunk(hunk,offset){return{oldStart:hunk.oldStart,oldLines:hunk.oldLines,newStart:hunk.newStart+offset,newLines:hunk.newLines,lines:hunk.lines}}function mergeLines(hunk,mineOffset,mineLines,theirOffset,theirLines){var mine={offset:mineOffset,lines:mineLines,index:0},their={offset:theirOffset,lines:theirLines,index:0};for(insertLeading(hunk,mine,their),insertLeading(hunk,their,mine);mine.index<mine.lines.length&&their.index<their.lines.length;){var mineCurrent=mine.lines[mine.index],theirCurrent=their.lines[their.index];if("-"!==mineCurrent[0]&&"+"!==mineCurrent[0]||"-"!==theirCurrent[0]&&"+"!==theirCurrent[0])if("+"===mineCurrent[0]&&" "===theirCurrent[0]){var _hunk$lines;(_hunk$lines=hunk.lines).push.apply(_hunk$lines,_toConsumableArray(collectChange(mine)))}else if("+"===theirCurrent[0]&&" "===mineCurrent[0]){var _hunk$lines2;(_hunk$lines2=hunk.lines).push.apply(_hunk$lines2,_toConsumableArray(collectChange(their)))}else"-"===mineCurrent[0]&&" "===theirCurrent[0]?removal(hunk,mine,their):"-"===theirCurrent[0]&&" "===mineCurrent[0]?removal(hunk,their,mine,!0):mineCurrent===theirCurrent?(hunk.lines.push(mineCurrent),mine.index++,their.index++):conflict(hunk,collectChange(mine),collectChange(their));else mutualChange(hunk,mine,their)}insertTrailing(hunk,mine),insertTrailing(hunk,their),calcLineCount(hunk)}function mutualChange(hunk,mine,their){var a,b,myChanges=collectChange(mine),theirChanges=collectChange(their);if(allRemoves(myChanges)&&allRemoves(theirChanges)){var _hunk$lines3,_hunk$lines4;if(arrayStartsWith(myChanges,theirChanges)&&skipRemoveSuperset(their,myChanges,myChanges.length-theirChanges.length))return void(_hunk$lines3=hunk.lines).push.apply(_hunk$lines3,_toConsumableArray(myChanges));if(arrayStartsWith(theirChanges,myChanges)&&skipRemoveSuperset(mine,theirChanges,theirChanges.length-myChanges.length))return void(_hunk$lines4=hunk.lines).push.apply(_hunk$lines4,_toConsumableArray(theirChanges))}else if(b=theirChanges,(a=myChanges).length===b.length&&arrayStartsWith(a,b)){var _hunk$lines5;return void(_hunk$lines5=hunk.lines).push.apply(_hunk$lines5,_toConsumableArray(myChanges))}conflict(hunk,myChanges,theirChanges)}function removal(hunk,mine,their,swap){var _hunk$lines6,myChanges=collectChange(mine),theirChanges=function(state,matchChanges){for(var changes=[],merged=[],matchIndex=0,contextChanges=!1,conflicted=!1;matchIndex<matchChanges.length&&state.index<state.lines.length;){var change=state.lines[state.index],match=matchChanges[matchIndex];if("+"===match[0])break;if(contextChanges=contextChanges||" "!==change[0],merged.push(match),matchIndex++,"+"===change[0])for(conflicted=!0;"+"===change[0];)changes.push(change),change=state.lines[++state.index];match.substr(1)===change.substr(1)?(changes.push(change),state.index++):conflicted=!0}if("+"===(matchChanges[matchIndex]||"")[0]&&contextChanges&&(conflicted=!0),conflicted)return changes;for(;matchIndex<matchChanges.length;)merged.push(matchChanges[matchIndex++]);return{merged:merged,changes:changes}}(their,myChanges);theirChanges.merged?(_hunk$lines6=hunk.lines).push.apply(_hunk$lines6,_toConsumableArray(theirChanges.merged)):conflict(hunk,swap?theirChanges:myChanges,swap?myChanges:theirChanges)}function conflict(hunk,mine,their){hunk.conflict=!0,hunk.lines.push({conflict:!0,mine:mine,theirs:their})}function insertLeading(hunk,insert,their){for(;insert.offset<their.offset&&insert.index<insert.lines.length;){var line=insert.lines[insert.index++];hunk.lines.push(line),insert.offset++}}function insertTrailing(hunk,insert){for(;insert.index<insert.lines.length;){var line=insert.lines[insert.index++];hunk.lines.push(line)}}function collectChange(state){for(var ret=[],operation=state.lines[state.index][0];state.index<state.lines.length;){var line=state.lines[state.index];if("-"===operation&&"+"===line[0]&&(operation="+"),operation!==line[0])break;ret.push(line),state.index++}return ret}function allRemoves(changes){return changes.reduce((function(prev,change){return prev&&"-"===change[0]}),!0)}function skipRemoveSuperset(state,removeChanges,delta){for(var i=0;i<delta;i++){var changeContent=removeChanges[removeChanges.length-delta+i].substr(1);if(state.lines[state.index+i]!==" "+changeContent)return!1}return state.index+=delta,!0}function calcOldNewLineCount(lines){var oldLines=0,newLines=0;return lines.forEach((function(line){if("string"!=typeof line){var myCount=calcOldNewLineCount(line.mine),theirCount=calcOldNewLineCount(line.theirs);void 0!==oldLines&&(myCount.oldLines===theirCount.oldLines?oldLines+=myCount.oldLines:oldLines=void 0),void 0!==newLines&&(myCount.newLines===theirCount.newLines?newLines+=myCount.newLines:newLines=void 0)}else void 0===newLines||"+"!==line[0]&&" "!==line[0]||newLines++,void 0===oldLines||"-"!==line[0]&&" "!==line[0]||oldLines++})),{oldLines:oldLines,newLines:newLines}}arrayDiff.tokenize=function(value){return value.slice()},arrayDiff.join=arrayDiff.removeEmpty=function(value){return value},exports.Diff=Diff,exports.applyPatch=applyPatch,exports.applyPatches=function(uniDiff,options){"string"==typeof uniDiff&&(uniDiff=parsePatch(uniDiff));var currentIndex=0;!function processIndex(){var index=uniDiff[currentIndex++];if(!index)return options.complete();options.loadFile(index,(function(err,data){if(err)return options.complete(err);var updatedContent=applyPatch(data,index,options);options.patched(index,updatedContent,(function(err){if(err)return options.complete(err);processIndex()}))}))}()},exports.canonicalize=canonicalize,exports.convertChangesToDMP=function(changes){for(var change,operation,ret=[],i=0;i<changes.length;i++)operation=(change=changes[i]).added?1:change.removed?-1:0,ret.push([operation,change.value]);return ret},exports.convertChangesToXML=function(changes){for(var ret=[],i=0;i<changes.length;i++){var change=changes[i];change.added?ret.push("<ins>"):change.removed&&ret.push("<del>"),ret.push((s=change.value,void 0,s.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;"))),change.added?ret.push("</ins>"):change.removed&&ret.push("</del>")}var s;return ret.join("")},exports.createPatch=function(fileName,oldStr,newStr,oldHeader,newHeader,options){return createTwoFilesPatch(fileName,fileName,oldStr,newStr,oldHeader,newHeader,options)},exports.createTwoFilesPatch=createTwoFilesPatch,exports.diffArrays=function(oldArr,newArr,callback){return arrayDiff.diff(oldArr,newArr,callback)},exports.diffChars=function(oldStr,newStr,options){return characterDiff.diff(oldStr,newStr,options)},exports.diffCss=function(oldStr,newStr,callback){return cssDiff.diff(oldStr,newStr,callback)},exports.diffJson=function(oldObj,newObj,options){return jsonDiff.diff(oldObj,newObj,options)},exports.diffLines=diffLines,exports.diffSentences=function(oldStr,newStr,callback){return sentenceDiff.diff(oldStr,newStr,callback)},exports.diffTrimmedLines=function(oldStr,newStr,callback){var options=function(options,defaults){if("function"==typeof options)defaults.callback=options;else if(options)for(var name in options)options.hasOwnProperty(name)&&(defaults[name]=options[name]);return defaults}(callback,{ignoreWhitespace:!0});return lineDiff.diff(oldStr,newStr,options)},exports.diffWords=function(oldStr,newStr,options){return null==(null==options?void 0:options.ignoreWhitespace)||options.ignoreWhitespace?wordDiff.diff(oldStr,newStr,options):diffWordsWithSpace(oldStr,newStr,options)},exports.diffWordsWithSpace=diffWordsWithSpace,exports.formatPatch=formatPatch,exports.merge=function(mine,theirs,base){mine=loadPatch(mine,base),theirs=loadPatch(theirs,base);var ret={};(mine.index||theirs.index)&&(ret.index=mine.index||theirs.index),(mine.newFileName||theirs.newFileName)&&(fileNameChanged(mine)?fileNameChanged(theirs)?(ret.oldFileName=selectField(ret,mine.oldFileName,theirs.oldFileName),ret.newFileName=selectField(ret,mine.newFileName,theirs.newFileName),ret.oldHeader=selectField(ret,mine.oldHeader,theirs.oldHeader),ret.newHeader=selectField(ret,mine.newHeader,theirs.newHeader)):(ret.oldFileName=mine.oldFileName,ret.newFileName=mine.newFileName,ret.oldHeader=mine.oldHeader,ret.newHeader=mine.newHeader):(ret.oldFileName=theirs.oldFileName||mine.oldFileName,ret.newFileName=theirs.newFileName||mine.newFileName,ret.oldHeader=theirs.oldHeader||mine.oldHeader,ret.newHeader=theirs.newHeader||mine.newHeader)),ret.hunks=[];for(var mineIndex=0,theirsIndex=0,mineOffset=0,theirsOffset=0;mineIndex<mine.hunks.length||theirsIndex<theirs.hunks.length;){var mineCurrent=mine.hunks[mineIndex]||{oldStart:1/0},theirsCurrent=theirs.hunks[theirsIndex]||{oldStart:1/0};if(hunkBefore(mineCurrent,theirsCurrent))ret.hunks.push(cloneHunk(mineCurrent,mineOffset)),mineIndex++,theirsOffset+=mineCurrent.newLines-mineCurrent.oldLines;else if(hunkBefore(theirsCurrent,mineCurrent))ret.hunks.push(cloneHunk(theirsCurrent,theirsOffset)),theirsIndex++,mineOffset+=theirsCurrent.newLines-theirsCurrent.oldLines;else{var mergedHunk={oldStart:Math.min(mineCurrent.oldStart,theirsCurrent.oldStart),oldLines:0,newStart:Math.min(mineCurrent.newStart+mineOffset,theirsCurrent.oldStart+theirsOffset),newLines:0,lines:[]};mergeLines(mergedHunk,mineCurrent.oldStart,mineCurrent.lines,theirsCurrent.oldStart,theirsCurrent.lines),theirsIndex++,mineIndex++,ret.hunks.push(mergedHunk)}}return ret},exports.parsePatch=parsePatch,exports.reversePatch=function reversePatch(structuredPatch){return Array.isArray(structuredPatch)?structuredPatch.map(reversePatch).reverse():_objectSpread2(_objectSpread2({},structuredPatch),{},{oldFileName:structuredPatch.newFileName,oldHeader:structuredPatch.newHeader,newFileName:structuredPatch.oldFileName,newHeader:structuredPatch.oldHeader,hunks:structuredPatch.hunks.map((function(hunk){return{oldLines:hunk.newLines,oldStart:hunk.newStart,newLines:hunk.oldLines,newStart:hunk.oldStart,lines:hunk.lines.map((function(l){return l.startsWith("-")?"+".concat(l.slice(1)):l.startsWith("+")?"-".concat(l.slice(1)):l}))}}))})},exports.structuredPatch=structuredPatch},"object"==typeof exports&&"undefined"!=typeof module?factory(exports):"function"==typeof define&&define.amd?define("qtype_aitext/diff",["exports"],factory):factory((global="undefined"!=typeof globalThis?globalThis:global||self).Diff={});

//# sourceMappingURL=diff.min.js.map