<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Aitext backup
 *
 * @package    qtype_aitext
 * @copyright  2024 Marcus Green
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


/**
 * Provides the information to backup aitext questions
 *
 * @copyright  2024 Marcus Green
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class backup_qtype_aitext_plugin extends backup_qtype_plugin {
    /**
     * returns the name of the plugin/question type
     *
     * @return string
     */
    protected static function qtype_name() {
        return 'aitext';
    }

    /**
     * Returns the qtype information to attach to question element
     */
    protected function define_question_plugin_structure() {

        // Define the virtual plugin element with the condition to fulfill.
            $plugin = $this->get_plugin_element(null, '../../qtype', 'aitext');

        // Create one standard named plugin element (the visible container).
        $pluginwrapper = new backup_nested_element($this->get_recommended_name());

        // Connect the visible container ASAP.
        $plugin->add_child($pluginwrapper);

        // Now create the qtype own structures.

        $aitext = new backup_nested_element('aitext', ['id'], [
                'aiprompt', 'markscheme', 'sampleanswer', 'responseformat', 'responsefieldlines', 'minwordlimit', 'maxwordlimit',
                'graderinfo', 'graderinfoformat', 'responsetemplate', 'model',
                'responsetemplateformat', 'maxbytes', 'spellcheck']);

        $sampleresponses = new backup_nested_element('sampleresponses');
        $sampleresponse = new backup_nested_element('sampleresponse', ['id'], ['question', 'response']);

        $pluginwrapper->add_child($sampleresponses);
        $sampleresponses->add_child($sampleresponse);

        // Now the own qtype tree.
        $pluginwrapper->add_child($aitext);

        // Set source to populate the data.
        $aitext->set_source_table(
            'qtype_aitext',
            ['questionid' => backup::VAR_PARENTID]
        );

        // Set source to populate the data.
        $sampleresponse->set_source_table(
            'qtype_aitext_sampleresponses',
            ['question' => backup::VAR_PARENTID]
        );

        // Don't need to annotate ids nor files.

        return $plugin;
    }

    /**
     * Returns one array with filearea => mappingname elements for the qtype
     *
     * Used by get_components_and_fileareas to know about all the qtype
     * files to be processed both in backup and restore.
     */
    public static function get_qtype_fileareas() {
        return [
            'graderinfo' => 'question_created',
        ];
    }
}
