angular.module('mm.addons.qtype_gapfill',[])
.config(["$mmQuestionDelegateProvider", function($mmQuestionDelegateProvider) {
    $mmQuestionDelegateProvider.registerHandler('mmaQtypeGapfill', 'qtype_gapfill', '$mmaQtypeGapfillHandler');
}]);

angular.module('mm.addons.qtype_gapfill')
        .directive('mmaQtypeGapfill', ["$log", "$mmQuestionHelper", "$mmUtil", "$timeout", function ($log, $mmQuestionHelper, $mmUtil, $timeout) {
            $log = $log.getInstance('mmaQtypeGapfill');
            return {
                restrict: 'A',
                priority: 100,
                templateUrl: '$ADDONPATH$/template.html',
                link: function (scope) {
                    var   questionEl,
                          content,
                          question = scope.question;
                    if (!question) {
                        $log.warn('Aborting because of no question received.');
                        return $mmQuestionHelper.showDirectiveError(scope);
                    }
                    questionEl = angular.element(question.html);
                    questionEl = questionEl[0] || questionEl;
                    content = questionEl.querySelector('.content');
                    if (!content) {
                        $log.warn('Aborting because of an error parsing question.', question.name);
                        return $mmQuestionHelper.showDirectiveError(scope);
                    }
                    $mmUtil.removeElement(content, 'input[name*=sequencecheck]');
                    $mmUtil.removeElement(content, '.validationerror');
                    $mmQuestionHelper.treatCorrectnessIcons(scope, questionEl);
                    $mmQuestionHelper.replaceFeedbackClasses(questionEl);
                    draggables = content.querySelectorAll('.draggable');
                    if (draggables.length > 0) {
                        droppables = content.querySelectorAll('.droptarget');
                        for (i = 0; i < droppables.length; i++) {
                            droppables[i].disabled = "true";
                            angular.element(droppables[i]).css('-webkit-opacity', '1');
                        }
                    }
                    question.text = content.innerHTML;
                    if(questionEl.querySelector('.readonly') != null){
                        question.readonly = true;
                    }
                    function getEl(event) {
                        selector = "#" + event.target.id;
                        parts = selector.split(":");
                        element = parts[0] + "\\:" + parts[1];
                        element = document.querySelector(element);
                        return element;
                    }
                    function deselect(selection) {
                        draggables = document.querySelectorAll('.draggable');
                        for (i = 0; i < draggables.length; i++) {
                            if (draggables[i] === selection)
                                continue;
                            angular.element(draggables[i]).attr('title', '');
                            angular.element(draggables[i]).removeClass('picked');
                            angular.element(draggables[i]).addClass('notpicked');
                        }
                    }
                    scope.selectAnswer = function (event) {
                        if (question.readonly==true) {
                            return;
                        }
                        selectedel = getEl(event);
                        if ((selectedel === null) || (angular.element(selectedel).hasClass('readonly'))) {
                            last_item_clicked = "";
                            deselect();
                            return;
                        }
                        selection = angular.element(selectedel);
                        if (selection.hasClass('draggable')) {
                            if (typeof last_item_clicked !== "undefined") {
                                if (selection[0].innerText != last_item_clicked) {
                                    deselect(selection);
                                }
                            }
                            if (selection.hasClass('picked')) {
                                deselect();
                                last_item_clicked = "";
                            } else {
                                selection.addClass('picked');
                                selection.removeClass('notpicked');
                                selection.attr('title', 'picked');
                                last_item_clicked = event.target.innerText;
                            }
                        }
                        if (selection.hasClass('droptarget')) {
                            if (question.readonly==true) {
                                return;
                            }
                            selection[0].value = last_item_clicked;
                            angular.element(selection[0]).css('text-align', 'center');
                            last_item_clicked = "";
                            deselect();
                        }
                    };
                    $timeout(function () {
                         if(questionEl.querySelectorAll('.draggable').length >0){
                            question.isdragdrop = true;
                        }
                    });
                }
            };
        }]);
angular.module('mm.addons.qtype_gapfill')
.factory('$mmaQtypeGapfillHandler', ["$mmQuestion", function($mmQuestion) {
    var self = {};
    self.isCompleteResponse = function(question, answers) {
        var isComplete = true;
        angular.forEach(answers, function(value) {
            if (!value || value === '0') {
                isComplete = false;
            }
        });
        return isComplete;
    };
    self.isEnabled = function() {
        return true;
    };
    self.isGradableResponse = function(question, answers) {
        var hasReponse = false;
        angular.forEach(answers, function(value) {
            if (value && value !== '0') {
                hasReponse = true;
            }
        });
        return hasReponse;
    };
    self.isSameResponse = function(question, prevAnswers, newAnswers) {
        return $mmQuestion.compareAllAnswers(prevAnswers, newAnswers);
    };
    self.getBehaviour = function(question, behaviour) {
        if (behaviour === 'interactive') {
            return 'interactivecountback';
        }
        return behaviour;
    };
    self.getDirectiveName = function(question) {
        return 'mma-qtype-gapfill';
    };
    return self;
}]);
