define("format_flexsections/local/content/actions",["exports","core/reactive","core/str","core/notification","core/modal_factory","core/templates","core/pending"],(function(_exports,_reactive,_str,_notification,_modal_factory,_templates,_pending){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Actions
   *
   * @module     format_flexsections/local/content/actions
   * @copyright  2022 Marina Glancy
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_notification=_interopRequireDefault(_notification),_modal_factory=_interopRequireDefault(_modal_factory),_templates=_interopRequireDefault(_templates),_pending=_interopRequireDefault(_pending);class _default extends _reactive.BaseComponent{create(){this.name="content_actions_flexsections",this.selectors={ACTIONLINK:"[data-action-flexsections]",SECTIONLINK:"[data-for='section']"},this.classes={DISABLED:"disabled"}}stateReady(state){super.stateReady(state),this.addEventListener(this.element,"click",this._dispatchClick)}_dispatchClick(event){const target=event.target.closest(this.selectors.ACTIONLINK);if(!target)return;if(target.classList.contains(this.classes.DISABLED))return void event.preventDefault();const methodName=this._actionMethodName(target.getAttribute("data-action-flexsections"));void 0!==this[methodName]&&this[methodName](target,event)}_actionMethodName(name){const requestName=name.charAt(0).toUpperCase()+name.slice(1);return"_request".concat(requestName)}_requestDelete(target,event){var _sectionInfo$cmlist;const sectionId=target.dataset.id;if(!sectionId)return;event.preventDefault();const sectionInfo=this.reactive.get("section",sectionId);(null!==(_sectionInfo$cmlist=sectionInfo.cmlist)&&void 0!==_sectionInfo$cmlist?_sectionInfo$cmlist:[]).length||sectionInfo.hassummary||sectionInfo.rawtitle||sectionInfo.children.length?(0,_str.get_strings)([{key:"confirm",component:"moodle"},{key:"confirmdelete",component:"format_flexsections"},{key:"yes",component:"moodle"},{key:"no",component:"moodle"}]).done((strings=>{_notification.default.confirm(strings[0],strings[1],strings[2],strings[3],(()=>{this.reactive.dispatch("sectionDelete",[sectionId])}))})).fail(_notification.default.exception):this.reactive.dispatch("sectionDelete",[sectionId])}_requestMergeup(target,event){var _sectionInfo$cmlist2;const sectionId=target.dataset.id;if(!sectionId)return;event.preventDefault();const sectionInfo=this.reactive.get("section",sectionId);(null!==(_sectionInfo$cmlist2=sectionInfo.cmlist)&&void 0!==_sectionInfo$cmlist2?_sectionInfo$cmlist2:[]).length||sectionInfo.hassummary||sectionInfo.rawtitle||sectionInfo.children.length?(0,_str.get_strings)([{key:"confirm",component:"moodle"},{key:"confirmmerge",component:"format_flexsections"},{key:"yes",component:"moodle"},{key:"no",component:"moodle"}]).done((strings=>{_notification.default.confirm(strings[0],strings[1],strings[2],strings[3],(()=>{this.reactive.dispatch("sectionMergeUp",sectionId)}))})).fail(_notification.default.exception):this.reactive.dispatch("sectionMergeUp",sectionId)}_requestMoveSection(target,event){event.preventDefault();const sectionId=target.dataset.id,sectionInfo=this.reactive.get("section",sectionId),data=this.reactive.getExporter().course(this.reactive.state);data.sectiontitle=sectionInfo.title,1===data.sections.length&&"1"==="".concat(data.sections[0].singlesection)&&(data.singlesectionmode=1,data.sections[0].contentcollapsed=!1);const buildParents=(sections,parents)=>{for(var i in sections)sections[i].parents=parents,sections[i].aftersectionid=i>0?sections[i-1].id:0,buildParents(sections[i].children,parents+","+sections[i].id),sections[i].lastchildid=sections[i].children.length?sections[i].children[sections[i].children.length-1].id:0};buildParents(data.sections,""),data.lastchildid=data.sections.length?data.sections[data.sections.length-1].id:0,_modal_factory.default.create({type:_modal_factory.default.types.CANCEL,title:(0,_str.get_string)("movecoursesection","core"),large:!0,buttons:{cancel:(0,_str.get_string)("closebuttontitle","core")},removeOnClose:!0}).then((modal=>(_templates.default.render("format_flexsections/local/content/movesection",data).then((body=>(modal.setBody(body),this._setupMoveSection(modal,modal.getBody()[0],sectionId,data),null))).fail((()=>null)),modal.show(),modal))).fail((()=>null))}_requestMoveCm(target,event){event.preventDefault();const cmId=target.dataset.id;if(!cmId)return;const cmInfo=this.reactive.get("cm",cmId),data=this.reactive.getExporter().course(this.reactive.state);data.cmid=cmInfo.id,data.cmname=cmInfo.name,_modal_factory.default.create({type:_modal_factory.default.types.CANCEL,title:(0,_str.get_string)("movecoursemodule","core"),large:!0,buttons:{cancel:(0,_str.get_string)("closebuttontitle","core")},removeOnClose:!0}).then((modal=>(_templates.default.render("format_flexsections/local/content/movecm",data).then((body=>(modal.setBody(body),this._setupMoveCm(modal,modal.getBody()[0],cmId,data),null))).fail((()=>null)),modal.show(),modal))).fail((()=>null))}_setupMoveCm(modal,modalBody,cmId,data){let element=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null;modalBody.addEventListener("click",(event=>{const target=event.target;if(!target.matches("a")||void 0===target.dataset.for||void 0===target.dataset.id)return;if(target.getAttribute("aria-disabled"))return;event.preventDefault();const targetSectionId="section"===target.dataset.for?target.dataset.id:0,targetCmId="cm"===target.dataset.for?target.dataset.id:0;this.reactive.dispatch("cmMove",[cmId],targetSectionId,targetCmId),this._destroyModal(modal,element)}))}_destroyModal(modal){let element=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;modal.hide();const pendingDestroy=new _pending.default("courseformat/actions:destroyModal");element&&element.focus(),setTimeout((()=>{modal.destroy(),pendingDestroy.resolve()}),500)}_setupMoveSection(modal,modalBody,sectionId,data){let element=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null;const links=modalBody.querySelectorAll("".concat(this.selectors.SECTIONLINK));for(let i=0;i<links.length;++i){const re=new RegExp(",".concat(sectionId,","),"g");(links[i].getAttribute("data-before")==="".concat(sectionId)||links[i].getAttribute("data-after")==="".concat(sectionId)||"".concat(links[i].getAttribute("data-parents"),",").match(re))&&this._disableLink(links[i]);const depth=("".concat(links[i].getAttribute("data-parents")).match(/,/g)||[]).length;data.maxsectiondepth&&depth>=data.maxsectiondepth&&this._disableLink(links[i])}modalBody.addEventListener("click",(event=>{const target=event.target;if(!target.matches("a")||"section"!==target.dataset.for||void 0===target.dataset.after)return;if(target.getAttribute("aria-disabled"))return;event.preventDefault();const afterId=parseInt(target.dataset.after),parentId=parseInt(target.dataset.parentid);this.reactive.dispatch("sectionMoveAfter",[sectionId],afterId||-parentId),this._destroyModal(modal,element)}))}_disableLink(element){element&&(element.style.pointerEvents="none",element.style.userSelect="none",element.classList.add("disabled"),element.setAttribute("aria-disabled",!0),element.addEventListener("click",(event=>event.preventDefault())))}_requestAddSubSection(target,event){var _target$dataset$paren;event.preventDefault(),this.reactive.dispatch("addSubSection",parseInt(null!==(_target$dataset$paren=target.dataset.parentid)&&void 0!==_target$dataset$paren?_target$dataset$paren:0))}_requestInsertSubSection(target,event){var _target$dataset$paren2;event.preventDefault(),this.reactive.dispatch("insertSubSection",parseInt(null!==(_target$dataset$paren2=target.dataset.parentid)&&void 0!==_target$dataset$paren2?_target$dataset$paren2:0))}_requestSectionSwitchCollapsed(target,event){var _target$dataset$id;event.preventDefault(),this.reactive.dispatch("sectionSwitchCollapsed",null!==(_target$dataset$id=target.dataset.id)&&void 0!==_target$dataset$id?_target$dataset$id:0)}}return _exports.default=_default,_exports.default}));

//# sourceMappingURL=actions.min.js.map