define("tool_courserating/rating",["exports","core/str","core/toast","core_form/modalform","core/modal_factory","core/fragment","core/templates","core/modal_events","core/ajax"],(function(_exports,_str,_toast,_modalform,_modal_factory,_fragment,_templates,_modal_events,_ajax){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Manage the courses view for the overview block.
   *
   * @module     tool_courserating/rating
   * @copyright  2022 Marina Glancy <marina.glancy@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.setupViewRatingsPopup=_exports.setupAddRatingForm=_exports.init=_exports.hideEditField=void 0,_modalform=_interopRequireDefault(_modalform),_modal_factory=_interopRequireDefault(_modal_factory),_fragment=_interopRequireDefault(_fragment),_templates=_interopRequireDefault(_templates),_modal_events=_interopRequireDefault(_modal_events),_ajax=_interopRequireDefault(_ajax);const SELECTORS_COURSERATING=".customfield_tool_courserating",SELECTORS_COURSEWIDGET=".tool_courserating-widget",SELECTORS_ADD_RATING="[data-action=tool_courserating-addrating][data-courseid]",SELECTORS_VIEW_RATINGS_CFIELD=".tool_courserating-cfield .tool_courserating-ratings",SELECTORS_VIEW_RATINGS_LINK='[data-action="tool_courserating-viewratings"]',SELECTORS_DELETE_RATING="[data-action='tool_courserating-delete-rating']",SELECTORS_USER_RATING="[data-for='tool_courserating-user-rating']",SELECTORS_CFIELD_WRAPPER="[data-for='tool_courserating-cfield-wrapper'][data-courseid]",SELECTORS_USER_RATING_FLAG="[data-for='tool_courserating-user-flag']",SELECTORS_REVIEWS_LIST='.tool_courserating-reviews-popup [data-for="tool_courserating-reviews"]',SELECTORS_SHOWMORE_WRAPPER='.tool_courserating-reviews-popup [data-for="tool_courserating-reviews"] [data-for="tool_courserating-showmore"]',SELECTORS_SHOWMORE_BUTTON='.tool_courserating-reviews-popup [data-for="tool_courserating-reviews"] [data-for="tool_courserating-showmore"] [data-action="showmore"]',SELECTORS_RESET_WITHRATINGS='.tool_courserating-reviews-popup [data-for="tool_courserating-reviews"] [data-for="tool_courserating-resetwithrating"]',SELECTORS_POPUP_SUMMARY='.tool_courserating-reviews-popup [data-for="tool_courserating-summary"]',SELECTORS_SET_WITHRATINGS='.tool_courserating-reviews-popup [data-for="tool_courserating-summary"] [data-for="tool_courserating_setwithrating"]',SELECTORS_RBCELL='[data-for="tool_courserating-rbcell"][data-ratingid]';let systemContextId,viewRatingsModal,addRatingModal;_exports.init=systemContextIdParam=>{systemContextId=systemContextIdParam,document.addEventListener("click",(e=>{if(!e||!e.target||void 0===e.target.closest)return;const addRatingElement=e.target.closest(SELECTORS_ADD_RATING),viewRatingsElement=e.target.closest(SELECTORS_VIEW_RATINGS_CFIELD),deleteRatingElement=e.target.closest(SELECTORS_DELETE_RATING);if(addRatingElement){e.preventDefault();const courseid=addRatingElement.getAttribute("data-courseid");viewRatingsModal&&viewRatingsModal.destroy(),addRating(courseid)}else if(viewRatingsElement){e.preventDefault();const matches=(" "+viewRatingsElement.getAttribute("class")+" ").match(/ tool_courserating-ratings-courseid-(\d+) /);if(matches){const widget=viewRatingsElement.closest(SELECTORS_COURSEWIDGET);widget&&widget.querySelector(SELECTORS_ADD_RATING)?addRating(matches[1]):viewRatings(matches[1])}}else if(deleteRatingElement){e.preventDefault();const ratingid=deleteRatingElement.getAttribute("data-ratingid");deleteRating(ratingid)}})),document.addEventListener("core/inplace_editable:updated",(e=>reloadFlag(e.target)))};const reloadFlag=inplaceEditable=>{if("tool_courserating"===inplaceEditable.dataset.component&&"flag"===inplaceEditable.dataset.itemtype){const ratingid=inplaceEditable.dataset.itemid,node=document.querySelector("".concat(SELECTORS_USER_RATING_FLAG,"[data-ratingid='").concat(ratingid,"']"));node&&_fragment.default.loadFragment("tool_courserating","rating_flag",systemContextId,{ratingid:ratingid}).done(((html,js)=>{_templates.default.replaceNode(node,html,js)}))}},addRating=courseid=>{addRatingModal=new _modalform.default({formClass:"tool_courserating\\form\\addrating",args:{courseid:courseid},modalConfig:{title:(0,_str.get_string)("addrating","tool_courserating")}}),addRatingModal.addEventListener(addRatingModal.events.FORM_SUBMITTED,(()=>{(0,_str.get_string)("changessaved").then(_toast.add).catch(null),refreshRating(courseid)})),addRatingModal.show()},viewRatings=courseid=>{_modal_factory.default.create({type:_modal_factory.default.types.CANCEL,title:(0,_str.get_string)("coursereviews","tool_courserating"),large:!0,buttons:{cancel:(0,_str.get_string)("closebuttontitle","core")},removeOnClose:!0}).then((modal=>(modal.setLarge(),loadCourseRatingPopupContents({courseid:courseid}).done((_ref=>{let{html:html,js:js}=_ref;modal.setBody(html),_templates.default.runTemplateJS(js)})),modal.getRoot().on(_modal_events.default.hidden,(function(){modal.destroy()})),modal.show(),viewRatingsModal=modal,modal))).fail((()=>null))},deleteRating=ratingid=>{const form=new _modalform.default({formClass:"tool_courserating\\form\\deleterating",args:{ratingid:ratingid},modalConfig:{title:(0,_str.get_string)("deleterating","tool_courserating")}});form.addEventListener(form.events.FORM_SUBMITTED,(async e=>{const el=document.querySelector(SELECTORS_USER_RATING+"[data-ratingid='".concat(e.detail.ratingid,"'"));if(el&&el.remove(),refreshRating(e.detail.courseid),!el){const rbcell=document.querySelector(SELECTORS_RBCELL+"[data-ratingid='".concat(e.detail.ratingid,"'"));rbcell&&(rbcell.innerHTML=await(0,_str.get_string)("ratingdeleted","tool_courserating"))}})),form.show()},refreshRating=courseid=>{let el1=document.getElementsByClassName("tool_courserating-ratings-courseid-"+courseid);if(el1&&el1.length){const cfield=el1[0].closest(SELECTORS_COURSERATING);_fragment.default.loadFragment("tool_courserating","cfield",systemContextId,{courseid:courseid}).done(((html,js)=>{_templates.default.replaceNode(cfield,html,js)}))}const el2=document.querySelector(SELECTORS_CFIELD_WRAPPER+"[data-courseid='".concat(courseid,"']"));el2&&_fragment.default.loadFragment("tool_courserating","cfield",systemContextId,{courseid:courseid}).done(((html,js)=>{el2.innerHTML="",_templates.default.appendNodeContents(el2,html,js)}));const el3=document.querySelector("[data-for='tool_courserating-summary'][data-courseid='".concat(courseid,"']"));el3&&_fragment.default.loadFragment("tool_courserating","course_ratings_summary",systemContextId,{courseid:courseid}).done(((html,js)=>{el3.innerHTML="",_templates.default.appendNodeContents(el3,html,js)}))},setFormGroupClasses=(ratingFormGroup,value)=>{const addRemoveClass=(className,add)=>{add&&!ratingFormGroup.classList.contains(className)?ratingFormGroup.classList.add(className):!add&&ratingFormGroup.classList.contains(className)&&ratingFormGroup.classList.remove(className)};for(let i=1;i<=5;i++)addRemoveClass("s-"+i,i<=parseInt(value));addRemoveClass("tool_courserating-norating",0===parseInt(value))};_exports.setupAddRatingForm=grpId=>{const ratingFormGroup=document.getElementById(grpId),curchecked=ratingFormGroup.querySelector("input:checked");setFormGroupClasses(ratingFormGroup,curchecked?curchecked.value:0);let els=ratingFormGroup.querySelectorAll("input");for(let i=0;i<els.length;i++)els[i].addEventListener("change",(e=>setFormGroupClasses(ratingFormGroup,e.target.value)));let labels=ratingFormGroup.querySelectorAll("label");for(let i=0;i<labels.length;i++)labels[i].addEventListener("mouseover",(e=>{const el=e.target.closest("label").querySelector("input");setFormGroupClasses(ratingFormGroup,el.value)})),labels[i].addEventListener("mouseleave",(()=>{const el=ratingFormGroup.querySelector("input:checked");setFormGroupClasses(ratingFormGroup,el?el.value:0)}));const viewratingsLink=ratingFormGroup.closest("form").querySelector(SELECTORS_VIEW_RATINGS_LINK);viewratingsLink&&viewratingsLink.addEventListener("click",(e=>{e.preventDefault(),addRatingModal.modal.destroy(),viewRatings(e.target.dataset.courseid)}))};_exports.setupViewRatingsPopup=()=>{const el=document.querySelector(SELECTORS_REVIEWS_LIST),reloadReviews=function(){let offset=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;const params={courseid:el.dataset.courseid,offset:offset,withrating:el.dataset.withrating};return _fragment.default.loadFragment("tool_courserating","course_reviews",el.dataset.systemcontextid,params)};null==el||el.addEventListener("click",(e=>{const button=e.target.closest(SELECTORS_SHOWMORE_BUTTON);if(button){const wrapper=button.closest(SELECTORS_SHOWMORE_WRAPPER);e.preventDefault(),reloadReviews(button.dataset.nextoffset).done(((html,js)=>_templates.default.replaceNode(wrapper,html,js)))}e.target.closest(SELECTORS_RESET_WITHRATINGS)&&(e.preventDefault(),el.dataset.withrating=0,reloadReviews(0).done(((html,js)=>_templates.default.replaceNodeContents(el,html,js))))}));const elSummary=document.querySelector(SELECTORS_POPUP_SUMMARY);null==elSummary||elSummary.addEventListener("click",(e=>{const withRatingButton=e.target.closest(SELECTORS_SET_WITHRATINGS);withRatingButton&&(el.dataset.withrating=el.dataset.withrating===withRatingButton.dataset.withrating?0:withRatingButton.dataset.withrating,reloadReviews(0).done(((html,js)=>_templates.default.replaceNodeContents(el,html,js))))}))};_exports.hideEditField=fieldname=>{const s="#fitem_id_customfield_"+fieldname;let el=document.querySelector(s+"_editor");el&&(el.style.display="none",el=document.querySelector(s+"_static"),el&&(el.style.display="none"))};const loadCourseRatingPopupContents=function(args){return!document.body.classList.contains("notloggedin")?_fragment.default.loadFragment("tool_courserating","course_ratings_popup",systemContextId,args).then(((html,js)=>({html:html,js:js}))):_ajax.default.call([{methodname:"tool_courserating_course_rating_popup",args:args}],void 0,!1)[0].then((function(data){return{html:data.html,js:_fragment.default.processCollectedJavascript(data.javascript)}}))}}));

//# sourceMappingURL=rating.min.js.map