# Question blocks

## Introduction ##

Question blocks add flexibility to STACK questions by adding functional structures to the CASText.  These are new from v4.0 onwards.

For example, you can add in a conditional statement to selectively include materials in the version of the CASText depending on values of variables.
This is useful in randomly generated contexts, especially within model solutions and randomly generated diagrams/charts.

For maximum flexibility, blocks can be nested and conditionally evaluated. A body of CASText is then repeatedly processed until all
blocks have been interpreted into CASText. This is a core part of CASText and so applied to all appropriate parts of the question.

Information on some blocks are contained in a question available from the [STACK question library](../../STACK_question_admin/Library/index.md) in the `doc-examples\authoring` directory.  

Note:  The parameters to blocks in the question body may **NOT** depend on the student's answers. This means that you cannot reveal
an input block based on student input, well not just by using an `[[if/]]`-block. But you may still adapt PRT feedback as much as you
want. Such adaptation requires persistent modifiable question state and is not currently possible in STACK; however, there is work being done to create systems that would allow it.

## Block groups ##

Question blocks are divided into three broad groups.

1. [Static blocks](Static_blocks.md), which are active when a question version is created.
  * Lang
  * Comment
  * Todo
  * Debug
  * Format
  * Textdownload
  * Include
  * QUID
  * Template
  * [Hints/fact sheets](Fact_sheets.md)
  * Entity escape
2. [Conditional blocks](Conditional_blocks.md), for looping and branching and programatic structures.
  * Define
  * If
  * Foreach
3. [Dynamic blocks](Dynamic_blocks.md), which manage features like Javascript and JSXGraph components.
  * Reveal
  * Hint
  * Adapt
  * JSXGraph
  * JSString
  * Geogebra
  * Parsons
4. [System blocks](System_blocks.md), which are not realy intended for end-users.
5. [Iframe blocks](Iframe_blocks.md), which allow creation of sandboxed iframes that can be included in the output.
  * Iframe
  * Style
  * Script

## General syntax ##

The syntax is quite similar to XML but preserving the style ``[[ ... ]]`` used in the inputs and potential response tree declarations.

    [[ block_type param1="value1" param2='value2' ... paramN="valueN" ]]
    Some content.
    [[/ block_type ]]

This syntax avoids issues with the rich text editors used in Moodle but it is still recommended to use the plain text editor to avoid excess line changes and white space generated by the WYSIWYG editors.

Notes

1. In closing a block you must use `[[/ "blockname"]]` where `"blockname"` must be used, and it must match the previous opening block.  
2. White space is tolerated in block definitions and after the `/` in the closing block, but is not necessary.
3. The parameters have the following syntax:  `param1="value1"`.  Blocks define what are valid identifiers and parameters.  The identifiers must not be in quotes (and so cannot contain spaces).  The parameters must be in quotes, and either `param1="value1"` or `param1='value1'` is accepted.
4. Typically `param1` will be a valid Maxima identifier, e.g. a variable name and the value would be a valid Maxima expression.
5. The parameter value must be surrounded by quotes, and both `"value"` and `'value'` are accepted.

## Empty blocks ##

Some blocks do not have content.  For example, the `[[ define x='1' /]]` block does not include content.
The following is correct syntax:

    [[ define x='1']][[/ define]]

But we think the following is much more direct, and clean.

    [[ define x='1' /]]

There are other kinds of `[[ emptyblocks /]]`, which are useful in certain cases and developers of new blocks might like to consider this as a possibility.

While the define block does not generate any visible content, empty blocks may be used to generate output. For example `[[ debug /]]` does generate output.