# STACK

STACK is the world-leading open-source (GPL) automatic assessment system for mathematics, science and related disciplines.

* Students type in mathematical expressions, and are not restricted to multiple choice.
* STACK separates _validation_ and _assessment_ with an emphasis on formative assessment.
* Random generation of questions is highly structured with computer algebra support.
* STACK has a wide variety of input types, including line by line working  and interaction with mathematical diagrams.
* STACK has support for multipart questions.
* STACK has support for scientific units and significant figures.

This is the official user documentation for STACK.

* The main community website for STACK is [https://stack-assessment.org/](https://stack-assessment.org/)
* A demonstration server is available in Edinburgh: [https://stack-demo.maths.ed.ac.uk/demo/](https://stack-demo.maths.ed.ac.uk/demo/)
* Community discussion takes place on [https://stack-assessment.zulipchat.com/](https://stack-assessment.zulipchat.com/)

#### [**Authoring**](Authoring/index.md)

Documentation for question authors, including:

* An [authoring quick start guide](AbInitio/Authoring_quick_start_1.md), which can be used in conjunction with the "Getting started with STACK" [guide](../static/2019-STACK-Guide.pdf).
* Reference documentation on [question authoring](Authoring/index.md), such as [answer tests](Authoring/Answer_Tests/index.md), [inputs](Authoring/Inputs/index.md), [potential response trees](Authoring/Potential_response_trees.md) and [translations](Authoring/Languages.md).
* Detailed guides for using [specialist tools](Specialist_tools/index.md), such as drag and drop questions.
* Information on using the [CAS Maxima](CAS/index.md) for question authoring, including [randomisation](CAS/Random.md).
* Guides for writing questions in various [mathematical topics](Topics/index.md).

#### **Installation and development**

* [Installation instructions](Installation/index.md).
* [Topics for developers](Developer/index.md)
* [Development history](Developer/Development_history.md).

#### [**Students**](Students/index.md)

Information for students using STACK, including:

* [Input instructions](Students/Answer_input.md).
* [How answers are assessed](Students/Answer_assessment.md).
* [Frequently asked questions](Students/FAQ.md).

