# 問題作成クイック・スタート・ガイド5：問題のテスト

[1 - 基本的な問題](Authoring_quick_start_1.md) | [2 - 問題変数](Authoring_quick_start_2.md) | [3 - フィードバックを改善する](Authoring_quick_start_3.md) |　[4 - ランダム化](Authoring_quick_start_4.md) | 5 - 問題のテスト | [6 - 複数解答問題](Authoring_quick_start_6.md) | [7 - 数式簡略の無効化](Authoring_quick_start_7.md) | [8 - 問題のインポートと小テスト](Authoring_quick_start_8.md)


問題作成クイック・スタート・ガイドのこの部分では問題のテストについて扱います。次のビデオでそのプロセスを説明していますので,ご覧ください：

<iframe width="560" height="315" src="https://www.youtube.com/embed/wnvsc-v9svE" frameborder="0" allowfullscreen></iframe>

## はじめに

ここ数回で,私たちはシンプルな積分の問題を扱いました。クイックスタートを続ける前に,問題変数が次のように設定されていることを確認してください：

```
a1 : 1+rand(6)；
a2 : 1+rand(6)；
nn : 2+rand(4)；
exp : a1*(x-a2)^(-nn)；
ta: int(exp, x)+c；
```

問題のテストは時間がかかり面倒ですが,問題が確実に動作するためには重要です。このプロセスを支援するために,STACKでは教師が「問題テスト」を定義することができます。原理はソフトウェア工学における「ユニットテスト」と同じです。

## 問題テスト

問題バンクのテストしたい問題の「操作」列のプルダウンメニューから，`問題のテストとデプロイ`を選択してください。

`テストケースを追加する` をクリックして,問題にテストケースを追加します。テストケースは学生の入力を受け取り,その入力に対して点数,減点,解答記録を指定して正しく動作しているかを確認します。

減点は学生が間違った解答をするたびに合計点から差し引かれる数値です。デフォルトでは0.1に設定されています。減点は`一般`の `減点` で変更することができます。この機能は問題動作 `複数受験インタラクティブ` および `アダプティブモード` でのみ使用されることに注意してください。問題動作については後ほど説明します。`解答記録` はポテンシャル・レスポンス・ツリー上で決めた特定の結果の名前を指定できます。

「説明」にテストケースの名前を指定します。例えば「正解のテスト」としましょう。また，以下の値を入力あるいは選択してください。

```
ans1 : ta
点数 : 1
減点 : 0
解答記録 : prt1-2-T
```

つまり,学生が正しい解答を入れた場合,最初のノード (正しく積分されたかチェック) を通過し,2番目のノード (答えが因数分解されたかテスト) を通過し,点数 1,減点なしで終わるはずです。

「テストケースを作成する」をクリックして問題のテストが実施されます。

テストが実施される前に入力が評価されることに注意してください。変数 `ta` は教師が定義した変数であるため，学生は入力することができません。しかし，`1*(x-1)^(-3)+c` は入力可能です。各テストケースについて,評価されていない入力は `入力テスト` の下に,実際に評価のためにシステムに渡された値は `入力値` の下に表示されます。


必要だと思う数だけテストを追加することができます。通常は予想されるケースごとに一つずつ追加するのが賢明です。

別の、積分定数のないテストケースを追加しましょう。

```
説明 : 積分定数のないテストケース
ans1 : int(exp,x)
点数 : 0
減点 : 0.1
解答記録 : prt1-1-F
```

この場合,STACKは学生に点数を与えず,テストが通過したことを示します！

また,学生が教師の望む能力を身につけているかを確認するために,問題テストを使用することもできます。例えば，この積分の問題では，(1) べき指数を1増加させ，(2) 新しいべき乗で割ることを学生に理解してほしいと考えます。例えば,べき乗を増加させ,新しいべき乗で*乗算*することはできないはずです。これを確認するテストケースを追加しましょう。

```
説明 : べき乗を掛けてしまう
ans1 : (a1*(-nn+1))*(x-a2)^(-nn+1)+c
点数 : 0
減点 : 0.1
解答記録 = prt1-1-F
```

割り算ではなく, \(-nn+1\)をかけると0点になることをテストしています。学生にこの知識をすべての乱数の場合で使用して欲しいのならば,すべての乱数の場合（問題のケース）でこのテストに合格しなければなりません。これを確認するには,`デプロイされた全ての問題ケースに対して，全てのテストケースを実行します` をクリックしてください。

すべての問題のケースが問題テストに合格するわけではありません。テストに失敗した問題ケースをクリックすると,その理由がわかります！\(nn=2\)の時， \(-nn+1=-1\)乗の掛け算は割り算と等価です。この問題ケースは他のものより「簡単」です。これは,問題テストのもう1つの重要な使い方,つまり,想定される知識に対してすべての問題ケースが同じ難易度でありることを保証することを確認することです。これを踏まえて,`nn`を ` 3+rand(4)` に変更したくなるかもしれません。これですべての問題ケースですべての問題テストに合格するはずです。

品質管理は不可欠であり,より詳しい情報は [問題のテスト・デバッグ・品質管理](../../en/Authoring/Testing.md) のページにあります。

##　余談：禁止ワード

STACKでは,`sin`,`cos`などの標準的な数学関数を使うことができます。さらに驚くべきことに,STACKは`int`も使うことができます。そのため,理論的には生徒が`int(...)+c`と入力すると,システムは正しいと判断します！

これを止める場合には,`input:ans1`に行き,禁止ワードに`int`と入力します。禁止ワードは通常許可されている単語を禁止します。

この例は生徒を助けるために有効性がどのように使われるかをうまく示しています。`int(p,x)+c`は問題に対する正しい答えですが,無効です。この例では，CASに積分をさせるのではなく，生徒に積分をさせたいのです！

# 次のステップ

これでSTACKで質問テストを使用できるようになります。

#### 問題作成クイック・スタート・ガイドの次のパートでは,[複数解答問題](Authoring_quick_start_6.md)について説明します。
