# System question blocks

## Commonstring block ##

In some circumstances one might see the `[[commonstring/]]` block. While it might not be one that an author would use it might appear when working with built-in labels and their localisations. What it does is that it gets a `key` as a parameter and fetches the matching localised string from STACK's language packs and replaces the block with it. It also provides means for injecting named parameters into those templates with varying simplification and presentation options.

For example

    [[commonstring key="pluginname_help"/]]

will display the string `pluginname_help` from the language pack, which in English is currently "STACK is an assessment system for mathematics."

## Blocks that exist but should not be used ##

There are other blocks that have roles inside the system and that transfer information required for the operation of the system. If you look at the code these are often called "specialblocks". You can rest assured that there are no realistic use cases for them, even in advanced authoring proceses. Practically, none of these blocks ever exist in written out CASText and are only added in as virtual objects during processing. However, if you ever look at the commands going into the CAS you might see these block names going in and coming out.

For example, `[[pfs]]` is a special block that gets generated by internal logic when we see plugin files (if you place an image into the WYSIWYG editor) in the text, it works as a marker for those files context so that we can combine text from multiple contexts together and still keep track of the origins when the final product gets rendered.

There are blocks that handle the placeholders for inputs, validation, and feedback. Some others deal with translations between forms and postprocessing special types of content. 